/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.util;

import com.tangosol.util.Resources;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Hashtable;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public abstract class ClassHelper {
    private static Hashtable tblPrimitives = new Hashtable(10, 1.0f);
    public static final Class[] VOID_PARAMS;
    public static final Object[] VOID;

    public static boolean isInstanceOf(Object obj, String sClz) {
        try {
            return ClassHelper.isInstanceOf(obj, Class.forName(sClz));
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isInstanceOf(Object obj, Class clz) {
        return clz.isAssignableFrom(obj.getClass());
    }

    public static String getPackageName(Class clz) {
        String sFullClass = clz.getName();
        int ofDotClass = sFullClass.lastIndexOf(46);
        if (ofDotClass < 0) {
            return "";
        }
        return sFullClass.substring(0, ofDotClass + 1);
    }

    public static String getPackageName(String sName) {
        int ofLastDot = sName.lastIndexOf(46);
        if (ofLastDot < 0) {
            return "";
        }
        if (ofLastDot == sName.length() - 1) {
            return sName;
        }
        if (ofLastDot > 0) {
            return sName.substring(0, ofLastDot + 1);
        }
        return sName + '.';
    }

    public static String getSimpleName(Class clz) {
        String sFullClass = clz.getName();
        int ofDotClass = sFullClass.lastIndexOf(46);
        if (ofDotClass < 0) {
            return sFullClass;
        }
        String sName = sFullClass.substring(ofDotClass + 1);
        int ofInnerClass = sName.lastIndexOf(36);
        return ofInnerClass < 0 ? sName : sName.substring(ofInnerClass + 1);
    }

    public static String getSimpleName(String sName) {
        int ofLastDot = sName.lastIndexOf(46);
        if (ofLastDot < 0) {
            return sName;
        }
        if (ofLastDot == sName.length() - 1) {
            return "";
        }
        if (ofLastDot > 0) {
            return sName.substring(ofLastDot + 1);
        }
        return "";
    }

    public static String getQualifiedName(String pkg, String sName) {
        if (pkg.length() == 0) {
            return sName;
        }
        if (pkg.charAt(0) == '.') {
            pkg = pkg.substring(1);
        }
        if (pkg.charAt(pkg.length() - 1) == '.') {
            return pkg + sName;
        }
        return pkg + '.' + sName;
    }

    public static String getCompositePackage(String pkg1, String pkg2) {
        String sComposite = pkg1.length() == 0 ? pkg2 : (pkg2.length() == 0 ? pkg1 : (pkg2.charAt(0) != '.' ? pkg2 : (pkg1.charAt(pkg1.length() - 1) == '.' ? pkg1 + pkg2.substring(1) : pkg1 + pkg2)));
        if (sComposite.length() > 0 && sComposite.charAt(sComposite.length() - 1) != '.') {
            sComposite = sComposite + '.';
        }
        return sComposite;
    }

    public static String getCompositeName(Class clz, String sName) {
        return ClassHelper.getCompositeName(clz.getName(), sName);
    }

    public static String getCompositeName(String sName1, String sName2) {
        String sPkg = ClassHelper.getCompositePackage(ClassHelper.getPackageName(sName1), ClassHelper.getPackageName(sName2));
        String sClass = ClassHelper.getSimpleName(sName2);
        if (sClass.length() == 0) {
            sClass = ClassHelper.getSimpleName(sName1);
        }
        return ClassHelper.getQualifiedName(sPkg, sClass);
    }

    public static String getDerivedName(Class clz, String sPrefix) {
        return ClassHelper.getDerivedName(clz.getName(), sPrefix);
    }

    public static String getDerivedName(String sName, String sPrefix) {
        String sPkg = ClassHelper.getCompositePackage(ClassHelper.getPackageName(sName), ClassHelper.getPackageName(sPrefix));
        sPrefix = ClassHelper.getSimpleName(sPrefix);
        String sSuffix = ClassHelper.getSimpleName(sName);
        return ClassHelper.getQualifiedName(sPkg, sPrefix + sSuffix);
    }

    public static boolean isPartialNameLegal(String sName) {
        if (sName == null || sName.length() == 0) {
            return false;
        }
        int ofStart = 0;
        int ofEnd = sName.length();
        if (sName.charAt(ofStart) == '.') {
            ++ofStart;
        }
        if (ofEnd > 1 && sName.charAt(ofEnd - 1) == '.') {
            --ofEnd;
        }
        return ClassHelper.isQualifiedNameLegal(sName.substring(ofStart, ofEnd));
    }

    public static boolean isSimpleNameLegal(String sName) {
        char[] ach = sName.toCharArray();
        int cch = ach.length;
        if (cch < 1 || !Character.isJavaIdentifierStart(ach[0])) {
            return false;
        }
        for (int i = 1; i < cch; ++i) {
            if (Character.isJavaIdentifierPart(ach[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean isQualifiedNameLegal(String sName) {
        int cch = sName.length();
        if (cch < 1) {
            return false;
        }
        int ofStart = 0;
        while (ofStart < cch) {
            int ofEnd = sName.indexOf(46, ofStart);
            if (ofEnd == cch - 1) {
                return false;
            }
            if (ofEnd < 0) {
                ofEnd = cch;
            }
            if (!ClassHelper.isSimpleNameLegal(sName.substring(ofStart, ofEnd))) {
                return false;
            }
            ofStart = ofEnd + 1;
        }
        return true;
    }

    public static Resources getPackageResources(String sClass) throws MissingResourceException {
        return (Resources)ResourceBundle.getBundle(ClassHelper.getCompositeName(sClass, "PackageResources"));
    }

    public static Resources getPackageResources(Class clz) throws MissingResourceException {
        return ClassHelper.getResources(clz, "PackageResources");
    }

    public static Resources getResources(Class clz, String sName) throws MissingResourceException {
        return (Resources)ResourceBundle.getBundle(ClassHelper.getCompositeName(clz, sName));
    }

    public static Object newInstance(Class clz, Object[] aoParam) throws InstantiationException, InvocationTargetException {
        int cParams;
        if (aoParam == null) {
            aoParam = VOID;
        }
        if ((cParams = aoParam.length) == 0) {
            try {
                return clz.newInstance();
            }
            catch (IllegalAccessException e) {
                throw new InstantiationException(e.toString());
            }
        }
        Class[] aclzParam = cParams == 0 ? VOID_PARAMS : new Class[cParams];
        boolean fExactMatch = true;
        for (int i = 0; i < cParams; ++i) {
            if (aoParam[i] == null) {
                fExactMatch = false;
                continue;
            }
            aclzParam[i] = aoParam[i].getClass();
        }
        if (fExactMatch) {
            try {
                return clz.getConstructor(aclzParam).newInstance(aoParam);
            }
            catch (Throwable e) {
                // empty catch block
            }
        }
        Constructor<?>[] aconstr = clz.getConstructors();
        int cconstr = aconstr.length;
        for (int iconstr = 0; iconstr < cconstr; ++iconstr) {
            Constructor<?> constr = aconstr[iconstr];
            Class<?>[] aclzActual = constr.getParameterTypes();
            if (aclzActual.length != cParams) continue;
            boolean fMatch = true;
            for (int i = 0; i < cParams && (fMatch = aoParam[i] == null ? !aclzActual[i].isPrimitive() : (aclzActual[i].isPrimitive() ? aclzActual[i] == (Class)tblPrimitives.get(aclzParam[i]) : aclzActual[i].isAssignableFrom(aclzParam[i]))); ++i) {
            }
            if (!fMatch) continue;
            try {
                return constr.newInstance(aoParam);
            }
            catch (IllegalAccessException e) {
                throw new InstantiationException(e.toString());
            }
            catch (SecurityException e) {
                throw new InstantiationException(e.toString());
            }
        }
        throw new InstantiationException();
    }

    public static Object invokeStatic(Class clz, String sName, Object[] aoParam) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        return ClassHelper.invoke(clz, null, sName, aoParam);
    }

    public static Object invoke(Object obj, String sName, Object[] aoParam) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        return ClassHelper.invoke(obj.getClass(), obj, sName, aoParam);
    }

    public static Object invoke(Class clz, Object obj, String sName, Object[] aoParam) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        int cParams;
        if (aoParam == null) {
            aoParam = VOID;
        }
        Class[] aclzParam = (cParams = aoParam.length) == 0 ? VOID_PARAMS : new Class[cParams];
        for (int i = 0; i < cParams; ++i) {
            Object oParam = aoParam[i];
            if (oParam == null) continue;
            aclzParam[i] = oParam.getClass();
        }
        IllegalAccessException iae = null;
        boolean fStatic = obj == null;
        Method method = ClassHelper.findMethod(clz, sName, aclzParam, fStatic);
        while (method != null) {
            try {
                return method.invoke(obj, aoParam);
            }
            catch (IllegalAccessException e) {
                if (iae == null) {
                    iae = e;
                }
                Class<?>[] aclzIface = clz.getInterfaces();
                int c = aclzIface.length;
                for (int i = 0; i < c; ++i) {
                    method = ClassHelper.findMethod(aclzIface[i], sName, aclzParam, fStatic);
                    if (method == null) continue;
                    try {
                        return method.invoke(obj, aoParam);
                    }
                    catch (IllegalAccessException e2) {
                        // empty catch block
                    }
                }
                if ((clz = clz.getSuperclass()) == null) {
                    throw iae;
                }
                method = ClassHelper.findMethod(clz, sName, aclzParam, fStatic);
            }
        }
        if (iae == null) {
            throw new NoSuchMethodException(clz.getName() + '.' + sName);
        }
        throw iae;
    }

    public static Method findMethod(Class clz, String sName, Class[] aclzParam, boolean fStatic) {
        if (aclzParam == null) {
            aclzParam = VOID_PARAMS;
        }
        int cParams = aclzParam.length;
        boolean fExactMatch = true;
        for (int i = 0; i < cParams; ++i) {
            if (aclzParam[i] != null) continue;
            fExactMatch = false;
            break;
        }
        if (fExactMatch) {
            try {
                return clz.getMethod(sName, aclzParam);
            }
            catch (NoSuchMethodException e) {
                // empty catch block
            }
        }
        Method[] aMethod = clz.getMethods();
        int cMethods = aMethod.length;
        block3: for (int iMethod = 0; iMethod < cMethods; ++iMethod) {
            Class<?>[] aclzActual;
            Method method = aMethod[iMethod];
            if (!method.getName().equals(sName) || Modifier.isStatic(method.getModifiers()) != fStatic || (aclzActual = method.getParameterTypes()).length != cParams) continue;
            for (int i = 0; i < cParams; ++i) {
                Class clzParam = aclzParam[i];
                Class<?> clzActual = aclzActual[i];
                boolean fMatch = clzParam == null ? !clzActual.isPrimitive() : (clzActual.isPrimitive() ? clzActual == tblPrimitives.get(clzParam) : clzActual.isAssignableFrom(clzParam));
                if (!fMatch) continue block3;
            }
            return method;
        }
        return null;
    }

    static {
        tblPrimitives.put(Boolean.class, Boolean.TYPE);
        tblPrimitives.put(Character.class, Character.TYPE);
        tblPrimitives.put(Byte.class, Byte.TYPE);
        tblPrimitives.put(Short.class, Short.TYPE);
        tblPrimitives.put(Integer.class, Integer.TYPE);
        tblPrimitives.put(Long.class, Long.TYPE);
        tblPrimitives.put(Float.class, Float.TYPE);
        tblPrimitives.put(Double.class, Double.TYPE);
        tblPrimitives.put(Void.class, Void.TYPE);
        VOID_PARAMS = new Class[0];
        VOID = new Object[0];
    }
}

