/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.util;

import com.tangosol.net.cache.CacheEvent;
import com.tangosol.net.cache.CacheMap;
import com.tangosol.util.Base;
import com.tangosol.util.Converter;
import com.tangosol.util.ConverterEnumerator;
import com.tangosol.util.Filter;
import com.tangosol.util.InvocableMapHelper;
import com.tangosol.util.MapEvent;
import com.tangosol.util.MapListener;
import com.tangosol.util.MapListenerSupport;
import com.tangosol.util.ObservableMap;
import com.tangosol.util.QueryMap;
import com.tangosol.util.SimpleMapEntry;
import com.tangosol.util.ValueExtractor;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;

public abstract class ConverterCollections
extends Base {
    public static Iterator getIterator(Iterator iter, Converter conv) {
        return new ConverterEnumerator(iter, conv);
    }

    public static ConverterCollection getCollection(Collection col, Converter convUp, Converter convDown) {
        return new ConverterCollection(col, convUp, convDown);
    }

    public static ConverterSet getSet(Set set, Converter convUp, Converter convDown) {
        return new ConverterSet(set, convUp, convDown);
    }

    public static ConverterSortedSet getSortedSet(SortedSet set, Converter convUp, Converter convDown) {
        return new ConverterSortedSet(set, convUp, convDown);
    }

    public static ConverterList getList(List list, Converter convUp, Converter convDown) {
        return new ConverterList(list, convUp, convDown);
    }

    public static ConverterListIterator getListIterator(ListIterator iter, Converter convUp, Converter convDown) {
        return new ConverterListIterator(iter, convUp, convDown);
    }

    public static ConverterMap getMap(Map map, Converter convKeyUp, Converter convKeyDown, Converter convValUp, Converter convValDown) {
        return new ConverterMap(map, convKeyUp, convKeyDown, convValUp, convValDown);
    }

    public static ConverterObservableMap getObservableMap(ObservableMap map, Converter convKeyUp, Converter convKeyDown, Converter convValUp, Converter convValDown) {
        return new ConverterObservableMap(map, convKeyUp, convKeyDown, convValUp, convValDown);
    }

    public static ConverterSortedMap getSortedMap(SortedMap map, Converter convKeyUp, Converter convKeyDown, Converter convValUp, Converter convValDown) {
        return new ConverterSortedMap(map, convKeyUp, convKeyDown, convValUp, convValDown);
    }

    public static ConverterEntrySet getEntrySet(Collection set, Converter convKeyUp, Converter convKeyDown, Converter convValUp, Converter convValDown) {
        return new ConverterEntrySet(set, convKeyUp, convKeyDown, convValUp, convValDown);
    }

    public static ConverterEntry getEntry(Map.Entry entry, Converter convKeyUp, Converter convValUp, Converter convValDown) {
        return new ConverterEntry(entry, convKeyUp, convValUp, convValDown);
    }

    public static MapEvent getMapEvent(ObservableMap map, MapEvent event, Converter convKey, Converter convVal) {
        return event instanceof CacheEvent ? new ConverterCacheEvent(map, (CacheEvent)event, convKey, convVal) : new ConverterMapEvent(map, event, convKey, convVal);
    }

    public static Object[] convertArray(Object[] ao, Converter conv) {
        int c = ao.length;
        for (int i = 0; i < c; ++i) {
            ao[i] = conv.convert(ao[i]);
        }
        return ao;
    }

    public static Object[] convertArray(Object[] aoSrc, Converter conv, Object[] aoDest) {
        int cSrc = aoSrc.length;
        int cDest = aoDest.length;
        if (cSrc > cDest) {
            cDest = cSrc;
            aoDest = (Object[])Array.newInstance(aoDest.getClass().getComponentType(), cDest);
        }
        if (cDest > cSrc) {
            aoDest[cSrc] = null;
        }
        for (int i = 0; i < cSrc; ++i) {
            aoDest[i] = conv.convert(aoSrc[i]);
        }
        return aoDest;
    }

    public static class ConverterMapListener
    extends Base
    implements MapListener {
        protected ObservableMap m_map;
        protected MapListener m_listener;
        protected Converter m_convKey;
        protected Converter m_convVal;

        public ConverterMapListener(ObservableMap map, MapListener listener, Converter convKey, Converter convVal) {
            ConverterMapListener.azzert(listener != null && convKey != null && convVal != null, "Null listener or converter");
            this.m_map = map;
            this.m_listener = listener;
            this.m_convKey = convKey;
            this.m_convVal = convVal;
        }

        public void entryInserted(MapEvent evt) {
            this.m_listener.entryInserted(ConverterCollections.getMapEvent(this.m_map, evt, this.m_convKey, this.m_convVal));
        }

        public void entryUpdated(MapEvent evt) {
            this.m_listener.entryUpdated(ConverterCollections.getMapEvent(this.m_map, evt, this.m_convKey, this.m_convVal));
        }

        public void entryDeleted(MapEvent evt) {
            this.m_listener.entryDeleted(ConverterCollections.getMapEvent(this.m_map, evt, this.m_convKey, this.m_convVal));
        }

        public int hashCode() {
            return this.m_listener.hashCode();
        }

        public boolean equals(Object o) {
            if (o instanceof ConverterMapListener) {
                ConverterMapListener that = (ConverterMapListener)o;
                return this.m_listener.equals(that.m_listener) && this.m_convKey.equals(that.m_convKey) && this.m_convVal.equals(that.m_convVal);
            }
            return false;
        }
    }

    public static class ConverterCacheEvent
    extends CacheEvent {
        protected CacheEvent m_event;
        protected Converter m_convKey;
        protected Converter m_convVal;

        public ConverterCacheEvent(ObservableMap map, CacheEvent event, Converter convKey, Converter convVal) {
            super(map, event.getId(), null, null, null, event.isSynthetic());
            this.m_event = event;
            this.m_convKey = convKey;
            this.m_convVal = convVal;
        }

        public Object getKey() {
            Object oKey = this.m_oKey;
            if (oKey == null) {
                oKey = this.m_oKey = this.m_convKey.convert(this.m_event.getKey());
            }
            return oKey;
        }

        public Object getOldValue() {
            Object oValueOld = this.m_oValueOld;
            if (oValueOld == null) {
                oValueOld = this.m_oValueOld = this.m_convVal.convert(this.m_event.getOldValue());
            }
            return oValueOld;
        }

        public Object getNewValue() {
            Object oValueNew = this.m_oValueNew;
            if (oValueNew == null) {
                oValueNew = this.m_oValueNew = this.m_convVal.convert(this.m_event.getNewValue());
            }
            return oValueNew;
        }

        public CacheEvent getOriginalEvent() {
            return this.m_event;
        }
    }

    public static class ConverterMapEvent
    extends MapEvent {
        protected MapEvent m_event;
        protected Converter m_convKey;
        protected Converter m_convVal;

        public ConverterMapEvent(ObservableMap map, MapEvent event, Converter convKey, Converter convVal) {
            super(map, event.getId(), null, null, null);
            this.m_event = event;
            this.m_convKey = convKey;
            this.m_convVal = convVal;
        }

        public Object getKey() {
            Object oKey = this.m_oKey;
            if (oKey == null) {
                oKey = this.m_oKey = this.m_convKey.convert(this.m_event.getKey());
            }
            return oKey;
        }

        public Object getOldValue() {
            Object oValueOld = this.m_oValueOld;
            if (oValueOld == null) {
                oValueOld = this.m_oValueOld = this.m_convVal.convert(this.m_event.getOldValue());
            }
            return oValueOld;
        }

        public Object getNewValue() {
            Object oValueNew = this.m_oValueNew;
            if (oValueNew == null) {
                oValueNew = this.m_oValueNew = this.m_convVal.convert(this.m_event.getNewValue());
            }
            return oValueNew;
        }
    }

    public static class ConverterEntry
    extends AbstractConverterEntry {
        protected Converter m_convKeyUp;
        protected Converter m_convValUp;
        protected Converter m_convValDown;

        public ConverterEntry(Map.Entry entry, Converter convKeyUp, Converter convValUp, Converter convValDown) {
            super(entry);
            this.m_convKeyUp = convKeyUp;
            this.m_convValUp = convValUp;
            this.m_convValDown = convValDown;
        }

        protected Converter getKeyUpConv() {
            return this.m_convKeyUp;
        }

        protected Converter getValueUpConv() {
            return this.m_convValUp;
        }

        protected Converter getValueDownConv() {
            return this.m_convValDown;
        }
    }

    protected static abstract class AbstractConverterEntry
    extends Base
    implements Map.Entry,
    Serializable {
        protected Map.Entry m_entry;
        protected transient Object m_oKeyUp;
        protected transient Object m_oValueUp;

        protected AbstractConverterEntry(Map.Entry entry) {
            this.m_entry = entry;
        }

        protected abstract Converter getKeyUpConv();

        protected abstract Converter getValueUpConv();

        protected abstract Converter getValueDownConv();

        public Object getKey() {
            Object oKeyUp = this.m_oKeyUp;
            if (oKeyUp == null) {
                this.m_oKeyUp = oKeyUp = this.getKeyUpConv().convert(this.m_entry.getKey());
            }
            return oKeyUp;
        }

        public Object getValue() {
            Object oValueUp = this.m_oValueUp;
            if (oValueUp == null) {
                this.m_oValueUp = oValueUp = this.getValueUpConv().convert(this.m_entry.getValue());
            }
            return oValueUp;
        }

        public Object setValue(Object value) {
            this.m_oValueUp = null;
            return this.getValueUpConv().convert(this.m_entry.setValue(this.getValueDownConv().convert(value)));
        }

        public boolean equals(Object o) {
            Map.Entry that = (Map.Entry)o;
            if (this == that || that == null) {
                return this == that;
            }
            return Base.equals(this.getKey(), that.getKey()) && Base.equals(this.getValue(), that.getValue());
        }

        public int hashCode() {
            Object oKey = this.getKey();
            Object oValue = this.getValue();
            return (oKey == null ? 0 : oKey.hashCode()) ^ (oValue == null ? 0 : oValue.hashCode());
        }

        public String toString() {
            return "ConverterEntry{Key=\"" + this.getKey() + "\", Value=\"" + this.getValue() + "\"}";
        }
    }

    public static class ConverterEntrySet
    extends Base
    implements Set,
    Serializable {
        protected Collection m_set;
        protected Converter m_convKeyUp;
        protected Converter m_convKeyDown;
        protected Converter m_convValUp;
        protected Converter m_convValDown;

        public ConverterEntrySet(Collection set, Converter convKeyUp, Converter convKeyDown, Converter convValUp, Converter convValDown) {
            ConverterEntrySet.azzert(set != null && convKeyUp != null && convKeyDown != null && convValUp != null && convValDown != null);
            this.m_set = set;
            this.m_convKeyUp = convKeyUp;
            this.m_convKeyDown = convKeyDown;
            this.m_convValUp = convValUp;
            this.m_convValDown = convValDown;
        }

        public int size() {
            return this.m_set.size();
        }

        public boolean isEmpty() {
            return this.m_set.isEmpty();
        }

        public boolean contains(Object o) {
            return this.m_set.contains(new com.tangosol.util.ConverterCollections$ConverterEntry((Map.Entry)o, this.m_convKeyDown, this.m_convValDown, this.m_convValUp));
        }

        public Iterator iterator() {
            return this.wrapIterator(this.m_set.iterator());
        }

        public Object[] toArray() {
            Object[] ao = this.m_set.toArray();
            int c = ao.length;
            Object[] aEntry = new Map.Entry[c];
            for (int i = 0; i < c; ++i) {
                aEntry[i] = this.wrapEntry((Map.Entry)ao[i]);
            }
            return aEntry;
        }

        public Object[] toArray(Object[] ao) {
            Object[] aoDest;
            int cDest;
            Object[] aoSrc = this.m_set.toArray();
            int cSrc = aoSrc.length;
            if (cSrc > (cDest = (aoDest = ao).length)) {
                cDest = cSrc;
                aoDest = (Object[])Array.newInstance(aoDest.getClass().getComponentType(), cDest);
            }
            if (cDest > cSrc) {
                aoDest[cSrc] = null;
            }
            for (int i = 0; i < cSrc; ++i) {
                aoDest[i] = this.wrapEntry((Map.Entry)aoSrc[i]);
            }
            return aoDest;
        }

        public boolean add(Object o) {
            throw new UnsupportedOperationException();
        }

        public boolean remove(Object o) {
            Map.Entry entry = (Map.Entry)o;
            return this.m_set.remove(new SimpleMapEntry(this.m_convKeyDown.convert(entry.getKey()), this.m_convValDown.convert(entry.getValue())));
        }

        public boolean containsAll(Collection col) {
            return this.m_set.containsAll(this.instantiateEntrySet(col, this.m_convKeyDown, this.m_convKeyUp, this.m_convValDown, this.m_convValUp));
        }

        public boolean addAll(Collection col) {
            throw new UnsupportedOperationException();
        }

        public boolean removeAll(Collection col) {
            return this.m_set.removeAll(this.instantiateEntrySet(col, this.m_convKeyDown, this.m_convKeyUp, this.m_convValDown, this.m_convValUp));
        }

        public boolean retainAll(Collection col) {
            return this.m_set.retainAll(this.instantiateEntrySet(col, this.m_convKeyDown, this.m_convKeyUp, this.m_convValDown, this.m_convValUp));
        }

        public void clear() {
            this.m_set.clear();
        }

        public boolean equals(Object o) {
            if (o == this || o == null) {
                return o == this;
            }
            if (o instanceof ConverterEntrySet) {
                ConverterEntrySet that = (ConverterEntrySet)o;
                return ((Object)this.m_set).equals(that.m_set) && this.m_convKeyUp.equals(that.m_convKeyUp) && this.m_convKeyDown.equals(that.m_convKeyDown) && this.m_convValUp.equals(that.m_convValUp) && this.m_convValDown.equals(that.m_convValDown);
            }
            return false;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("ConverterEntrySet{");
            boolean fFirst = true;
            Iterator iter = this.iterator();
            while (iter.hasNext()) {
                if (fFirst) {
                    fFirst = false;
                } else {
                    sb.append(", ");
                }
                sb.append(iter.next());
            }
            sb.append('}');
            return sb.toString();
        }

        protected Set instantiateEntrySet(Collection col, Converter convKeyUp, Converter convKeyDown, Converter convValUp, Converter convValDown) {
            return ConverterCollections.getEntrySet(col, convKeyUp, convKeyDown, convValUp, convValDown);
        }

        protected Map.Entry wrapEntry(Map.Entry entry) {
            return new ConverterEntry(entry);
        }

        protected Iterator wrapIterator(Iterator iter) {
            return new ConverterIterator(iter);
        }

        protected class ConverterIterator
        extends Base
        implements Iterator {
            protected Iterator m_iter;

            public ConverterIterator(Iterator iter) {
                this.m_iter = iter;
            }

            public boolean hasNext() {
                return this.m_iter.hasNext();
            }

            public Object next() {
                return ConverterEntrySet.this.wrapEntry((Map.Entry)this.m_iter.next());
            }

            public void remove() {
                this.m_iter.remove();
            }
        }

        protected class ConverterEntry
        extends AbstractConverterEntry {
            public ConverterEntry(Map.Entry entry) {
                super(entry);
            }

            protected Converter getKeyUpConv() {
                return ConverterEntrySet.this.m_convKeyUp;
            }

            protected Converter getValueUpConv() {
                return ConverterEntrySet.this.m_convValUp;
            }

            protected Converter getValueDownConv() {
                return ConverterEntrySet.this.m_convValDown;
            }
        }
    }

    public static class ConverterSortedMap
    extends ConverterMap
    implements SortedMap,
    Serializable {
        public ConverterSortedMap(SortedMap map, Converter convKeyUp, Converter convKeyDown, Converter convValUp, Converter convValDown) {
            super(map, convKeyUp, convKeyDown, convValUp, convValDown);
        }

        public Comparator comparator() {
            return ((SortedMap)this.m_map).comparator();
        }

        public SortedMap subMap(Object fromKey, Object toKey) {
            return this.instantiateSortedMap(((SortedMap)this.m_map).subMap(fromKey, toKey), this.m_convKeyUp, this.m_convKeyDown, this.m_convValUp, this.m_convValDown);
        }

        public SortedMap headMap(Object toKey) {
            return this.instantiateSortedMap(((SortedMap)this.m_map).headMap(toKey), this.m_convKeyUp, this.m_convKeyDown, this.m_convValUp, this.m_convValDown);
        }

        public SortedMap tailMap(Object fromKey) {
            return this.instantiateSortedMap(((SortedMap)this.m_map).tailMap(fromKey), this.m_convKeyUp, this.m_convKeyDown, this.m_convValUp, this.m_convValDown);
        }

        public Object firstKey() {
            return this.m_convKeyUp.convert(((SortedMap)this.m_map).firstKey());
        }

        public Object lastKey() {
            return this.m_convKeyUp.convert(((SortedMap)this.m_map).lastKey());
        }

        protected SortedMap instantiateSortedMap(SortedMap map, Converter convKeyUp, Converter convKeyDown, Converter convValUp, Converter convValDown) {
            return ConverterCollections.getSortedMap(map, convKeyUp, convKeyUp, convValDown, convValDown);
        }
    }

    public static class ConverterObservableMap
    extends ConverterMap
    implements ObservableMap,
    CacheMap,
    Serializable {
        public ConverterObservableMap(ObservableMap map, Converter convKeyUp, Converter convKeyDown, Converter convValUp, Converter convValDown) {
            super(map, convKeyUp, convKeyDown, convValUp, convValDown);
        }

        public void addMapListener(MapListener listener) {
            ((ObservableMap)this.m_map).addMapListener(this.getConverterListener(listener));
        }

        public void removeMapListener(MapListener listener) {
            ((ObservableMap)this.m_map).removeMapListener(this.getConverterListener(listener));
        }

        public void addMapListener(MapListener listener, Object oKey, boolean fLite) {
            ((ObservableMap)this.m_map).addMapListener(this.getConverterListener(listener), oKey, fLite);
        }

        public void removeMapListener(MapListener listener, Object oKey) {
            ((ObservableMap)this.m_map).removeMapListener(this.getConverterListener(listener), oKey);
        }

        public void addMapListener(MapListener listener, Filter filter, boolean fLite) {
            ((ObservableMap)this.m_map).addMapListener(this.getConverterListener(listener), filter, fLite);
        }

        public void removeMapListener(MapListener listener, Filter filter) {
            ((ObservableMap)this.m_map).removeMapListener(this.getConverterListener(listener), filter);
        }

        public Map getAll(Collection colKeys) {
            Map map = this.m_map;
            if (map instanceof CacheMap) {
                Collection colKeysConv = colKeys instanceof Set ? this.instantiateSet((Set)colKeys, this.m_convKeyDown, this.m_convKeyUp) : this.instantiateCollection(colKeys, this.m_convKeyDown, this.m_convKeyUp);
                return this.instantiateMap(((CacheMap)map).getAll(colKeysConv), this.m_convKeyUp, this.m_convKeyDown, this.m_convValUp, this.m_convValDown);
            }
            HashMap mapResult = new HashMap(colKeys.size());
            Iterator iter = colKeys.iterator();
            while (iter.hasNext()) {
                Object oKey = iter.next();
                Object oVal = this.get(oKey);
                if (oVal == null && !this.containsKey(oKey)) continue;
                mapResult.put(oKey, oVal);
            }
            return mapResult;
        }

        public Object put(Object oKey, Object oValue, long cMillis) {
            Map map = this.m_map;
            if (map instanceof CacheMap) {
                return this.m_convValUp.convert(((CacheMap)map).put(this.m_convKeyDown.convert(oKey), this.m_convValDown.convert(oValue), cMillis));
            }
            if (cMillis <= 0L) {
                return super.put(oKey, oValue);
            }
            throw new UnsupportedOperationException();
        }

        protected MapListener getConverterListener(MapListener listener) {
            Base listenerConv = new ConverterMapListener(this, listener, this.m_convKeyUp, this.m_convValUp);
            if (listener instanceof MapListenerSupport.SynchronousListener) {
                listenerConv = new MapListenerSupport.WrapperSynchronousListener((MapListener)((Object)listenerConv));
            }
            return listenerConv;
        }
    }

    public static class ConverterMap
    extends Base
    implements Map,
    QueryMap,
    Serializable {
        protected Map m_map;
        protected Converter m_convKeyUp;
        protected Converter m_convKeyDown;
        protected Converter m_convValUp;
        protected Converter m_convValDown;
        protected transient Set m_set;

        public ConverterMap(Map map, Converter convKeyUp, Converter convKeyDown, Converter convValUp, Converter convValDown) {
            ConverterMap.azzert(map != null && convKeyUp != null && convKeyDown != null && convValUp != null && convValDown != null);
            this.m_map = map;
            this.m_convKeyUp = convKeyUp;
            this.m_convKeyDown = convKeyDown;
            this.m_convValUp = convValUp;
            this.m_convValDown = convValDown;
        }

        public int size() {
            return this.m_map.size();
        }

        public boolean isEmpty() {
            return this.m_map.isEmpty();
        }

        public boolean containsKey(Object key) {
            return this.m_map.containsKey(this.m_convKeyDown.convert(key));
        }

        public boolean containsValue(Object value) {
            return this.m_map.containsValue(this.m_convValDown.convert(value));
        }

        public Object get(Object key) {
            return this.m_convValUp.convert(this.m_map.get(this.m_convKeyDown.convert(key)));
        }

        public Object put(Object key, Object value) {
            return this.m_convValUp.convert(this.m_map.put(this.m_convKeyDown.convert(key), this.m_convValDown.convert(value)));
        }

        public Object remove(Object key) {
            return this.m_convValUp.convert(this.m_map.remove(this.m_convKeyDown.convert(key)));
        }

        public void putAll(Map map) {
            this.m_map.putAll(this.instantiateMap(map, this.m_convKeyDown, this.m_convKeyUp, this.m_convValDown, this.m_convValUp));
        }

        public void clear() {
            this.m_map.clear();
        }

        public Set keySet() {
            return this.instantiateSet(this.m_map.keySet(), this.m_convKeyUp, this.m_convKeyDown);
        }

        public Collection values() {
            return this.instantiateCollection(this.m_map.values(), this.m_convValUp, this.m_convValDown);
        }

        public Set entrySet() {
            if (this.m_set == null) {
                Set set = this.m_map.entrySet();
                this.m_set = this.instantiateEntrySet(set, this.m_convKeyUp, this.m_convKeyDown, this.m_convValUp, this.m_convValDown);
            }
            return this.m_set;
        }

        public Set keySet(Filter filter) {
            Map map = this.m_map;
            Set set = map instanceof QueryMap ? ((QueryMap)map).keySet(filter) : InvocableMapHelper.query(map, filter, false, false, null);
            return this.instantiateSet(set, this.m_convKeyUp, this.m_convKeyDown);
        }

        public Set entrySet(Filter filter) {
            Map map = this.m_map;
            Set set = map instanceof QueryMap ? ((QueryMap)map).entrySet(filter) : InvocableMapHelper.query(map, filter, true, false, null);
            return this.instantiateEntrySet(set, this.m_convKeyUp, this.m_convKeyDown, this.m_convValUp, this.m_convValDown);
        }

        public Set entrySet(Filter filter, Comparator comparator) {
            Map map = this.m_map;
            Set set = map instanceof QueryMap ? ((QueryMap)map).entrySet(filter, comparator) : InvocableMapHelper.query(map, filter, true, true, comparator);
            return this.instantiateEntrySet(set, this.m_convKeyUp, this.m_convKeyDown, this.m_convValUp, this.m_convValDown);
        }

        public void addIndex(ValueExtractor extractor, boolean fOrdered, Comparator comparator) {
        }

        public void removeIndex(ValueExtractor extractor) {
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("ConverterMap{");
            boolean fFirst = true;
            Iterator iter = this.entrySet().iterator();
            while (iter.hasNext()) {
                if (fFirst) {
                    fFirst = false;
                } else {
                    sb.append(", ");
                }
                sb.append(iter.next());
            }
            sb.append("}");
            return sb.toString();
        }

        protected Collection instantiateCollection(Collection col, Converter convUp, Converter convDown) {
            return ConverterCollections.getCollection(col, convUp, convDown);
        }

        protected Set instantiateSet(Set set, Converter convUp, Converter convDown) {
            return ConverterCollections.getSet(set, convUp, convDown);
        }

        protected Map instantiateMap(Map map, Converter convKeyUp, Converter convKeyDown, Converter convValUp, Converter convValDown) {
            return ConverterCollections.getMap(map, convKeyUp, convKeyDown, convValUp, convValDown);
        }

        protected Set instantiateEntrySet(Set set, Converter convKeyUp, Converter convKeyDown, Converter convValUp, Converter convValDown) {
            return ConverterCollections.getEntrySet(set, convKeyUp, convKeyDown, convValUp, convValDown);
        }
    }

    public static class ConverterListIterator
    extends Base
    implements ListIterator {
        protected ListIterator m_iter;
        protected Converter m_convUp;
        protected Converter m_convDown;

        public ConverterListIterator(ListIterator iter, Converter convUp, Converter convDown) {
            ConverterListIterator.azzert(iter != null && convUp != null && convDown != null);
            this.m_iter = iter;
            this.m_convUp = convUp;
            this.m_convDown = convDown;
        }

        public boolean hasNext() {
            return this.m_iter.hasNext();
        }

        public Object next() {
            return this.m_convUp.convert(this.m_iter.next());
        }

        public boolean hasPrevious() {
            return this.m_iter.hasPrevious();
        }

        public Object previous() {
            return this.m_convUp.convert(this.m_iter.previous());
        }

        public int nextIndex() {
            return this.m_iter.nextIndex();
        }

        public int previousIndex() {
            return this.m_iter.previousIndex();
        }

        public void remove() {
            this.m_iter.remove();
        }

        public void set(Object o) {
            this.m_iter.set(this.m_convDown.convert(o));
        }

        public void add(Object o) {
            this.m_iter.add(this.m_convDown.convert(o));
        }
    }

    public static class ConverterList
    extends ConverterCollection
    implements List,
    Serializable {
        public ConverterList(List list, Converter convUp, Converter convDown) {
            super(list, convUp, convDown);
        }

        public Object get(int index) {
            return this.m_convUp.convert(((List)this.m_col).get(index));
        }

        public Object set(int index, Object element) {
            return this.m_convUp.convert(((List)this.m_col).set(index, this.m_convDown.convert(element)));
        }

        public void add(int index, Object element) {
            ((List)this.m_col).add(index, this.m_convDown.convert(element));
        }

        public boolean addAll(int index, Collection col) {
            return ((List)this.m_col).addAll(index, this.instantiateCollection(col, this.m_convDown, this.m_convUp));
        }

        public Object remove(int index) {
            return this.m_convUp.convert(((List)this.m_col).remove(index));
        }

        public int indexOf(Object o) {
            return ((List)this.m_col).indexOf(this.m_convDown.convert(o));
        }

        public int lastIndexOf(Object o) {
            return ((List)this.m_col).lastIndexOf(this.m_convDown.convert(o));
        }

        public ListIterator listIterator() {
            return this.instantiateListIterator(((List)this.m_col).listIterator(), this.m_convUp, this.m_convDown);
        }

        public ListIterator listIterator(int index) {
            return this.instantiateListIterator(((List)this.m_col).listIterator(index), this.m_convUp, this.m_convDown);
        }

        public List subList(int fromIndex, int toIndex) {
            return this.instantiateList(((List)this.m_col).subList(fromIndex, toIndex), this.m_convUp, this.m_convDown);
        }

        protected List instantiateList(List list, Converter convUp, Converter convDown) {
            return ConverterCollections.getList(list, convUp, convDown);
        }

        protected ListIterator instantiateListIterator(ListIterator iter, Converter convUp, Converter convDown) {
            return ConverterCollections.getListIterator(iter, convUp, convDown);
        }
    }

    public static class ConverterSortedSet
    extends ConverterSet
    implements SortedSet,
    Serializable {
        public ConverterSortedSet(SortedSet set, Converter convUp, Converter convDown) {
            super(set, convUp, convDown);
        }

        public Comparator comparator() {
            return ((SortedSet)this.m_col).comparator();
        }

        public SortedSet subSet(Object fromElement, Object toElement) {
            SortedSet<Object> subset = ((SortedSet)this.m_col).subSet(this.m_convDown.convert(fromElement), this.m_convDown.convert(toElement));
            return this.instantiateSortedSet(subset, this.m_convUp, this.m_convDown);
        }

        public SortedSet headSet(Object toElement) {
            SortedSet<Object> subset = ((SortedSet)this.m_col).headSet(this.m_convDown.convert(toElement));
            return this.instantiateSortedSet(subset, this.m_convUp, this.m_convDown);
        }

        public SortedSet tailSet(Object fromElement) {
            SortedSet<Object> subset = ((SortedSet)this.m_col).tailSet(this.m_convDown.convert(fromElement));
            return this.instantiateSortedSet(subset, this.m_convUp, this.m_convDown);
        }

        public Object first() {
            return this.m_convUp.convert(((SortedSet)this.m_col).first());
        }

        public Object last() {
            return this.m_convUp.convert(((SortedSet)this.m_col).last());
        }

        protected SortedSet instantiateSortedSet(SortedSet set, Converter convUp, Converter convDown) {
            return ConverterCollections.getSortedSet(set, convUp, convDown);
        }
    }

    public static class ConverterSet
    extends ConverterCollection
    implements Set,
    Serializable {
        public ConverterSet(Set set, Converter convUp, Converter convDown) {
            super(set, convUp, convDown);
        }
    }

    public static class ConverterCollection
    extends Base
    implements Collection,
    Serializable {
        protected Collection m_col;
        protected Converter m_convUp;
        protected Converter m_convDown;

        public ConverterCollection(Collection col, Converter convUp, Converter convDown) {
            ConverterCollection.azzert(col != null && convUp != null && convDown != null);
            this.m_col = col;
            this.m_convUp = convUp;
            this.m_convDown = convDown;
        }

        public int size() {
            return this.m_col.size();
        }

        public boolean isEmpty() {
            return this.m_col.isEmpty();
        }

        public boolean contains(Object o) {
            return this.m_col.contains(this.m_convDown.convert(o));
        }

        public Iterator iterator() {
            return this.instantiateIterator(this.m_col.iterator(), this.m_convUp);
        }

        public Object[] toArray() {
            return ConverterCollections.convertArray(this.m_col.toArray(), this.m_convUp);
        }

        public Object[] toArray(Object[] aoDest) {
            return ConverterCollections.convertArray(this.m_col.toArray(), this.m_convUp, aoDest);
        }

        public boolean add(Object o) {
            return this.m_col.add(this.m_convDown.convert(o));
        }

        public boolean remove(Object o) {
            return this.m_col.remove(this.m_convDown.convert(o));
        }

        public boolean containsAll(Collection col) {
            return this.m_col.containsAll(this.instantiateCollection(col, this.m_convDown, this.m_convUp));
        }

        public boolean addAll(Collection col) {
            return this.m_col.addAll(this.instantiateCollection(col, this.m_convDown, this.m_convUp));
        }

        public boolean removeAll(Collection col) {
            return this.m_col.removeAll(this.instantiateCollection(col, this.m_convDown, this.m_convUp));
        }

        public boolean retainAll(Collection col) {
            return this.m_col.retainAll(this.instantiateCollection(col, this.m_convDown, this.m_convUp));
        }

        public void clear() {
            this.m_col.clear();
        }

        public boolean equals(Object o) {
            if (o == this || o == null) {
                return o == this;
            }
            if (o instanceof ConverterCollection) {
                ConverterCollection that = (ConverterCollection)o;
                return ((Object)this.m_col).equals(that.m_col) && this.m_convUp.equals(that.m_convUp) && this.m_convDown.equals(that.m_convDown);
            }
            return false;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("ConverterCollection{");
            boolean fFirst = true;
            Iterator iter = this.iterator();
            while (iter.hasNext()) {
                if (fFirst) {
                    fFirst = false;
                } else {
                    sb.append(", ");
                }
                sb.append(iter.next());
            }
            sb.append('}');
            return sb.toString();
        }

        public void invalidate() {
            this.m_col = null;
            this.m_convUp = null;
            this.m_convDown = null;
        }

        protected Collection instantiateCollection(Collection col, Converter convUp, Converter convDown) {
            return ConverterCollections.getCollection(col, convUp, convDown);
        }

        protected Iterator instantiateIterator(Iterator iter, Converter conv) {
            return ConverterCollections.getIterator(iter, conv);
        }
    }
}

