/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.util;

import com.tangosol.util.Base;

public abstract class Daemon
extends Base
implements Runnable {
    private static final int STATE_STOPPED = 0;
    private static final int STATE_STARTING = 1;
    private static final int STATE_RUNNING = 2;
    private static final int STATE_STOPPING = 3;
    private String m_sConfiguredName;
    private int m_nConfiguredPriority;
    private ClassLoader m_loaderConfigured;
    private volatile DaemonWorker m_worker;
    private volatile int m_nState;
    private ThreadGroup m_threadGroup;

    public Daemon() {
        this(null);
    }

    public Daemon(String sName) {
        this(sName, 5, false);
    }

    public Daemon(String sName, int nPriority, boolean fStart) {
        this.setConfiguredName(sName);
        this.setConfiguredPriority(nPriority);
        ThreadGroup threadGroup = new ThreadGroup(sName);
        threadGroup.setDaemon(false);
        this.m_threadGroup = threadGroup;
        if (fStart) {
            this.start();
        }
    }

    public abstract void run();

    public Thread getThread() {
        DaemonWorker worker = this.getWorker();
        return worker == null ? null : worker.getThread();
    }

    public DaemonWorker getWorker() {
        return this.m_worker;
    }

    public synchronized void start() {
        DaemonWorker worker = this.getWorker();
        if (worker != null && worker.isCurrentThread()) {
            return;
        }
        if (worker != null && !worker.getThread().isAlive()) {
            this.changeState(0, worker);
        }
        switch (this.getState()) {
            default: {
                worker = this.instantiateWorker();
                this.configureWorker(worker);
                this.changeState(1, worker);
                worker.getThread().start();
            }
            case 1: {
                Daemon.azzert(worker != null);
                this.finishStarting(worker);
                return;
            }
            case 2: {
                return;
            }
            case 3: 
        }
    }

    public boolean isRunning() {
        switch (this.getState()) {
            default: {
                return false;
            }
            case 2: 
            case 3: 
        }
        Thread thread = this.getThread();
        return thread != null && thread.isAlive();
    }

    public synchronized void stop() {
        DaemonWorker worker = this.getWorker();
        if (worker != null && worker.isCurrentThread()) {
            this.changeState(0, worker);
            return;
        }
        if (this.isOnWorkerThread()) {
            return;
        }
        if (worker != null && !worker.getThread().isAlive()) {
            this.changeState(0, worker);
            return;
        }
        switch (this.getState()) {
            case 1: {
                this.finishStarting(worker);
                if (this.getState() != 2 || worker != this.getWorker()) {
                    return;
                }
            }
            case 2: {
                this.changeState(3, worker);
                return;
            }
            case 0: 
            case 3: {
                return;
            }
        }
    }

    public boolean isStopping() {
        switch (this.getState()) {
            case 3: {
                return true;
            }
            case 0: {
                return this.isOnWorkerThread();
            }
        }
        return false;
    }

    public boolean isOnWorkerThread() {
        return this.m_threadGroup == Thread.currentThread().getThreadGroup();
    }

    protected int getState() {
        return this.m_nState;
    }

    protected void finishStarting(DaemonWorker worker) {
        while (worker == this.getWorker() && worker.getThread().isAlive() && this.getState() == 1) {
            try {
                this.wait(1000L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw Daemon.ensureRuntimeException(e);
            }
        }
    }

    protected synchronized void changeState(int nState, DaemonWorker worker) {
        DaemonWorker workerPrev = this.getWorker();
        switch (nState) {
            case 1: {
                if (workerPrev != null) {
                    Daemon.err("unexpected state: a thread (" + worker + ") is starting while another thread (" + workerPrev + ") still exists");
                }
                this.m_worker = worker;
                this.m_nState = 1;
                break;
            }
            case 2: {
                if (worker != workerPrev) break;
                this.m_nState = 2;
                break;
            }
            case 3: {
                if (worker != workerPrev) break;
                worker.notifyStopping();
                this.m_nState = 3;
                break;
            }
            case 0: {
                if (worker != workerPrev) break;
                worker.notifyStopping();
                this.m_worker = null;
                this.m_nState = 0;
            }
        }
        this.notifyAll();
    }

    protected void setConfiguredPriority(int nPriority) {
        nPriority = Math.min(nPriority, 10);
        this.m_nConfiguredPriority = nPriority = Math.max(nPriority, 1);
    }

    protected int getConfiguredPriority() {
        return this.m_nConfiguredPriority;
    }

    protected void setConfiguredName(String sName) {
        this.m_sConfiguredName = sName;
    }

    protected String getConfiguredName() {
        return this.m_sConfiguredName;
    }

    public void setThreadContextClassLoader(ClassLoader loader) {
        Thread thread = this.getThread();
        if (thread != null) {
            thread.setContextClassLoader(loader);
        }
        this.m_loaderConfigured = loader;
    }

    public ClassLoader getThreadContextClassLoader() {
        return this.m_loaderConfigured;
    }

    protected DaemonWorker instantiateWorker() {
        DaemonWorker worker = new DaemonWorker();
        worker.setThread(Daemon.makeThread(this.m_threadGroup, worker, null));
        return worker;
    }

    protected void configureWorker(DaemonWorker worker) {
        ClassLoader loader;
        Thread threadWorker = worker.getThread();
        threadWorker.setDaemon(true);
        threadWorker.setPriority(this.getConfiguredPriority());
        String sName = this.getConfiguredName();
        if (sName != null) {
            threadWorker.setName(sName);
        }
        if ((loader = this.getThreadContextClassLoader()) != null) {
            threadWorker.setContextClassLoader(loader);
        }
    }

    public String toString() {
        return "Daemon{" + this.getDescription() + '}';
    }

    protected String getDescription() {
        return "Thread=\"" + this.getThread() + '\"' + ", State=" + Daemon.toStateString(this.getState());
    }

    protected static String toStateString(int nState) {
        switch (nState) {
            case 1: {
                return "Starting";
            }
            case 2: {
                return "Running";
            }
            case 3: {
                return "Stopping";
            }
            case 0: {
                return "Stopped";
            }
        }
        return "Unknown";
    }

    public class DaemonWorker
    implements Runnable {
        private volatile boolean m_fStopping;
        private Thread m_thread;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Daemon daemon = this.getDaemon();
            Base.azzert(daemon != null);
            try {
                daemon.changeState(2, this);
                daemon.run();
            }
            finally {
                daemon.changeState(0, this);
            }
        }

        protected Daemon getDaemon() {
            return Daemon.this;
        }

        protected void notifyStopping() {
            this.m_fStopping = true;
        }

        protected boolean isStopping() {
            return this.m_fStopping;
        }

        protected void setThread(Thread thread) {
            this.m_thread = thread;
        }

        protected Thread getThread() {
            return this.m_thread;
        }

        protected boolean isCurrentThread() {
            return Thread.currentThread() == this.getThread();
        }
    }
}

