/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.util;

import com.tangosol.util.Base;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class Dequeue
extends Base
implements Enumeration,
Iterator,
Cloneable,
Serializable {
    private static final int DEFAULT_MAX_ELEMENTS = 32;
    Object[] m_aoItem;
    int m_iFront;
    int m_iBack;

    public Dequeue() {
        this.removeAllElements();
    }

    public boolean hasMoreElements() {
        return !this.isEmpty();
    }

    public Object nextElement() throws NoSuchElementException {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        this.m_iFront = this.next(this.m_iFront);
        Object o = this.m_aoItem[this.m_iFront];
        this.m_aoItem[this.m_iFront] = null;
        return o;
    }

    public boolean hasNext() {
        return !this.isEmpty();
    }

    public Object next() {
        return this.nextElement();
    }

    public void remove() {
        throw new UnsupportedOperationException("iterator is immutable");
    }

    public void addElement(Object o) {
        if (this.isFull()) {
            this.grow();
        }
        this.m_iBack = this.next(this.m_iBack);
        this.m_aoItem[this.m_iBack] = o;
    }

    public void putBackElement(Object o) {
        if (this.isFull()) {
            this.grow();
        }
        this.m_aoItem[this.m_iFront] = o;
        this.m_iFront = this.prev(this.m_iFront);
    }

    public void removeAllElements() {
        this.m_aoItem = new Object[32];
        this.m_iFront = 0;
        this.m_iBack = 0;
    }

    public int capacity() {
        return this.m_aoItem.length - 1;
    }

    public int size() {
        if (this.m_iFront <= this.m_iBack) {
            return this.m_iBack - this.m_iFront;
        }
        return this.m_aoItem.length - (this.m_iFront - this.m_iBack);
    }

    public boolean isEmpty() {
        return this.m_iFront == this.m_iBack;
    }

    public boolean isFull() {
        return this.m_iFront == this.next(this.m_iBack);
    }

    public Object clone() {
        try {
            Dequeue that = (Dequeue)super.clone();
            that.m_aoItem = (Object[])that.m_aoItem.clone();
            return that;
        }
        catch (Exception e) {
            throw Dequeue.ensureRuntimeException(e);
        }
    }

    protected int next(int i) {
        return ++i == this.m_aoItem.length ? 0 : i;
    }

    protected int prev(int i) {
        return i == 0 ? this.m_aoItem.length - 1 : --i;
    }

    protected void grow() {
        int cOld = this.m_aoItem.length;
        int cNew = cOld + Math.max(Math.min(cOld >> 1, 256), 32);
        Object[] aoNew = new Object[cNew];
        if (this.m_iFront < this.m_iBack) {
            System.arraycopy(this.m_aoItem, this.m_iFront, aoNew, this.m_iFront, this.m_iBack - this.m_iFront + 1);
        } else if (this.m_iFront > this.m_iBack) {
            System.arraycopy(this.m_aoItem, 0, aoNew, 0, this.m_iBack + 1);
            System.arraycopy(this.m_aoItem, this.m_iFront, aoNew, cNew - (cOld - this.m_iFront), cOld - this.m_iFront);
            this.m_iFront += cNew - cOld;
        }
        this.m_aoItem = aoNew;
    }
}

