/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.util;

import com.tangosol.io.AbstractWriteBuffer;
import com.tangosol.io.ByteArrayReadBuffer;
import com.tangosol.io.ByteArrayWriteBuffer;
import com.tangosol.io.ClassLoaderAware;
import com.tangosol.io.ExternalizableLite;
import com.tangosol.io.InputStreaming;
import com.tangosol.io.MultiBufferWriteBuffer;
import com.tangosol.io.ReadBuffer;
import com.tangosol.io.Resolving;
import com.tangosol.io.ResolvingMarshalInputStream;
import com.tangosol.io.ResolvingMarshalOutputStream;
import com.tangosol.io.ResolvingObjectInputStream;
import com.tangosol.io.ResolvingObjectOutputStream;
import com.tangosol.io.Serializer;
import com.tangosol.io.SimpleSerializer;
import com.tangosol.io.WrapperDataOutputStream;
import com.tangosol.io.WrapperObjectOutputStream;
import com.tangosol.io.WrapperOutputStream;
import com.tangosol.io.WriteBuffer;
import com.tangosol.io.pof.ConfigurablePofContext;
import com.tangosol.io.pof.PofInputStream;
import com.tangosol.io.pof.PofOutputStream;
import com.tangosol.io.pof.RawDate;
import com.tangosol.io.pof.RawDateTime;
import com.tangosol.io.pof.RawTime;
import com.tangosol.run.xml.SimpleParser;
import com.tangosol.run.xml.XmlBean;
import com.tangosol.run.xml.XmlDocument;
import com.tangosol.run.xml.XmlElement;
import com.tangosol.run.xml.XmlHelper;
import com.tangosol.run.xml.XmlSerializable;
import com.tangosol.util.Base;
import com.tangosol.util.Binary;
import com.tangosol.util.BinaryWriteBuffer;
import com.tangosol.util.BitHelper;
import com.tangosol.util.Converter;
import com.tangosol.util.Resources;
import com.tangosol.util.WrapperException;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.EOFException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.NotSerializableException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.UTFDataFormatException;
import java.lang.ref.WeakReference;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.WeakHashMap;
import sun.rmi.server.MarshalInputStream;
import sun.rmi.server.MarshalOutputStream;

public abstract class ExternalizableHelper
extends BitHelper {
    protected static final int FMT_NONE = -1;
    protected static final int FMT_NULL = 0;
    protected static final int FMT_INT = 1;
    protected static final int FMT_LONG = 2;
    protected static final int FMT_DOUBLE = 3;
    protected static final int FMT_INTEGER = 4;
    protected static final int FMT_DECIMAL = 5;
    protected static final int FMT_STRING = 6;
    protected static final int FMT_BINARY = 7;
    protected static final int FMT_B_ARRAY = 8;
    protected static final int FMT_XML_SER = 9;
    protected static final int FMT_OBJ_EXT = 10;
    protected static final int FMT_OBJ_SER = 11;
    protected static final int FMT_XML_BEAN = 12;
    protected static final int FMT_IDO = 13;
    protected static final int FMT_FLOAT = 14;
    protected static final int FMT_SHORT = 15;
    protected static final int FMT_BYTE = 16;
    protected static final int FMT_BOOLEAN = 17;
    protected static final int FMT_BIN_DECO = 18;
    public static final int DECO_ID_MIN = 0;
    public static final int DECO_ID_MAX = 7;
    public static final int DECO_VALUE = 0;
    public static final int DECO_EXPIRY = 1;
    public static final int DECO_STORE = 2;
    public static final int DECO_CUSTOM = 7;
    public static final int TRINT_DOMAIN_SPAN = 0x1000000;
    public static final int TRINT_MAX_VALUE = 0xFFFFFF;
    public static final int TRINT_MAX_VARIANCE = 0x800000;
    public static final Converter CONVERTER_TO_BINARY;
    public static final Converter CONVERTER_FROM_BINARY;
    public static final String PROPERTY_CONFIG = "tangosol.externalizable.config";
    public static final boolean FORCE_RESOLVING_STREAMS;
    public static final boolean USE_MARSHAL_STREAMS;
    public static final boolean USE_XMLBEAN_CLASS_CACHE;
    public static final XmlBeanClassCache XMLBEAN_CLASS_CACHE;
    public static final int STATS_THRESHOLD;
    public static final boolean USE_POF_STREAMS;
    private static final Stats[] s_astats;
    private static final Map s_mapSerializerByClassLoader;
    static final /* synthetic */ boolean $assertionsDisabled;

    public static byte[] toByteArray(Object o) {
        try {
            return ExternalizableHelper.internalWriteObject(o, false).toByteArray();
        }
        catch (IOException e) {
            throw new WrapperException(e);
        }
    }

    public static Object fromByteArray(byte[] ab) {
        return ExternalizableHelper.fromByteArray(ab, null);
    }

    public static Object fromByteArray(byte[] ab, ClassLoader loader) {
        try {
            return ExternalizableHelper.readObject(new ByteArrayReadBuffer(ab).getBufferInput(), loader);
        }
        catch (IOException e) {
            throw new WrapperException(e);
        }
    }

    public static Binary toBinary(Object o) {
        try {
            return ExternalizableHelper.internalWriteObject(o, true).toBinary();
        }
        catch (IOException e) {
            throw new WrapperException(e);
        }
    }

    public static Object fromBinary(Binary bin) {
        return ExternalizableHelper.fromBinary(bin, null);
    }

    public static Object fromBinary(Binary bin, ClassLoader loader) {
        try {
            return ExternalizableHelper.readObject(bin.getBufferInput(), loader);
        }
        catch (IOException e) {
            throw new WrapperException(e);
        }
    }

    public static Serializer ensureSerializer(ClassLoader loader) {
        Map map = s_mapSerializerByClassLoader;
        Serializer serializer = (Serializer)map.get(loader = ExternalizableHelper.resolveLoader(loader));
        if (serializer == null) {
            serializer = USE_POF_STREAMS ? new ConfigurablePofContext() : new SimpleSerializer();
            ((ClassLoaderAware)((Object)serializer)).setContextClassLoader(loader);
            map.put(loader, serializer);
        }
        return serializer;
    }

    public static int readTrint(DataInput in) throws IOException {
        int n;
        if (in instanceof PofInputStream) {
            n = ((PofInputStream)in).readInt();
        } else {
            n = in.readUnsignedByte() << 16 | in.readUnsignedByte() << 8 | in.readUnsignedByte();
            if ((n & 0x800000) != 0) {
                n |= 0xFF000000;
            }
        }
        return n;
    }

    public static int readUnsignedTrint(DataInput in) throws IOException {
        int n = in instanceof PofInputStream ? ((PofInputStream)in).readInt() : in.readUnsignedByte() << 16 | in.readUnsignedByte() << 8 | in.readUnsignedByte();
        return n;
    }

    public static void writeTrint(DataOutput out, int n) throws IOException {
        if (out instanceof PofOutputStream) {
            ((PofOutputStream)out).writeInt(n);
        } else {
            out.writeByte(n >>> 16);
            out.writeByte(n >>> 8);
            out.writeByte(n);
        }
    }

    public static void writeTrint(DataOutput out, long l) throws IOException {
        ExternalizableHelper.writeTrint(out, (int)(l & 0xFFFFFFL));
    }

    public static int makeTrint(long l) {
        return (int)(l & 0xFFFFFFL);
    }

    public static long translateTrint(int nTrint, long lCurrent) {
        long lLo = lCurrent - 0x800000L;
        long lHi = lCurrent + 0x800000L;
        nTrint &= 0xFFFFFF;
        long lBase = lCurrent >>> 24;
        for (int i = -1; i <= 1; ++i) {
            long lGuess = lBase + (long)i << 24 | (long)nTrint;
            if (lGuess < lLo || lGuess > lHi) continue;
            if (lGuess < 1L) {
                if (lCurrent >= 256L) {
                    throw new IllegalStateException("translateTrint failed because (lCurrent >= 0x100L): nTrint=" + nTrint + ", lCurrent=" + lCurrent + ", lGuess=" + lGuess);
                }
                if ((lGuess += 0x1000000L) < 1L) {
                    throw new IllegalStateException("translateTrint failed because (lGuess < 1L): nTrint=" + nTrint + ", lCurrent=" + lCurrent + ", lGuess=" + lGuess);
                }
            }
            return lGuess;
        }
        throw new IllegalStateException("translateTrint failed: nTrint=" + nTrint + ", lCurrent=" + lCurrent);
    }

    public static int readInt(DataInput in) throws IOException {
        int n;
        if (in instanceof ReadBuffer.BufferInput) {
            n = ((ReadBuffer.BufferInput)in).readPackedInt();
        } else if (in instanceof PofInputStream) {
            n = ((PofInputStream)in).readInt();
        } else {
            boolean fNeg;
            int b = in.readUnsignedByte();
            n = b & 0x3F;
            int cBits = 6;
            boolean bl = fNeg = (b & 0x40) != 0;
            while ((b & 0x80) != 0) {
                b = in.readUnsignedByte();
                n |= (b & 0x7F) << cBits;
                cBits += 7;
            }
            if (fNeg) {
                n ^= 0xFFFFFFFF;
            }
        }
        return n;
    }

    public static void writeInt(DataOutput out, int n) throws IOException {
        if (out instanceof WriteBuffer.BufferOutput) {
            ((WriteBuffer.BufferOutput)out).writePackedInt(n);
        } else if (out instanceof PofOutputStream) {
            ((PofOutputStream)out).writeInt(n);
        } else {
            int b = 0;
            if (n < 0) {
                b = 64;
                n ^= 0xFFFFFFFF;
            }
            b |= (byte)(n & 0x3F);
            n >>>= 6;
            while (n != 0) {
                out.writeByte(b |= 0x80);
                b = n & 0x7F;
                n >>>= 7;
            }
            out.writeByte(b);
        }
    }

    public static long readLong(DataInput in) throws IOException {
        long l;
        if (in instanceof ReadBuffer.BufferInput) {
            l = ((ReadBuffer.BufferInput)in).readPackedLong();
        } else if (in instanceof PofInputStream) {
            l = ((PofInputStream)in).readLong();
        } else {
            boolean fNeg;
            int b = in.readUnsignedByte();
            l = b & 0x3F;
            int cBits = 6;
            boolean bl = fNeg = (b & 0x40) != 0;
            while ((b & 0x80) != 0) {
                b = in.readUnsignedByte();
                l |= (long)(b & 0x7F) << cBits;
                cBits += 7;
            }
            if (fNeg) {
                l ^= 0xFFFFFFFFFFFFFFFFL;
            }
        }
        return l;
    }

    public static void writeLong(DataOutput out, long l) throws IOException {
        if (out instanceof WriteBuffer.BufferOutput) {
            ((WriteBuffer.BufferOutput)out).writePackedLong(l);
        } else if (out instanceof PofOutputStream) {
            ((PofOutputStream)out).writeLong(l);
        } else {
            int b = 0;
            if (l < 0L) {
                b = 64;
                l ^= 0xFFFFFFFFFFFFFFFFL;
            }
            b |= (byte)((int)l & 0x3F);
            l >>>= 6;
            while (l != 0L) {
                out.writeByte(b |= 0x80);
                b = (int)l & 0x7F;
                l >>>= 7;
            }
            out.writeByte(b);
        }
    }

    public static boolean[] readBooleanArray(DataInput in) throws IOException {
        boolean[] af;
        if (in instanceof PofInputStream) {
            af = (boolean[])((PofInputStream)in).readObject();
        } else {
            int c = ExternalizableHelper.readInt(in);
            af = new boolean[c];
            int cb = (c + 7) / 8;
            int i = 0;
            for (int of = 0; of < cb; ++of) {
                int nBits = in.readUnsignedByte();
                for (int nMask = 1; i < c && nMask <= 255; nMask <<= 1) {
                    af[i++] = (nBits & nMask) != 0;
                }
            }
        }
        return af;
    }

    public static void writeBooleanArray(DataOutput out, boolean[] af) throws IOException {
        if (out instanceof PofOutputStream) {
            ((PofOutputStream)out).writeObject(af);
        } else {
            int c = af.length;
            ExternalizableHelper.writeInt(out, c);
            int cb = (c + 7) / 8;
            int i = 0;
            for (int of = 0; of < cb; ++of) {
                int nBits = 0;
                for (int nMask = 1; i < c && nMask <= 255; nMask <<= 1) {
                    if (!af[i++]) continue;
                    nBits |= nMask;
                }
                out.writeByte(nBits);
            }
        }
    }

    public static byte[] readByteArray(DataInput in) throws IOException {
        byte[] ab;
        if (in instanceof PofInputStream) {
            ab = (byte[])((PofInputStream)in).readObject();
        } else {
            int cb = ExternalizableHelper.readInt(in);
            ab = new byte[cb];
            in.readFully(ab);
        }
        return ab;
    }

    public static void writeByteArray(DataOutput out, byte[] ab) throws IOException {
        if (out instanceof PofOutputStream) {
            ((PofOutputStream)out).writeObject(ab);
        } else {
            int cb = ab.length;
            ExternalizableHelper.writeInt(out, cb);
            out.write(ab, 0, cb);
        }
    }

    public static String readUTF(DataInput in) throws IOException {
        String s;
        if (in instanceof ReadBuffer.BufferInput) {
            s = ((ReadBuffer.BufferInput)in).readSafeUTF();
        } else if (in instanceof PofInputStream) {
            s = ((PofInputStream)in).readUTF();
        } else {
            int cb = ExternalizableHelper.readInt(in);
            if (cb < 0) {
                return null;
            }
            if (cb == 0) {
                return "";
            }
            byte[] ab = new byte[cb];
            in.readFully(ab);
            s = ExternalizableHelper.convertUTF(ab, 0, cb, new char[cb]);
        }
        return s;
    }

    public static String convertUTF(byte[] ab, int of, int cb, char[] ach) throws UTFDataFormatException {
        int ofAsc;
        boolean fAscii = true;
        int ofch = 0;
        int ofEnd = of + cb;
        for (ofAsc = of; ofAsc < ofEnd; ++ofAsc) {
            int n = ab[ofAsc] & 0xFF;
            if (n >= 128) {
                fAscii = false;
                break;
            }
            ach[ofch++] = (char)n;
        }
        if (!fAscii) {
            while (ofAsc < ofEnd) {
                int ch = ab[ofAsc] & 0xFF;
                switch ((ch & 0xF0) >>> 4) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: {
                        ach[ofch++] = (char)ch;
                        break;
                    }
                    case 12: 
                    case 13: {
                        int ch2 = ab[++ofAsc] & 0xFF;
                        if ((ch2 & 0xC0) != 128) {
                            throw new UTFDataFormatException();
                        }
                        ach[ofch++] = (char)((ch & 0x1F) << 6 | ch2 & 0x3F);
                        break;
                    }
                    case 14: {
                        int ch2 = ab[++ofAsc] & 0xFF;
                        int ch3 = ab[++ofAsc] & 0xFF;
                        if ((ch2 & 0xC0) != 128 || (ch3 & 0xC0) != 128) {
                            throw new UTFDataFormatException();
                        }
                        ach[ofch++] = (char)((ch & 0xF) << 12 | (ch2 & 0x3F) << 6 | ch3 & 0x3F);
                        break;
                    }
                    default: {
                        throw new UTFDataFormatException("illegal leading UTF byte: " + ch);
                    }
                }
                ++ofAsc;
            }
        }
        return new String(ach, 0, ofch);
    }

    public static void writeUTF(DataOutput out, String s) throws IOException {
        if (out instanceof WriteBuffer.BufferOutput) {
            ((WriteBuffer.BufferOutput)out).writeSafeUTF(s);
        } else if (out instanceof PofOutputStream) {
            ((PofOutputStream)out).writeUTF(s);
        } else if (s == null) {
            ExternalizableHelper.writeInt(out, -1);
        } else {
            int cch = s.length();
            if (cch == 0) {
                ExternalizableHelper.writeInt(out, 0);
            } else {
                int cb = cch;
                for (int ofch = 0; ofch < cch; ++ofch) {
                    char ch = s.charAt(ofch);
                    if (ch <= '\u007f') {
                        if (ch != '\u0000') continue;
                        ++cb;
                        continue;
                    }
                    cb += ch <= '\u07ff' ? 1 : 2;
                }
                ExternalizableHelper.writeInt(out, cb);
                byte[] ab = new byte[cb];
                if (cb == cch) {
                    s.getBytes(0, cch, ab, 0);
                } else {
                    int ofb = 0;
                    for (int ofch = 0; ofch < cch; ++ofch) {
                        char ch = s.charAt(ofch);
                        if (ch >= '\u0001' && ch <= '\u007f') {
                            ab[ofb++] = (byte)ch;
                            continue;
                        }
                        if (ch <= '\u07ff') {
                            ab[ofb++] = (byte)(0xC0 | ch >>> 6 & 0x1F);
                            ab[ofb++] = (byte)(0x80 | ch & 0x3F);
                            continue;
                        }
                        ab[ofb++] = (byte)(0xE0 | ch >>> 12 & 0xF);
                        ab[ofb++] = (byte)(0x80 | ch >>> 6 & 0x3F);
                        ab[ofb++] = (byte)(0x80 | ch & 0x3F);
                    }
                }
                out.write(ab, 0, cb);
            }
        }
    }

    public static String readSafeUTF(DataInput in) throws IOException {
        return ExternalizableHelper.readUTF(in);
    }

    public static void writeSafeUTF(DataOutput out, String s) throws IOException {
        ExternalizableHelper.writeUTF(out, s);
    }

    public static String[] readStringArray(DataInput in) throws IOException {
        String[] as;
        if (in instanceof PofInputStream) {
            Object[] ao = (Object[])((PofInputStream)in).readObject();
            if (ao == null) {
                as = null;
            } else {
                int co = ao.length;
                as = new String[co];
                System.arraycopy(ao, 0, as, 0, co);
            }
        } else {
            int c = ExternalizableHelper.readInt(in);
            as = new String[c];
            for (int i = 0; i < c; ++i) {
                as[i] = ExternalizableHelper.readSafeUTF(in);
            }
        }
        return as;
    }

    public static void writeStringArray(DataOutput out, String[] as) throws IOException {
        if (out instanceof PofOutputStream) {
            ((PofOutputStream)out).writeObject(as);
        } else {
            int c = as.length;
            ExternalizableHelper.writeInt(out, c);
            for (int i = 0; i < c; ++i) {
                ExternalizableHelper.writeSafeUTF(out, as[i]);
            }
        }
    }

    public static BigInteger readBigInteger(DataInput in) throws IOException {
        BigInteger n = in instanceof PofInputStream ? (BigInteger)((PofInputStream)in).readObject() : new BigInteger(ExternalizableHelper.readByteArray(in));
        return n;
    }

    public static void writeBigInteger(DataOutput out, BigInteger bigint) throws IOException {
        if (out instanceof PofOutputStream) {
            ((PofOutputStream)out).writeObject(bigint);
        } else {
            ExternalizableHelper.writeByteArray(out, bigint.toByteArray());
        }
    }

    public static BigDecimal readBigDecimal(DataInput in) throws IOException {
        BigDecimal dec = in instanceof PofInputStream ? (BigDecimal)((PofInputStream)in).readObject() : new BigDecimal(ExternalizableHelper.readBigInteger(in), ExternalizableHelper.readInt(in));
        return dec;
    }

    public static void writeBigDecimal(DataOutput out, BigDecimal dec) throws IOException {
        if (out instanceof PofOutputStream) {
            ((PofOutputStream)out).writeObject(dec);
        } else {
            ExternalizableHelper.writeBigInteger(out, dec.unscaledValue());
            ExternalizableHelper.writeInt(out, dec.scale());
        }
    }

    public static Date readDate(DataInput in) throws IOException {
        PofInputStream inPof;
        RawDate dateRaw;
        Date date = in instanceof PofInputStream ? ((dateRaw = (inPof = (PofInputStream)in).getPofReader().readRawDate(inPof.nextIndex())) == null ? null : dateRaw.toSqlDate()) : new Date(ExternalizableHelper.readLong(in));
        return date;
    }

    public static void writeDate(DataOutput out, Date date) throws IOException {
        if (out instanceof PofOutputStream) {
            ((PofOutputStream)out).writeObject(date);
        } else {
            ExternalizableHelper.writeLong(out, date.getTime());
        }
    }

    public static Time readTime(DataInput in) throws IOException {
        PofInputStream inPof;
        RawTime timeRaw;
        Time time = in instanceof PofInputStream ? ((timeRaw = (inPof = (PofInputStream)in).getPofReader().readRawTime(inPof.nextIndex())) == null ? null : timeRaw.toSqlTime()) : new Time(ExternalizableHelper.readLong(in));
        return time;
    }

    public static void writeTime(DataOutput out, Time time) throws IOException {
        if (out instanceof PofOutputStream) {
            PofOutputStream outPof = (PofOutputStream)out;
            outPof.getPofWriter().writeTimeWithZone(outPof.nextIndex(), time);
        } else {
            ExternalizableHelper.writeLong(out, time.getTime());
        }
    }

    public static Timestamp readTimestamp(DataInput in) throws IOException {
        Timestamp dt;
        if (in instanceof PofInputStream) {
            PofInputStream inPof = (PofInputStream)in;
            RawDateTime dtRaw = inPof.getPofReader().readRawDateTime(inPof.nextIndex());
            dt = dtRaw == null ? null : dtRaw.toSqlTimestamp();
        } else {
            dt = new Timestamp(ExternalizableHelper.readLong(in));
            dt.setNanos(ExternalizableHelper.readInt(in));
        }
        return dt;
    }

    public static void writeTimestamp(DataOutput out, Timestamp dt) throws IOException {
        if (out instanceof PofOutputStream) {
            PofOutputStream outPof = (PofOutputStream)out;
            outPof.getPofWriter().writeDateTimeWithZone(outPof.nextIndex(), dt);
        } else {
            ExternalizableHelper.writeLong(out, dt.getTime());
            ExternalizableHelper.writeInt(out, dt.getNanos());
        }
    }

    public static float[] readFloatArray(DataInput in) throws IOException {
        float[] afl;
        if (in instanceof PofInputStream) {
            afl = (float[])((PofInputStream)in).readObject();
        } else {
            int cfl = in.readInt();
            afl = new float[cfl];
            if (cfl > 0) {
                byte[] ab = new byte[cfl << 2];
                in.readFully(ab);
                int of = 0;
                for (int i = 0; i < cfl; ++i) {
                    int iValue = ((ab[of++] & 0xFF) << 24) + ((ab[of++] & 0xFF) << 16) + ((ab[of++] & 0xFF) << 8) + (ab[of++] & 0xFF);
                    afl[i] = Float.intBitsToFloat(iValue);
                }
            }
        }
        return afl;
    }

    public static void writeFloatArray(DataOutput out, float[] afl) throws IOException {
        if (out instanceof PofOutputStream) {
            ((PofOutputStream)out).writeObject(afl);
        } else {
            int cfl = afl.length;
            out.writeInt(cfl);
            if (cfl > 0) {
                byte[] ab = new byte[cfl << 2];
                int of = 0;
                for (int i = 0; i < cfl; ++i) {
                    int iValue = Float.floatToIntBits(afl[i]);
                    ab[of++] = (byte)(iValue >>> 24);
                    ab[of++] = (byte)(iValue >>> 16);
                    ab[of++] = (byte)(iValue >>> 8);
                    ab[of++] = (byte)iValue;
                }
                out.write(ab);
            }
        }
    }

    public static double[] readDoubleArray(DataInput in) throws IOException {
        double[] adfl;
        if (in instanceof PofInputStream) {
            adfl = (double[])((PofInputStream)in).readObject();
        } else {
            int cdfl = in.readInt();
            adfl = new double[cdfl];
            if (cdfl > 0) {
                byte[] ab = new byte[cdfl << 3];
                in.readFully(ab);
                int of = 0;
                for (int i = 0; i < cdfl; ++i) {
                    int iUpper = ((ab[of++] & 0xFF) << 24) + ((ab[of++] & 0xFF) << 16) + ((ab[of++] & 0xFF) << 8) + (ab[of++] & 0xFF);
                    int iLower = ((ab[of++] & 0xFF) << 24) + ((ab[of++] & 0xFF) << 16) + ((ab[of++] & 0xFF) << 8) + (ab[of++] & 0xFF);
                    adfl[i] = Double.longBitsToDouble(((long)iUpper << 32) + ((long)iLower & 0xFFFFFFFFL));
                }
            }
        }
        return adfl;
    }

    public static void writeDoubleArray(DataOutput out, double[] ad) throws IOException {
        if (out instanceof PofOutputStream) {
            ((PofOutputStream)out).writeObject(ad);
        } else {
            int cd = ad.length;
            out.writeInt(cd);
            if (cd > 0) {
                byte[] ab = new byte[cd << 3];
                int of = 0;
                for (int i = 0; i < cd; ++i) {
                    long lValue = Double.doubleToLongBits(ad[i]);
                    int iUpper = (int)(lValue >>> 32);
                    int iLower = (int)lValue;
                    ab[of++] = (byte)(iUpper >>> 24);
                    ab[of++] = (byte)(iUpper >>> 16);
                    ab[of++] = (byte)(iUpper >>> 8);
                    ab[of++] = (byte)iUpper;
                    ab[of++] = (byte)(iLower >>> 24);
                    ab[of++] = (byte)(iLower >>> 16);
                    ab[of++] = (byte)(iLower >>> 8);
                    ab[of++] = (byte)iLower;
                }
                out.write(ab);
            }
        }
    }

    public static int readMap(DataInput in, Map map, ClassLoader loader) throws IOException {
        int cEntries;
        if (in instanceof PofInputStream) {
            PofInputStream inPof = (PofInputStream)in;
            inPof.getPofReader().readMap(inPof.nextIndex(), map);
            cEntries = map.size();
        } else {
            cEntries = in.readInt();
            for (int i = 0; i < cEntries; ++i) {
                Object oKey = ExternalizableHelper.readObject(in, loader);
                Object oVal = ExternalizableHelper.readObject(in, loader);
                map.put(oKey, oVal);
            }
        }
        return cEntries;
    }

    public static int readMap(DataInput in, Map map, int cBlock, ClassLoader loader) throws IOException {
        int cEntries;
        if (in instanceof PofInputStream) {
            PofInputStream inPof = (PofInputStream)in;
            Map mapTemp = inPof.getPofReader().readMap(inPof.nextIndex(), null);
            if (mapTemp == null) {
                cEntries = 0;
            } else {
                cEntries = mapTemp.size();
                map.putAll(mapTemp);
            }
        } else {
            if (cBlock <= 0) {
                throw new IllegalArgumentException("Illegal block size: " + cBlock);
            }
            cEntries = in.readInt();
            HashMap<Object, Object> mapTmp = new HashMap<Object, Object>(Math.min(cEntries, cBlock));
            int cTmp = 0;
            for (int i = 0; i < cEntries; ++i) {
                Object oKey = ExternalizableHelper.readObject(in, loader);
                Object oVal = ExternalizableHelper.readObject(in, loader);
                mapTmp.put(oKey, oVal);
                if (++cTmp != cBlock) continue;
                map.putAll(mapTmp);
                mapTmp.clear();
                cTmp = 0;
            }
            if (cTmp > 0) {
                map.putAll(mapTmp);
            }
        }
        return cEntries;
    }

    public static void writeMap(DataOutput out, Map map) throws IOException {
        if (out instanceof PofOutputStream) {
            ((PofOutputStream)out).writeObject(map);
        } else {
            int cEntries = map.size();
            int cCheck = 0;
            out.writeInt(cEntries);
            try {
                Iterator iter = map.entrySet().iterator();
                while (iter.hasNext()) {
                    Map.Entry entry = iter.next();
                    ExternalizableHelper.writeObject(out, entry.getKey());
                    ExternalizableHelper.writeObject(out, entry.getValue());
                    ++cCheck;
                }
            }
            catch (ConcurrentModificationException e) {
            }
            catch (NoSuchElementException e) {
                // empty catch block
            }
            if (cCheck != cEntries) {
                throw new IOException("Expected to write " + cEntries + " objects but actually wrote " + cCheck);
            }
        }
    }

    public static int readCollection(DataInput in, Collection collection, ClassLoader loader) throws IOException {
        int cItems;
        if (in instanceof PofInputStream) {
            PofInputStream inPof = (PofInputStream)in;
            inPof.getPofReader().readCollection(inPof.nextIndex(), collection);
            cItems = collection.size();
        } else {
            cItems = in.readInt();
            for (int i = 0; i < cItems; ++i) {
                collection.add(ExternalizableHelper.readObject(in, loader));
            }
        }
        return cItems;
    }

    public static void writeCollection(DataOutput out, Collection collection) throws IOException {
        if (out instanceof PofOutputStream) {
            ((PofOutputStream)out).writeObject(collection);
        } else {
            int cItems = collection.size();
            int cCheck = 0;
            out.writeInt(cItems);
            try {
                Iterator iter = collection.iterator();
                while (iter.hasNext()) {
                    ExternalizableHelper.writeObject(out, iter.next());
                    ++cCheck;
                }
            }
            catch (ConcurrentModificationException e) {
            }
            catch (NoSuchElementException e) {
                // empty catch block
            }
            if (cCheck != cItems) {
                throw new IOException("Expected to write " + cItems + " objects but actually wrote " + cCheck);
            }
        }
    }

    public static XmlSerializable readXmlSerializable(DataInput in) throws IOException {
        return ExternalizableHelper.readXmlSerializable(in, null);
    }

    public static XmlSerializable readXmlSerializable(DataInput in, ClassLoader loader) throws IOException {
        XmlSerializable value;
        if (in instanceof PofInputStream) {
            value = (XmlSerializable)((PofInputStream)in).readObject();
        } else {
            String sClass = ExternalizableHelper.readUTF(in);
            try {
                value = (XmlSerializable)ExternalizableHelper.loadClass(sClass, loader, null).newInstance();
            }
            catch (Exception e) {
                throw new IOException("Class initialization failed: " + e + "\n" + ExternalizableHelper.getStackTrace(e) + "\nClass: " + sClass + "\nClassLoader: " + loader + "\nContextClassLoader: " + ExternalizableHelper.getContextClassLoader());
            }
            String sXml = ExternalizableHelper.readUTF(in);
            XmlDocument xml = new SimpleParser().parseXml(sXml);
            value.fromXml(xml);
        }
        return value;
    }

    public static void writeXmlSerializable(DataOutput out, XmlSerializable o) throws IOException {
        if (out instanceof PofOutputStream) {
            ((PofOutputStream)out).writeObject(o);
        } else {
            StringWriter writerRaw = new StringWriter();
            PrintWriter writerPrn = new PrintWriter(writerRaw);
            o.toXml().writeXml(writerPrn, false);
            writerPrn.close();
            ExternalizableHelper.writeUTF(out, o.getClass().getName());
            ExternalizableHelper.writeUTF(out, writerRaw.toString());
        }
    }

    public static ExternalizableLite readExternalizableLite(DataInput in) throws IOException {
        return ExternalizableHelper.readExternalizableLite(in, null);
    }

    public static ExternalizableLite readExternalizableLite(DataInput in, ClassLoader loader) throws IOException {
        ExternalizableLite value;
        if (in instanceof PofInputStream) {
            value = (ExternalizableLite)((PofInputStream)in).readObject();
        } else {
            String sClass = ExternalizableHelper.readUTF(in);
            try {
                value = (ExternalizableLite)ExternalizableHelper.loadClass(sClass, loader, null).newInstance();
            }
            catch (InstantiationException e) {
                throw new IOException("Unable to instantiate an instance of class '" + sClass + "'; this is most likely due to a missing public " + "no-args constructor: " + e + "\n" + ExternalizableHelper.getStackTrace(e) + "\nClass: " + sClass + "\nClassLoader: " + loader + "\nContextClassLoader: " + ExternalizableHelper.getContextClassLoader());
            }
            catch (Exception e) {
                throw new IOException("Class initialization failed: " + e + "\n" + ExternalizableHelper.getStackTrace(e) + "\nClass: " + sClass + "\nClassLoader: " + loader + "\nContextClassLoader: " + ExternalizableHelper.getContextClassLoader());
            }
            value.readExternal(in);
        }
        return value;
    }

    public static void writeExternalizableLite(DataOutput out, ExternalizableLite o) throws IOException {
        if (out instanceof PofOutputStream) {
            ((PofOutputStream)out).writeObject(o);
        } else {
            ExternalizableHelper.writeUTF(out, o.getClass().getName());
            o.writeExternal(out);
        }
    }

    public static XmlBean readXmlBean(DataInput in, ClassLoader loader) throws IOException {
        XmlBean bean;
        if (in instanceof PofInputStream) {
            bean = (XmlBean)((PofInputStream)in).readObject();
        } else if (USE_XMLBEAN_CLASS_CACHE) {
            int nBeanId = ExternalizableHelper.readInt(in);
            if (nBeanId < 0) {
                bean = (XmlBean)ExternalizableHelper.readExternalizableLite(in, loader);
            } else {
                try {
                    Class clz = XMLBEAN_CLASS_CACHE.getClass(nBeanId, loader);
                    bean = (XmlBean)clz.newInstance();
                }
                catch (Exception e) {
                    throw new IOException("Class instantiation failed: " + e + "\n" + ExternalizableHelper.getStackTrace(e) + "\nXmlBean ID: " + nBeanId + "\nClassLoader: " + loader + "\nContextClassLoader: " + ExternalizableHelper.getContextClassLoader());
                }
                bean.readExternal(in);
            }
        } else {
            bean = (XmlBean)ExternalizableHelper.readExternalizableLite(in, loader);
        }
        return bean;
    }

    public static void writeXmlBean(DataOutput out, XmlBean bean) throws IOException {
        if (out instanceof PofOutputStream) {
            ((PofOutputStream)out).writeObject(bean);
        } else if (USE_XMLBEAN_CLASS_CACHE) {
            int nBeanId = bean.getBeanInfo().getBeanId();
            ExternalizableHelper.writeInt(out, nBeanId);
            if (nBeanId < 0) {
                ExternalizableHelper.writeExternalizableLite(out, bean);
            } else {
                bean.writeExternal(out);
            }
        } else {
            ExternalizableHelper.writeExternalizableLite(out, bean);
        }
    }

    public static Serializable readSerializable(DataInput in) throws IOException {
        return ExternalizableHelper.readSerializable(in, null);
    }

    public static Serializable readSerializable(DataInput in, ClassLoader loader) throws IOException {
        Serializable o;
        if (in instanceof PofInputStream) {
            o = (Serializable)((PofInputStream)in).readObject();
        } else {
            ObjectInput streamObj = ExternalizableHelper.getObjectInput(in, loader);
            try {
                o = (Serializable)streamObj.readObject();
            }
            catch (IOException e) {
                throw e;
            }
            catch (Exception e) {
                throw new IOException("readObject failed: " + e + "\n" + ExternalizableHelper.getStackTrace(e) + "\nClassLoader: " + loader);
            }
        }
        return o;
    }

    public static void writeSerializable(DataOutput out, Serializable o) throws IOException {
        if (out instanceof PofOutputStream) {
            ((PofOutputStream)out).writeObject(o);
        } else {
            ObjectOutput streamObj = ExternalizableHelper.getObjectOutput(out);
            streamObj.writeObject(o);
            streamObj.close();
        }
    }

    public static Object readObject(DataInput in) throws IOException {
        return ExternalizableHelper.readObject(in, null);
    }

    public static Object readObject(DataInput in, ClassLoader loader) throws IOException {
        if (in instanceof PofInputStream) {
            return ((PofInputStream)in).readObject();
        }
        switch (in.readUnsignedByte()) {
            default: {
                throw new IOException("unsupported type / corrupted stream");
            }
            case 0: {
                return null;
            }
            case 1: {
                return ExternalizableHelper.makeInteger(ExternalizableHelper.readInt(in));
            }
            case 2: {
                return ExternalizableHelper.makeLong(ExternalizableHelper.readLong(in));
            }
            case 6: {
                return ExternalizableHelper.readUTF(in);
            }
            case 3: {
                return new Double(in.readDouble());
            }
            case 4: {
                return ExternalizableHelper.readBigInteger(in);
            }
            case 5: {
                return ExternalizableHelper.readBigDecimal(in);
            }
            case 7: {
                Binary bin = new Binary();
                bin.readExternal(in);
                return bin;
            }
            case 8: {
                return ExternalizableHelper.readByteArray(in);
            }
            case 9: {
                return ExternalizableHelper.readXmlSerializable(in, loader);
            }
            case 10: {
                return ExternalizableHelper.readExternalizableLite(in, loader);
            }
            case 11: {
                return ExternalizableHelper.readSerializable(in, loader);
            }
            case 12: {
                return ExternalizableHelper.readXmlBean(in, loader);
            }
            case 13: {
                ExternalizableHelper.readInt(in);
                return ExternalizableHelper.readObject(in, loader);
            }
            case 14: {
                return new Float(in.readFloat());
            }
            case 15: {
                return new Short(in.readShort());
            }
            case 16: {
                return new Byte(in.readByte());
            }
            case 17: {
                return in.readBoolean() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 18: 
        }
        if ((in.readByte() & 1) != 0) {
            ExternalizableHelper.readInt(in);
            return ExternalizableHelper.readObject(in, loader);
        }
        throw new EOFException("Decorated value was missing a value");
    }

    public static void writeObject(DataOutput out, Object o) throws IOException {
        if (out instanceof PofOutputStream) {
            ((PofOutputStream)out).writeObject(o);
        } else {
            int nType = ExternalizableHelper.getStreamFormat(o);
            out.writeByte(nType);
            switch (nType) {
                default: {
                    throw new NotSerializableException("unsupported type: " + o.getClass().getName());
                }
                case 0: {
                    break;
                }
                case 1: {
                    ExternalizableHelper.writeInt(out, (Integer)o);
                    break;
                }
                case 2: {
                    ExternalizableHelper.writeLong(out, (Long)o);
                    break;
                }
                case 6: {
                    ExternalizableHelper.writeUTF(out, (String)o);
                    break;
                }
                case 3: {
                    out.writeDouble((Double)o);
                    break;
                }
                case 4: {
                    ExternalizableHelper.writeBigInteger(out, (BigInteger)o);
                    break;
                }
                case 5: {
                    ExternalizableHelper.writeBigDecimal(out, (BigDecimal)o);
                    break;
                }
                case 7: {
                    ((Binary)o).writeExternal(out);
                    break;
                }
                case 8: {
                    ExternalizableHelper.writeByteArray(out, (byte[])o);
                    break;
                }
                case 9: {
                    ExternalizableHelper.writeXmlSerializable(out, (XmlSerializable)o);
                    break;
                }
                case 10: {
                    ExternalizableHelper.writeExternalizableLite(out, (ExternalizableLite)o);
                    break;
                }
                case 11: {
                    ExternalizableHelper.writeSerializable(out, (Serializable)o);
                    break;
                }
                case 12: {
                    ExternalizableHelper.writeXmlBean(out, (XmlBean)o);
                    break;
                }
                case 13: {
                    IntDecoratedObject ido = (IntDecoratedObject)o;
                    ExternalizableHelper.writeInt(out, ido.getDecoration());
                    ExternalizableHelper.writeObject(out, ido.getValue());
                    break;
                }
                case 14: {
                    out.writeFloat(((Float)o).floatValue());
                    break;
                }
                case 15: {
                    out.writeShort(((Short)o).shortValue());
                    break;
                }
                case 16: {
                    out.writeByte(((Byte)o).byteValue());
                    break;
                }
                case 17: {
                    out.writeBoolean((Boolean)o);
                }
            }
        }
    }

    protected static WriteBuffer internalWriteObject(Object o, boolean fBinary) throws IOException {
        int nType;
        int cb = 1;
        int nOrig = nType = ExternalizableHelper.getStreamFormat(o);
        boolean fDeco = false;
        int nDeco = 0;
        boolean fUser = false;
        Stats stats = null;
        if (nType == 13) {
            IntDecoratedObject ido = (IntDecoratedObject)o;
            fDeco = true;
            nDeco = ido.getDecoration();
            cb += 5;
            o = ido.getValue();
            nType = ExternalizableHelper.getStreamFormat(o);
        }
        switch (nType) {
            default: {
                throw new NotSerializableException("unsupported type: " + o.getClass().getName());
            }
            case 0: {
                break;
            }
            case 16: 
            case 17: {
                ++cb;
                break;
            }
            case 15: {
                cb += 2;
                break;
            }
            case 1: 
            case 14: {
                cb += 4;
                break;
            }
            case 2: 
            case 3: {
                cb += 8;
                break;
            }
            case 4: {
                cb += ((BigInteger)o).bitLength() / 8 + 1;
                break;
            }
            case 5: {
                cb += ((BigDecimal)o).unscaledValue().bitLength() / 8 + 2;
                break;
            }
            case 7: {
                cb += ((Binary)o).length() + 4;
                break;
            }
            case 8: {
                cb += ((byte[])o).length + 5;
                break;
            }
            case 6: {
                cb += ((String)o).length() + 5;
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                fUser = true;
                stats = ExternalizableHelper.findStats(o);
                if (stats != null) break;
                cb = 64;
            }
        }
        WriteBuffer buf = stats == null ? (fBinary ? new BinaryWriteBuffer(cb) : new ByteArrayWriteBuffer(cb)) : stats.instantiateBuffer(fBinary);
        WriteBuffer.BufferOutput out = buf.getBufferOutput();
        out.writeByte(nOrig);
        if (fDeco) {
            out.writePackedInt(nDeco);
            out.writeByte(nType);
        }
        switch (nType) {
            case 0: {
                break;
            }
            case 1: {
                out.writePackedInt((Integer)o);
                break;
            }
            case 2: {
                out.writePackedLong((Long)o);
                break;
            }
            case 6: {
                out.writeSafeUTF((String)o);
                break;
            }
            case 3: {
                out.writeDouble((Double)o);
                break;
            }
            case 4: {
                ExternalizableHelper.writeBigInteger(out, (BigInteger)o);
                break;
            }
            case 5: {
                ExternalizableHelper.writeBigDecimal(out, (BigDecimal)o);
                break;
            }
            case 7: {
                ((Binary)o).writeExternal(out);
                break;
            }
            case 8: {
                ExternalizableHelper.writeByteArray(out, (byte[])o);
                break;
            }
            case 9: {
                ExternalizableHelper.writeXmlSerializable(out, (XmlSerializable)o);
                break;
            }
            case 10: {
                ExternalizableHelper.writeExternalizableLite(out, (ExternalizableLite)o);
                break;
            }
            case 11: {
                ExternalizableHelper.writeSerializable(out, (Serializable)o);
                break;
            }
            case 12: {
                ExternalizableHelper.writeXmlBean(out, (XmlBean)o);
                break;
            }
            case 14: {
                out.writeFloat(((Float)o).floatValue());
                break;
            }
            case 15: {
                out.writeShort(((Short)o).shortValue());
                break;
            }
            case 16: {
                out.writeByte(((Byte)o).byteValue());
                break;
            }
            case 17: {
                out.writeBoolean((Boolean)o);
                break;
            }
            default: {
                throw ExternalizableHelper.azzert();
            }
        }
        if (fUser) {
            cb = buf.length();
            if (stats == null || cb > STATS_THRESHOLD) {
                ExternalizableHelper.updateStats(o, stats, cb);
            }
        }
        return buf;
    }

    private static Stats findStats(Object o) {
        return s_astats[ExternalizableHelper.calculateStatsId(o)];
    }

    private static void updateStats(Object o, Stats stats, int cb) {
        if (stats == null) {
            ExternalizableHelper.s_astats[ExternalizableHelper.calculateStatsId((Object)o)] = stats = new Stats();
        }
        stats.update(cb);
    }

    private static int calculateStatsId(Object o) {
        int n = o.getClass().hashCode();
        return ((n >>> 1) + (n & 1)) % s_astats.length;
    }

    /*
     * WARNING - void declaration
     */
    public static Class loadClass(String sClass, ClassLoader loader1, ClassLoader loader2) throws ClassNotFoundException {
        for (int i = 1; i <= 3; ++i) {
            switch (i) {
                case 1: {
                    ClassLoader loader = loader1;
                    break;
                }
                case 2: {
                    ClassLoader loader = loader2;
                    break;
                }
                case 3: {
                    ClassLoader loader = ExternalizableHelper.getContextClassLoader();
                    if (loader != loader1 && loader != loader2) break;
                    loader = null;
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            try {
                void var4_4;
                if (var4_4 == null) continue;
                return Class.forName(sClass, false, (ClassLoader)var4_4);
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
        }
        return Class.forName(sClass);
    }

    /*
     * WARNING - void declaration
     */
    public static URL loadResource(String sName, ClassLoader loader1, ClassLoader loader2) {
        for (int i = 1; i <= 3; ++i) {
            URL url;
            void var4_4;
            switch (i) {
                case 1: {
                    ClassLoader loader = loader1;
                    break;
                }
                case 2: {
                    ClassLoader loader = loader2;
                    break;
                }
                case 3: {
                    ClassLoader loader = ExternalizableHelper.getContextClassLoader();
                    if (loader != loader1 && loader != loader2) break;
                    loader = null;
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            if (var4_4 == null || (url = var4_4.getResource(sName)) == null) continue;
            return url;
        }
        return null;
    }

    public static InputStream getInputStream(final DataInput in) {
        return in instanceof InputStream ? (InputStream)((Object)in) : new InputStream(){

            public int read() throws IOException {
                try {
                    return in.readUnsignedByte();
                }
                catch (EOFException e) {
                    return -1;
                }
            }
        };
    }

    public static OutputStream getOutputStream(DataOutput out) {
        return out instanceof ObjectOutput ? new ShieldedObjectOutputStream((ObjectOutput)out) : new ShieldedDataOutputStream(out);
    }

    public static OutputStream getShieldedOutputStream(OutputStream out) {
        return out instanceof Shielded ? out : (out instanceof ObjectOutput ? new ShieldedObjectOutputStream((ObjectOutput)((Object)out)) : (out instanceof DataOutput ? new ShieldedDataOutputStream((DataOutput)((Object)out)) : new ShieldedOutputStream(out)));
    }

    public static ObjectInput getObjectInput(InputStream in, ClassLoader loader) throws IOException {
        if (!(!(in instanceof ObjectInput) || FORCE_RESOLVING_STREAMS && !(in instanceof Resolving) || USE_MARSHAL_STREAMS && !(in instanceof MarshalInputStream))) {
            return (ObjectInput)((Object)in);
        }
        loader = ExternalizableHelper.resolveLoader(loader);
        return USE_MARSHAL_STREAMS ? new ResolvingMarshalInputStream(in, loader) : new ResolvingObjectInputStream(in, loader);
    }

    public static ObjectInput getObjectInput(DataInput in, ClassLoader loader) throws IOException {
        return !(!(in instanceof ObjectInput) || FORCE_RESOLVING_STREAMS && !(in instanceof Resolving) || USE_MARSHAL_STREAMS && !(in instanceof MarshalInputStream)) ? (ObjectInput)in : ExternalizableHelper.getNewObjectInput(in, loader);
    }

    public static ObjectInput getNewObjectInput(DataInput in, ClassLoader loader) throws IOException {
        InputStream stream = ExternalizableHelper.getInputStream(in);
        loader = ExternalizableHelper.resolveLoader(loader);
        return USE_MARSHAL_STREAMS ? new ResolvingMarshalInputStream(stream, loader) : new ResolvingObjectInputStream(stream, loader);
    }

    public static ClassLoader resolveLoader(ClassLoader loader) {
        return loader == null ? ExternalizableHelper.getContextClassLoader() : loader;
    }

    public static ObjectOutput getObjectOutput(OutputStream out) throws IOException {
        if (!(!(out instanceof ObjectOutput) || FORCE_RESOLVING_STREAMS && !ExternalizableHelper.isResolving((DataOutput)((Object)out)) || USE_MARSHAL_STREAMS && !ExternalizableHelper.isMarshalled((DataOutput)((Object)out)))) {
            return out instanceof Shielded ? (ObjectOutput)((Object)out) : new ShieldedObjectOutputStream((ObjectOutput)((Object)out));
        }
        out = ExternalizableHelper.getShieldedOutputStream(out);
        return USE_MARSHAL_STREAMS ? new ResolvingMarshalOutputStream(out) : new ResolvingObjectOutputStream(out);
    }

    public static ObjectOutput getObjectOutput(DataOutput out) throws IOException {
        if (!(!(out instanceof ObjectOutput) || FORCE_RESOLVING_STREAMS && !ExternalizableHelper.isResolving(out) || USE_MARSHAL_STREAMS && !ExternalizableHelper.isMarshalled(out))) {
            return out instanceof Shielded ? (ObjectOutput)out : new ShieldedObjectOutputStream((ObjectOutput)out);
        }
        OutputStream stream = ExternalizableHelper.getOutputStream(out);
        return USE_MARSHAL_STREAMS ? new ResolvingMarshalOutputStream(stream) : new ResolvingObjectOutputStream(stream);
    }

    public static boolean isMarshalled(DataOutput out) {
        return out instanceof MarshalOutputStream || out instanceof ShieldedObjectOutputStream && ((ShieldedObjectOutputStream)out).isMarshalled();
    }

    public static boolean isResolving(DataOutput out) {
        return out instanceof Resolving || out instanceof ShieldedObjectOutputStream && ((ShieldedObjectOutputStream)out).isResolving();
    }

    public static boolean isSerializable(Object o) {
        return ExternalizableHelper.getStreamFormat(o) != -1;
    }

    public static boolean isClassLoaderDependent(Object o) {
        switch (ExternalizableHelper.getStreamFormat(o)) {
            case 9: 
            case 10: 
            case 11: 
            case 13: {
                return true;
            }
        }
        return false;
    }

    protected static int getStreamFormat(Object o) {
        return o == null ? 0 : (o instanceof Binary ? 7 : (o instanceof String ? 6 : (o instanceof Number ? (o instanceof Integer ? 1 : (o instanceof Long ? 2 : (o instanceof Double ? 3 : (o instanceof BigInteger ? 4 : (o instanceof BigDecimal ? 5 : (o instanceof Float ? 14 : (o instanceof Short ? 15 : (o instanceof Byte ? 16 : 11)))))))) : (o instanceof byte[] ? 8 : (o instanceof XmlBean ? 12 : (o instanceof IntDecoratedObject ? 13 : (o instanceof ExternalizableLite ? 10 : (o instanceof Boolean ? 17 : (o instanceof Serializable ? 11 : (o instanceof XmlSerializable ? 9 : -1))))))))));
    }

    public static boolean isDecorated(Binary bin) {
        try {
            return bin.byteAt(0) == 18;
        }
        catch (NullPointerException e) {
            return false;
        }
        catch (IndexOutOfBoundsException e) {
            return false;
        }
    }

    public static Binary decorate(Binary bin, int nId, Binary binDecoration) {
        if (binDecoration == null) {
            throw new IllegalArgumentException("decoration must not be null");
        }
        if (nId < 0 || nId > 7) {
            throw new IndexOutOfBoundsException("decoration index is out of range: index=" + nId + ", min=" + 0 + ", max=" + 7);
        }
        if (bin == null || nId == 0 && !ExternalizableHelper.isDecorated(bin)) {
            return binDecoration;
        }
        int nBits = 1 << nId;
        int ofFront = -1;
        int cbFront = 0;
        int ofBack = -1;
        int cbBack = 0;
        boolean fEncodeFrontLength = false;
        if (ExternalizableHelper.isDecorated(bin)) {
            int nPrevBits = bin.byteAt(1) & 0xFF;
            int nFrontBits = nPrevBits & 255 >>> 8 - nId;
            int nBackBits = nPrevBits & 255 << 1 + nId;
            int nLastFront = ExternalizableHelper.indexOfMSB((byte)nFrontBits);
            int nFirstBack = ExternalizableHelper.indexOfLSB((byte)nBackBits);
            nBits |= nPrevBits;
            ReadBuffer.BufferInput in = bin.getBufferInput();
            try {
                in.setOffset(2);
                int iCurrentId = 0;
                while (nPrevBits != 0) {
                    if ((nPrevBits & 1) != 0) {
                        if (iCurrentId == nFirstBack) {
                            ofBack = in.getOffset();
                            cbBack = bin.length() - ofBack;
                        }
                        in.skipBytes(in.readPackedInt());
                        if (iCurrentId == nLastFront) {
                            ofFront = 2;
                            cbFront = in.getOffset() - ofFront;
                        }
                    }
                    nPrevBits >>>= 1;
                    ++iCurrentId;
                }
            }
            catch (IOException e) {
                throw ExternalizableHelper.ensureRuntimeException(e);
            }
        } else {
            nBits |= 1;
            ofFront = 0;
            cbFront = bin.length();
            fEncodeFrontLength = true;
        }
        int cbNew = binDecoration.length();
        int cbFixed = 2 + cbFront + cbNew + cbBack;
        int cbTotal = cbFixed + (ExternalizableHelper.indexOfMSB(cbNew) + 8) / 7;
        int cbCap = cbFixed + 5;
        if (fEncodeFrontLength) {
            cbTotal += (ExternalizableHelper.indexOfMSB(cbFront) + 8) / 7;
            cbCap += 5;
        }
        BinaryWriteBuffer buf = new BinaryWriteBuffer(cbTotal, cbCap);
        WriteBuffer.BufferOutput out = buf.getBufferOutput();
        try {
            out.writeByte(18);
            out.writeByte(nBits);
            if (cbFront > 0) {
                if (fEncodeFrontLength) {
                    out.writePackedInt(cbFront);
                }
                out.writeBuffer(bin, ofFront, cbFront);
            }
            out.writePackedInt(cbNew);
            out.writeBuffer(binDecoration);
            if (cbBack > 0) {
                out.writeBuffer(bin, ofBack, cbBack);
            }
            if (!$assertionsDisabled && out.getOffset() != cbTotal) {
                throw new AssertionError();
            }
        }
        catch (IOException e) {
            throw ExternalizableHelper.ensureRuntimeException(e);
        }
        return buf.toBinary();
    }

    public static Binary decorate(Binary bin, Binary[] abinDecorations) {
        int cbTotal;
        if (bin != null) {
            if (ExternalizableHelper.isDecorated(bin)) {
                Binary[] abinOver;
                int cbinOver;
                Binary[] abinOrig = ExternalizableHelper.getDecorations(bin);
                int cbinOrig = abinOrig.length;
                if (cbinOrig > (cbinOver = (abinOver = abinDecorations).length)) {
                    abinDecorations = new Binary[cbinOrig];
                    System.arraycopy(abinOver, 0, abinDecorations, 0, cbinOver);
                }
                for (int i = 0; i < cbinOrig; ++i) {
                    if (abinDecorations[i] != null) continue;
                    abinDecorations[i] = abinOrig[i];
                }
            } else if (abinDecorations.length < 1 || abinDecorations[0] == null) {
                Binary[] abinOver = abinDecorations;
                int cbinOver = abinOver.length;
                abinDecorations = new Binary[Math.max(1, cbinOver)];
                if (cbinOver > 0) {
                    System.arraycopy(abinOver, 0, abinDecorations, 0, cbinOver);
                }
                abinDecorations[0] = bin;
            }
        }
        int cbCap = cbTotal = 2;
        int cDecorations = 0;
        int nLastId = -1;
        int nBits = 0;
        int cbinDecorations = abinDecorations.length;
        for (int i = 0; i < cbinDecorations; ++i) {
            Binary binDecoration = abinDecorations[i];
            if (binDecoration == null) continue;
            int cb = binDecoration.length();
            cbTotal += (ExternalizableHelper.indexOfMSB(cb) + 8) / 7 + cb;
            cbCap += 5 + cb;
            ++cDecorations;
            nLastId = i;
            nBits |= 1 << i;
        }
        if (cDecorations == 0) {
            return null;
        }
        if (cDecorations == 1 && nLastId == 0) {
            return abinDecorations[0];
        }
        if (nLastId > 7) {
            throw new IndexOutOfBoundsException("decoration id out of bounds: " + nLastId);
        }
        BinaryWriteBuffer buf = new BinaryWriteBuffer(cbTotal, cbCap);
        WriteBuffer.BufferOutput out = buf.getBufferOutput();
        try {
            out.writeByte(18);
            out.writeByte(nBits);
            for (int i = 0; i <= nLastId; ++i) {
                Binary binDecoration = abinDecorations[i];
                if (binDecoration == null) continue;
                out.writePackedInt(binDecoration.length());
                out.writeBuffer(binDecoration);
            }
            if (!$assertionsDisabled && out.getOffset() != cbTotal) {
                throw new AssertionError();
            }
        }
        catch (IOException e) {
            throw ExternalizableHelper.ensureRuntimeException(e);
        }
        return buf.toBinary();
    }

    public static Binary getDecoration(Binary bin, int nId) {
        int nMask;
        if (!ExternalizableHelper.isDecorated(bin)) {
            return nId == 0 ? bin : null;
        }
        if (nId < 0 || nId > 7) {
            throw new IndexOutOfBoundsException("decoration index is out of range: index=" + nId + ", min=" + 0 + ", max=" + 7);
        }
        int nBits = bin.byteAt(1) & 0xFF;
        if ((nBits & (nMask = 1 << nId)) == 0) {
            return null;
        }
        ReadBuffer.BufferInput in = bin.getBufferInput();
        try {
            in.setOffset(2);
            for (int i = 0; i < nId; ++i) {
                if ((nBits & 1) != 0) {
                    in.skipBytes(in.readPackedInt());
                }
                nBits >>>= 1;
            }
            int cb = in.readPackedInt();
            int of = in.getOffset();
            return bin.toBinary(of, cb);
        }
        catch (IOException e) {
            throw ExternalizableHelper.ensureRuntimeException(e);
        }
    }

    public static Binary[] getDecorations(Binary bin) {
        if (!ExternalizableHelper.isDecorated(bin)) {
            return new Binary[0];
        }
        int nBits = bin.byteAt(1) & 0xFF;
        int ofMSB = ExternalizableHelper.indexOfMSB((byte)nBits);
        if (!($assertionsDisabled || ofMSB >= 0 && ofMSB <= 7)) {
            throw new AssertionError();
        }
        int cbinDecorations = ofMSB + 1;
        Binary[] abinDecorations = new Binary[cbinDecorations];
        ReadBuffer.BufferInput in = bin.getBufferInput();
        try {
            in.setOffset(2);
            for (int i = 0; i < cbinDecorations; ++i) {
                if ((nBits & 1) != 0) {
                    int cb = in.readPackedInt();
                    int of = in.getOffset();
                    abinDecorations[i] = bin.toBinary(of, cb);
                    in.skipBytes(cb);
                }
                nBits >>>= 1;
            }
        }
        catch (IOException e) {
            throw ExternalizableHelper.ensureRuntimeException(e);
        }
        return abinDecorations;
    }

    public static Binary undecorate(Binary bin, int nId) {
        int nMask;
        if (!ExternalizableHelper.isDecorated(bin) || nId < 0 || nId > 7) {
            return bin;
        }
        int nBits = bin.byteAt(1) & 0xFF;
        if ((nBits & (nMask = 1 << nId)) == 0) {
            return bin;
        }
        int nRemains = nBits & ~nMask;
        if (nRemains == 0) {
            return null;
        }
        if (nRemains == 0) {
            return ExternalizableHelper.getUndecorated(bin);
        }
        Binary[] abinDecorations = ExternalizableHelper.getDecorations(bin);
        abinDecorations[nId] = null;
        return ExternalizableHelper.decorate(null, abinDecorations);
    }

    public static Binary getUndecorated(Binary bin) {
        return ExternalizableHelper.getDecoration(bin, 0);
    }

    public static void main(String[] asArgs) {
        if (asArgs.length == 0) {
            ExternalizableHelper.out("Usage:");
            ExternalizableHelper.out("java com.tangosol.util.ExternalizableHelper <hex string>");
        } else {
            Object o = ExternalizableHelper.fromByteArray(ExternalizableHelper.parseHex(asArgs[0]));
            if (o != null) {
                ExternalizableHelper.out("Class: " + o.getClass().getName());
            }
            ExternalizableHelper.out("Value: " + o);
        }
    }

    public static IntDecoratedObject decorate(Object oValue, int nDecoration) {
        return new IntDecoratedObject(oValue, nDecoration);
    }

    public static boolean isIntDecorated(ReadBuffer buffer) {
        try {
            return buffer.byteAt(0) == 13;
        }
        catch (IndexOutOfBoundsException e) {
            return false;
        }
    }

    public static int extractIntDecoration(ReadBuffer buffer) {
        try {
            ReadBuffer.BufferInput in = buffer.getBufferInput();
            in.readUnsignedByte();
            return ExternalizableHelper.readInt(in);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("invalid buffer");
        }
    }

    static {
        $assertionsDisabled = !ExternalizableHelper.class.desiredAssertionStatus();
        CONVERTER_TO_BINARY = new Converter(){

            public Object convert(Object o) {
                return ExternalizableHelper.toBinary(o);
            }
        };
        CONVERTER_FROM_BINARY = new Converter(){

            public Object convert(Object o) {
                return o == null ? null : ExternalizableHelper.fromBinary((Binary)o, null);
            }
        };
        boolean fResolve = true;
        boolean fMarshal = false;
        boolean fCache = false;
        XmlBeanClassCache cache = null;
        int cbStats = 1024;
        boolean fPof = false;
        XmlElement xml = null;
        String sConfig = System.getProperty(PROPERTY_CONFIG);
        if (sConfig != null && sConfig.length() > 0) {
            URL url = Resources.findResource(sConfig, null);
            Throwable e = null;
            if (url != null) {
                try {
                    xml = XmlHelper.loadXml(url.openStream());
                }
                catch (Throwable t) {
                    e = t;
                }
            }
            if (xml == null) {
                ExternalizableHelper.err("Unable to load ExternalizableHelper configuration file \"" + sConfig + "\";");
                if (e != null) {
                    ExternalizableHelper.err(e);
                }
                ExternalizableHelper.err("Using default configuration.");
            }
        }
        try {
            XmlElement xmlCfg;
            if (xml == null) {
                xml = XmlHelper.loadXml(ExternalizableHelper.class, "ISO-8859-1");
            }
            fResolve = xml.getSafeElement("force-classloader-resolving").getBoolean(fResolve);
            fMarshal = xml.getSafeElement("enable-rmi-marshalling").getBoolean(fMarshal);
            fCache = xml.getSafeElement("enable-xmlbean-class-cache").getBoolean(fCache);
            if (fCache && (xmlCfg = xml.getElement("xmlbean-class-cache-config")) != null) {
                String sImpl = xml.getSafeElement("cache-class").getString(null);
                try {
                    cache = sImpl == null ? new SimpleXmlBeanClassCache() : (XmlBeanClassCache)Class.forName(sImpl).newInstance();
                    cache.init(xmlCfg);
                }
                catch (Throwable e) {
                    fCache = false;
                    ExternalizableHelper.err("Unable to instantiate and configure class cache \"" + sImpl + "\":");
                    ExternalizableHelper.err(e);
                    throw e;
                }
            }
            String sThreshold = xml.getSafeElement("serialization-stats-threshold").getString(String.valueOf(cbStats));
            cbStats = (int)ExternalizableHelper.parseMemorySize(sThreshold, 0);
            fPof = xml.getSafeElement("enable-pof-serialization").getBoolean(fPof);
        }
        catch (Throwable e) {
            // empty catch block
        }
        FORCE_RESOLVING_STREAMS = fResolve;
        USE_MARSHAL_STREAMS = fMarshal;
        USE_XMLBEAN_CLASS_CACHE = fCache;
        XMLBEAN_CLASS_CACHE = cache;
        STATS_THRESHOLD = cbStats;
        USE_POF_STREAMS = fPof;
        s_astats = new Stats[1951];
        s_mapSerializerByClassLoader = Collections.synchronizedMap(new WeakHashMap());
    }

    public static class SimpleXmlBeanClassCache
    extends Base
    implements XmlBeanClassCache {
        private boolean m_fAware;
        private String[] m_asBeans;
        private Class[] m_aclzBeans;
        private WeakHashMap m_mapBeanClasses;

        public void init(XmlElement xml) {
            ArrayList<String> list = new ArrayList<String>();
            Iterator iter = xml.getSafeElement("xmlbean-list").getElements("xmlbean-class");
            while (iter.hasNext()) {
                XmlElement xmlClassName = (XmlElement)iter.next();
                String sClass = xmlClassName.getString(null);
                list.add(sClass == null ? null : sClass.intern());
            }
            this.m_asBeans = list.toArray(new String[list.size()]);
            if (xml.getSafeElement("classloader-aware").getBoolean()) {
                this.m_fAware = true;
                this.m_mapBeanClasses = new WeakHashMap(101, 1000.0f);
            }
        }

        public int getClassId(Class clz) {
            String sName = clz.getName();
            String[] asBeans = this.m_asBeans;
            int c = asBeans.length;
            for (int i = 0; i < c; ++i) {
                if (!SimpleXmlBeanClassCache.equals(asBeans[i], sName)) continue;
                return i;
            }
            return -1;
        }

        public Class getClass(int nId, ClassLoader loader) {
            Class clz = null;
            if (this.m_fAware) {
                WeakReference[] aref = (WeakReference[])this.m_mapBeanClasses.get(loader);
                if (aref == null) {
                    aref = this.initClassLoader(loader);
                }
                try {
                    clz = (Class)aref[nId].get();
                }
                catch (NullPointerException e) {}
            } else {
                Class[] aclz = this.m_aclzBeans;
                if (aclz == null) {
                    this.m_aclzBeans = aclz = this.initClasses(loader);
                }
                try {
                    clz = aclz[nId];
                }
                catch (IndexOutOfBoundsException e) {
                    // empty catch block
                }
            }
            if (clz == null) {
                if (nId < 0) {
                    throw new IndexOutOfBoundsException("Class ID=" + nId + "; a negative XmlBean ID is used to indicate" + " an \"unknown\" XmlBean class");
                }
                throw new IndexOutOfBoundsException("Class ID=" + nId + ", Max ID=" + (this.m_aclzBeans.length - 1));
            }
            return clz;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private WeakReference[] initClassLoader(ClassLoader loader) {
            WeakHashMap map;
            SimpleXmlBeanClassCache.azzert(this.m_fAware);
            Class[] aclz = this.initClasses(loader);
            int c = aclz.length;
            WeakReference[] aref = new WeakReference[c];
            for (int i = 0; i < c; ++i) {
                aref[i] = new WeakReference<Class>(aclz[i]);
            }
            WeakHashMap weakHashMap = map = this.m_mapBeanClasses;
            synchronized (weakHashMap) {
                map.put(loader, aref);
            }
            return aref;
        }

        private Class[] initClasses(ClassLoader loader) {
            String[] asBeans = this.m_asBeans;
            int cBeans = asBeans.length;
            Class[] aclz = new Class[cBeans];
            for (int i = 0; i < cBeans; ++i) {
                String sBean = asBeans[i];
                if (sBean == null || sBean.length() <= 0) continue;
                try {
                    aclz[i] = ExternalizableHelper.loadClass(sBean, loader, null);
                    continue;
                }
                catch (ClassNotFoundException e) {
                    throw new WrapperException(e);
                }
            }
            return aclz;
        }
    }

    public static interface XmlBeanClassCache {
        public void init(XmlElement var1);

        public int getClassId(Class var1);

        public Class getClass(int var1, ClassLoader var2);
    }

    protected static final class IntDecoratedObject
    extends ExternalizableHelper
    implements Serializable {
        private Object m_oValue;
        private int m_nDecoration;

        public IntDecoratedObject(Object oValue, int nDecoration) {
            IntDecoratedObject.azzert(!(oValue instanceof IntDecoratedObject));
            this.m_oValue = oValue;
            this.m_nDecoration = nDecoration;
        }

        public Object getValue() {
            return this.m_oValue;
        }

        public int getDecoration() {
            return this.m_nDecoration;
        }

        private void writeObject(ObjectOutputStream stream) throws IOException {
            throw new IOException("not allowed");
        }

        private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
            throw new IOException("not allowed");
        }
    }

    public static class ShieldedObjectOutputStream
    extends WrapperObjectOutputStream
    implements Shielded {
        public ShieldedObjectOutputStream(ObjectOutput out) {
            super(out);
        }

        public final void flush() {
        }

        public final void close() {
        }

        boolean isMarshalled() {
            return ExternalizableHelper.isMarshalled(this.getObjectOutput());
        }

        boolean isResolving() {
            return ExternalizableHelper.isResolving(this.getObjectOutput());
        }
    }

    public static class ShieldedDataOutputStream
    extends WrapperDataOutputStream
    implements Shielded {
        public ShieldedDataOutputStream(DataOutput out) {
            super(out);
        }

        public final void flush() {
        }

        public final void close() {
        }
    }

    public static class ShieldedOutputStream
    extends WrapperOutputStream
    implements Shielded {
        public ShieldedOutputStream(OutputStream out) {
            super(out);
        }

        public final void flush() {
        }

        public final void close() {
        }
    }

    public static class ShieldedInputStream
    extends FilterInputStream
    implements InputStreaming,
    Shielded {
        public ShieldedInputStream(InputStream in) {
            super(in);
        }

        public final void close() {
        }
    }

    public static interface Shielded {
    }

    private static final class Stats
    implements MultiBufferWriteBuffer.WriteBufferPool {
        private static final int MIN_ALLOC = 128;
        private static final int MAX_ALLOC = 0x100000;
        private static final int EXPIRY_MILLIS = 600000;
        private int m_cItems;
        private long m_cbTotal;
        private int m_cbMax;
        private volatile int m_cbAvg;
        private long m_ldtCreated;

        private Stats() {
        }

        synchronized void update(int cb) {
            long cbTotal;
            int cItems = this.m_cItems;
            if ((cItems & 0x3FF) == 0 && Base.getSafeTimeMillis() > this.m_ldtCreated + 600000L) {
                cItems = 0;
                this.m_cbMax = 0;
                this.m_cbTotal = 0L;
                this.m_ldtCreated = Base.getSafeTimeMillis();
            }
            this.m_cItems = ++cItems;
            this.m_cbTotal = cbTotal = this.m_cbTotal + (long)cb;
            this.m_cbAvg = (int)(cbTotal / (long)cItems);
            if (cb > this.m_cbMax) {
                this.m_cbMax = cb;
            }
        }

        synchronized WriteBuffer instantiateBuffer(boolean fBinary) {
            int cbMax = this.m_cbMax;
            int cbAvg = this.m_cbAvg;
            AbstractWriteBuffer buf = cbMax > 1024 && cbMax > cbAvg + (cbAvg >>> 3) ? new MultiBufferWriteBuffer(this) : (fBinary ? new BinaryWriteBuffer(cbMax) : new ByteArrayWriteBuffer(cbMax));
            return buf;
        }

        public int getMaximumCapacity() {
            return Integer.MAX_VALUE;
        }

        public WriteBuffer allocate(int cbPreviousTotal) {
            int cb;
            if (cbPreviousTotal <= 0) {
                int cbAvg = this.m_cbAvg;
                cb = Math.min(0x100000, Math.min(this.m_cbMax, cbAvg + (cbAvg >>> 3)));
            } else {
                cb = cbPreviousTotal <= 1024 ? Math.max(128, cbPreviousTotal) : (cbPreviousTotal <= 4096 ? cbPreviousTotal >>> 1 : Math.min(0x100000, cbPreviousTotal >>> 2));
            }
            return new BinaryWriteBuffer(cb);
        }

        public void release(WriteBuffer buffer) {
        }
    }
}

