/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.util;

import com.tangosol.util.Base;
import com.tangosol.util.SimpleEnumerator;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.AbstractList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.SortedSet;

public class ImmutableArrayList
extends AbstractList
implements Collection,
List,
Set,
SortedSet,
Comparable,
Cloneable,
Serializable {
    private Object[] m_ao;
    private transient Map m_mapValueIndex;

    public ImmutableArrayList(Object[] ao) {
        Base.azzert(ao != null);
        this.m_ao = ao;
    }

    public ImmutableArrayList(Collection collection) {
        this(collection.toArray());
    }

    public int size() {
        return this.m_ao.length;
    }

    public Object get(int i) {
        return this.m_ao[i];
    }

    public int indexOf(Object o) {
        Map map = this.getValueIndex();
        if (map != null) {
            Integer I = (Integer)map.get(o);
            return I == null ? -1 : I;
        }
        Object[] ao = this.m_ao;
        int c = ao.length;
        for (int i = 0; i < c; ++i) {
            if (!Base.equals(ao[i], o)) continue;
            return i;
        }
        return -1;
    }

    public int lastIndexOf(Object o) {
        Map map = this.getValueIndex();
        if (map != null) {
            Integer I = (Integer)map.get(o);
            if (I == null) {
                return -1;
            }
            if (this.size() == map.size()) {
                return I;
            }
        }
        Object[] ao = this.m_ao;
        for (int i = ao.length - 1; i >= 0; --i) {
            if (!Base.equals(ao[i], o)) continue;
            return i;
        }
        return -1;
    }

    public boolean contains(Object o) {
        return this.indexOf(o) != -1;
    }

    public Object[] toArray() {
        return (Object[])this.m_ao.clone();
    }

    public Object[] toArray(Object[] a) {
        int c = this.m_ao.length;
        if (a == null) {
            a = new Object[c];
        } else if (a.length < c) {
            a = (Object[])Array.newInstance(a.getClass().getComponentType(), c);
        } else if (a.length > c) {
            a[c] = null;
        }
        System.arraycopy(this.m_ao, 0, a, 0, c);
        return a;
    }

    public Iterator iterator() {
        return new SimpleEnumerator(this.m_ao);
    }

    public Comparator comparator() {
        return new Comparator(){

            public int compare(Object o1, Object o2) {
                int iPos1 = ImmutableArrayList.this.indexOf(o1);
                if (iPos1 == -1) {
                    throw new IllegalArgumentException("missing element: " + o1);
                }
                int iPos2 = ImmutableArrayList.this.indexOf(o2);
                if (iPos2 == -1) {
                    throw new IllegalArgumentException("missing element: " + o2);
                }
                return iPos1 - iPos2;
            }
        };
    }

    public Object first() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        return this.get(0);
    }

    public Object last() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        return this.get(this.size() - 1);
    }

    public SortedSet headSet(Object toElement) {
        int iPos = this.indexOf(toElement);
        if (iPos < 0) {
            throw new IllegalArgumentException("no such element: " + toElement);
        }
        return new ImmutableArrayList(this.subList(0, iPos));
    }

    public SortedSet tailSet(Object fromElement) {
        int iPos = this.lastIndexOf(fromElement);
        if (iPos < 0) {
            throw new IllegalArgumentException("no such element: " + fromElement);
        }
        return new ImmutableArrayList(this.subList(iPos, this.size()));
    }

    public SortedSet subSet(Object fromElement, Object toElement) {
        int iPosBegin = this.lastIndexOf(fromElement);
        if (iPosBegin < 0) {
            throw new IllegalArgumentException("no such element: " + fromElement);
        }
        int iPosEnd = this.indexOf(toElement);
        if (iPosEnd < 0) {
            throw new IllegalArgumentException("no such element: " + toElement);
        }
        return new ImmutableArrayList(this.subList(iPosBegin, iPosEnd));
    }

    public Object clone() {
        try {
            ImmutableArrayList that = (ImmutableArrayList)super.clone();
            that.m_ao = (Object[])this.m_ao.clone();
            return that;
        }
        catch (CloneNotSupportedException e) {
            throw Base.ensureRuntimeException(e);
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeObject(this.m_ao);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.m_ao = (Object[])in.readObject();
    }

    public int compareTo(Object o) {
        Object[] aoThis = this.m_ao;
        Object[] aoThat = o instanceof ImmutableArrayList ? ((ImmutableArrayList)o).m_ao : ((Collection)o).toArray();
        int cThis = aoThis.length;
        int cThat = aoThat.length;
        int c = Math.min(cThis, cThat);
        for (int i = 0; i < c; ++i) {
            Object oThis = aoThis[i];
            Object oThat = aoThat[i];
            int iResult = oThis == null || oThat == null ? (oThis == null ? (oThat == null ? 0 : -1) : 1) : ((Comparable)oThis).compareTo(oThat);
            if (iResult == 0) continue;
            return iResult;
        }
        return cThis - cThat;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (o instanceof List) {
            return super.equals(o);
        }
        if (o instanceof Collection) {
            Collection that = (Collection)o;
            return this.size() == that.size() && this.containsAll(that);
        }
        return false;
    }

    protected Map getValueIndex() {
        Object[] ao;
        int c;
        HashMap<Object, Integer> map = this.m_mapValueIndex;
        if (map == null && (c = (ao = this.m_ao).length) > 32) {
            map = new HashMap<Object, Integer>(c + (c >>> 2), 1.0f);
            for (int i = c - 1; i >= 0; --i) {
                map.put(ao[i], Base.makeInteger(i));
            }
            this.m_mapValueIndex = map;
        }
        return map;
    }
}

