/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.util;

import com.tangosol.net.cache.LocalCache;
import com.tangosol.util.Base;
import com.tangosol.util.ConcurrentMap;
import com.tangosol.util.Converter;
import com.tangosol.util.ConverterCollections;
import com.tangosol.util.Filter;
import com.tangosol.util.ImmutableArrayList;
import com.tangosol.util.InvocableMap;
import com.tangosol.util.NullImplementation;
import com.tangosol.util.SimpleMapEntry;
import com.tangosol.util.ValueExtractor;
import com.tangosol.util.ValueUpdater;
import com.tangosol.util.comparator.EntryComparator;
import com.tangosol.util.comparator.SafeComparator;
import com.tangosol.util.extractor.KeyExtractor;
import com.tangosol.util.filter.EntryFilter;
import com.tangosol.util.filter.KeyAssociatedFilter;
import com.tangosol.util.filter.LimitFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class InvocableMapHelper
extends Base {
    public static final Converter ENTRY_TO_KEY_CONVERTER = new Converter(){

        public Object convert(Object o) {
            return ((Map.Entry)o).getKey();
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object invokeLocked(ConcurrentMap map, InvocableMap.Entry entry, InvocableMap.EntryProcessor agent) {
        Object oKey = entry.getKey();
        map.lock(oKey, -1L);
        try {
            Object object = agent.process(entry);
            return object;
        }
        finally {
            map.unlock(oKey);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map invokeAllLocked(ConcurrentMap map, Set setEntries, InvocableMap.EntryProcessor agent) {
        ConverterCollections.ConverterSet setKeys = ConverterCollections.getSet(setEntries, ENTRY_TO_KEY_CONVERTER, NullImplementation.getConverter());
        List listLocked = InvocableMapHelper.lockAll(map, setKeys, 0L);
        if (listLocked == null) {
            HashMap<Object, Object> mapResult = new HashMap<Object, Object>(setEntries.size());
            Iterator iter = setEntries.iterator();
            while (iter.hasNext()) {
                InvocableMap.Entry entry = (InvocableMap.Entry)iter.next();
                mapResult.put(entry.getKey(), InvocableMapHelper.invokeLocked(map, entry, agent));
            }
            return mapResult;
        }
        try {
            Map map2 = agent.processAll(setEntries);
            return map2;
        }
        finally {
            InvocableMapHelper.unlockAll(map, listLocked);
        }
    }

    public static List lockAll(ConcurrentMap map, Collection collKeys, long cWait) {
        Set setKeys = collKeys instanceof Set ? (Set)collKeys : new HashSet(collKeys);
        ArrayList listKeys = new ArrayList(setKeys);
        LinkedList listLocked = new LinkedList();
        int cKeys = listKeys.size();
        boolean fSuccess = true;
        do {
            long cWaitNext = cWait;
            for (int i = 0; i < cKeys; ++i) {
                Object oKey = listKeys.get(i);
                fSuccess = map.lock(oKey, cWaitNext);
                if (fSuccess) {
                    listLocked.add(0, oKey);
                    cWaitNext = 0L;
                    continue;
                }
                if (i == 0) {
                    return null;
                }
                Iterator iterLocked = listLocked.iterator();
                while (iterLocked.hasNext()) {
                    map.unlock(iterLocked.next());
                }
                listLocked.clear();
                listKeys.remove(i);
                listKeys.add(0, oKey);
            }
        } while (!fSuccess);
        return listLocked;
    }

    public static void unlockAll(ConcurrentMap map, Collection collKeys) {
        Iterator iterLocked = collKeys.iterator();
        while (iterLocked.hasNext()) {
            map.unlock(iterLocked.next());
        }
    }

    public static SimpleEntry makeEntry(Map map, Object oKey) {
        return new SimpleEntry(map, oKey, false);
    }

    public static Set makeEntrySet(Map map, Collection collKeys, boolean fReadOnly) {
        HashSet<SimpleEntry> setEntries = new HashSet<SimpleEntry>(collKeys.size());
        Iterator iter = collKeys.iterator();
        while (iter.hasNext()) {
            setEntries.add(new SimpleEntry(map, iter.next(), fReadOnly));
        }
        return setEntries;
    }

    public static Set makeEntrySet(Collection collEntries) {
        HashSet<SimpleEntry> setEntries = new HashSet<SimpleEntry>(collEntries.size());
        Iterator iter = collEntries.iterator();
        while (iter.hasNext()) {
            Map.Entry entry = (Map.Entry)iter.next();
            setEntries.add(new SimpleEntry(entry.getKey(), entry.getValue()));
        }
        return setEntries;
    }

    public static boolean evaluateEntry(Filter filter, Map.Entry entry) {
        return filter instanceof EntryFilter ? ((EntryFilter)filter).evaluateEntry(entry) : filter.evaluate(entry.getValue());
    }

    public static boolean evaluateEntry(Filter filter, Object oKey, Object oValue) {
        return filter instanceof EntryFilter ? ((EntryFilter)filter).evaluateEntry(new SimpleMapEntry(oKey, oValue)) : filter.evaluate(oValue);
    }

    public static Object extractFromEntry(ValueExtractor extractor, Map.Entry entry) {
        return extractor.extract(extractor instanceof KeyExtractor ? entry.getKey() : entry.getValue());
    }

    public static Set query(Map map, Filter filter, boolean fEntries, boolean fSort, Comparator comparator) {
        if (filter == null) {
            return fEntries ? map.entrySet() : map.keySet();
        }
        LimitFilter filterLimit = null;
        while (filter instanceof KeyAssociatedFilter || filter instanceof LimitFilter) {
            if (filter instanceof KeyAssociatedFilter) {
                InvocableMapHelper.azzert(!((filter = ((KeyAssociatedFilter)filter).getFilter()) instanceof KeyAssociatedFilter), "recursive KeyAssociatedFilter");
            }
            if (!(filter instanceof LimitFilter)) continue;
            filterLimit = (LimitFilter)filter;
            InvocableMapHelper.azzert(!((filter = filterLimit.getFilter()) instanceof LimitFilter), "recursive LimitFilter");
        }
        Set set = new HashSet();
        try {
            Iterator iter = map.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                if (!InvocableMapHelper.evaluateEntry(filter, entry)) continue;
                set.add(fEntries ? entry : entry.getKey());
            }
        }
        catch (ConcurrentModificationException e) {
            set.clear();
            Object[] ao = map.entrySet().toArray();
            int c = ao.length;
            for (int i = 0; i < c; ++i) {
                Map.Entry entry = (Map.Entry)ao[i];
                if (!InvocableMapHelper.evaluateEntry(filter, entry)) continue;
                set.add(fEntries ? entry : entry.getKey());
            }
        }
        if (fEntries && fSort) {
            if (comparator == null) {
                comparator = SafeComparator.INSTANCE;
            }
            Object[] aEntry = set.toArray();
            EntryComparator compEntry = new EntryComparator(comparator);
            Arrays.sort(aEntry, compEntry);
            set = new ImmutableArrayList(aEntry);
            if (filterLimit != null) {
                filterLimit.setComparator(compEntry);
                set = filterLimit.extractPage(set);
                filterLimit.setComparator(comparator);
            }
        } else if (filterLimit != null) {
            filterLimit.setComparator(null);
            set = filterLimit.extractPage(set);
        }
        return set;
    }

    public static class SimpleEntry
    extends Base
    implements InvocableMap.Entry {
        private static final Object UNKNOWN = new Object();
        protected Map m_map;
        private Object m_oKey;
        private Object m_oValue;
        private boolean m_fReadOnly;

        public SimpleEntry(Map map, Object oKey, boolean fReadOnly) {
            SimpleEntry.azzert(map != null);
            this.m_map = map;
            this.m_oKey = oKey;
            this.m_fReadOnly = fReadOnly;
            this.m_oValue = UNKNOWN;
        }

        public SimpleEntry(Object oKey, Object oValue) {
            this.m_oKey = oKey;
            this.m_oValue = oValue;
            this.m_fReadOnly = true;
        }

        public Object getKey() {
            return this.m_oKey;
        }

        public Object getValue() {
            Object oValue = this.m_oValue;
            if (oValue == UNKNOWN) {
                oValue = this.m_oValue = this.m_map.get(this.m_oKey);
            }
            return oValue;
        }

        public Object setValue(Object oValue) {
            this.checkMutable();
            this.m_oValue = oValue;
            return this.m_map.put(this.m_oKey, oValue);
        }

        public void setValue(Object oValue, boolean fSynthetic) {
            this.checkMutable();
            this.m_map.putAll(Collections.singletonMap(this.m_oKey, oValue));
            this.m_oValue = oValue;
        }

        public Object extract(ValueExtractor extractor) {
            return InvocableMapHelper.extractFromEntry(extractor, this);
        }

        public void update(ValueUpdater updater, Object oValue) {
            Object oTarget = this.getValue();
            updater.update(oTarget, oValue);
            this.setValue(oTarget, false);
        }

        public boolean isPresent() {
            Object oValue = this.m_oValue;
            return oValue != UNKNOWN && oValue != null || this.m_map == null || this.m_map.containsKey(this.m_oKey);
        }

        public void remove(boolean fSynthetic) {
            this.checkMutable();
            Map map = this.m_map;
            Object oKey = this.m_oKey;
            if (fSynthetic && map instanceof LocalCache) {
                ((LocalCache)map).evict(oKey);
            } else {
                map.keySet().remove(oKey);
            }
            this.m_oValue = null;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            SimpleEntry that = (SimpleEntry)o;
            return SimpleEntry.equals(this.m_oKey, that.m_oKey);
        }

        public int hashCode() {
            Object oKey = this.m_oKey;
            return oKey == null ? 0 : oKey.hashCode();
        }

        public String toString() {
            return "SimpleEntry(key=" + this.m_oKey + ')';
        }

        protected void checkMutable() {
            if (this.m_fReadOnly) {
                throw new UnsupportedOperationException("Read-only entry does not allow Map modification");
            }
        }
    }
}

