/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.util;

import com.tangosol.util.Base;
import java.io.Serializable;
import java.util.EventListener;

public class Listeners
extends Base
implements Serializable {
    private static final EventListener[] BLANKLIST = new EventListener[0];
    private EventListener[] m_aListeners = BLANKLIST;

    public synchronized void add(EventListener listener) {
        if (listener == null) {
            return;
        }
        if (!this.contains(listener)) {
            int c = this.m_aListeners.length;
            EventListener[] a = new EventListener[c + 1];
            System.arraycopy(this.m_aListeners, 0, a, 0, c);
            a[c] = listener;
            this.m_aListeners = a;
        }
    }

    public synchronized void remove(EventListener listener) {
        int i;
        if (listener == null) {
            return;
        }
        EventListener[] aOld = this.m_aListeners;
        int c = aOld.length;
        if (c == 1) {
            if (listener.equals(aOld[0])) {
                this.m_aListeners = BLANKLIST;
            }
            return;
        }
        if (c > 0 && (i = this.indexOf(listener)) >= 0) {
            EventListener[] aNew = new EventListener[c - 1];
            if (i > 0) {
                System.arraycopy(aOld, 0, aNew, 0, i);
            }
            if (i + 1 < c) {
                System.arraycopy(aOld, i + 1, aNew, i, c - i - 1);
            }
            this.m_aListeners = aNew;
        }
    }

    public synchronized void addAll(Listeners listeners) {
        if (listeners == null) {
            return;
        }
        EventListener[] aOld = this.m_aListeners;
        EventListener[] aAdd = listeners.m_aListeners;
        int cOld = aOld.length;
        if (cOld == 0) {
            this.m_aListeners = aAdd;
        } else {
            int cAdd = aAdd.length;
            EventListener[] aNew = new EventListener[cAdd];
            int cNew = 0;
            for (int i = 0; i < cAdd; ++i) {
                EventListener l = aAdd[i];
                if (this.contains(l)) continue;
                aNew[cNew++] = l;
            }
            if (cNew > 0) {
                EventListener[] aAll = new EventListener[cOld + cNew];
                System.arraycopy(aOld, 0, aAll, 0, cOld);
                System.arraycopy(aNew, 0, aAll, cOld, cNew);
                this.m_aListeners = aAll;
            }
        }
    }

    public synchronized void removeAll() {
        this.m_aListeners = BLANKLIST;
    }

    public boolean isEmpty() {
        return this.m_aListeners.length == 0;
    }

    public boolean contains(EventListener listener) {
        return this.indexOf(listener) >= 0;
    }

    private int indexOf(EventListener listener) {
        EventListener[] a = this.m_aListeners;
        int c = a.length;
        for (int i = 0; i < c; ++i) {
            if (!listener.equals(a[i])) continue;
            return i;
        }
        return -1;
    }

    public EventListener[] listeners() {
        return this.m_aListeners;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("Listeners{");
        EventListener[] a = this.m_aListeners;
        int c = a.length;
        for (int i = 0; i < c; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(a[i]);
        }
        sb.append('}');
        return sb.toString();
    }
}

