/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.util;

import com.tangosol.io.ExternalizableLite;
import com.tangosol.util.Base;
import com.tangosol.util.ExternalizableHelper;
import com.tangosol.util.NullImplementation;
import com.tangosol.util.SimpleMapEntry;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.Externalizable;
import java.io.IOException;
import java.io.NotActiveException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class LiteMap
extends AbstractMap
implements Cloneable,
Externalizable,
ExternalizableLite {
    private static final Object[] NO_OBJECTS;
    private static final int THRESHOLD = 8;
    private static final int I_EMPTY = 0;
    private static final int I_SINGLE = 1;
    private static final int I_ARRAY_1 = 2;
    private static final int I_ARRAY_2 = 3;
    private static final int I_ARRAY_3 = 4;
    private static final int I_ARRAY_4 = 5;
    private static final int I_ARRAY_5 = 6;
    private static final int I_ARRAY_6 = 7;
    private static final int I_ARRAY_7 = 8;
    private static final int I_ARRAY_8 = 9;
    private static final int I_OTHER = 10;
    byte m_nImpl;
    Object m_oContents;
    static final /* synthetic */ boolean $assertionsDisabled;

    public LiteMap() {
    }

    public LiteMap(Map map) {
        this.putAll(map);
    }

    public boolean isEmpty() {
        return this.m_nImpl == 0;
    }

    public int size() {
        switch (this.m_nImpl) {
            case 0: {
                return 0;
            }
            case 1: {
                return 1;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                return this.m_nImpl - 2 + 1;
            }
            case 10: {
                return ((Map)this.m_oContents).size();
            }
        }
        throw new IllegalStateException();
    }

    public boolean containsKey(Object oKey) {
        switch (this.m_nImpl) {
            case 0: {
                return false;
            }
            case 1: {
                Object oKeyEntry = ((Map.Entry)this.m_oContents).getKey();
                return Base.equals(oKey, oKeyEntry);
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                Map.Entry[] aEntry = (Map.Entry[])this.m_oContents;
                int c = this.m_nImpl - 2 + 1;
                return this.indexOf(aEntry, c, oKey) >= 0;
            }
            case 10: {
                return ((Map)this.m_oContents).containsKey(oKey);
            }
        }
        throw new IllegalStateException();
    }

    public Object get(Object oKey) {
        switch (this.m_nImpl) {
            case 0: {
                return null;
            }
            case 1: {
                Map.Entry entry = (Map.Entry)this.m_oContents;
                Object oKeyEntry = entry.getKey();
                return Base.equals(oKey, oKeyEntry) ? entry.getValue() : null;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                Map.Entry[] aEntry = (Map.Entry[])this.m_oContents;
                int c = this.m_nImpl - 2 + 1;
                int i = this.indexOf(aEntry, c, oKey);
                return i < 0 ? null : aEntry[i].getValue();
            }
            case 10: {
                return ((Map)this.m_oContents).get(oKey);
            }
        }
        throw new IllegalStateException();
    }

    public Object put(Object oKey, Object oValue) {
        switch (this.m_nImpl) {
            case 0: {
                this.m_nImpl = 1;
                this.m_oContents = this.instantiateEntry(oKey, oValue);
                return null;
            }
            case 1: {
                Map.Entry entry = (Map.Entry)this.m_oContents;
                Object oKeyEntry = entry.getKey();
                Object oPrev = null;
                if (Base.equals(oKey, oKeyEntry)) {
                    oPrev = entry.getValue();
                    entry.setValue(oValue);
                } else {
                    Map.Entry[] aEntry = new Map.Entry[8];
                    aEntry[0] = entry;
                    aEntry[1] = this.instantiateEntry(oKey, oValue);
                    this.m_nImpl = (byte)3;
                    this.m_oContents = aEntry;
                }
                return oPrev;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                byte nImpl = this.m_nImpl;
                Map.Entry[] aEntry = (Map.Entry[])this.m_oContents;
                int c = nImpl - 2 + 1;
                int i = this.indexOf(aEntry, c, oKey);
                if (i >= 0) {
                    Map.Entry entry = aEntry[i];
                    Object oPrev = entry.getValue();
                    entry.setValue(oValue);
                    return oPrev;
                }
                if (c >= 8) {
                    Map map = this.instantiateMap();
                    for (i = 0; i < c; ++i) {
                        Map.Entry entry = aEntry[i];
                        map.put(entry.getKey(), entry.getValue());
                    }
                    map.put(oKey, oValue);
                    this.m_nImpl = (byte)10;
                    this.m_oContents = map;
                } else {
                    aEntry[c] = this.instantiateEntry(oKey, oValue);
                    this.m_nImpl = (byte)(nImpl + 1);
                }
                return null;
            }
            case 10: {
                return ((Map)this.m_oContents).put(oKey, oValue);
            }
        }
        throw new IllegalStateException();
    }

    public Object remove(Object oKey) {
        switch (this.m_nImpl) {
            case 0: {
                return null;
            }
            case 1: {
                Map.Entry entry = (Map.Entry)this.m_oContents;
                Object oKeyEntry = entry.getKey();
                Object oPrev = null;
                if (Base.equals(oKey, oKeyEntry)) {
                    oPrev = entry.getValue();
                    this.m_nImpl = 0;
                    this.m_oContents = null;
                }
                return oPrev;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                int nImpl = this.m_nImpl;
                Map.Entry[] aEntry = (Map.Entry[])this.m_oContents;
                int c = nImpl - 2 + 1;
                int i = this.indexOf(aEntry, c, oKey);
                if (i < 0) {
                    return null;
                }
                Object oPrev = aEntry[i].getValue();
                if (c == 1) {
                    this.m_nImpl = 0;
                    this.m_oContents = null;
                } else {
                    System.arraycopy(aEntry, i + 1, aEntry, i, c - i - 1);
                    aEntry[c - 1] = null;
                    this.m_nImpl = (byte)(--nImpl);
                }
                return oPrev;
            }
            case 10: {
                Map map = (Map)this.m_oContents;
                Object oPrev = map.remove(oKey);
                this.checkShrinkFromOther();
                return oPrev;
            }
        }
        throw new IllegalStateException();
    }

    public void clear() {
        this.m_nImpl = 0;
        this.m_oContents = null;
    }

    public Object clone() {
        LiteMap that;
        try {
            that = (LiteMap)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw Base.ensureRuntimeException(e);
        }
        switch (this.m_nImpl) {
            case 0: {
                break;
            }
            case 1: {
                Map.Entry entry = (Map.Entry)this.m_oContents;
                that.m_oContents = that.instantiateEntry(entry.getKey(), entry.getValue());
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                Map.Entry[] aEntryThis = (Map.Entry[])this.m_oContents;
                Map.Entry[] aEntryThat = new Map.Entry[8];
                int c = this.m_nImpl - 2 + 1;
                for (int i = 0; i < c; ++i) {
                    Map.Entry entryThis = aEntryThis[i];
                    aEntryThat[i] = that.instantiateEntry(entryThis.getKey(), entryThis.getValue());
                }
                that.m_oContents = aEntryThat;
                break;
            }
            case 10: {
                Map mapThis = (Map)this.m_oContents;
                Map mapThat = that.instantiateMap();
                mapThat.putAll(mapThis);
                that.m_oContents = mapThat;
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        return that;
    }

    public Set entrySet() {
        return this.instantiateEntrySet();
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        if (!this.isEmpty()) {
            throw new NotActiveException();
        }
        int c = in.readInt();
        switch (c) {
            case 0: {
                break;
            }
            case 1: {
                this.m_nImpl = 1;
                this.m_oContents = this.instantiateEntry(in.readObject(), in.readObject());
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                Map.Entry[] aEntry = new Map.Entry[8];
                for (int i = 0; i < c; ++i) {
                    aEntry[i] = this.instantiateEntry(in.readObject(), in.readObject());
                }
                this.m_nImpl = (byte)(2 + c - 1);
                this.m_oContents = aEntry;
                break;
            }
            default: {
                Map map = this.instantiateMap();
                for (int i = 0; i < c; ++i) {
                    map.put(in.readObject(), in.readObject());
                }
                this.m_nImpl = (byte)10;
                this.m_oContents = map;
            }
        }
    }

    public synchronized void writeExternal(ObjectOutput out) throws IOException {
        byte nImpl = this.m_nImpl;
        switch (nImpl) {
            case 0: {
                out.writeInt(0);
                break;
            }
            case 1: {
                Map.Entry entry = (Map.Entry)this.m_oContents;
                out.writeInt(1);
                out.writeObject(entry.getKey());
                out.writeObject(entry.getValue());
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                Map.Entry[] aEntry = (Map.Entry[])this.m_oContents;
                int c = nImpl - 2 + 1;
                out.writeInt(c);
                for (int i = 0; i < c; ++i) {
                    Map.Entry entry = aEntry[i];
                    out.writeObject(entry.getKey());
                    out.writeObject(entry.getValue());
                }
                break;
            }
            case 10: {
                Map map = (Map)this.m_oContents;
                int c = map.size();
                Map.Entry[] aEntry = map.entrySet().toArray(new Map.Entry[c]);
                out.writeInt(c);
                for (int i = 0; i < c; ++i) {
                    Map.Entry entry = aEntry[i];
                    out.writeObject(entry.getKey());
                    out.writeObject(entry.getValue());
                }
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public void readExternal(DataInput in) throws IOException {
        Map<void, void> map;
        ObjectInput inObj;
        if (!this.isEmpty()) {
            throw new NotActiveException();
        }
        int c = ExternalizableHelper.readInt(in);
        if (c == 0) {
            return;
        }
        boolean fLite = in.readBoolean();
        ObjectInput objectInput = inObj = fLite ? null : ExternalizableHelper.getObjectInput(in, null);
        if (c > 8) {
            map = this.instantiateMap();
            this.m_nImpl = (byte)10;
            this.m_oContents = map;
        } else {
            map = this;
        }
        for (int i = 0; i < c; ++i) {
            void var8_8;
            void var7_7;
            Object oValue;
            Object oKey;
            if (fLite) {
                oKey = ExternalizableHelper.readObject(in);
                oValue = ExternalizableHelper.readObject(in);
            } else {
                try {
                    oKey = inObj.readObject();
                    oValue = inObj.readObject();
                }
                catch (ClassNotFoundException e) {
                    throw new IOException("readObject failed: " + e + "\n" + Base.getStackTrace(e));
                }
            }
            map.put(var7_7, var8_8);
        }
    }

    public synchronized void writeExternal(DataOutput out) throws IOException {
        int c = this.size();
        Map.Entry[] aEntry = this.entrySet().toArray(new Map.Entry[c]);
        ExternalizableHelper.writeInt(out, c);
        if (c == 0) {
            return;
        }
        boolean fLite = true;
        int FMT_OBJ_SER = 11;
        for (int i = 0; i < c; ++i) {
            Map.Entry entry = aEntry[i];
            if (ExternalizableHelper.getStreamFormat(entry.getKey()) != 11 && ExternalizableHelper.getStreamFormat(entry.getValue()) != 11) continue;
            fLite = false;
            break;
        }
        out.writeBoolean(fLite);
        ObjectOutput outObj = fLite ? null : ExternalizableHelper.getObjectOutput(out);
        for (int i = 0; i < c; ++i) {
            Map.Entry entry = aEntry[i];
            Object oKey = entry.getKey();
            Object oValue = entry.getValue();
            if (fLite) {
                ExternalizableHelper.writeObject(out, oKey);
                ExternalizableHelper.writeObject(out, oValue);
                continue;
            }
            outObj.writeObject(oKey);
            outObj.writeObject(oValue);
        }
        if (outObj != null) {
            outObj.close();
        }
    }

    protected Map.Entry instantiateEntry(Object key, Object value) {
        return new SimpleMapEntry(key, value);
    }

    protected Set instantiateEntrySet() {
        return new EntrySet();
    }

    protected Map instantiateMap() {
        return new HashMap();
    }

    private int indexOf(Map.Entry[] aEntry, int c, Object oKey) {
        int i;
        for (i = 0; i < c; ++i) {
            if (oKey != aEntry[i].getKey()) continue;
            return i;
        }
        if (oKey != null) {
            for (i = 0; i < c; ++i) {
                if (!oKey.equals(aEntry[i].getKey())) continue;
                return i;
            }
        }
        return -1;
    }

    protected void checkShrinkFromOther() {
        if (!$assertionsDisabled && this.m_nImpl != 10) {
            throw new AssertionError();
        }
        Map map = (Map)this.m_oContents;
        int c = map.size();
        switch (c) {
            case 0: {
                this.m_nImpl = 0;
                this.m_oContents = null;
                break;
            }
            case 1: {
                Map.Entry entry = (Map.Entry)map.entrySet().toArray()[0];
                this.m_nImpl = 1;
                this.m_oContents = this.instantiateEntry(entry.getKey(), entry.getValue());
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                Map.Entry[] aEntry = new Map.Entry[8];
                int i = 0;
                Iterator iter = map.entrySet().iterator();
                while (iter.hasNext()) {
                    Map.Entry entry = iter.next();
                    aEntry[i++] = this.instantiateEntry(entry.getKey(), entry.getValue());
                }
                if (!$assertionsDisabled && i != c) {
                    throw new AssertionError();
                }
                this.m_nImpl = (byte)(2 + i - 1);
                this.m_oContents = aEntry;
            }
        }
    }

    static {
        $assertionsDisabled = !LiteMap.class.desiredAssertionStatus();
        NO_OBJECTS = new Object[0];
    }

    public static class EntryIterator
    implements Iterator {
        Map m_map;
        Map.Entry[] m_aEntry;
        int m_iPrev = -1;
        boolean m_fCanRemove = false;

        EntryIterator(LiteMap map, Map.Entry[] aEntry) {
            this.m_map = map;
            this.m_aEntry = aEntry;
        }

        public boolean hasNext() {
            return this.m_iPrev + 1 < this.m_aEntry.length;
        }

        public Object next() {
            int iNext = this.m_iPrev + 1;
            if (iNext < this.m_aEntry.length) {
                this.m_iPrev = iNext;
                this.m_fCanRemove = true;
                return this.m_aEntry[iNext];
            }
            throw new NoSuchElementException();
        }

        public void remove() {
            if (!this.m_fCanRemove) {
                throw new IllegalStateException();
            }
            this.m_fCanRemove = false;
            this.m_map.remove(this.m_aEntry[this.m_iPrev].getKey());
        }
    }

    protected class EntrySet
    extends AbstractSet
    implements Serializable {
        protected EntrySet() {
        }

        public Iterator iterator() {
            LiteMap map = LiteMap.this;
            int c = map.size();
            return c == 0 ? NullImplementation.getIterator() : new EntryIterator(map, (Map.Entry[])this.toArray(new Map.Entry[c]));
        }

        public boolean isEmpty() {
            return LiteMap.this.isEmpty();
        }

        public int size() {
            return LiteMap.this.size();
        }

        public boolean contains(Object o) {
            if (o instanceof Map.Entry) {
                Map.Entry entry = (Map.Entry)o;
                Object oKey = entry.getKey();
                Object oValue = entry.getValue();
                LiteMap map = LiteMap.this;
                Object oActual = map.get(oKey);
                return oActual == null ? oValue == null && map.containsKey(oKey) : Base.equals(oValue, oActual);
            }
            return false;
        }

        public Object[] toArray() {
            return this.toArray((Object[])null);
        }

        public Object[] toArray(Object[] ao) {
            LiteMap map = LiteMap.this;
            int c = map.size();
            if (ao == null) {
                ao = c == 0 ? NO_OBJECTS : new Object[c];
            } else if (ao.length < c) {
                ao = (Object[])Array.newInstance(ao.getClass().getComponentType(), c);
            } else if (ao.length > c) {
                ao[c] = null;
            }
            switch (map.m_nImpl) {
                case 0: {
                    break;
                }
                case 1: {
                    ao[0] = map.m_oContents;
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    System.arraycopy((Map.Entry[])LiteMap.this.m_oContents, 0, ao, 0, c);
                    break;
                }
                case 10: {
                    ao = ((Map)LiteMap.this.m_oContents).entrySet().toArray(ao);
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            return ao;
        }
    }
}

