/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.util;

import com.tangosol.util.Base;
import com.tangosol.util.Listeners;
import com.tangosol.util.MapListener;
import com.tangosol.util.ObservableMap;
import java.util.EventListener;
import java.util.EventObject;

public class MapEvent
extends EventObject {
    public static final int ENTRY_INSERTED = 1;
    public static final int ENTRY_UPDATED = 2;
    public static final int ENTRY_DELETED = 3;
    protected int m_nId;
    protected Object m_oKey;
    protected Object m_oValueOld;
    protected Object m_oValueNew;

    public MapEvent(ObservableMap map, int nId, Object oKey, Object oValueOld, Object oValueNew) {
        super(map);
        this.m_nId = nId;
        this.m_oKey = oKey;
        this.m_oValueOld = oValueOld;
        this.m_oValueNew = oValueNew;
    }

    public ObservableMap getMap() {
        return (ObservableMap)this.getSource();
    }

    public int getId() {
        return this.m_nId;
    }

    public Object getKey() {
        return this.m_oKey;
    }

    public Object getOldValue() {
        return this.m_oValueOld;
    }

    public Object getNewValue() {
        return this.m_oValueNew;
    }

    public String toString() {
        String sEvt = this.getClass().getName();
        String sSrc = this.getSource().getClass().getName();
        return sEvt.substring(sEvt.lastIndexOf(46) + 1) + '{' + sSrc.substring(sSrc.lastIndexOf(46) + 1) + this.getDescription() + '}';
    }

    public void dispatch(Listeners listeners) {
        this.dispatch(listeners, true);
    }

    public void dispatch(Listeners listeners, boolean fStrict) {
        if (listeners != null) {
            EventListener[] targets = listeners.listeners();
            int i = targets.length;
            while (--i >= 0) {
                MapListener target = (MapListener)targets[i];
                try {
                    this.dispatch(target);
                }
                catch (RuntimeException e) {
                    if (fStrict) {
                        throw e;
                    }
                    Base.err(e);
                }
            }
        }
    }

    public void dispatch(MapListener listener) {
        switch (this.getId()) {
            case 1: {
                listener.entryInserted(this);
                break;
            }
            case 2: {
                listener.entryUpdated(this);
                break;
            }
            case 3: {
                listener.entryDeleted(this);
            }
        }
    }

    protected String getDescription() {
        switch (this.getId()) {
            case 1: {
                return " added: key=" + this.getKey() + ", value=" + this.getNewValue();
            }
            case 2: {
                return " updated: key=" + this.getKey() + ", old value=" + this.getOldValue() + ", new value=" + this.getNewValue();
            }
            case 3: {
                return " deleted: key=" + this.getKey() + ", value=" + this.getOldValue();
            }
        }
        throw new IllegalStateException();
    }

    public static String getDescription(int nId) {
        switch (nId) {
            case 1: {
                return "inserted";
            }
            case 2: {
                return "updated";
            }
            case 3: {
                return "deleted";
            }
        }
        return "<unknown>";
    }
}

