/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.util;

import com.tangosol.net.cache.CacheEvent;
import com.tangosol.util.Base;
import com.tangosol.util.Converter;
import com.tangosol.util.ConverterCollections;
import com.tangosol.util.Filter;
import com.tangosol.util.ImmutableArrayList;
import com.tangosol.util.Listeners;
import com.tangosol.util.LiteMap;
import com.tangosol.util.LiteSet;
import com.tangosol.util.MapEvent;
import com.tangosol.util.MapListener;
import com.tangosol.util.NullImplementation;
import com.tangosol.util.ObservableMap;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class MapListenerSupport
extends Base {
    protected static final int PLAN_NONE = 0;
    protected static final int PLAN_NO_LISTENERS = 1;
    protected static final int PLAN_ALL_LISTENER = 2;
    protected static final int PLAN_KEY_LISTENER = 3;
    protected static final int PLAN_NO_OPTIMIZE = 4;
    protected final Listeners NO_LISTENERS = new Listeners();
    protected Map m_mapListeners;
    protected Map m_mapKeyListeners;
    protected Map m_mapStandardListeners;
    protected Map m_mapStandardKeyListeners;
    protected int m_nOptimizationPlan;
    protected Listeners m_listenersCached;

    public synchronized void addListener(MapListener listener, Filter filter, boolean fLite) {
        if (listener != null) {
            Map mapListeners = this.m_mapListeners;
            if (mapListeners == null) {
                mapListeners = this.m_mapListeners = new LiteMap();
            }
            MapListenerSupport.addSafeListener(mapListeners, filter, listener);
            Map mapStandard = this.m_mapStandardListeners;
            if (mapStandard == null) {
                mapStandard = this.m_mapStandardListeners = new LiteMap();
            }
            MapListenerSupport.addListenerState(mapStandard, filter, listener, fLite);
            this.m_nOptimizationPlan = 0;
            this.m_listenersCached = null;
        }
    }

    public synchronized void addListener(MapListener listener, Object oKey, boolean fLite) {
        if (listener != null) {
            EventListener[] alistener;
            HashMap mapListeners = this.m_mapKeyListeners;
            if (mapListeners == null) {
                mapListeners = this.m_mapKeyListeners = new HashMap();
            }
            MapListenerSupport.addSafeListener(mapListeners, oKey, listener);
            Map mapStandard = this.m_mapStandardKeyListeners;
            if (mapStandard == null) {
                mapStandard = this.m_mapStandardKeyListeners = new LiteMap();
            }
            MapListenerSupport.addListenerState(mapStandard, oKey, listener, fLite);
            boolean fKeepPlan = false;
            if (this.m_nOptimizationPlan == 3 && (alistener = this.m_listenersCached.listeners()) != null && alistener.length == 1 && alistener[0] == listener) {
                fKeepPlan = true;
            }
            if (!fKeepPlan) {
                this.m_nOptimizationPlan = 0;
                this.m_listenersCached = null;
            }
        }
    }

    public synchronized void removeListener(MapListener listener, Filter filter) {
        if (listener != null) {
            Map mapListeners = this.m_mapListeners;
            if (mapListeners != null) {
                Map mapStandard;
                MapListenerSupport.removeSafeListener(mapListeners, filter, listener);
                if (mapListeners.isEmpty()) {
                    this.m_mapListeners = null;
                }
                if ((mapStandard = this.m_mapStandardListeners) != null) {
                    MapListenerSupport.removeListenerState(mapStandard, filter, listener);
                    if (mapStandard.isEmpty()) {
                        this.m_mapStandardListeners = null;
                    }
                }
            }
            this.m_nOptimizationPlan = 0;
            this.m_listenersCached = null;
        }
    }

    public synchronized void removeListener(MapListener listener, Object oKey) {
        if (listener != null) {
            EventListener[] alistener;
            Map mapListeners = this.m_mapKeyListeners;
            if (mapListeners != null) {
                Map mapStandard;
                MapListenerSupport.removeSafeListener(mapListeners, oKey, listener);
                if (mapListeners.isEmpty()) {
                    this.m_mapKeyListeners = null;
                }
                if ((mapStandard = this.m_mapStandardKeyListeners) != null) {
                    MapListenerSupport.removeListenerState(mapStandard, oKey, listener);
                    if (mapStandard.isEmpty()) {
                        this.m_mapStandardKeyListeners = null;
                    }
                }
            }
            boolean fKeepPlan = false;
            if (this.m_nOptimizationPlan == 3 && (alistener = this.m_listenersCached.listeners()) != null && alistener.length == 1 && alistener[0] == listener) {
                boolean bl = fKeepPlan = this.m_mapKeyListeners != null;
            }
            if (!fKeepPlan) {
                this.m_nOptimizationPlan = 0;
                this.m_listenersCached = null;
            }
        }
    }

    public synchronized void clear() {
        this.m_mapListeners = null;
        this.m_mapKeyListeners = null;
        this.m_mapStandardListeners = null;
        this.m_mapStandardKeyListeners = null;
        this.m_nOptimizationPlan = 1;
        this.m_listenersCached = null;
    }

    public boolean isEmpty() {
        return this.m_mapListeners == null && this.m_mapKeyListeners == null;
    }

    public boolean isEmpty(Filter filter) {
        Map mapListeners = this.m_mapListeners;
        return mapListeners == null || !mapListeners.containsKey(filter);
    }

    public boolean isEmpty(Object oKey) {
        Map mapListeners = this.m_mapKeyListeners;
        return mapListeners == null || !mapListeners.containsKey(oKey);
    }

    public boolean containsStandardListeners(Filter filter) {
        Map mapStandard = this.m_mapStandardListeners;
        if (mapStandard == null) {
            return false;
        }
        Set setStandard = (Set)mapStandard.get(filter);
        return setStandard != null && !setStandard.isEmpty();
    }

    public boolean containsStandardListeners(Object oKey) {
        Map mapStandard = this.m_mapStandardKeyListeners;
        if (mapStandard == null) {
            return false;
        }
        Set setStandard = (Set)mapStandard.get(oKey);
        return setStandard != null && !setStandard.isEmpty();
    }

    public Set getFilterSet() {
        Map mapListeners = this.m_mapListeners;
        return mapListeners == null ? NullImplementation.getSet() : mapListeners.keySet();
    }

    public Set getKeySet() {
        Map mapListeners = this.m_mapKeyListeners;
        return mapListeners == null ? NullImplementation.getSet() : mapListeners.keySet();
    }

    public synchronized Listeners getListeners(Filter filter) {
        Map mapListeners = this.m_mapListeners;
        return mapListeners == null ? null : (Listeners)mapListeners.get(filter);
    }

    public synchronized Listeners getListeners(Object oKey) {
        Map mapListeners = this.m_mapKeyListeners;
        return mapListeners == null ? null : (Listeners)mapListeners.get(oKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public Listeners collectListeners(MapEvent event) {
        switch (this.m_nOptimizationPlan) {
            default: {
                var2_2 = this;
                synchronized (var2_2) {
                    mapAllListeners = this.m_mapListeners;
                    mapKeyListeners = this.m_mapKeyListeners;
                    if (mapAllListeners != null && !mapAllListeners.isEmpty()) ** GOTO lbl35
                    if (mapKeyListeners != null && !mapKeyListeners.isEmpty()) ** GOTO lbl13
                    this.m_nOptimizationPlan = 1;
                    this.m_listenersCached = null;
                    ** GOTO lbl40
lbl13:
                    // 1 sources

                    alistenerPrev = null;
                    iter = mapKeyListeners.values().iterator();
                    while (iter.hasNext()) {
                        listeners = (Listeners)iter.next();
                        if (alistenerPrev == null) {
                            this.m_nOptimizationPlan = 3;
                            this.m_listenersCached = listeners;
                            alistenerPrev = listeners.listeners();
                            continue;
                        }
                        alistenerCur = listeners.listeners();
                        cListenersCur = alistenerCur.length;
                        v0 = fOptimize = cListenersCur == (cListenersPrev = alistenerPrev.length);
                        if (fOptimize) {
                            for (i = 0; i < cListenersCur; ++i) {
                                if (alistenerCur[i] == alistenerPrev[i]) continue;
                                fOptimize = false;
                                break;
                            }
                        }
                        if (fOptimize) continue;
                        this.m_nOptimizationPlan = 4;
                        this.m_listenersCached = null;
                        ** GOTO lbl40
                    }
                    ** GOTO lbl40
lbl35:
                    // 1 sources

                    this.m_nOptimizationPlan = 4;
                    this.m_listenersCached = null;
                    if ((mapKeyListeners == null || mapKeyListeners.isEmpty()) && mapAllListeners.size() == 1 && (listeners = (Listeners)mapAllListeners.get(null)) != null) {
                        this.m_nOptimizationPlan = 2;
                        this.m_listenersCached = listeners;
                    }
lbl40:
                    // 6 sources

                    MapListenerSupport.azzert(this.m_nOptimizationPlan != 0);
                }
                return this.collectListeners(event);
            }
            case 1: {
                return this.NO_LISTENERS;
            }
            case 2: {
                return this.m_listenersCached;
            }
            case 3: {
                return this.m_mapKeyListeners.containsKey(event.getKey()) != false ? this.m_listenersCached : this.NO_LISTENERS;
            }
            case 4: 
        }
        listeners = new Listeners();
        mapListeners = this.m_mapListeners;
        if (mapListeners != null) {
            listeners = this;
            synchronized (listeners) {
                aEntry = mapListeners.entrySet().toArray();
            }
            setFilters = null;
            evt = event;
            while (evt instanceof ConverterCollections.ConverterCacheEvent) {
                evt = ((ConverterCollections.ConverterCacheEvent)evt).getOriginalEvent();
            }
            if (evt instanceof FilterEvent) {
                setFilters = new ImmutableArrayList(((FilterEvent)evt).getFilter());
            }
            c = aEntry.length;
            for (i = 0; i < c; ++i) {
                entry = (Map.Entry)aEntry[i];
                filter = (Filter)entry.getKey();
                lsnrs = (Listeners)entry.getValue();
                if (!(setFilters == null ? filter == null || filter.evaluate(event) != false : setFilters.contains(filter) != false)) continue;
                listeners.addAll(lsnrs);
            }
        }
        if ((mapKeyListeners = this.m_mapKeyListeners) != null && (lsnrs = (Listeners)mapKeyListeners.get(event.getKey())) != null) {
            listeners.addAll(lsnrs);
        }
        return listeners;
    }

    public void fireEvent(MapEvent event, boolean fStrict) {
        event.dispatch(this.collectListeners(event), fStrict);
    }

    public static MapEvent convertEvent(MapEvent event, ObservableMap mapConv, Converter convKey, Converter convVal) {
        if (convKey == null) {
            convKey = NullImplementation.getConverter();
        }
        if (convVal == null) {
            convVal = NullImplementation.getConverter();
        }
        return ConverterCollections.getMapEvent(mapConv, event, convKey, convVal);
    }

    protected static void addSafeListener(Map mapListeners, Object anyKey, MapListener listener) {
        Listeners listeners = (Listeners)mapListeners.get(anyKey);
        if (listeners == null) {
            listeners = new Listeners();
            mapListeners.put(anyKey, listeners);
        }
        listeners.add(listener);
    }

    protected static void removeSafeListener(Map mapListeners, Object anyKey, MapListener listener) {
        Listeners listeners = (Listeners)mapListeners.get(anyKey);
        if (listeners != null) {
            listeners.remove(listener);
            if (listeners.isEmpty()) {
                mapListeners.remove(anyKey);
            }
        }
    }

    protected static void addListenerState(Map mapStandardListeners, Object anyKey, MapListener listener, boolean fLite) {
        Set setStandard = (Set)mapStandardListeners.get(anyKey);
        if (fLite) {
            if (setStandard != null) {
                setStandard.remove(listener);
            }
        } else {
            if (setStandard == null) {
                setStandard = new LiteSet();
                mapStandardListeners.put(anyKey, setStandard);
            }
            setStandard.add(listener);
        }
    }

    protected static void removeListenerState(Map mapStandardListeners, Object anyKey, MapListener listener) {
        Set setStandard = (Set)mapStandardListeners.get(anyKey);
        if (setStandard != null) {
            setStandard.remove(listener);
            if (setStandard.isEmpty()) {
                mapStandardListeners.remove(anyKey);
            }
        }
    }

    public synchronized String toString() {
        Iterator iter;
        StringBuffer sb = new StringBuffer();
        sb.append("Global listeners:");
        if (this.m_mapListeners == null) {
            sb.append(" none");
        } else {
            iter = this.m_mapListeners.keySet().iterator();
            while (iter.hasNext()) {
                Filter filter = (Filter)iter.next();
                sb.append("\n  Filter=").append(filter).append("; lite=").append(!this.containsStandardListeners(filter));
            }
        }
        sb.append("\nKey listeners:");
        if (this.m_mapKeyListeners == null) {
            sb.append(" none");
        } else {
            iter = this.m_mapKeyListeners.keySet().iterator();
            while (iter.hasNext()) {
                Object oKey = iter.next();
                sb.append("\n  Key=").append(oKey).append("; lite=").append(!this.containsStandardListeners(oKey));
            }
        }
        return sb.toString();
    }

    public static class WrapperSynchronousListener
    extends Base
    implements SynchronousListener {
        private MapListener m_listener;

        public WrapperSynchronousListener(MapListener listener) {
            WrapperSynchronousListener.azzert(listener != null);
            this.m_listener = listener;
        }

        public void entryInserted(MapEvent evt) {
            this.m_listener.entryInserted(evt);
        }

        public void entryUpdated(MapEvent evt) {
            this.m_listener.entryUpdated(evt);
        }

        public void entryDeleted(MapEvent evt) {
            this.m_listener.entryDeleted(evt);
        }

        public int hashCode() {
            return this.m_listener.hashCode();
        }

        public boolean equals(Object o) {
            if (o instanceof WrapperSynchronousListener) {
                WrapperSynchronousListener that = (WrapperSynchronousListener)o;
                return this.m_listener.equals(that.m_listener);
            }
            return false;
        }
    }

    public static interface SynchronousListener
    extends MapListener {
    }

    public static class FilterEvent
    extends CacheEvent {
        protected Filter[] m_afilter;

        public FilterEvent(ObservableMap map, int nId, Object oKey, boolean fSynthetic, Filter[] afilter) {
            this(map, nId, oKey, null, null, fSynthetic, afilter);
        }

        public FilterEvent(ObservableMap map, int nId, Object oKey, Object oValueOld, Object oValueNew, boolean fSynthetic, Filter[] afilter) {
            super(map, nId, oKey, oValueOld, oValueNew, fSynthetic);
            Base.azzert(afilter != null);
            this.m_afilter = afilter;
        }

        public Filter[] getFilter() {
            return this.m_afilter;
        }

        protected String getDescription() {
            return super.getDescription() + ", filters=" + new ImmutableArrayList(this.m_afilter);
        }
    }
}

