/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.util;

import com.tangosol.io.ExternalizableLite;
import com.tangosol.io.OutputStreaming;
import com.tangosol.io.ReadBuffer;
import com.tangosol.io.WriteBuffer;
import com.tangosol.io.pof.PofContext;
import com.tangosol.io.pof.PofHandler;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofSerializer;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.io.pof.PortableObject;
import com.tangosol.io.pof.RawQuad;
import com.tangosol.util.Binary;
import com.tangosol.util.Converter;
import com.tangosol.util.Filter;
import com.tangosol.util.MapListener;
import com.tangosol.util.ObservableMap;
import com.tangosol.util.ValueExtractor;
import com.tangosol.util.registry.FlatRegistry;
import com.tangosol.util.registry.RegistryException;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class NullImplementation
extends ClassLoader {
    private static final NullImplementation LOADER = new NullImplementation();

    private NullImplementation() {
        super(NullImplementation.class.getClassLoader());
    }

    public static Enumeration getEnumeration() {
        return NullEnumerator.INSTANCE;
    }

    public static Iterator getIterator() {
        return NullEnumerator.INSTANCE;
    }

    public static Set getSet() {
        return NullSet.INSTANCE;
    }

    public static Map getMap() {
        return NullMap.INSTANCE;
    }

    public static ObservableMap getObservableMap() {
        return NullObservableMap.INSTANCE;
    }

    public static Writer getWriter() {
        return new NullWriter();
    }

    public static OutputStream getOutputStream() {
        return new NullOutputStream();
    }

    public static Converter getConverter() {
        return NullConverter.INSTANCE;
    }

    public static ValueExtractor getValueExtractor() {
        return NullValueExtractor.INSTANCE;
    }

    public static ClassLoader getClassLoader() {
        return LOADER;
    }

    public static FlatRegistry getFlatRegistry() {
        return NullFlatRegistry.INSTANCE;
    }

    public static PofContext getPofContext() {
        return NullPofContext.INSTANCE;
    }

    public static PofHandler getPofHandler() {
        return NullPofHandler.INSTANCE;
    }

    public static class NullPofHandler
    implements PofHandler {
        public static final NullPofHandler INSTANCE = new NullPofHandler();

        NullPofHandler() {
        }

        public void registerIdentity(int nId) {
        }

        public void onNullReference(int iPos) {
        }

        public void onIdentityReference(int iPos, int nId) {
        }

        public void onInt16(int iPos, short n) {
        }

        public void onInt32(int iPos, int n) {
        }

        public void onInt64(int iPos, long n) {
        }

        public void onInt128(int iPos, BigInteger n) {
        }

        public void onFloat32(int iPos, float fl) {
        }

        public void onFloat64(int iPos, double dfl) {
        }

        public void onFloat128(int iPos, RawQuad qfl) {
        }

        public void onDecimal32(int iPos, BigDecimal dec) {
        }

        public void onDecimal64(int iPos, BigDecimal dec) {
        }

        public void onDecimal128(int iPos, BigDecimal dec) {
        }

        public void onBoolean(int iPos, boolean f) {
        }

        public void onOctet(int iPos, int b) {
        }

        public void onOctetString(int iPos, Binary bin) {
        }

        public void onChar(int iPos, char ch) {
        }

        public void onCharString(int iPos, String s) {
        }

        public void onDate(int iPos, int nYear, int nMonth, int nDay) {
        }

        public void onYearMonthInterval(int iPos, int cYears, int cMonths) {
        }

        public void onTime(int iPos, int nHour, int nMinute, int nSecond, int nNano, boolean fUTC) {
        }

        public void onTime(int iPos, int nHour, int nMinute, int nSecond, int nNano, int nHourOffset, int nMinuteOffset) {
        }

        public void onTimeInterval(int iPos, int cHours, int cMinutes, int cSeconds, int cNanos) {
        }

        public void onDateTime(int iPos, int nYear, int nMonth, int nDay, int nHour, int nMinute, int nSecond, int nNano, boolean fUTC) {
        }

        public void onDateTime(int iPos, int nYear, int nMonth, int nDay, int nHour, int nMinute, int nSecond, int nNano, int nHourOffset, int nMinuteOffset) {
        }

        public void onDayTimeInterval(int iPos, int cDays, int cHours, int cMinutes, int cSeconds, int cNanos) {
        }

        public void beginCollection(int iPos, int cElements) {
        }

        public void beginUniformCollection(int iPos, int cElements, int nType) {
        }

        public void beginArray(int iPos, int cElements) {
        }

        public void beginUniformArray(int iPos, int cElements, int nType) {
        }

        public void beginSparseArray(int iPos, int cElements) {
        }

        public void beginUniformSparseArray(int iPos, int cElements, int nType) {
        }

        public void beginMap(int iPos, int cElements) {
        }

        public void beginUniformKeysMap(int iPos, int cElements, int nTypeKeys) {
        }

        public void beginUniformMap(int iPos, int cElements, int nTypeKeys, int nTypeValues) {
        }

        public void beginUserType(int iPos, int nUserTypeId, int nVersionId) {
        }

        public void endComplexValue() {
        }
    }

    public static class NullPofContext
    implements PofContext {
        public static final NullPofContext INSTANCE = new NullPofContext();

        NullPofContext() {
        }

        public PofSerializer getPofSerializer(int nTypeId) {
            throw new IllegalArgumentException();
        }

        public int getUserTypeIdentifier(Object o) {
            throw new IllegalArgumentException();
        }

        public int getUserTypeIdentifier(Class clz) {
            throw new IllegalArgumentException();
        }

        public int getUserTypeIdentifier(String sClass) {
            throw new IllegalArgumentException();
        }

        public String getClassName(int nTypeId) {
            throw new IllegalArgumentException();
        }

        public Class getClass(int nTypeId) {
            throw new IllegalArgumentException();
        }

        public boolean isUserType(Object o) {
            return false;
        }

        public boolean isUserType(Class clz) {
            return false;
        }

        public boolean isUserType(String sClass) {
            return false;
        }

        public void serialize(WriteBuffer.BufferOutput out, Object o) throws IOException {
            throw new UnsupportedOperationException();
        }

        public Object deserialize(ReadBuffer.BufferInput in) throws IOException {
            throw new UnsupportedOperationException();
        }

        public ClassLoader getContextClassLoader() {
            return null;
        }

        public void setContextClassLoader(ClassLoader loader) {
            throw new UnsupportedOperationException();
        }
    }

    public static class NullFlatRegistry
    implements FlatRegistry {
        public static final NullFlatRegistry INSTANCE = new NullFlatRegistry();

        NullFlatRegistry() {
        }

        public FlatRegistry.Entry getByName(String sName) {
            return null;
        }

        public FlatRegistry.Entry getById(int nId) {
            return null;
        }

        public int getSize() {
            return 0;
        }

        public Iterator iterator() {
            return NullImplementation.getIterator();
        }

        public void register(FlatRegistry.Entry entry) throws RegistryException {
        }

        public void unregister(FlatRegistry.Entry entry) throws RegistryException {
        }

        public boolean equals(Object o) {
            return o instanceof FlatRegistry && ((FlatRegistry)o).getSize() == 0;
        }

        public int hashCode() {
            return 0;
        }
    }

    public static class NullValueExtractor
    implements ValueExtractor,
    Serializable,
    ExternalizableLite,
    PortableObject {
        public static final NullValueExtractor INSTANCE = new NullValueExtractor();

        public Object extract(Object o) {
            return o;
        }

        public boolean equals(Object o) {
            return o instanceof NullValueExtractor;
        }

        public int hashCode() {
            return 42;
        }

        public String toString() {
            return "NullValueExtractor";
        }

        public void readExternal(DataInput in) throws IOException {
        }

        public void writeExternal(DataOutput out) throws IOException {
        }

        public void readExternal(PofReader in) throws IOException {
        }

        public void writeExternal(PofWriter out) throws IOException {
        }
    }

    public static class NullConverter
    implements Converter {
        public static final NullConverter INSTANCE = new NullConverter();

        NullConverter() {
        }

        public Object convert(Object o) {
            return o;
        }
    }

    public static class NullOutputStream
    extends OutputStream
    implements OutputStreaming {
        private boolean m_fClosed;
        private int m_cb;

        NullOutputStream() {
        }

        public void write(int b) throws IOException {
            this.check();
            this.advance(1);
        }

        public void write(byte[] b) throws IOException {
            this.check();
            this.advance(b.length);
        }

        public void write(byte[] b, int off, int len) throws IOException {
            this.check();
            this.advance(len);
        }

        public void flush() throws IOException {
            this.check();
        }

        public void close() throws IOException {
            this.m_fClosed = true;
        }

        public int size() {
            return this.m_cb;
        }

        private void check() throws IOException {
            if (this.m_fClosed) {
                throw new IOException("Stream closed");
            }
        }

        private void advance(int cb) {
            this.m_cb = (cb += this.m_cb) < 0 ? Integer.MAX_VALUE : cb;
        }
    }

    public static class NullWriter
    extends Writer {
        private boolean m_fClosed;

        NullWriter() {
        }

        public void write(char[] cbuf) throws IOException {
            this.check();
        }

        public void write(char[] cbuf, int off, int len) throws IOException {
            this.check();
        }

        public void write(int c) throws IOException {
            this.check();
        }

        public void write(String str) throws IOException {
            this.check();
        }

        public void write(String str, int off, int len) throws IOException {
            this.check();
        }

        public void flush() throws IOException {
            this.check();
        }

        public void close() throws IOException {
            this.m_fClosed = true;
        }

        private void check() throws IOException {
            if (this.m_fClosed) {
                throw new IOException("Stream closed");
            }
        }
    }

    public static class NullObservableMap
    extends NullMap
    implements ObservableMap {
        public static final ObservableMap INSTANCE = new NullObservableMap();

        public void addMapListener(MapListener listener) {
        }

        public void removeMapListener(MapListener listener) {
        }

        public void addMapListener(MapListener listener, Object oKey, boolean fLite) {
        }

        public void removeMapListener(MapListener listener, Object oKey) {
        }

        public void addMapListener(MapListener listener, Filter filter, boolean fLite) {
        }

        public void removeMapListener(MapListener listener, Filter filter) {
        }
    }

    public static class NullMap
    extends AbstractMap
    implements Map,
    Serializable,
    ExternalizableLite,
    PortableObject {
        public static final Map INSTANCE = new NullMap();

        public int size() {
            return 0;
        }

        public Object get(Object key) {
            return null;
        }

        public Object put(Object key, Object value) {
            return null;
        }

        public void putAll(Map map) {
        }

        public Object remove(Object key) {
            return null;
        }

        public boolean containsKey(Object key) {
            return false;
        }

        public boolean containsValue(Object value) {
            return false;
        }

        public Set entrySet() {
            return NullImplementation.getSet();
        }

        public Set keySet() {
            return NullImplementation.getSet();
        }

        public Collection values() {
            return NullImplementation.getSet();
        }

        public boolean equals(Object o) {
            return o instanceof Map && ((Map)o).isEmpty();
        }

        public int hashCode() {
            return 0;
        }

        public void readExternal(DataInput in) throws IOException {
        }

        public void writeExternal(DataOutput out) throws IOException {
        }

        public void readExternal(PofReader in) throws IOException {
        }

        public void writeExternal(PofWriter out) throws IOException {
        }
    }

    public static class NullSet
    extends AbstractSet
    implements Serializable,
    ExternalizableLite,
    PortableObject {
        public static final Set INSTANCE = new NullSet();
        private static final Object[] EMPTY_ARRAY = new Object[0];
        private static final Iterator EMPTY_ITERATOR = NullImplementation.getIterator();

        public Object[] toArray() {
            return EMPTY_ARRAY;
        }

        public Iterator iterator() {
            return EMPTY_ITERATOR;
        }

        public int size() {
            return 0;
        }

        public boolean contains(Object o) {
            return false;
        }

        public boolean add(Object o) {
            return false;
        }

        public boolean remove(Object o) {
            return false;
        }

        public void clear() {
        }

        public boolean equals(Object o) {
            return o instanceof Set && ((Set)o).isEmpty();
        }

        public int hashCode() {
            return 0;
        }

        public void readExternal(DataInput in) throws IOException {
        }

        public void writeExternal(DataOutput out) throws IOException {
        }

        public void readExternal(PofReader in) throws IOException {
        }

        public void writeExternal(PofWriter out) throws IOException {
        }
    }

    public static class NullEnumerator
    implements Enumeration,
    Iterator {
        public static final NullEnumerator INSTANCE = new NullEnumerator();

        NullEnumerator() {
        }

        public boolean hasMoreElements() {
            return false;
        }

        public Object nextElement() {
            throw new NoSuchElementException();
        }

        public boolean hasNext() {
            return false;
        }

        public Object next() {
            throw new NoSuchElementException();
        }

        public void remove() {
            throw new IllegalStateException();
        }
    }
}

