/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.util;

import com.tangosol.util.Base;
import com.tangosol.util.Filter;
import com.tangosol.util.MapEvent;
import com.tangosol.util.MapListener;
import com.tangosol.util.MapListenerSupport;
import com.tangosol.util.ObservableMap;
import com.tangosol.util.SafeHashMap;

public class ObservableHashMap
extends SafeHashMap
implements ObservableMap {
    protected transient MapListenerSupport m_listenerSupport;

    public ObservableHashMap() {
    }

    public ObservableHashMap(int cInitialBuckets, float flLoadFactor, float flGrowthRate) {
        super(cInitialBuckets, flLoadFactor, flGrowthRate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object remove(Object oKey) {
        Entry entry;
        ObservableHashMap observableHashMap = this;
        synchronized (observableHashMap) {
            entry = (Entry)this.getEntryInternal(oKey);
            if (entry == null) {
                return null;
            }
            this.removeEntryInternal(entry);
        }
        entry.onRemove();
        return entry.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        SafeHashMap.Entry[] aeBucket;
        ObservableHashMap observableHashMap = this;
        synchronized (observableHashMap) {
            aeBucket = this.m_aeBucket;
            super.clear();
        }
        int c = aeBucket.length;
        for (int i = 0; i < c; ++i) {
            Entry entry = (Entry)aeBucket[i];
            while (entry != null) {
                entry.onRemove();
                entry = (Entry)entry.m_eNext;
            }
        }
    }

    public synchronized void addMapListener(MapListener listener) {
        this.addMapListener(listener, null, false);
    }

    public synchronized void removeMapListener(MapListener listener) {
        this.removeMapListener(listener, null);
    }

    public synchronized void addMapListener(MapListener listener, Object oKey, boolean fLite) {
        Base.azzert(listener != null);
        MapListenerSupport support = this.m_listenerSupport;
        if (support == null) {
            support = this.m_listenerSupport = new MapListenerSupport();
        }
        support.addListener(listener, oKey, fLite);
    }

    public synchronized void removeMapListener(MapListener listener, Object oKey) {
        Base.azzert(listener != null);
        MapListenerSupport support = this.m_listenerSupport;
        if (support != null) {
            support.removeListener(listener, oKey);
            if (support.isEmpty()) {
                this.m_listenerSupport = null;
            }
        }
    }

    public synchronized void addMapListener(MapListener listener, Filter filter, boolean fLite) {
        Base.azzert(listener != null);
        MapListenerSupport support = this.m_listenerSupport;
        if (support == null) {
            support = this.m_listenerSupport = new MapListenerSupport();
        }
        support.addListener(listener, filter, fLite);
    }

    public synchronized void removeMapListener(MapListener listener, Filter filter) {
        Base.azzert(listener != null);
        MapListenerSupport support = this.m_listenerSupport;
        if (support != null) {
            support.removeListener(listener, filter);
            if (support.isEmpty()) {
                this.m_listenerSupport = null;
            }
        }
    }

    protected MapListenerSupport getMapListenerSupport() {
        return this.m_listenerSupport;
    }

    protected boolean hasListeners() {
        return this.m_listenerSupport != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void dispatchEvent(MapEvent evt) {
        MapListenerSupport listenerSupport = this.getMapListenerSupport();
        if (listenerSupport != null) {
            ObservableHashMap observableHashMap = this;
            synchronized (observableHashMap) {
                listenerSupport.fireEvent(evt, false);
            }
        }
    }

    protected SafeHashMap.Entry instantiateEntry() {
        return new Entry();
    }

    protected class Entry
    extends SafeHashMap.Entry {
        protected Entry() {
        }

        protected void onAdd() {
            ObservableHashMap map = ObservableHashMap.this;
            if (map.hasListeners()) {
                map.dispatchEvent(new MapEvent(map, 1, this.getKey(), null, this.getValue()));
            }
        }

        public Object setValue(Object oValue) {
            Object oPrev = super.setValue(oValue);
            ObservableHashMap map = ObservableHashMap.this;
            if (map.hasListeners()) {
                map.dispatchEvent(new MapEvent(map, 2, this.getKey(), oPrev, oValue));
            }
            return oPrev;
        }

        protected void onRemove() {
            ObservableHashMap map = ObservableHashMap.this;
            if (map.hasListeners()) {
                map.dispatchEvent(new MapEvent(map, 3, this.getKey(), this.getValue(), null));
            }
        }
    }
}

