/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.util;

import com.tangosol.util.Base;
import com.tangosol.util.ImmutableArrayList;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;

public class RestrictedCollections
extends Base {
    private RestrictedCollections() {
    }

    public static Collection getCollection(Collection col, Class clz) {
        return new RestrictedCollection(col, clz);
    }

    public static Set getSet(Set set, Class clz) {
        return new RestrictedSet(set, clz);
    }

    public static SortedSet getSortedSet(SortedSet set, Class clz) {
        return new RestrictedSortedSet(set, clz);
    }

    public static List getList(List list, Class clz) {
        return new RestrictedList(list, clz);
    }

    public static ListIterator getListIterator(ListIterator iter, Class clz) {
        return new RestrictedListIterator(iter, clz);
    }

    public static Map getMap(Map map, Class clzKey, Class clzVal) {
        return new RestrictedMap(map, clzKey, clzVal);
    }

    public static SortedMap getSortedMap(SortedMap map, Class clzKey, Class clzVal) {
        return new RestrictedSortedMap(map, clzKey, clzVal);
    }

    public static Set getEntrySet(Set set, Class clzKey, Class clzVal) {
        return new RestrictedEntrySet(set, clzKey, clzVal);
    }

    public static class RestrictedEntrySet
    extends Base
    implements Set,
    Serializable {
        protected Set m_set;
        protected Class m_clzVal;

        public RestrictedEntrySet(Set set, Class clzKey, Class clzVal) {
            RestrictedEntrySet.azzert(set != null);
            RestrictedEntrySet.azzert(clzKey != null && !clzKey.isPrimitive());
            RestrictedEntrySet.azzert(clzVal != null && !clzVal.isPrimitive());
            this.m_set = set;
            this.m_clzVal = clzVal;
        }

        public int size() {
            return this.m_set.size();
        }

        public boolean isEmpty() {
            return this.m_set.isEmpty();
        }

        public boolean contains(Object o) {
            return this.m_set.contains(o);
        }

        public Iterator iterator() {
            Iterator iter = this.m_set.iterator();
            return this.wrapIterator(iter);
        }

        public Object[] toArray() {
            return this.toArray((Object[])null);
        }

        public Object[] toArray(Object[] ao) {
            Object[] aoRaw = this.m_set.toArray();
            int c = aoRaw.length;
            if (ao == null) {
                ao = new Map.Entry[c];
            } else if (ao.length < c) {
                ao = (Object[])Array.newInstance(ao.getClass().getComponentType(), c);
            } else if (ao.length > c) {
                ao[c] = null;
            }
            for (int i = 0; i < c; ++i) {
                ao[i] = this.wrapEntry((Map.Entry)aoRaw[i]);
            }
            return ao;
        }

        public boolean add(Object o) {
            throw new UnsupportedOperationException();
        }

        public boolean remove(Object o) {
            return this.m_set.remove(o);
        }

        public boolean containsAll(Collection col) {
            return this.m_set.containsAll(col);
        }

        public boolean addAll(Collection col) {
            throw new UnsupportedOperationException();
        }

        public boolean removeAll(Collection col) {
            return this.m_set.removeAll(col);
        }

        public boolean retainAll(Collection col) {
            return this.m_set.retainAll(col);
        }

        public void clear() {
            this.m_set.clear();
        }

        public boolean equals(Object o) {
            if (o instanceof RestrictedEntrySet) {
                o = ((RestrictedEntrySet)o).m_set;
            }
            return ((Object)this.m_set).equals(o);
        }

        public int hashCode() {
            return ((Object)this.m_set).hashCode();
        }

        public String toString() {
            return this.m_set.toString();
        }

        protected void checkValue(Object o) {
            if (o != null && !this.m_clzVal.isInstance(o)) {
                throw new ClassCastException("Unable to cast an object of class " + o.getClass().getName() + " to class " + this.m_clzVal.getName());
            }
        }

        protected Map.Entry wrapEntry(Map.Entry entry) {
            return new RestrictedEntry(entry);
        }

        protected Iterator wrapIterator(Iterator iter) {
            return new RestrictedIterator(iter);
        }

        protected class RestrictedIterator
        extends Base
        implements Iterator {
            protected Iterator m_iter;

            public RestrictedIterator(Iterator iter) {
                this.m_iter = iter;
            }

            public boolean hasNext() {
                return this.m_iter.hasNext();
            }

            public Object next() {
                return RestrictedEntrySet.this.wrapEntry((Map.Entry)this.m_iter.next());
            }

            public void remove() {
                this.m_iter.remove();
            }

            public boolean equals(Object o) {
                if (o instanceof RestrictedIterator) {
                    o = ((RestrictedIterator)o).m_iter;
                }
                return this.m_iter.equals(o);
            }

            public int hashCode() {
                return this.m_iter.hashCode();
            }

            public String toString() {
                return this.m_iter.toString();
            }
        }

        protected class RestrictedEntry
        extends Base
        implements Map.Entry,
        Serializable {
            protected Map.Entry m_entry;

            public RestrictedEntry(Map.Entry entry) {
                this.m_entry = entry;
            }

            public Object getKey() {
                return this.m_entry.getKey();
            }

            public Object getValue() {
                return this.m_entry.getValue();
            }

            public Object setValue(Object value) {
                RestrictedEntrySet.this.checkValue(value);
                return this.m_entry.setValue(value);
            }

            public boolean equals(Object o) {
                if (o instanceof RestrictedEntry) {
                    o = ((RestrictedEntry)o).m_entry;
                }
                return ((Object)this.m_entry).equals(o);
            }

            public int hashCode() {
                return ((Object)this.m_entry).hashCode();
            }

            public String toString() {
                return this.m_entry.toString();
            }
        }
    }

    public static class RestrictedSortedMap
    extends RestrictedMap
    implements SortedMap,
    Serializable {
        public RestrictedSortedMap(Map map, Class clzKey, Class clzVal) {
            super(map, clzKey, clzVal);
        }

        public Comparator comparator() {
            return ((SortedMap)this.m_map).comparator();
        }

        public SortedMap subMap(Object fromKey, Object toKey) {
            SortedMap submap = ((SortedMap)this.m_map).subMap(fromKey, toKey);
            return RestrictedCollections.getSortedMap(submap, this.m_clzKey, this.m_clzVal);
        }

        public SortedMap headMap(Object toKey) {
            SortedMap submap = ((SortedMap)this.m_map).headMap(toKey);
            return RestrictedCollections.getSortedMap(submap, this.m_clzKey, this.m_clzVal);
        }

        public SortedMap tailMap(Object fromKey) {
            SortedMap submap = ((SortedMap)this.m_map).tailMap(fromKey);
            return RestrictedCollections.getSortedMap(submap, this.m_clzKey, this.m_clzVal);
        }

        public Object firstKey() {
            return ((SortedMap)this.m_map).firstKey();
        }

        public Object lastKey() {
            return ((SortedMap)this.m_map).lastKey();
        }
    }

    public static class RestrictedMap
    extends Base
    implements Map,
    Serializable {
        protected Map m_map;
        protected Class m_clzKey;
        protected Class m_clzVal;
        protected Set m_set;

        public RestrictedMap(Map map, Class clzKey, Class clzVal) {
            RestrictedMap.azzert(map != null);
            RestrictedMap.azzert(clzKey != null && !clzKey.isPrimitive());
            RestrictedMap.azzert(clzVal != null && !clzVal.isPrimitive());
            this.m_map = map;
            this.m_clzKey = clzKey;
            this.m_clzVal = clzVal;
        }

        public int size() {
            return this.m_map.size();
        }

        public boolean isEmpty() {
            return this.m_map.isEmpty();
        }

        public boolean containsKey(Object key) {
            return this.m_map.containsKey(key);
        }

        public boolean containsValue(Object value) {
            return this.m_map.containsValue(value);
        }

        public Object get(Object key) {
            return this.m_map.get(key);
        }

        public Object put(Object key, Object value) {
            this.checkKey(key);
            this.checkValue(value);
            return this.m_map.put(key, value);
        }

        public Object remove(Object key) {
            return this.m_map.remove(key);
        }

        public void putAll(Map map) {
            Iterator iter = map.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                Object oKey = entry.getKey();
                Object oValue = entry.getValue();
                this.checkKey(oKey);
                this.checkValue(oValue);
                this.put(oKey, oValue);
            }
        }

        public void clear() {
            this.m_map.clear();
        }

        public Set keySet() {
            Set set = this.m_map.keySet();
            return RestrictedCollections.getSet(set, this.m_clzKey);
        }

        public Collection values() {
            Collection col = this.m_map.values();
            return RestrictedCollections.getCollection(col, this.m_clzVal);
        }

        public Set entrySet() {
            if (this.m_set == null) {
                Set set = this.m_map.entrySet();
                this.m_set = RestrictedCollections.getEntrySet(set, this.m_clzKey, this.m_clzVal);
            }
            return this.m_set;
        }

        public boolean equals(Object o) {
            if (o instanceof RestrictedMap) {
                o = ((RestrictedMap)o).m_map;
            }
            return ((Object)this.m_map).equals(o);
        }

        public int hashCode() {
            return ((Object)this.m_map).hashCode();
        }

        public String toString() {
            return this.m_map.toString();
        }

        protected void checkKey(Object o) {
            if (o != null && !this.m_clzKey.isInstance(o)) {
                throw new ClassCastException("Unable to cast an object of class " + o.getClass().getName() + " to class " + this.m_clzKey.getName());
            }
        }

        protected void checkValue(Object o) {
            if (o != null && !this.m_clzVal.isInstance(o)) {
                throw new ClassCastException("Unable to cast an object of class " + o.getClass().getName() + " to class " + this.m_clzVal.getName());
            }
        }
    }

    public static class RestrictedListIterator
    extends Base
    implements ListIterator {
        protected ListIterator m_iter;
        protected Class m_clz;

        public RestrictedListIterator(ListIterator iter, Class clz) {
            RestrictedListIterator.azzert(iter != null);
            RestrictedListIterator.azzert(clz != null && !clz.isPrimitive());
            this.m_iter = iter;
            this.m_clz = clz;
        }

        public boolean hasNext() {
            return this.m_iter.hasNext();
        }

        public Object next() {
            return this.m_iter.next();
        }

        public boolean hasPrevious() {
            return this.m_iter.hasPrevious();
        }

        public Object previous() {
            return this.m_iter.previous();
        }

        public int nextIndex() {
            return this.m_iter.nextIndex();
        }

        public int previousIndex() {
            return this.m_iter.previousIndex();
        }

        public void remove() {
            this.m_iter.remove();
        }

        public void set(Object o) {
            this.checkObject(o);
            this.m_iter.set(o);
        }

        public void add(Object o) {
            this.checkObject(o);
            this.m_iter.add(o);
        }

        protected void checkObject(Object o) {
            if (o != null && !this.m_clz.isInstance(o)) {
                throw new ClassCastException("Unable to cast an object of class " + o.getClass().getName() + " to class " + this.m_clz.getName());
            }
        }
    }

    public static class RestrictedList
    extends RestrictedCollection
    implements List,
    Serializable {
        public RestrictedList(List list, Class clz) {
            super(list, clz);
        }

        public Object get(int index) {
            return ((List)this.m_col).get(index);
        }

        public Object set(int index, Object element) {
            this.checkObject(element);
            return ((List)this.m_col).set(index, element);
        }

        public void add(int index, Object element) {
            this.checkObject(element);
            ((List)this.m_col).add(index, element);
        }

        public boolean addAll(int index, Collection col) {
            Object[] ao = col.toArray();
            int c = ao.length;
            for (int i = 0; i < c; ++i) {
                this.checkObject(ao[i]);
            }
            return ((List)this.m_col).addAll(index, new ImmutableArrayList(ao));
        }

        public Object remove(int index) {
            return ((List)this.m_col).remove(index);
        }

        public int indexOf(Object o) {
            return ((List)this.m_col).indexOf(o);
        }

        public int lastIndexOf(Object o) {
            return ((List)this.m_col).lastIndexOf(o);
        }

        public ListIterator listIterator() {
            ListIterator iter = ((List)this.m_col).listIterator();
            return RestrictedCollections.getListIterator(iter, this.m_clz);
        }

        public ListIterator listIterator(int index) {
            ListIterator iter = ((List)this.m_col).listIterator(index);
            return RestrictedCollections.getListIterator(iter, this.m_clz);
        }

        public List subList(int fromIndex, int toIndex) {
            List sublist = ((List)this.m_col).subList(fromIndex, toIndex);
            return RestrictedCollections.getList(sublist, this.m_clz);
        }
    }

    public static class RestrictedSortedSet
    extends RestrictedSet
    implements SortedSet,
    Serializable {
        public RestrictedSortedSet(SortedSet set, Class clz) {
            super(set, clz);
        }

        public Comparator comparator() {
            return ((SortedSet)this.m_col).comparator();
        }

        public SortedSet subSet(Object fromElement, Object toElement) {
            SortedSet<Object> subset = ((SortedSet)this.m_col).subSet(fromElement, toElement);
            return RestrictedCollections.getSortedSet(subset, this.m_clz);
        }

        public SortedSet headSet(Object toElement) {
            SortedSet<Object> subset = ((SortedSet)this.m_col).headSet(toElement);
            return RestrictedCollections.getSortedSet(subset, this.m_clz);
        }

        public SortedSet tailSet(Object fromElement) {
            SortedSet<Object> subset = ((SortedSet)this.m_col).tailSet(fromElement);
            return RestrictedCollections.getSortedSet(subset, this.m_clz);
        }

        public Object first() {
            return ((SortedSet)this.m_col).first();
        }

        public Object last() {
            return ((SortedSet)this.m_col).last();
        }
    }

    public static class RestrictedSet
    extends RestrictedCollection
    implements Set,
    Serializable {
        public RestrictedSet(Set set, Class clz) {
            super(set, clz);
        }
    }

    public static class RestrictedCollection
    extends Base
    implements Collection,
    Serializable {
        protected Collection m_col;
        protected Class m_clz;

        public RestrictedCollection(Collection col, Class clz) {
            RestrictedCollection.azzert(col != null);
            RestrictedCollection.azzert(clz != null && !clz.isPrimitive());
            this.m_col = col;
            this.m_clz = clz;
        }

        public int size() {
            return this.m_col.size();
        }

        public boolean isEmpty() {
            return this.m_col.isEmpty();
        }

        public boolean contains(Object o) {
            return this.m_col.contains(o);
        }

        public Iterator iterator() {
            return this.m_col.iterator();
        }

        public Object[] toArray() {
            return this.m_col.toArray((Object[])Array.newInstance(this.m_clz, this.m_col.size()));
        }

        public Object[] toArray(Object[] ao) {
            return this.m_col.toArray(ao);
        }

        public boolean add(Object o) {
            this.checkObject(o);
            return this.m_col.add(o);
        }

        public boolean remove(Object o) {
            return this.m_col.remove(o);
        }

        public boolean containsAll(Collection col) {
            return this.m_col.containsAll(col);
        }

        public boolean addAll(Collection col) {
            Object[] ao = col.toArray();
            int c = ao.length;
            for (int i = 0; i < c; ++i) {
                this.checkObject(ao[i]);
            }
            return this.m_col.addAll(new ImmutableArrayList(ao));
        }

        public boolean removeAll(Collection col) {
            return this.m_col.removeAll(col);
        }

        public boolean retainAll(Collection col) {
            return this.m_col.retainAll(col);
        }

        public void clear() {
            this.m_col.clear();
        }

        public boolean equals(Object o) {
            if (o instanceof RestrictedCollection) {
                o = ((RestrictedCollection)o).m_col;
            }
            return ((Object)this.m_col).equals(o);
        }

        public int hashCode() {
            return ((Object)this.m_col).hashCode();
        }

        public String toString() {
            return this.m_col.toString();
        }

        protected void checkObject(Object o) {
            if (o != null && !this.m_clz.isInstance(o)) {
                throw new ClassCastException("Unable to cast an object of class " + o.getClass().getName() + " to class " + this.m_clz.getName());
            }
        }
    }
}

