/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.util;

import com.tangosol.util.AbstractStableIterator;
import com.tangosol.util.Base;
import com.tangosol.util.NullImplementation;
import com.tangosol.util.WrapperException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.lang.reflect.Array;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;

public class SafeHashMap
extends AbstractMap
implements Cloneable,
Serializable {
    private static final Entry[] NO_ENTRIES;
    protected static final int[] PRIME_MODULO;
    public static final int DEFAULT_INITIALSIZE;
    protected static final int BIGGEST_MODULO;
    public static final float DEFAULT_LOADFACTOR = 1.0f;
    public static final float DEFAULT_GROWTHRATE = 3.0f;
    protected Object RESIZING = new Object();
    protected volatile int m_cEntries;
    protected volatile Entry[] m_aeBucket;
    protected int m_cCapacity;
    protected float m_flLoadFactor;
    protected float m_flGrowthRate;
    protected transient EntrySet m_setEntries;
    protected transient KeySet m_setKeys;
    protected transient ValuesCollection m_colValues;
    protected transient Object m_oIterActive;
    static final /* synthetic */ boolean $assertionsDisabled;

    public SafeHashMap() {
        this(DEFAULT_INITIALSIZE, 1.0f, 3.0f);
    }

    public SafeHashMap(int cInitialBuckets, float flLoadFactor, float flGrowthRate) {
        if (cInitialBuckets <= 0) {
            throw new IllegalArgumentException("SafeHashMap:  Initial number of buckets must be greater than zero.");
        }
        if (flLoadFactor <= 0.0f) {
            throw new IllegalArgumentException("SafeHashMap:  Load factor must be greater than zero.");
        }
        if (flGrowthRate <= 0.0f) {
            throw new IllegalArgumentException("SafeHashMap:  Growth rate must be greater than zero.");
        }
        this.m_aeBucket = new Entry[cInitialBuckets];
        this.m_cCapacity = (int)((float)cInitialBuckets * flLoadFactor);
        this.m_flLoadFactor = flLoadFactor;
        this.m_flGrowthRate = flGrowthRate;
    }

    public int size() {
        return this.m_cEntries;
    }

    public boolean isEmpty() {
        return this.m_cEntries == 0;
    }

    public boolean containsKey(Object key) {
        return this.getEntryInternal(key) != null;
    }

    public Object get(Object key) {
        Entry entry = this.getEntryInternal(key);
        return entry == null ? null : entry.getValue();
    }

    public Entry getEntry(Object key) {
        return this.getEntryInternal(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object put(Object key, Object value) {
        Entry entry;
        block7: {
            entry = this.getEntryInternal(key);
            if (entry == null) {
                int nHash = key == null ? 0 : key.hashCode();
                entry = this.instantiateEntry();
                entry.m_oKey = key;
                entry.m_oValue = value;
                entry.m_nHash = nHash;
                SafeHashMap safeHashMap = this;
                synchronized (safeHashMap) {
                    Entry[] aeBucket = this.m_aeBucket;
                    int cBuckets = aeBucket.length;
                    int nBucket = this.getBucketIndex(nHash, cBuckets);
                    Entry entryCur = aeBucket[nBucket];
                    while (entryCur != null) {
                        if (nHash == entryCur.m_nHash && (key == null ? entryCur.m_oKey == null : key.equals(entryCur.m_oKey))) {
                            entry = entryCur;
                            break block7;
                        }
                        entryCur = entryCur.m_eNext;
                    }
                    entry.m_eNext = aeBucket[nBucket];
                    aeBucket[nBucket] = entry;
                    if (++this.m_cEntries > this.m_cCapacity) {
                        this.grow();
                    }
                }
                entry.onAdd();
                return null;
            }
        }
        return entry.setValue(value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void grow() {
        Entry[] aeNew;
        Entry[] aeOld = this.m_aeBucket;
        int cOld = aeOld.length;
        if (cOld >= BIGGEST_MODULO) {
            return;
        }
        this.m_aeBucket = NO_ENTRIES;
        int cNew = (int)Math.min((long)((float)cOld * (1.0f + this.m_flGrowthRate)), (long)BIGGEST_MODULO);
        if (cNew <= cOld) {
            cNew = cOld + 1;
        }
        int[] aiModulo = PRIME_MODULO;
        int cModulos = aiModulo.length;
        for (int i = 0; i < cModulos; ++i) {
            int iModulo = aiModulo[i];
            if (iModulo < cNew) continue;
            cNew = iModulo;
            break;
        }
        try {
            aeNew = new Entry[cNew];
        }
        catch (OutOfMemoryError e) {
            this.m_aeBucket = aeOld;
            throw e;
        }
        boolean fRetain = this.isActiveIterator();
        for (int i = 0; i < cOld; ++i) {
            Entry entry = aeOld[i];
            Entry entryRetain = null;
            while (entry != null) {
                Entry entryNext = entry.m_eNext;
                int nBucket = this.getBucketIndex(entry.m_nHash, cNew);
                entry.m_eNext = aeNew[nBucket];
                aeNew[nBucket] = entry;
                if (fRetain) {
                    Entry entryCopy = (Entry)entry.clone();
                    if (entryRetain == null) {
                        aeOld[i] = entryCopy;
                    } else {
                        entryRetain.m_eNext = entryCopy;
                    }
                    entryRetain = entryCopy;
                }
                entry = entryNext;
            }
        }
        this.m_cCapacity = (int)((float)cNew * this.m_flLoadFactor);
        this.m_aeBucket = aeNew;
        Object object = this.RESIZING;
        synchronized (object) {
            this.RESIZING.notifyAll();
        }
    }

    public synchronized Object remove(Object oKey) {
        Entry[] aeBucket = this.m_aeBucket;
        int cBuckets = aeBucket.length;
        int nHash = oKey == null ? 0 : oKey.hashCode();
        int nBucket = this.getBucketIndex(nHash, cBuckets);
        Entry entryCur = aeBucket[nBucket];
        Entry entryPrev = null;
        while (entryCur != null) {
            if (nHash == entryCur.m_nHash && (oKey == null ? entryCur.m_oKey == null : oKey.equals(entryCur.m_oKey))) {
                if (entryPrev == null) {
                    aeBucket[nBucket] = entryCur.m_eNext;
                } else {
                    entryPrev.m_eNext = entryCur.m_eNext;
                }
                --this.m_cEntries;
                return entryCur.getValue();
            }
            entryPrev = entryCur;
            entryCur = entryCur.m_eNext;
        }
        return null;
    }

    public synchronized void clear() {
        this.m_aeBucket = new Entry[DEFAULT_INITIALSIZE];
        this.m_cEntries = 0;
        this.m_cCapacity = (int)((float)DEFAULT_INITIALSIZE * this.m_flLoadFactor);
    }

    public Set entrySet() {
        EntrySet set = this.m_setEntries;
        if (set == null) {
            this.m_setEntries = set = this.instantiateEntrySet();
        }
        return set;
    }

    public Set keySet() {
        KeySet set = this.m_setKeys;
        if (set == null) {
            this.m_setKeys = set = this.instantiateKeySet();
        }
        return set;
    }

    public Collection values() {
        ValuesCollection col = this.m_colValues;
        if (col == null) {
            this.m_colValues = col = this.instantiateValuesCollection();
        }
        return col;
    }

    public synchronized Object clone() {
        try {
            SafeHashMap that = (SafeHashMap)super.clone();
            Entry[] aeBucket = (Entry[])this.m_aeBucket.clone();
            int cBuckets = aeBucket.length;
            for (int i = 0; i < cBuckets; ++i) {
                Entry entryThis = aeBucket[i];
                if (entryThis == null) continue;
                aeBucket[i] = that.cloneEntryList(entryThis);
            }
            that.m_aeBucket = aeBucket;
            that.m_setEntries = null;
            that.m_setKeys = null;
            that.m_colValues = null;
            that.m_oIterActive = null;
            return that;
        }
        catch (CloneNotSupportedException e) {
            throw Base.ensureRuntimeException(e);
        }
    }

    protected Entry cloneEntryList(Entry entryThat) {
        if (entryThat == null) {
            return null;
        }
        Entry entryThis = this.instantiateEntry();
        entryThis.copyFrom(entryThat);
        Entry entryPrevThis = entryThis;
        Entry entryNextThat = entryThat.m_eNext;
        while (entryNextThat != null) {
            Entry entryNextThis = this.instantiateEntry();
            entryNextThis.copyFrom(entryNextThat);
            entryPrevThis.m_eNext = entryNextThis;
            entryPrevThis = entryNextThis;
            entryNextThat = entryNextThat.m_eNext;
        }
        return entryThis;
    }

    private synchronized void writeObject(ObjectOutputStream out) throws IOException {
        Entry[] aeBucket = this.m_aeBucket;
        int cBuckets = aeBucket.length;
        out.writeInt(cBuckets);
        out.writeInt(this.m_cCapacity);
        out.writeFloat(this.m_flLoadFactor);
        out.writeFloat(this.m_flGrowthRate);
        int cEntries = this.m_cEntries;
        int cCheck = 0;
        out.writeInt(cEntries);
        for (int iBucket = 0; iBucket < cBuckets; ++iBucket) {
            Entry entry = aeBucket[iBucket];
            while (entry != null) {
                out.writeObject(entry.m_oKey);
                out.writeObject(entry.m_oValue);
                entry = entry.m_eNext;
                ++cCheck;
            }
        }
        if (cCheck != cEntries) {
            throw new IOException("expected to write " + cEntries + " objects but actually wrote " + cCheck);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        int cEntries;
        this.RESIZING = new Object();
        int cBuckets = in.readInt();
        Entry[] aeBucket = new Entry[cBuckets];
        this.m_aeBucket = aeBucket;
        this.m_cCapacity = in.readInt();
        this.m_flLoadFactor = in.readFloat();
        this.m_flGrowthRate = in.readFloat();
        this.m_cEntries = cEntries = in.readInt();
        for (int i = 0; i < cEntries; ++i) {
            Object oKey = in.readObject();
            Object oValue = in.readObject();
            int nHash = oKey == null ? 0 : oKey.hashCode();
            int nBucket = this.getBucketIndex(nHash, cBuckets);
            Entry entry = this.instantiateEntry();
            entry.m_oKey = oKey;
            entry.m_oValue = oValue;
            entry.m_nHash = nHash;
            entry.m_eNext = aeBucket[nBucket];
            aeBucket[nBucket] = entry;
        }
    }

    protected Entry getEntryInternal(Object oKey) {
        Entry[] aeBucket;
        int nHash = oKey == null ? 0 : oKey.hashCode();
        do {
            aeBucket = this.getStableBucketArray();
            int cBuckets = aeBucket.length;
            int nBucket = this.getBucketIndex(nHash, cBuckets);
            Entry entry = aeBucket[nBucket];
            while (entry != null) {
                if (nHash == entry.m_nHash && (oKey == null ? entry.m_oKey == null : oKey.equals(entry.m_oKey))) {
                    return entry;
                }
                entry = entry.m_eNext;
            }
        } while (aeBucket != this.m_aeBucket);
        return null;
    }

    protected synchronized void removeEntryInternal(Entry entry) {
        if (entry == null) {
            throw new IllegalArgumentException("entry is null");
        }
        Entry[] aeBucket = this.m_aeBucket;
        int nHash = entry.m_nHash;
        int cBuckets = aeBucket.length;
        int nBucket = this.getBucketIndex(nHash, cBuckets);
        Entry entryHead = aeBucket[nBucket];
        if (entry == entryHead) {
            aeBucket[nBucket] = entry.m_eNext;
        } else {
            Entry entryPrev = entryHead;
            while (true) {
                if (entryPrev == null) {
                    return;
                }
                Entry entryCur = entryPrev.m_eNext;
                if (entry == entryCur) {
                    entryPrev.m_eNext = entryCur.m_eNext;
                    break;
                }
                entryPrev = entryCur;
            }
        }
        --this.m_cEntries;
    }

    protected int getBucketIndex(int nHash, int cBuckets) {
        return (int)(((long)nHash & 0xFFFFFFFFL) % (long)cBuckets);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Entry[] getStableBucketArray() {
        Entry[] aeBucket = this.m_aeBucket;
        while (aeBucket.length == 0) {
            Object object = this.RESIZING;
            synchronized (object) {
                if (this.m_aeBucket.length == 0) {
                    try {
                        this.RESIZING.wait(1000L);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        throw new WrapperException(e);
                    }
                }
            }
            aeBucket = this.m_aeBucket;
        }
        return aeBucket;
    }

    protected synchronized void iteratorActivated(Iterator iter) {
        Object oIterActive = this.m_oIterActive;
        if (oIterActive == null) {
            this.m_oIterActive = new WeakReference<Iterator>(iter);
        } else if (oIterActive instanceof WeakReference) {
            Object oPrev = ((WeakReference)oIterActive).get();
            if (oPrev == null) {
                this.m_oIterActive = new WeakReference<Iterator>(iter);
            } else {
                WeakHashMap<Object, Object> map;
                this.m_oIterActive = map = new WeakHashMap<Object, Object>();
                map.put(oPrev, null);
                map.put(iter, null);
            }
        } else {
            ((Map)oIterActive).put(iter, null);
        }
    }

    protected synchronized void iteratorDeactivated(Iterator iter) {
        Object oIterActive = this.m_oIterActive;
        if (oIterActive instanceof WeakReference) {
            if (!$assertionsDisabled && ((WeakReference)oIterActive).get() != iter) {
                throw new AssertionError();
            }
            this.m_oIterActive = null;
        } else {
            ((Map)oIterActive).remove(iter);
        }
    }

    protected synchronized boolean isActiveIterator() {
        Object oIterActive = this.m_oIterActive;
        if (oIterActive == null) {
            return false;
        }
        if (oIterActive instanceof WeakReference) {
            return ((WeakReference)oIterActive).get() != null;
        }
        return !((Map)oIterActive).isEmpty();
    }

    protected Entry instantiateEntry() {
        return new Entry();
    }

    protected EntrySet instantiateEntrySet() {
        return new EntrySet();
    }

    protected KeySet instantiateKeySet() {
        return new KeySet();
    }

    protected ValuesCollection instantiateValuesCollection() {
        return new ValuesCollection();
    }

    static {
        $assertionsDisabled = !SafeHashMap.class.desiredAssertionStatus();
        NO_ENTRIES = new Entry[0];
        PRIME_MODULO = new int[]{17, 31, 47, 61, 79, 103, 127, 149, 173, 197, 229, 277, 347, 397, 457, 509, 587, 641, 701, 761, 827, 883, 953, 1019, 1129, 1279, 1427, 1543, 1733, 1951, 2143, 2371, 2671, 2927, 3253, 3539, 3907, 4211, 4591, 4973, 5393, 5743, 6143, 6619, 6997, 7529, 8009, 8423, 8819, 9311, 9929, 10069, 11087, 12203, 13003, 14051, 15017, 16007, 17027, 18061, 19013, 20063, 23011, 27011, 30011, 35023, 40009, 45007, 50021, 60013, 70001, 80021, 90001, 100003, 120011, 140009, 160001, 180001, 200003, 233021, 266003, 300007, 350003, 400009, 450001, 500009, 550007, 600011, 650011, 700001, 800011, 850009, 900001, 950009, 1000003, 1100009, 1200007, 1300021, 1400017, 1500007, 1600033, 1700021, 1800017, 1900009, 2000003, 2500009, 3000017, 3500017, 4000037, 4500007, 0x4C4B4B, 6000011, 7000003, 8000009, 9000011, 10000019, 0xB71B11, 14000029, 16000057, 18000041, 20000003, 25000009, 30000001, 35000011, 40000003, 45000017, 50000017, 60000011, 70000027, 80000023, 90000049, 100000007, 150000001, 200000033, 300000007, 400000009, 500000003, 600000001, 700000001, 800000011, 900000011, 1000000007, 1100000009, 1200000041, 1300000003, 1400000023, 1500000001, 1600000009, 1700000009, 1800000011, 1900000043, Integer.MAX_VALUE};
        DEFAULT_INITIALSIZE = PRIME_MODULO[0];
        BIGGEST_MODULO = PRIME_MODULO[PRIME_MODULO.length - 1];
    }

    protected class ValuesCollection
    extends AbstractCollection
    implements Serializable {
        protected ValuesCollection() {
        }

        public Iterator iterator() {
            return new Iterator(this){
                private Iterator m_iter;
                private final /* synthetic */ ValuesCollection this$1;
                {
                    this.this$1 = this$1;
                    this.m_iter = ValuesCollection.access$200(this.this$1).entrySet().iterator();
                }

                public boolean hasNext() {
                    return this.m_iter.hasNext();
                }

                public Object next() {
                    return ((Entry)this.m_iter.next()).m_oValue;
                }

                public void remove() {
                    this.m_iter.remove();
                }
            };
        }

        public int size() {
            return SafeHashMap.this.size();
        }

        public void clear() {
            SafeHashMap.this.clear();
        }

        public Object[] toArray() {
            return this.toArray((Object[])null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object[] toArray(Object[] a) {
            SafeHashMap map;
            SafeHashMap safeHashMap = map = SafeHashMap.this;
            synchronized (safeHashMap) {
                int c = map.size();
                if (a == null) {
                    a = new Object[c];
                } else if (a.length < c) {
                    a = (Object[])Array.newInstance(a.getClass().getComponentType(), c);
                } else if (a.length > c) {
                    a[c] = null;
                }
                Entry[] aeBucket = map.m_aeBucket;
                int cBuckets = aeBucket.length;
                int i = 0;
                for (int iBucket = 0; iBucket < cBuckets; ++iBucket) {
                    Entry entry = aeBucket[iBucket];
                    while (entry != null) {
                        a[i++] = entry.m_oValue;
                        entry = entry.m_eNext;
                    }
                }
            }
            return a;
        }

        static /* synthetic */ SafeHashMap access$200(ValuesCollection x0) {
            return x0.SafeHashMap.this;
        }
    }

    protected class KeySet
    extends AbstractSet
    implements Serializable {
        protected KeySet() {
        }

        public Iterator iterator() {
            return new Iterator(this){
                private Iterator m_iter;
                private final /* synthetic */ KeySet this$1;
                {
                    this.this$1 = this$1;
                    this.m_iter = KeySet.access$100(this.this$1).entrySet().iterator();
                }

                public boolean hasNext() {
                    return this.m_iter.hasNext();
                }

                public Object next() {
                    return ((Entry)this.m_iter.next()).m_oKey;
                }

                public void remove() {
                    this.m_iter.remove();
                }
            };
        }

        public int size() {
            return SafeHashMap.this.size();
        }

        public boolean contains(Object oKey) {
            return SafeHashMap.this.containsKey(oKey);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean remove(Object o) {
            SafeHashMap map;
            SafeHashMap safeHashMap = map = SafeHashMap.this;
            synchronized (safeHashMap) {
                if (map.containsKey(o)) {
                    map.remove(o);
                    return true;
                }
                return false;
            }
        }

        public void clear() {
            SafeHashMap.this.clear();
        }

        public Object[] toArray() {
            return this.toArray((Object[])null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object[] toArray(Object[] a) {
            SafeHashMap map;
            SafeHashMap safeHashMap = map = SafeHashMap.this;
            synchronized (safeHashMap) {
                int c = map.size();
                if (a == null) {
                    a = new Object[c];
                } else if (a.length < c) {
                    a = (Object[])Array.newInstance(a.getClass().getComponentType(), c);
                } else if (a.length > c) {
                    a[c] = null;
                }
                Entry[] aeBucket = map.m_aeBucket;
                int cBuckets = aeBucket.length;
                int i = 0;
                for (int iBucket = 0; iBucket < cBuckets; ++iBucket) {
                    Entry entry = aeBucket[iBucket];
                    while (entry != null) {
                        a[i++] = entry.m_oKey;
                        entry = entry.m_eNext;
                    }
                }
            }
            return a;
        }

        static /* synthetic */ SafeHashMap access$100(KeySet x0) {
            return x0.SafeHashMap.this;
        }
    }

    protected class EntrySet
    extends AbstractSet
    implements Serializable {
        protected EntrySet() {
        }

        public Iterator iterator() {
            return SafeHashMap.this.isEmpty() ? NullImplementation.getIterator() : this.instantiateIterator();
        }

        public int size() {
            return SafeHashMap.this.size();
        }

        public boolean contains(Object o) {
            if (o instanceof Map.Entry) {
                Map.Entry thatEntry = (Map.Entry)o;
                Entry thisEntry = SafeHashMap.this.getEntryInternal(thatEntry.getKey());
                return thisEntry != null && ((Object)thisEntry).equals(thatEntry);
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean remove(Object o) {
            SafeHashMap map;
            SafeHashMap safeHashMap = map = SafeHashMap.this;
            synchronized (safeHashMap) {
                if (this.contains(o)) {
                    map.remove(((Map.Entry)o).getKey());
                    return true;
                }
                return false;
            }
        }

        public void clear() {
            SafeHashMap.this.clear();
        }

        public Object[] toArray() {
            return this.toArray((Object[])null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object[] toArray(Object[] a) {
            SafeHashMap map;
            SafeHashMap safeHashMap = map = SafeHashMap.this;
            synchronized (safeHashMap) {
                int c = map.size();
                if (a == null) {
                    a = new Object[c];
                } else if (a.length < c) {
                    a = (Object[])Array.newInstance(a.getClass().getComponentType(), c);
                } else if (a.length > c) {
                    a[c] = null;
                }
                Entry[] aeBucket = map.m_aeBucket;
                int cBuckets = aeBucket.length;
                int i = 0;
                for (int iBucket = 0; iBucket < cBuckets; ++iBucket) {
                    Entry entry = aeBucket[iBucket];
                    while (entry != null) {
                        a[i++] = entry;
                        entry = entry.m_eNext;
                    }
                }
            }
            return a;
        }

        protected Iterator instantiateIterator() {
            return new EntrySetIterator();
        }

        protected class EntrySetIterator
        extends AbstractStableIterator {
            private Entry[] m_aeBucket;
            private int m_iBucket = -1;
            private Entry m_entryPrev;
            private boolean m_fResized;
            private boolean m_fDeactivated;

            protected EntrySetIterator() {
            }

            protected void advance() {
                Entry entryVisible;
                if (this.m_fDeactivated) {
                    return;
                }
                Entry[] aeBucket = this.m_aeBucket;
                if (aeBucket == null) {
                    SafeHashMap map = SafeHashMap.this;
                    map.iteratorActivated(this);
                    aeBucket = this.m_aeBucket = map.getStableBucketArray();
                }
                Entry entry = this.m_entryPrev;
                int iBucket = -1;
                boolean fResized = this.m_fResized;
                do {
                    if (entry != null) {
                        entry = entry.m_eNext;
                    }
                    if (entry == null) {
                        iBucket = this.m_iBucket;
                        int cBuckets = aeBucket.length;
                        do {
                            if (++iBucket < cBuckets) continue;
                            if (!fResized && aeBucket != ((EntrySet)EntrySet.this).SafeHashMap.this.m_aeBucket) break;
                            this.deactivate();
                            return;
                        } while ((entry = aeBucket[iBucket]) == null);
                    }
                    if (fResized || aeBucket == ((EntrySet)EntrySet.this).SafeHashMap.this.m_aeBucket) continue;
                    this.m_fResized = true;
                    if (this.m_entryPrev != null) {
                        SafeHashMap.this.getStableBucketArray();
                        Object oKey = this.m_entryPrev.m_oKey;
                        entry = aeBucket[this.m_iBucket];
                        while (entry != null && entry.m_oKey != oKey) {
                            entry = entry.m_eNext;
                        }
                        if (entry == null) {
                            this.deactivate();
                            throw new ConcurrentModificationException();
                        }
                        this.m_entryPrev = entry;
                    }
                    this.advance();
                    return;
                } while ((entryVisible = fResized ? SafeHashMap.this.getEntryInternal(entry.getKey()) : entry) == null);
                if (iBucket >= 0) {
                    this.m_iBucket = iBucket;
                }
                this.m_entryPrev = entry;
                this.setNext(entryVisible);
            }

            protected void remove(Object oPrev) {
                SafeHashMap.this.remove(((Map.Entry)oPrev).getKey());
            }

            protected void deactivate() {
                if (!this.m_fDeactivated) {
                    SafeHashMap.this.iteratorDeactivated(this);
                    this.m_fDeactivated = true;
                    this.m_aeBucket = null;
                    this.m_entryPrev = null;
                }
            }
        }
    }

    protected static class Entry
    extends Base
    implements Map.Entry,
    Cloneable,
    Serializable {
        protected Object m_oKey;
        protected volatile Object m_oValue;
        protected int m_nHash;
        protected volatile Entry m_eNext;

        protected Entry() {
        }

        public Object getKey() {
            return this.m_oKey;
        }

        public Object getValue() {
            return this.m_oValue;
        }

        public Object setValue(Object value) {
            Object oPrev = this.m_oValue;
            this.m_oValue = value;
            return oPrev;
        }

        public boolean equals(Object o) {
            if (o instanceof Map.Entry) {
                Map.Entry that = (Map.Entry)o;
                if (this == that) {
                    return true;
                }
                Object oThisKey = this.m_oKey;
                Object oThatKey = that.getKey();
                Object oThisValue = this.m_oValue;
                Object oThatValue = that.getValue();
                return (oThisKey == null ? oThatKey == null : oThisKey.equals(oThatKey)) && (oThisValue == null ? oThatValue == null : oThisValue.equals(oThatValue));
            }
            return false;
        }

        public int hashCode() {
            Object oKey = this.m_oKey;
            Object oValue = this.m_oValue;
            return (oKey == null ? 0 : this.m_nHash) ^ (oValue == null ? 0 : oValue.hashCode());
        }

        public String toString() {
            return "key=\"" + this.getKey() + '\"' + ", value=\"" + this.getValue() + '\"';
        }

        public Object clone() {
            try {
                Entry that = (Entry)super.clone();
                that.m_eNext = null;
                return that;
            }
            catch (CloneNotSupportedException e) {
                throw Entry.ensureRuntimeException(e);
            }
        }

        protected void copyFrom(Entry entry) {
            this.m_oKey = entry.m_oKey;
            this.m_oValue = entry.m_oValue;
            this.m_nHash = entry.m_nHash;
        }

        protected void onAdd() {
        }
    }
}

