/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.util;

import com.tangosol.util.AbstractLongArray;
import com.tangosol.util.LongArray;
import java.io.Serializable;
import java.util.ConcurrentModificationException;
import java.util.NoSuchElementException;

public class SimpleLongArray
extends AbstractLongArray
implements Serializable {
    public static final long MAX = Integer.MAX_VALUE;
    public static final Object[] EMPTY = new Object[0];
    Object[] m_ao;
    int m_iFirst;
    int m_iLast;
    int m_cItems;

    public SimpleLongArray() {
        this.clear();
    }

    public Object get(long lIndex) {
        if (lIndex < 0L || lIndex > Integer.MAX_VALUE) {
            throw new IndexOutOfBoundsException("illegal index: " + lIndex);
        }
        int i = (int)lIndex;
        if (i < this.m_iFirst || i > this.m_iLast) {
            return null;
        }
        return this.m_ao[i];
    }

    public Object set(long lIndex, Object oValue) {
        if (oValue == null) {
            return this.remove(lIndex);
        }
        if (lIndex < 0L || lIndex > Integer.MAX_VALUE) {
            throw new IndexOutOfBoundsException("illegal index: " + lIndex);
        }
        int iFirst = this.m_iFirst;
        int iLast = this.m_iLast;
        int cItems = this.m_cItems;
        int i = (int)lIndex;
        Object[] ao = this.m_ao;
        int co = ao.length;
        if (i >= co) {
            int coNew = Math.max((i >>> 5) + 1 << 5, co + (co >>> 2));
            Object[] aoNew = new Object[coNew];
            if (cItems > 0) {
                System.arraycopy(ao, iFirst, aoNew, iFirst, iLast - iFirst + 1);
            }
            ao = aoNew;
            this.m_ao = aoNew;
        }
        Object oOrig = ao[i];
        ao[i] = oValue;
        if (oOrig == null) {
            if (cItems == 0) {
                this.m_iFirst = i;
                this.m_iLast = i;
                this.m_cItems = 1;
            } else {
                if (i < iFirst) {
                    this.m_iFirst = i;
                } else if (i > iLast) {
                    this.m_iLast = i;
                }
                this.m_cItems = cItems + 1;
            }
        }
        return oOrig;
    }

    public long add(Object oValue) {
        int i = this.m_iLast + 1;
        this.set(i, oValue);
        return i;
    }

    public boolean exists(long lIndex) {
        int i;
        if (lIndex >= 0L && lIndex < Integer.MAX_VALUE && (i = (int)lIndex) >= this.m_iFirst && i <= this.m_iLast) {
            return this.m_ao[i] != null;
        }
        return false;
    }

    public Object remove(long lIndex) {
        if (lIndex < 0L || lIndex > Integer.MAX_VALUE) {
            throw new IndexOutOfBoundsException("illegal index: " + lIndex);
        }
        int iFirst = this.m_iFirst;
        int iLast = this.m_iLast;
        int i = (int)lIndex;
        if (i < iFirst || i > iLast) {
            return null;
        }
        Object[] ao = this.m_ao;
        Object oOrig = ao[i];
        if (oOrig == null) {
            return null;
        }
        int cItems = this.m_cItems;
        if (cItems == 1) {
            this.clear();
        } else {
            ao[i] = null;
            this.m_cItems = cItems - 1;
            if (i == iFirst) {
                while (ao[++iFirst] == null) {
                }
                this.m_iFirst = iFirst;
            } else if (i == iLast) {
                while (ao[--iLast] == null) {
                }
                this.m_iLast = iLast;
            }
        }
        return oOrig;
    }

    public boolean contains(Object oValue) {
        if (oValue == null) {
            return false;
        }
        int iFirst = this.m_iFirst;
        int iLast = this.m_iLast;
        if (iFirst < 0) {
            return false;
        }
        Object[] ao = this.m_ao;
        for (int i = iFirst; i <= iLast; ++i) {
            Object oElement = ao[i];
            if (oElement == null || !oValue.equals(oElement)) continue;
            return true;
        }
        return false;
    }

    public void clear() {
        this.m_ao = EMPTY;
        this.m_iFirst = -1;
        this.m_iLast = -1;
        this.m_cItems = 0;
    }

    public boolean isEmpty() {
        return this.m_cItems == 0;
    }

    public int getSize() {
        return this.m_cItems;
    }

    public LongArray.Iterator iterator() {
        return new Iterator(Math.max(0, this.m_iFirst));
    }

    public LongArray.Iterator iterator(long lIndex) {
        if (lIndex < 0L || lIndex > Integer.MAX_VALUE) {
            throw new IndexOutOfBoundsException("illegal index: " + lIndex);
        }
        return new Iterator((int)lIndex);
    }

    public long getFirstIndex() {
        return this.m_iFirst;
    }

    public long getLastIndex() {
        return this.m_iLast;
    }

    public Object clone() {
        SimpleLongArray that = (SimpleLongArray)super.clone();
        Object[] ao = that.m_ao;
        if (ao != null && ao.length != 0) {
            that.m_ao = (Object[])ao.clone();
        }
        return that;
    }

    public class Iterator
    implements LongArray.Iterator {
        private int m_iNext;
        private int m_iPrev;

        public Iterator(int iNext) {
            this.m_iNext = iNext;
            this.m_iPrev = -1;
            if (!SimpleLongArray.this.exists(iNext)) {
                this.scanNext();
            }
        }

        public boolean hasNext() {
            return this.m_iNext <= SimpleLongArray.this.m_iLast;
        }

        public Object next() {
            int i = this.m_iNext;
            if (i > SimpleLongArray.this.m_iLast) {
                throw new NoSuchElementException();
            }
            Object o = SimpleLongArray.this.get(i);
            if (o == null) {
                throw new ConcurrentModificationException();
            }
            this.m_iPrev = i;
            this.scanNext();
            return o;
        }

        public long getIndex() {
            int i = this.m_iPrev;
            if (i < 0) {
                throw new IllegalStateException();
            }
            return i;
        }

        public Object getValue() {
            return SimpleLongArray.this.get(this.getIndex());
        }

        public Object setValue(Object oValue) {
            Object oOrig = SimpleLongArray.this.set(this.getIndex(), oValue);
            if (oValue == null) {
                this.m_iPrev = -1;
            }
            return oOrig;
        }

        public void remove() {
            SimpleLongArray.this.remove(this.getIndex());
            this.m_iPrev = -1;
        }

        private void scanNext() {
            int i;
            Object[] ao = SimpleLongArray.this.m_ao;
            int iLast = SimpleLongArray.this.m_iLast;
            for (i = this.m_iNext + 1; i <= iLast && ao[i] == null; ++i) {
            }
            this.m_iNext = i;
        }
    }
}

