/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.util;

import com.tangosol.util.AbstractLongArray;
import com.tangosol.util.Base;
import com.tangosol.util.LongArray;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.NoSuchElementException;

public class SparseArray
extends AbstractLongArray
implements LongArray {
    protected static final Node NIL = Node.NIL;
    protected Node head = NIL;
    protected int size = 0;

    public Object get(long lIndex) {
        Node node = this.find(lIndex);
        return node == null ? null : node.value;
    }

    public Object set(long lIndex, Object oValue) {
        if (this.size == 0) {
            this.head = new Node();
            this.head.key = lIndex;
            this.head.value = oValue;
            this.size = 1;
            return null;
        }
        Node parent = NIL;
        Node child = this.head;
        Node target = null;
        Object oOrig = null;
        while (child != NIL) {
            if (target == null && lIndex == child.key) {
                target = child;
            }
            if (child.left.red && child.right.red) {
                child.red = true;
                child.left.red = false;
                child.right.red = false;
                if (parent.red) {
                    this.balance(child);
                }
            }
            parent = child;
            if (target != null || lIndex < child.key) {
                child = child.left;
                continue;
            }
            child = child.right;
        }
        if (target == null) {
            child = new Node();
            child.key = lIndex;
            child.value = oValue;
            child.parent = parent;
            child.red = true;
            ++this.size;
            if (lIndex < parent.key) {
                parent.left = child;
            } else {
                parent.right = child;
            }
            if (parent.red) {
                this.balance(child);
            }
        } else {
            oOrig = target.value;
            target.value = oValue;
        }
        this.head.red = false;
        return oOrig;
    }

    public boolean exists(long lIndex) {
        return this.find(lIndex) != null;
    }

    public Object remove(long lIndex) {
        Node grand = NIL;
        Node parent = NIL;
        Node child = this.head;
        Node sibling = null;
        Node left = null;
        Node right = null;
        Node foster = null;
        Node target = null;
        Node adoptee = null;
        Object value = null;
        while (child != NIL) {
            if (target == null && lIndex == child.key) {
                target = child;
            }
            grand = parent;
            parent = child;
            if (lIndex < parent.key) {
                sibling = parent.right;
                child = parent.left;
            } else {
                sibling = parent.left;
                child = parent.right;
            }
            left = sibling.left;
            right = sibling.right;
            if (!child.red && sibling.red) {
                if (grand == NIL) {
                    this.head = sibling;
                } else if (grand.left == parent) {
                    grand.left = sibling;
                } else {
                    grand.right = sibling;
                }
                sibling.parent = grand;
                if (parent.left == child) {
                    parent.right = left;
                    if (left != NIL) {
                        left.parent = parent;
                    }
                    sibling.left = parent;
                    parent.parent = sibling;
                    grand = sibling;
                    sibling = left;
                } else {
                    parent.left = right;
                    if (right != NIL) {
                        right.parent = parent;
                    }
                    sibling.right = parent;
                    parent.parent = sibling;
                    grand = sibling;
                    sibling = right;
                }
                left = sibling.left;
                right = sibling.right;
                parent.red = true;
                grand.red = false;
            }
            if (child == NIL || child.red || child.left.red || child.right.red) continue;
            if (!(sibling == NIL || sibling.red || sibling.left.red || sibling.right.red)) {
                parent.red = false;
                child.red = true;
                sibling.red = true;
                continue;
            }
            if (left.red) {
                if (parent.left == child) {
                    left.red = parent.red;
                    parent.red = false;
                    child.red = true;
                    if (grand == NIL) {
                        this.head = left;
                    } else if (grand.left == parent) {
                        grand.left = left;
                    } else {
                        grand.right = left;
                    }
                    left.parent = grand;
                    parent.right = adoptee = left.left;
                    if (adoptee != NIL) {
                        adoptee.parent = parent;
                    }
                    left.left = parent;
                    parent.parent = left;
                    sibling.left = adoptee = left.right;
                    if (adoptee != NIL) {
                        adoptee.parent = sibling;
                    }
                    left.right = sibling;
                    sibling.parent = left;
                    grand = left;
                    continue;
                }
                sibling.red = parent.red;
                left.red = false;
                parent.red = false;
                child.red = true;
                if (grand == NIL) {
                    this.head = sibling;
                } else if (grand.left == parent) {
                    grand.left = sibling;
                } else {
                    grand.right = sibling;
                }
                sibling.parent = grand;
                parent.left = right;
                if (right != NIL) {
                    right.parent = parent;
                }
                sibling.right = parent;
                parent.parent = sibling;
                grand = sibling;
                continue;
            }
            if (!right.red) continue;
            if (parent.left == child) {
                sibling.red = parent.red;
                right.red = false;
                parent.red = false;
                child.red = true;
                if (grand == NIL) {
                    this.head = sibling;
                } else if (grand.left == parent) {
                    grand.left = sibling;
                } else {
                    grand.right = sibling;
                }
                sibling.parent = grand;
                parent.right = left;
                if (left != NIL) {
                    left.parent = parent;
                }
                sibling.left = parent;
                parent.parent = sibling;
                grand = sibling;
                continue;
            }
            right.red = parent.red;
            parent.red = false;
            child.red = true;
            if (grand == NIL) {
                this.head = right;
            } else if (grand.left == parent) {
                grand.left = right;
            } else {
                grand.right = right;
            }
            right.parent = grand;
            parent.left = adoptee = right.right;
            if (adoptee != NIL) {
                adoptee.parent = parent;
            }
            right.right = parent;
            parent.parent = right;
            sibling.right = adoptee = right.left;
            if (adoptee != NIL) {
                adoptee.parent = sibling;
            }
            right.left = sibling;
            sibling.parent = right;
            grand = right;
        }
        if (target != null) {
            child = parent;
            parent = child.parent;
            foster = target.parent;
            if (target == child || target.left == NIL || target.right == NIL) {
                child = target.left != NIL ? target.left : target.right;
            } else {
                if (target != parent) {
                    parent.left = adoptee = child.right;
                    if (adoptee != NIL) {
                        adoptee.parent = parent;
                    }
                    child.right = adoptee = target.right;
                    if (adoptee != NIL) {
                        adoptee.parent = child;
                    }
                }
                child.left = adoptee = target.left;
                if (adoptee != NIL) {
                    adoptee.parent = child;
                }
            }
            if (child != NIL) {
                child.red = target.red;
            }
            if (foster == NIL) {
                this.head = child;
                child.parent = NIL;
            } else {
                if (foster.left == target) {
                    foster.left = child;
                } else {
                    foster.right = child;
                }
                if (child != NIL) {
                    child.parent = foster;
                }
            }
            value = target.value;
            --this.size;
        }
        this.head.red = false;
        return value;
    }

    public void clear() {
        this.head = NIL;
        this.size = 0;
    }

    public int getSize() {
        return this.size;
    }

    public LongArray.Iterator iterator() {
        return new Crawler(this.head);
    }

    public LongArray.Iterator iterator(long lIndex) {
        Node closest = NIL;
        Node current = this.head;
        while (current != NIL) {
            long lCurrent = current.key;
            if (lIndex < lCurrent) {
                closest = current;
                current = current.left;
                continue;
            }
            if (lIndex > lCurrent) {
                current = current.right;
                continue;
            }
            return new Crawler(current, 1);
        }
        return new Crawler(closest, 1);
    }

    public long getFirstIndex() {
        Node nodeCur = this.head;
        if (nodeCur == NIL) {
            return -1L;
        }
        Node nodeNext = nodeCur.left;
        while (nodeNext != NIL) {
            nodeCur = nodeNext;
            nodeNext = nodeCur.left;
        }
        return nodeCur.key;
    }

    public long getLastIndex() {
        Node nodeCur = this.head;
        if (nodeCur == NIL) {
            return -1L;
        }
        Node nodeNext = nodeCur.right;
        while (nodeNext != NIL) {
            nodeCur = nodeNext;
            nodeNext = nodeCur.right;
        }
        return nodeCur.key;
    }

    public Object clone() {
        SparseArray that = (SparseArray)super.clone();
        that.head = (Node)this.head.clone();
        return that;
    }

    public void print() {
        this.head.print();
    }

    protected Node find(long lIndex) {
        Node current = this.head;
        while (current != NIL) {
            long lCurrent = current.key;
            if (lIndex < lCurrent) {
                current = current.left;
                continue;
            }
            if (lIndex > lCurrent) {
                current = current.right;
                continue;
            }
            return current;
        }
        return null;
    }

    protected void balance(Node child) {
        Node parent = child.parent;
        Node grand = parent.parent;
        Node great = grand.parent;
        Node newgrand = null;
        Node adoptee = null;
        if (parent == grand.left) {
            if (child == parent.left) {
                newgrand = parent;
                grand.left = adoptee = parent.right;
                if (adoptee != NIL) {
                    adoptee.parent = grand;
                }
                parent.right = grand;
                grand.parent = parent;
            } else {
                newgrand = child;
                parent.right = adoptee = child.left;
                if (adoptee != NIL) {
                    adoptee.parent = parent;
                }
                grand.left = adoptee = child.right;
                if (adoptee != NIL) {
                    adoptee.parent = grand;
                }
                child.left = parent;
                child.right = grand;
                parent.parent = child;
                grand.parent = child;
            }
        } else if (child == parent.right) {
            newgrand = parent;
            grand.right = adoptee = parent.left;
            if (adoptee != NIL) {
                adoptee.parent = grand;
            }
            parent.left = grand;
            grand.parent = parent;
        } else {
            newgrand = child;
            grand.right = adoptee = child.left;
            if (adoptee != NIL) {
                adoptee.parent = grand;
            }
            parent.left = adoptee = child.right;
            if (adoptee != NIL) {
                adoptee.parent = parent;
            }
            child.left = grand;
            child.right = parent;
            grand.parent = child;
            parent.parent = child;
        }
        newgrand.red = false;
        grand.red = true;
        if (great == NIL) {
            this.head = newgrand;
            newgrand.parent = NIL;
        } else {
            if (grand == great.left) {
                great.left = newgrand;
            } else {
                great.right = newgrand;
            }
            newgrand.parent = great;
        }
    }

    protected class Crawler
    implements LongArray.Iterator,
    Cloneable {
        protected static final int ABOVE = 0;
        protected static final int LEFT = 1;
        protected static final int SITTING = 2;
        protected static final int RIGHT = 3;
        protected Node current;
        protected int fromdir;
        protected final transient Node NIL = Node.NIL;

        protected Crawler(Node head) {
            this.current = head;
            this.fromdir = 0;
        }

        protected Crawler(Node head, int fromdir) {
            this.current = head;
            this.fromdir = fromdir;
        }

        public boolean hasNext() {
            if (this.current == this.NIL) {
                return false;
            }
            block6: while (true) {
                switch (this.fromdir) {
                    case 0: {
                        if (this.current.left != this.NIL) {
                            this.current = this.current.left;
                            continue block6;
                        }
                        this.fromdir = 1;
                    }
                    case 1: {
                        return true;
                    }
                    case 2: {
                        if (this.current.right != this.NIL) {
                            this.fromdir = 0;
                            this.current = this.current.right;
                            continue block6;
                        }
                    }
                    case 3: {
                        if (this.current.parent != this.NIL) {
                            this.fromdir = this.current == this.current.parent.left ? 1 : 3;
                            this.current = this.current.parent;
                            continue block6;
                        }
                        this.current = this.NIL;
                        return false;
                    }
                }
                break;
            }
            throw new IllegalStateException("invalid direction: " + this.fromdir);
        }

        public Object next() {
            if (this.current == this.NIL) {
                throw new NoSuchElementException();
            }
            block6: while (true) {
                switch (this.fromdir) {
                    case 0: {
                        if (this.current.left != this.NIL) {
                            this.current = this.current.left;
                            continue block6;
                        }
                    }
                    case 1: {
                        this.fromdir = 2;
                        return this.current.value;
                    }
                    case 2: {
                        if (this.current.right != this.NIL) {
                            this.fromdir = 0;
                            this.current = this.current.right;
                            continue block6;
                        }
                    }
                    case 3: {
                        if (this.current.parent != this.NIL) {
                            this.fromdir = this.current == this.current.parent.left ? 1 : 3;
                            this.current = this.current.parent;
                            continue block6;
                        }
                        this.current = this.NIL;
                        throw new NoSuchElementException();
                    }
                }
                break;
            }
            throw new IllegalStateException("invalid direction: " + this.fromdir);
        }

        public long getIndex() {
            if (this.current == this.NIL || this.fromdir != 2) {
                throw new IllegalStateException();
            }
            return this.current.key;
        }

        public Object getValue() {
            if (this.current == this.NIL || this.fromdir != 2) {
                throw new IllegalStateException();
            }
            return this.current.value;
        }

        public Object setValue(Object oValue) {
            if (this.current == this.NIL || this.fromdir != 2) {
                throw new IllegalStateException();
            }
            Object oOrig = this.current.value;
            this.current.value = oValue;
            return oOrig;
        }

        public void remove() {
            long lRemove = this.getIndex();
            if (this.hasNext()) {
                this.next();
                SparseArray.this.remove(lRemove);
                this.fromdir = 1;
            } else {
                SparseArray.this.remove(lRemove);
            }
        }

        public String toString() {
            String key = String.valueOf(this.current.key);
            switch (this.fromdir) {
                case 0: {
                    return "just crawled into " + key;
                }
                case 1: {
                    return "just returned to " + key + " from the left child";
                }
                case 2: {
                    return "just sitting in " + key;
                }
                case 3: {
                    return "just returned to " + key + " from the right child";
                }
            }
            throw new IllegalStateException("invalid direction: " + this.fromdir);
        }

        public Object clone() {
            try {
                return super.clone();
            }
            catch (Exception e) {
                throw Base.ensureRuntimeException(e);
            }
        }
    }

    protected static class Node
    implements Cloneable,
    Serializable {
        protected static final Node NIL;
        protected long key;
        protected Object value;
        protected Node parent = NIL;
        protected Node left = NIL;
        protected Node right = NIL;
        protected boolean red;

        protected Node() {
        }

        public String toString() {
            if (this == NIL) {
                return "";
            }
            return (this.left != NIL ? this.left.toString() + ',' : "") + this.key + (this.right != NIL ? ',' + this.right.toString() : "");
        }

        public boolean equals(Object obj) {
            if (obj instanceof Node) {
                Node that = (Node)obj;
                if (this.key == that.key) {
                    return this.value == null ? that.value == null : this.value.equals(that.value);
                }
            }
            return false;
        }

        public Object clone() {
            Node right;
            if (this == NIL) {
                return this;
            }
            Node that = new Node();
            that.key = this.key;
            that.value = this.value;
            that.red = this.red;
            Node left = this.left;
            if (left != NIL) {
                that.left = left = (Node)left.clone();
                left.parent = that;
            }
            if ((right = this.right) != NIL) {
                that.right = right = (Node)right.clone();
                right.parent = that;
            }
            return that;
        }

        private void writeObject(ObjectOutputStream out) throws IOException {
            out.writeLong(this.key);
            out.writeObject(this.value);
            boolean fLeft = this.left != NIL;
            out.writeBoolean(fLeft);
            if (fLeft) {
                out.writeObject(this.left);
            }
            boolean fRight = this.right != NIL;
            out.writeBoolean(fRight);
            if (fRight) {
                out.writeObject(this.right);
            }
            out.writeBoolean(this.red);
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            this.key = in.readLong();
            this.value = in.readObject();
            this.parent = NIL;
            this.left = NIL;
            if (in.readBoolean()) {
                this.left = (Node)in.readObject();
                this.left.parent = this;
            }
            this.right = NIL;
            if (in.readBoolean()) {
                this.right = (Node)in.readObject();
                this.right.parent = this;
            }
            this.red = in.readBoolean();
        }

        protected boolean isLeaf() {
            return this.left == NIL || this.right == NIL;
        }

        protected int getDepth() {
            return (this.red ? 0 : 1) + (this.parent == NIL ? 0 : this.parent.getDepth());
        }

        protected void print() {
            if (this.left != NIL) {
                this.left.print();
            }
            if (this != NIL) {
                Base.out(String.valueOf(this.key));
            }
            if (this.right != NIL) {
                this.right.print();
            }
        }

        static {
            Node.NIL.parent = NIL = new Node();
            Node.NIL.left = NIL;
            Node.NIL.right = NIL;
        }
    }
}

