/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.util;

import com.tangosol.util.NullImplementation;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;

public class SubSet
extends AbstractSet
implements Cloneable,
Serializable {
    private static final Set EMPTY_SET = NullImplementation.getSet();
    private static final Iterator EMPTY_ITERATOR = NullImplementation.getIterator();
    private static final Object[] EMPTY_ARRAY = new Object[0];
    private Set m_setOrig;
    private Set m_setMod;
    private boolean m_fRetained;

    public SubSet(Set set) {
        this.m_setOrig = set;
        this.reset();
    }

    public Set getOriginal() {
        return this.m_setOrig;
    }

    public boolean isModified() {
        Set setMod = this.m_setMod;
        return this.m_fRetained ? setMod == null || setMod.size() != this.m_setOrig.size() : setMod != null && !setMod.isEmpty();
    }

    public boolean isTrackingRetained() {
        return this.m_fRetained;
    }

    public Set getRetained() {
        Set setMod = this.m_setMod;
        if (this.m_fRetained) {
            return setMod == null ? EMPTY_SET : setMod;
        }
        if (setMod == null || setMod.isEmpty()) {
            return this.m_setOrig;
        }
        Set setOrig = this.m_setOrig;
        if (setMod.size() == setOrig.size()) {
            return EMPTY_SET;
        }
        HashSet setRemain = new HashSet(setOrig);
        setRemain.removeAll(setMod);
        return setRemain;
    }

    public boolean isTrackingRemoved() {
        return !this.m_fRetained;
    }

    public Set getRemoved() {
        Set setMod = this.m_setMod;
        if (this.m_fRetained) {
            if (setMod == null || setMod.isEmpty()) {
                return this.m_setOrig;
            }
            Set setOrig = this.m_setOrig;
            if (setMod.size() == setOrig.size()) {
                return EMPTY_SET;
            }
            HashSet setRemove = new HashSet(setOrig);
            setRemove.retainAll(setMod);
            return setRemove;
        }
        return setMod == null ? EMPTY_SET : setMod;
    }

    protected Set ensureRetained() {
        HashSet setMod = this.m_setMod;
        if (this.m_fRetained) {
            if (setMod == null) {
                this.m_setMod = setMod = new HashSet();
            }
        } else {
            Set setOrig = this.m_setOrig;
            HashSet setRemoved = setMod;
            setMod = new HashSet();
            this.m_setMod = setMod;
            this.m_fRetained = true;
            if (setRemoved == null || setRemoved.isEmpty()) {
                setMod.addAll(setOrig);
            } else {
                int cRemoved;
                int cOrig = setOrig.size();
                if (cOrig != (cRemoved = setRemoved.size())) {
                    if (cRemoved << 2 > cOrig) {
                        Iterator iter = setOrig.iterator();
                        while (iter.hasNext()) {
                            Object o = iter.next();
                            if (setRemoved.contains(o)) continue;
                            setMod.add(o);
                        }
                    } else {
                        setMod.addAll(setOrig);
                        setMod.removeAll(setRemoved);
                    }
                }
            }
        }
        return setMod;
    }

    protected Set ensureRemoved() {
        HashSet setMod = this.m_setMod;
        if (this.m_fRetained) {
            Set setOrig = this.m_setOrig;
            HashSet setRetained = setMod;
            setMod = new HashSet();
            this.m_setMod = setMod;
            this.m_fRetained = false;
            if (setRetained == null || setRetained.isEmpty()) {
                setMod.addAll(setOrig);
            } else {
                int cRetained;
                int cOrig = setOrig.size();
                if (cOrig != (cRetained = setRetained.size())) {
                    if (cRetained << 2 > cOrig) {
                        Iterator iter = setOrig.iterator();
                        while (iter.hasNext()) {
                            Object o = iter.next();
                            if (setRetained.contains(o)) continue;
                            setMod.add(o);
                        }
                    } else {
                        setMod.addAll(setOrig);
                        setMod.removeAll(setRetained);
                    }
                }
            }
        } else if (setMod == null) {
            this.m_setMod = setMod = new HashSet();
        }
        return setMod;
    }

    public void resolve() {
        if (this.isModified()) {
            Set setMod = this.m_setMod;
            Set setOrig = this.m_setOrig;
            if (this.m_fRetained) {
                if (setMod == null || setMod.isEmpty()) {
                    setOrig.clear();
                } else {
                    setOrig.retainAll(setMod);
                }
            } else if (setMod != null && !setMod.isEmpty()) {
                setOrig.removeAll(setMod);
            }
        }
        this.reset();
    }

    public void reset() {
        this.m_setMod = null;
        this.m_fRetained = false;
    }

    public Iterator iterator() {
        return this.isEmpty() ? EMPTY_ITERATOR : new SubSetIterator();
    }

    public boolean isEmpty() {
        Set setMod = this.m_setMod;
        Set setOrig = this.m_setOrig;
        if (setOrig.isEmpty()) {
            return true;
        }
        if (this.m_fRetained) {
            return setMod == null || setMod.isEmpty();
        }
        if (setMod == null || setMod.isEmpty()) {
            return false;
        }
        return setMod.size() == setOrig.size();
    }

    public int size() {
        Set setMod = this.m_setMod;
        if (this.m_fRetained) {
            return setMod == null ? 0 : setMod.size();
        }
        return this.m_setOrig.size() - (setMod == null ? 0 : setMod.size());
    }

    public boolean contains(Object o) {
        Set setMod = this.m_setMod;
        if (this.m_fRetained) {
            return setMod != null && setMod.contains(o);
        }
        return (setMod == null || !setMod.contains(o)) && this.m_setOrig.contains(o);
    }

    public boolean containsAll(Collection col) {
        Collection colSmaller;
        Collection colLarger;
        Set setMod = this.m_setMod;
        if (this.m_fRetained) {
            return setMod != null && setMod.containsAll(col);
        }
        if (col.size() > setMod.size()) {
            colLarger = col;
            colSmaller = setMod;
        } else {
            colLarger = setMod;
            colSmaller = col;
        }
        Iterator iter = colSmaller.iterator();
        while (iter.hasNext()) {
            if (!colLarger.contains(iter.next())) continue;
            return false;
        }
        return this.m_setOrig.containsAll(col);
    }

    public boolean add(Object o) {
        if (!this.m_setOrig.contains(o)) {
            throw new UnsupportedOperationException("attempt to add an item to the SubSet that was not in the original set; item=\"" + o + "\"");
        }
        if (this.m_fRetained) {
            return this.ensureRetained().add(o);
        }
        return this.ensureRemoved().remove(o);
    }

    public boolean addAll(Collection col) {
        if (!this.m_setOrig.containsAll(col)) {
            throw new UnsupportedOperationException("attempt to add items to the SubSet that were not in the original set; item collection=\"" + col + "\"");
        }
        if (this.m_fRetained) {
            return this.ensureRetained().addAll(col);
        }
        return this.ensureRemoved().removeAll(col);
    }

    public boolean remove(Object o) {
        if (this.m_fRetained) {
            Set setMod = this.m_setMod;
            return setMod == null ? false : setMod.remove(o);
        }
        return this.m_setOrig.contains(o) ? this.ensureRemoved().add(o) : false;
    }

    public boolean removeAll(Collection col) {
        Set setMod = this.m_setMod;
        if (this.m_fRetained) {
            return setMod == null || setMod.isEmpty() ? false : setMod.removeAll(col);
        }
        Set setOrig = this.m_setOrig;
        int cOrig = setOrig.size();
        int cRemoved = setMod == null ? 0 : setMod.size();
        int cRemove = col.size();
        if (cRemove == 0) {
            return false;
        }
        if (cOrig > 64 && cRemove + cRemoved > cOrig >>> 2) {
            return this.ensureRetained().removeAll(col);
        }
        setMod = this.ensureRemoved();
        boolean fMod = false;
        Iterator iter = col.iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (setMod.contains(o) || !setOrig.contains(o)) continue;
            setMod.add(o);
            fMod = true;
        }
        return fMod;
    }

    public boolean retainAll(Collection col) {
        HashSet setMod;
        if (this.m_fRetained) {
            return this.ensureRetained().retainAll(col);
        }
        Set setOrig = this.m_setOrig;
        Set setRemoved = this.m_setMod;
        this.m_setMod = setMod = new HashSet();
        this.m_fRetained = true;
        if (setRemoved == null || setRemoved.isEmpty()) {
            Iterator iter = col.iterator();
            while (iter.hasNext()) {
                Object o = iter.next();
                if (!setOrig.contains(o)) continue;
                setMod.add(o);
            }
            return setMod.size() != setOrig.size();
        }
        boolean fMod = false;
        Iterator iter = col.iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (setRemoved.contains(o) || !setOrig.contains(o)) continue;
            setMod.add(o);
            fMod = true;
        }
        return fMod;
    }

    public void clear() {
        this.m_fRetained = true;
        this.m_setMod = null;
    }

    public Object[] toArray() {
        Set setMod = this.m_setMod;
        if (this.m_fRetained) {
            return setMod == null || setMod.isEmpty() ? EMPTY_ARRAY : setMod.toArray();
        }
        Set setOrig = this.m_setOrig;
        if (setMod == null || setMod.isEmpty()) {
            return setOrig.toArray();
        }
        int i = 0;
        int c = setOrig.size() - setMod.size();
        Object[] ao = new Object[c];
        Iterator iter = setOrig.iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (setMod.contains(o)) continue;
            ao[i++] = o;
        }
        if (i != c) {
            throw new ConcurrentModificationException("while assembling the array of objects in the SubSet, " + i + " objects were determined to be in the SubSet, but " + c + " objects were expected.");
        }
        return ao;
    }

    public Object[] toArray(Object[] ao) {
        int c = ao.length;
        Object[] aoActual = this.toArray();
        int cActual = aoActual.length;
        if (c < cActual) {
            ao = (Object[])Array.newInstance(ao.getClass().getComponentType(), cActual);
        } else if (c > cActual) {
            ao[cActual] = null;
        }
        System.arraycopy(aoActual, 0, ao, 0, cActual);
        return ao;
    }

    public Object clone() {
        SubSet dset;
        try {
            dset = (SubSet)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException();
        }
        Set setMod = dset.m_setMod;
        if (setMod != null) {
            dset.m_setMod = (Set)((HashSet)setMod).clone();
        }
        return dset;
    }

    protected class SubSetIterator
    implements Iterator {
        private Object[] m_aObject;
        private int m_index = 0;
        private boolean m_fRemovable = false;

        protected SubSetIterator() {
            this.m_aObject = SubSet.this.toArray();
        }

        public boolean hasNext() {
            return this.m_index < this.m_aObject.length;
        }

        public Object next() {
            if (this.m_index < this.m_aObject.length) {
                this.m_fRemovable = true;
                return this.m_aObject[this.m_index++];
            }
            this.m_fRemovable = false;
            throw new NoSuchElementException();
        }

        public void remove() {
            if (!this.m_fRemovable) {
                throw new IllegalStateException();
            }
            this.m_fRemovable = false;
            SubSet.this.remove(this.m_aObject[this.m_index - 1]);
        }
    }
}

