/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.util;

import com.tangosol.util.AtomicCounter;
import com.tangosol.util.Base;
import com.tangosol.util.WrapperException;

public class ThreadGate
extends Base {
    public static final int GATE_OPEN = 0;
    public static final int GATE_CLOSING = 1;
    public static final int GATE_CLOSED = 2;
    public static final int GATE_DESTROYED = 3;
    private static final int STATUS_OFFSET = 60;
    private static final long ACTIVE_COUNT_MASK = 0xFFFFFFFFFFFFFFFL;
    private static final long EMPTY_GATE_OPEN = 0L;
    private static final long EMPTY_GATE_CLOSING = 0x1000000000000000L;
    private static final long EMPTY_GATE_CLOSED = 0x2000000000000000L;
    private AtomicCounter m_atomicState = AtomicCounter.newAtomicCounter();
    private int m_cClose;
    private volatile transient Thread m_threadClosing;
    private volatile long m_cVersion;
    private ThreadLocalCounter m_tlcEnters = new ThreadLocalCounter();
    private ThreadLocalCounter m_tlcVersion = new ThreadLocalCounter();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean barEntry(long cMillis) {
        Thread thread = Thread.currentThread();
        if (this.getClosingThread() == thread) {
            this.setCloseCount(this.getCloseCount() + 1);
            return true;
        }
        ThreadGate threadGate = this;
        synchronized (threadGate) {
            do {
                if (this.getClosingThread() != null) continue;
                if (this.updateStatus(1) == 3) {
                    this.updateStatus(3);
                    throw new IllegalStateException("ThreadGate.close: ThreadGate has been destroyed.");
                }
                this.setClosingThread(thread);
                this.setCloseCount(1);
                return true;
            } while ((cMillis = this.doWait(cMillis)) != 0L);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean close(long cMillis) {
        Thread thread = Thread.currentThread();
        if (this.getClosingThread() == thread && this.getStatus() == 2) {
            this.setCloseCount(this.getCloseCount() + 1);
            return true;
        }
        AtomicCounter atomicState = this.m_atomicState;
        long cEnterThis = this.m_tlcEnters.getCount();
        long lStatusReq = 0L | cEnterThis;
        long lStatusEnd = 0x2000000000000000L | cEnterThis;
        boolean fReenter = false;
        boolean fReopen = false;
        ThreadGate threadGate = this;
        synchronized (threadGate) {
            boolean bl;
            block15: {
                boolean bl2;
                block14: {
                    try {
                        if (this.getClosingThread() == thread) {
                            lStatusReq = 0x1000000000000000L;
                            if (cEnterThis > 0L) {
                                fReenter = true;
                                atomicState.decrement(cEnterThis);
                            }
                        }
                        while (true) {
                            if (atomicState.setCount(lStatusReq, lStatusEnd)) {
                                this.setCloseCount(this.getCloseCount() + 1);
                                this.setClosingThread(thread);
                                fReopen = false;
                                fReenter = false;
                                bl2 = true;
                                Object var16_12 = null;
                                if (fReenter) {
                                    atomicState.increment(cEnterThis);
                                }
                                break block14;
                            }
                            if (this.getClosingThread() == null) {
                                if (this.updateStatus(1) == 3) {
                                    this.updateStatus(3);
                                    throw new IllegalStateException("ThreadGate.close: ThreadGate has been destroyed.");
                                }
                                this.setClosingThread(thread);
                                lStatusReq = 0x1000000000000000L;
                                fReopen = true;
                                if (cEnterThis <= 0L) continue;
                                fReenter = true;
                                atomicState.decrement(cEnterThis);
                                continue;
                            }
                            if ((cMillis = this.doWait(cMillis)) == 0L) break;
                        }
                        bl = false;
                        break block15;
                    }
                    catch (Throwable throwable) {
                        Object var16_14 = null;
                        if (fReenter) {
                            atomicState.increment(cEnterThis);
                        }
                        if (!fReopen) throw throwable;
                        this.setClosingThread(null);
                        this.updateStatus(0);
                        this.notifyAll();
                        throw throwable;
                    }
                }
                if (!fReopen) return bl2;
                this.setClosingThread(null);
                this.updateStatus(0);
                this.notifyAll();
                return bl2;
            }
            Object var16_13 = null;
            if (fReenter) {
                atomicState.increment(cEnterThis);
            }
            if (!fReopen) return bl;
            this.setClosingThread(null);
            this.updateStatus(0);
            this.notifyAll();
            return bl;
        }
    }

    public synchronized void destroy() {
        switch (this.getStatus()) {
            case 2: {
                Thread thread = Thread.currentThread();
                if (thread != this.getClosingThread()) {
                    throw new IllegalStateException("ThreadGate.destroy: Gate was not closed by this thread! " + this);
                }
                this.updateStatus(3);
                this.setClosingThread(null);
                this.notifyAll();
                break;
            }
            case 3: {
                break;
            }
            default: {
                throw new IllegalStateException("ThreadGate.destroy: Gate is not closed! " + this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public boolean enter(long cMillis) {
        AtomicCounter atomicState = this.m_atomicState;
        ThreadLocalCounter tlcEnters = this.m_tlcEnters;
        if (tlcEnters.increment() > 1L || this.getClosingThread() == Thread.currentThread()) {
            if ((atomicState.increment() & 0xFFFFFFFFFFFFFFFL) <= Integer.MAX_VALUE) return true;
            atomicState.decrement();
            tlcEnters.decrement();
            throw new IllegalStateException("The ThreadGate is full.");
        }
        ThreadLocalCounter tlcVersion = this.m_tlcVersion;
        boolean fSuccess = false;
        try {
            block14: while (true) {
                long lStatus = atomicState.getCount();
                switch ((int)(lStatus >>> 60)) {
                    case 0: {
                        if (!atomicState.setCount(lStatus, lStatus + 1L)) continue block14;
                        long cVersion = this.getVersion();
                        if (cVersion > tlcVersion.getCount()) {
                            ThreadGate threadGate = this;
                            // MONITORENTER : threadGate
                            // MONITOREXIT : threadGate
                            tlcVersion.setCount(cVersion);
                        }
                        fSuccess = true;
                        boolean bl = true;
                        return bl;
                    }
                    case 1: 
                    case 2: {
                        ThreadGate threadGate = this;
                        // MONITORENTER : threadGate
                        long nStatus = this.getStatus();
                        if ((nStatus == 1L || nStatus == 2L) && (cMillis = this.doWait(cMillis)) == 0L) {
                            boolean bl = false;
                            // MONITOREXIT : threadGate
                            return bl;
                        }
                        tlcVersion.setCount(this.getVersion());
                        // MONITOREXIT : threadGate
                        continue block14;
                    }
                    case 3: {
                        tlcEnters.decrement();
                        throw new IllegalStateException("ThreadGate.enter: ThreadGate has been destroyed.");
                    }
                }
                break;
            }
            tlcEnters.decrement();
            throw new IllegalStateException("ThreadGate.enter: ThreadGate has an invalid status. " + this);
        }
        finally {
            if (!fSuccess) {
                tlcEnters.decrement();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exit() {
        ThreadLocalCounter tlcEnters = this.m_tlcEnters;
        if (tlcEnters.decrement() < 0L) {
            tlcEnters.increment();
            throw new IllegalStateException("ThreadGate.exit: Thread has already exited! " + this);
        }
        if (this.m_atomicState.decrement() == 0x1000000000000000L) {
            ThreadGate threadGate = this;
            synchronized (threadGate) {
                this.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void open() {
        int cClosed;
        if (Thread.currentThread() == this.getClosingThread() && (cClosed = this.getCloseCount() - 1) >= 0) {
            this.setCloseCount(cClosed);
            if (cClosed == 0) {
                long cVersion = this.getVersion() + 1L;
                this.setVersion(cVersion);
                this.m_tlcVersion.setCount(cVersion);
                ThreadGate threadGate = this;
                synchronized (threadGate) {
                    this.updateStatus(0);
                    this.setClosingThread(null);
                    this.notifyAll();
                }
            }
            return;
        }
        throw new IllegalStateException("ThreadGate.open: Gate was not closed by this thread! " + this);
    }

    protected long doWait(long cMillis) {
        if (cMillis == 0L) {
            return 0L;
        }
        long lTime = ThreadGate.getSafeTimeMillis();
        try {
            this.wait(Math.max(0L, cMillis));
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new WrapperException(e, this.toString());
        }
        return cMillis < 0L ? cMillis : Math.max(0L, cMillis - (ThreadGate.getSafeTimeMillis() - lTime));
    }

    public int getActiveCount() {
        return (int)(this.m_atomicState.getCount() & 0xFFFFFFFFFFFFFFFL);
    }

    public boolean isActiveThread() {
        return this.m_tlcEnters.getCount() > 0L;
    }

    protected long getVersion() {
        return this.m_cVersion;
    }

    protected void setVersion(long cVersion) {
        this.m_cVersion = cVersion;
    }

    public int getCloseCount() {
        return this.m_cClose;
    }

    protected void setCloseCount(int cClose) {
        this.m_cClose = cClose;
    }

    protected Thread getClosingThread() {
        return this.m_threadClosing;
    }

    protected void setClosingThread(Thread thread) {
        this.m_threadClosing = thread;
    }

    public int getStatus() {
        return (int)(this.m_atomicState.getCount() >>> 60);
    }

    protected int updateStatus(int nStatus) {
        long lNew;
        long lCurr;
        AtomicCounter atomicState = this.m_atomicState;
        long lStatus = (long)nStatus << 60;
        while (!atomicState.setCount(lCurr = atomicState.getCount(), lNew = lStatus | lCurr & 0xFFFFFFFFFFFFFFFL)) {
        }
        return (int)(lCurr >>> 60);
    }

    public synchronized String toString() {
        String sState;
        switch (this.getStatus()) {
            case 0: {
                sState = "GATE_OPEN";
                break;
            }
            case 1: {
                sState = "GATE_CLOSING";
                break;
            }
            case 2: {
                sState = "GATE_CLOSED";
                break;
            }
            case 3: {
                sState = "GATE_DESTROYED";
                break;
            }
            default: {
                sState = "INVALID";
            }
        }
        return "ThreadGate{State=" + sState + ", ActiveCount=" + this.getActiveCount() + ", CloseCount=" + this.getCloseCount() + ", ClosingThread= " + this.getClosingThread() + '}';
    }

    public static class ThreadLocalCounter
    extends ThreadLocal {
        public long getCount() {
            Long L = (Long)this.get();
            return L == null ? 0L : L;
        }

        public void setCount(long c) {
            this.set(Base.makeLong(c));
        }

        public long increment() {
            long c = this.getCount() + 1L;
            this.setCount(c);
            return c;
        }

        public long decrement() {
            long c = this.getCount() - 1L;
            this.setCount(c);
            return c;
        }

        public void set(Object oValue) {
            super.set((Long)oValue);
        }
    }
}

