/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.util;

import com.tangosol.util.Base;
import com.tangosol.util.NullImplementation;
import com.tangosol.util.SimpleEnumerator;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.NoSuchElementException;

public class Tree
extends Base
implements Cloneable,
Serializable {
    protected static final Node NIL = Node.NIL;
    protected Node head = NIL;
    protected int size = 0;

    public void add(Comparable key) {
        this.put(key, null);
    }

    public synchronized void put(Comparable key, Object value) {
        if (this.size == 0) {
            this.head = new Node();
            this.head.key = key;
            this.head.value = value;
            this.size = 1;
            return;
        }
        Node parent = NIL;
        Node child = this.head;
        Node target = null;
        while (child != NIL) {
            if (target == null && key.equals(child.key)) {
                target = child;
            }
            if (child.left.red && child.right.red) {
                child.red = true;
                child.left.red = false;
                child.right.red = false;
                if (parent.red) {
                    this.balance(child);
                }
            }
            parent = child;
            if (target != null || key.compareTo(child.key) < 0) {
                child = child.left;
                continue;
            }
            child = child.right;
        }
        if (target == null) {
            child = new Node();
            child.key = key;
            child.value = value;
            child.parent = parent;
            child.red = true;
            ++this.size;
            if (key.compareTo(parent.key) < 0) {
                parent.left = child;
            } else {
                parent.right = child;
            }
            if (parent.red) {
                this.balance(child);
            }
        } else {
            target.value = value;
        }
        this.head.red = false;
    }

    public synchronized Object get(Comparable key) {
        Node node = this.find(key);
        return node == null ? null : node.value;
    }

    public synchronized boolean contains(Comparable key) {
        return this.find(key) != null;
    }

    public synchronized Object remove(Comparable key) {
        Node grand = NIL;
        Node parent = NIL;
        Node child = this.head;
        Node sibling = null;
        Node left = null;
        Node right = null;
        Node foster = null;
        Node target = null;
        Node adoptee = null;
        Object value = null;
        while (child != NIL) {
            if (target == null && key.equals(child.key)) {
                target = child;
            }
            grand = parent;
            parent = child;
            if (key.compareTo(parent.key) < 0) {
                sibling = parent.right;
                child = parent.left;
            } else {
                sibling = parent.left;
                child = parent.right;
            }
            left = sibling.left;
            right = sibling.right;
            if (!child.red && sibling.red) {
                if (grand == NIL) {
                    this.head = sibling;
                } else if (grand.left == parent) {
                    grand.left = sibling;
                } else {
                    grand.right = sibling;
                }
                sibling.parent = grand;
                if (parent.left == child) {
                    parent.right = left;
                    if (left != NIL) {
                        left.parent = parent;
                    }
                    sibling.left = parent;
                    parent.parent = sibling;
                    grand = sibling;
                    sibling = left;
                } else {
                    parent.left = right;
                    if (right != NIL) {
                        right.parent = parent;
                    }
                    sibling.right = parent;
                    parent.parent = sibling;
                    grand = sibling;
                    sibling = right;
                }
                left = sibling.left;
                right = sibling.right;
                parent.red = true;
                grand.red = false;
            }
            if (child == NIL || child.red || child.left.red || child.right.red) continue;
            if (!(sibling == NIL || sibling.red || sibling.left.red || sibling.right.red)) {
                parent.red = false;
                child.red = true;
                sibling.red = true;
                continue;
            }
            if (left.red) {
                if (parent.left == child) {
                    left.red = parent.red;
                    parent.red = false;
                    child.red = true;
                    if (grand == NIL) {
                        this.head = left;
                    } else if (grand.left == parent) {
                        grand.left = left;
                    } else {
                        grand.right = left;
                    }
                    left.parent = grand;
                    parent.right = adoptee = left.left;
                    if (adoptee != NIL) {
                        adoptee.parent = parent;
                    }
                    left.left = parent;
                    parent.parent = left;
                    sibling.left = adoptee = left.right;
                    if (adoptee != NIL) {
                        adoptee.parent = sibling;
                    }
                    left.right = sibling;
                    sibling.parent = left;
                    grand = left;
                    continue;
                }
                sibling.red = parent.red;
                left.red = false;
                parent.red = false;
                child.red = true;
                if (grand == NIL) {
                    this.head = sibling;
                } else if (grand.left == parent) {
                    grand.left = sibling;
                } else {
                    grand.right = sibling;
                }
                sibling.parent = grand;
                parent.left = right;
                if (right != NIL) {
                    right.parent = parent;
                }
                sibling.right = parent;
                parent.parent = sibling;
                grand = sibling;
                continue;
            }
            if (!right.red) continue;
            if (parent.left == child) {
                sibling.red = parent.red;
                right.red = false;
                parent.red = false;
                child.red = true;
                if (grand == NIL) {
                    this.head = sibling;
                } else if (grand.left == parent) {
                    grand.left = sibling;
                } else {
                    grand.right = sibling;
                }
                sibling.parent = grand;
                parent.right = left;
                if (left != NIL) {
                    left.parent = parent;
                }
                sibling.left = parent;
                parent.parent = sibling;
                grand = sibling;
                continue;
            }
            right.red = parent.red;
            parent.red = false;
            child.red = true;
            if (grand == NIL) {
                this.head = right;
            } else if (grand.left == parent) {
                grand.left = right;
            } else {
                grand.right = right;
            }
            right.parent = grand;
            parent.left = adoptee = right.right;
            if (adoptee != NIL) {
                adoptee.parent = parent;
            }
            right.right = parent;
            parent.parent = right;
            sibling.right = adoptee = right.left;
            if (adoptee != NIL) {
                adoptee.parent = sibling;
            }
            right.left = sibling;
            sibling.parent = right;
            grand = right;
        }
        if (target != null) {
            child = parent;
            parent = child.parent;
            foster = target.parent;
            if (target == child || target.left == NIL || target.right == NIL) {
                child = target.left != NIL ? target.left : target.right;
            } else {
                if (target != parent) {
                    parent.left = adoptee = child.right;
                    if (adoptee != NIL) {
                        adoptee.parent = parent;
                    }
                    child.right = adoptee = target.right;
                    if (adoptee != NIL) {
                        adoptee.parent = child;
                    }
                }
                child.left = adoptee = target.left;
                if (adoptee != NIL) {
                    adoptee.parent = child;
                }
            }
            if (child != NIL) {
                child.red = target.red;
            }
            if (foster == NIL) {
                this.head = child;
                child.parent = NIL;
            } else {
                if (foster.left == target) {
                    foster.left = child;
                } else {
                    foster.right = child;
                }
                if (child != NIL) {
                    child.parent = foster;
                }
            }
            value = target.value;
            --this.size;
        }
        this.head.red = false;
        return value;
    }

    public synchronized void clear() {
        this.head = NIL;
        this.size = 0;
    }

    public int getSize() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public synchronized Enumeration keys() {
        if (this.size == 0) {
            return NullImplementation.getEnumeration();
        }
        Crawler crawler = new Crawler(this.head);
        Object[] akey = new Comparable[this.size];
        int cElements = 0;
        while (crawler.hasMoreElements()) {
            akey[cElements++] = ((Node)crawler.nextElement()).key;
        }
        if (cElements != this.size) {
            throw new IllegalStateException("iterated " + cElements + " keys in a " + this.size + "-node tree!");
        }
        return new SimpleEnumerator(akey);
    }

    public synchronized Enumeration elements() {
        if (this.size == 0) {
            return NullImplementation.getEnumeration();
        }
        Crawler crawler = new Crawler(this.head);
        Object[] aoValue = new Object[this.size];
        int cElements = 0;
        while (crawler.hasMoreElements()) {
            aoValue[cElements++] = ((Node)crawler.nextElement()).value;
        }
        if (cElements != this.size) {
            throw new IllegalStateException("iterated " + cElements + " elements in a " + this.size + "-node tree!");
        }
        return new SimpleEnumerator(aoValue);
    }

    public boolean addAll(Tree that) {
        return this.addAll(that, false);
    }

    public void putAll(Tree that) {
        this.addAll(that, true);
    }

    private boolean addAll(Tree that, boolean fPutAll) {
        boolean bModified = false;
        Tree thisTree = this;
        Tree thatTree = that;
        Enumeration thisKeys = thisTree.keys();
        Crawler thatKeys = thatTree.getUnsynchronizedNodeEnumerator();
        Comparable thisKey = null;
        Comparable thatKey = null;
        boolean fAdvanceThis = true;
        boolean fAdvanceThat = true;
        while (!(fAdvanceThis && !thisKeys.hasMoreElements() || fAdvanceThat && !thatKeys.hasMoreElements())) {
            int iComp;
            if (fAdvanceThis) {
                thisKey = (Comparable)thisKeys.nextElement();
            }
            if (fAdvanceThat) {
                thatKey = ((Node)thatKeys.nextElement()).key;
            }
            if ((iComp = thisKey.compareTo(thatKey)) == 0) {
                if (fPutAll) {
                    thisTree.put(thatKey, thatTree.get(thatKey));
                }
                fAdvanceThis = true;
                fAdvanceThat = true;
                continue;
            }
            if (iComp < 0) {
                fAdvanceThis = true;
                fAdvanceThat = false;
                continue;
            }
            thisTree.put(thatKey, thatTree.get(thatKey));
            bModified = true;
            fAdvanceThis = false;
            fAdvanceThat = true;
        }
        while (!fAdvanceThat || thatKeys.hasMoreElements()) {
            if (fAdvanceThat) {
                thatKey = ((Node)thatKeys.nextElement()).key;
            }
            thisTree.put(thatKey, thatTree.get(thatKey));
            bModified = true;
            fAdvanceThat = true;
        }
        return bModified;
    }

    public boolean retainAll(Tree that) {
        boolean bModified = false;
        Tree thisTree = this;
        Tree thatTree = that;
        Enumeration thisKeys = thisTree.keys();
        Crawler thatKeys = thatTree.getUnsynchronizedNodeEnumerator();
        Comparable thisKey = null;
        Comparable thatKey = null;
        boolean fAdvanceThis = true;
        boolean fAdvanceThat = true;
        while (!(fAdvanceThis && !thisKeys.hasMoreElements() || fAdvanceThat && !thatKeys.hasMoreElements())) {
            int iComp;
            if (fAdvanceThis) {
                thisKey = (Comparable)thisKeys.nextElement();
            }
            if (fAdvanceThat) {
                thatKey = ((Node)thatKeys.nextElement()).key;
            }
            if ((iComp = thisKey.compareTo(thatKey)) == 0) {
                fAdvanceThis = true;
                fAdvanceThat = true;
                continue;
            }
            if (iComp < 0) {
                fAdvanceThis = true;
                fAdvanceThat = false;
                thisTree.remove(thisKey);
                bModified = true;
                continue;
            }
            fAdvanceThis = false;
            fAdvanceThat = true;
        }
        while (!fAdvanceThis || thisKeys.hasMoreElements()) {
            if (fAdvanceThis) {
                thisKey = (Comparable)thisKeys.nextElement();
            }
            thisTree.remove(thisKey);
            bModified = true;
            fAdvanceThis = true;
        }
        return bModified;
    }

    public boolean removeAll(Tree that) {
        boolean bModified = false;
        Tree thisTree = this;
        Tree thatTree = that;
        Enumeration thisKeys = thisTree.keys();
        Crawler thatKeys = thatTree.getUnsynchronizedNodeEnumerator();
        Comparable thisKey = null;
        Comparable thatKey = null;
        boolean fAdvanceThis = true;
        boolean fAdvanceThat = true;
        while (!(fAdvanceThis && !thisKeys.hasMoreElements() || fAdvanceThat && !thatKeys.hasMoreElements())) {
            int iComp;
            if (fAdvanceThis) {
                thisKey = (Comparable)thisKeys.nextElement();
            }
            if (fAdvanceThat) {
                thatKey = ((Node)thatKeys.nextElement()).key;
            }
            if ((iComp = thisKey.compareTo(thatKey)) == 0) {
                thisTree.remove(thisKey);
                bModified = true;
                fAdvanceThis = true;
                fAdvanceThat = true;
                continue;
            }
            if (iComp < 0) {
                fAdvanceThis = true;
                fAdvanceThat = false;
                continue;
            }
            fAdvanceThis = false;
            fAdvanceThat = true;
        }
        return bModified;
    }

    public synchronized String toString() {
        return "Tree(" + this.head.toString() + ")";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean equals(Object obj) {
        if (obj instanceof Tree) {
            Tree that;
            Tree tree = that = (Tree)obj;
            synchronized (tree) {
                if (this.size == that.size) {
                    if (this.size == 0) {
                        return true;
                    }
                    Crawler thisCrawler = new Crawler(this.head);
                    Crawler thatCrawler = new Crawler(that.head);
                    while (thisCrawler.hasMoreElements() && thatCrawler.hasMoreElements()) {
                        if (thisCrawler.nextElement().equals(thatCrawler.nextElement())) continue;
                        return false;
                    }
                    return thisCrawler.hasMoreElements() == thatCrawler.hasMoreElements();
                }
            }
        }
        return false;
    }

    public synchronized Object clone() {
        Tree that = new Tree();
        that.head = (Node)this.head.clone();
        that.size = this.size;
        return that;
    }

    public synchronized void print() {
        this.head.print();
    }

    protected Crawler getUnsynchronizedNodeEnumerator() {
        return new Crawler(this.head);
    }

    protected Crawler getUnsynchronizedNodeEnumerator(Comparable key) {
        Node closest = NIL;
        Node current = this.head;
        while (current != NIL) {
            int nResult = current.key.compareTo(key);
            if (nResult > 0) {
                closest = current;
                current = current.left;
                continue;
            }
            if (nResult < 0) {
                current = current.right;
                continue;
            }
            return new Crawler(current, 1);
        }
        return new Crawler(closest, 1);
    }

    protected Node find(Comparable key) {
        Node current = this.head;
        while (current != NIL) {
            int nResult = key.compareTo(current.key);
            if (nResult < 0) {
                current = current.left;
                continue;
            }
            if (nResult > 0) {
                current = current.right;
                continue;
            }
            return current;
        }
        return null;
    }

    private void balance(Node child) {
        Node parent = child.parent;
        Node grand = parent.parent;
        Node great = grand.parent;
        Node newgrand = null;
        Node adoptee = null;
        if (parent == grand.left) {
            if (child == parent.left) {
                newgrand = parent;
                grand.left = adoptee = parent.right;
                if (adoptee != NIL) {
                    adoptee.parent = grand;
                }
                parent.right = grand;
                grand.parent = parent;
            } else {
                newgrand = child;
                parent.right = adoptee = child.left;
                if (adoptee != NIL) {
                    adoptee.parent = parent;
                }
                grand.left = adoptee = child.right;
                if (adoptee != NIL) {
                    adoptee.parent = grand;
                }
                child.left = parent;
                child.right = grand;
                parent.parent = child;
                grand.parent = child;
            }
        } else if (child == parent.right) {
            newgrand = parent;
            grand.right = adoptee = parent.left;
            if (adoptee != NIL) {
                adoptee.parent = grand;
            }
            parent.left = grand;
            grand.parent = parent;
        } else {
            newgrand = child;
            grand.right = adoptee = child.left;
            if (adoptee != NIL) {
                adoptee.parent = grand;
            }
            parent.left = adoptee = child.right;
            if (adoptee != NIL) {
                adoptee.parent = parent;
            }
            child.left = grand;
            child.right = parent;
            grand.parent = child;
            parent.parent = child;
        }
        newgrand.red = false;
        grand.red = true;
        if (great == NIL) {
            this.head = newgrand;
            newgrand.parent = NIL;
        } else {
            if (grand == great.left) {
                great.left = newgrand;
            } else {
                great.right = newgrand;
            }
            newgrand.parent = great;
        }
    }

    protected static class Crawler
    implements Enumeration,
    Cloneable {
        protected static final Node NIL = Node.NIL;
        protected static final int ABOVE = 0;
        protected static final int LEFT = 1;
        protected static final int SITTING = 2;
        protected static final int RIGHT = 3;
        protected Node current;
        protected int fromdir;

        public Crawler(Node head) {
            this.current = head;
            this.fromdir = 0;
        }

        protected Crawler(Node head, int fromdir) {
            this.current = head;
            this.fromdir = fromdir;
        }

        public boolean hasMoreElements() {
            if (this.current == NIL) {
                return false;
            }
            block6: while (true) {
                switch (this.fromdir) {
                    case 0: {
                        if (this.current.left != NIL) {
                            this.current = this.current.left;
                            continue block6;
                        }
                        this.fromdir = 1;
                    }
                    case 1: {
                        return true;
                    }
                    case 2: {
                        if (this.current.right != NIL) {
                            this.fromdir = 0;
                            this.current = this.current.right;
                            continue block6;
                        }
                    }
                    case 3: {
                        if (this.current.parent != NIL) {
                            this.fromdir = this.current == this.current.parent.left ? 1 : 3;
                            this.current = this.current.parent;
                            continue block6;
                        }
                        this.current = NIL;
                        return false;
                    }
                }
                break;
            }
            throw new IllegalStateException("invalid direction: " + this.fromdir);
        }

        public Object nextElement() {
            if (this.current == NIL) {
                throw new NoSuchElementException();
            }
            block6: while (true) {
                switch (this.fromdir) {
                    case 0: {
                        if (this.current.left != NIL) {
                            this.current = this.current.left;
                            continue block6;
                        }
                    }
                    case 1: {
                        this.fromdir = 2;
                        return this.current;
                    }
                    case 2: {
                        if (this.current.right != NIL) {
                            this.fromdir = 0;
                            this.current = this.current.right;
                            continue block6;
                        }
                    }
                    case 3: {
                        if (this.current.parent != NIL) {
                            this.fromdir = this.current == this.current.parent.left ? 1 : 3;
                            this.current = this.current.parent;
                            continue block6;
                        }
                        this.current = NIL;
                        throw new NoSuchElementException();
                    }
                }
                break;
            }
            throw new IllegalStateException("invalid direction: " + this.fromdir);
        }

        public String toString() {
            String key = this.current.key.toString();
            switch (this.fromdir) {
                case 0: {
                    return "just crawled into " + key;
                }
                case 1: {
                    return "just returned to " + key + " from the left child";
                }
                case 2: {
                    return "just sitting in " + key;
                }
                case 3: {
                    return "just returned to " + key + " from the right child";
                }
            }
            throw new IllegalStateException("invalid direction: " + this.fromdir);
        }

        public Object clone() {
            try {
                return super.clone();
            }
            catch (Exception e) {
                throw Base.ensureRuntimeException(e);
            }
        }
    }

    protected static class Node
    implements Cloneable,
    Serializable {
        protected static final Node NIL;
        protected Comparable key = null;
        protected Object value = null;
        protected Node parent = NIL;
        protected Node left = NIL;
        protected Node right = NIL;
        protected boolean red = false;

        public String toString() {
            if (this == NIL) {
                return "";
            }
            return (this.left != NIL ? this.left.toString() + ',' : "") + this.key.toString() + (this.right != NIL ? ',' + this.right.toString() : "");
        }

        public boolean equals(Object obj) {
            if (obj instanceof Node) {
                Node that = (Node)obj;
                if (this.key.equals(that.key)) {
                    return this.value == null ? that.value == null : this.value.equals(that.value);
                }
            }
            return false;
        }

        public Object clone() {
            Node right;
            if (this == NIL) {
                return this;
            }
            Node that = new Node();
            that.key = this.key;
            that.value = this.value;
            that.red = this.red;
            Node left = this.left;
            if (left != NIL) {
                that.left = left = (Node)left.clone();
                left.parent = that;
            }
            if ((right = this.right) != NIL) {
                that.right = right = (Node)right.clone();
                right.parent = that;
            }
            return that;
        }

        private void writeObject(ObjectOutputStream out) throws IOException {
            out.writeObject(this.key);
            out.writeObject(this.value);
            boolean fLeft = this.left != NIL;
            out.writeBoolean(fLeft);
            if (fLeft) {
                out.writeObject(this.left);
            }
            boolean fRight = this.right != NIL;
            out.writeBoolean(fRight);
            if (fRight) {
                out.writeObject(this.right);
            }
            out.writeBoolean(this.red);
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            this.key = (Comparable)in.readObject();
            this.value = in.readObject();
            this.parent = NIL;
            this.left = NIL;
            if (in.readBoolean()) {
                this.left = (Node)in.readObject();
                this.left.parent = this;
            }
            this.right = NIL;
            if (in.readBoolean()) {
                this.right = (Node)in.readObject();
                this.right.parent = this;
            }
            this.red = in.readBoolean();
        }

        protected boolean isLeaf() {
            return this.left == NIL || this.right == NIL;
        }

        protected int getDepth() {
            return (this.red ? 0 : 1) + (this.parent == NIL ? 0 : this.parent.getDepth());
        }

        protected void print() {
            if (this.left != NIL) {
                this.left.print();
            }
            if (this != NIL) {
                Base.out(this.key);
            }
            if (this.right != NIL) {
                this.right.print();
            }
        }

        static {
            Node.NIL.parent = NIL = new Node();
            Node.NIL.left = NIL;
            Node.NIL.right = NIL;
        }
    }
}

