/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.util;

import com.tangosol.util.Base;
import com.tangosol.util.ConcurrentMap;
import com.tangosol.util.SafeHashMap;
import com.tangosol.util.ThreadGate;
import com.tangosol.util.WrapperObservableMap;
import java.util.ConcurrentModificationException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;

public class WrapperConcurrentMap
extends WrapperObservableMap
implements ConcurrentMap {
    protected boolean m_fEnforceLocking;
    protected long m_cWaitMillis;
    protected final SafeHashMap m_mapLock = new SafeHashMap();
    protected final ThreadGate m_gateMap = new ThreadGate();

    public WrapperConcurrentMap(Map map) {
        this(map, true, -1L);
    }

    public WrapperConcurrentMap(Map map, boolean fEnforceLocking, long cWaitMillis) {
        super(map);
        this.m_fEnforceLocking = fEnforceLocking;
        this.m_cWaitMillis = cWaitMillis;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean lock(Object oKey, long cWait) {
        boolean bl;
        Lock lock;
        boolean fSuccess;
        ThreadGate gateMap;
        SafeHashMap mapLock;
        block21: {
            boolean bl2;
            block20: {
                boolean bl3;
                mapLock = this.m_mapLock;
                gateMap = this.m_gateMap;
                if (oKey == LOCK_ALL) {
                    return gateMap.close(cWait);
                }
                if (!gateMap.enter(cWait)) {
                    return false;
                }
                fSuccess = false;
                lock = null;
                try {
                    while (true) {
                        Object object = mapLock;
                        synchronized (object) {
                            lock = (Lock)mapLock.get(oKey);
                            if (lock == null) {
                                lock = this.instantiateLock(oKey);
                                lock.assign(0L);
                                mapLock.put(oKey, lock);
                                fSuccess = true;
                                bl3 = true;
                                // MONITOREXIT @DISABLED, blocks:[0, 18, 6, 9] lbl22 : MonitorExitStatement: MONITOREXIT : var8_7
                                Object var13_11 = null;
                                if (fSuccess) return bl3;
                                if (lock != null && lock.isDiscardable()) {
                                    mapLock.remove(oKey);
                                }
                                break;
                            }
                            if (lock.isOwnedByCaller()) {
                                lock.assign(0L);
                                fSuccess = true;
                                bl2 = true;
                                // MONITOREXIT @DISABLED, blocks:[0, 17, 6, 9] lbl35 : MonitorExitStatement: MONITOREXIT : var8_7
                                break block20;
                            }
                        }
                        object = lock;
                        synchronized (object) {
                            if (lock == mapLock.get(oKey)) {
                                bl = fSuccess = lock.assign(cWait);
                                // MONITOREXIT @DISABLED, blocks:[0, 16, 7, 9] lbl43 : MonitorExitStatement: MONITOREXIT : var8_7
                                break block21;
                            }
                        }
                    }
                }
                catch (Throwable throwable) {
                    Object var13_14 = null;
                    if (fSuccess) throw throwable;
                    if (lock != null && lock.isDiscardable()) {
                        mapLock.remove(oKey);
                    }
                    gateMap.exit();
                    throw throwable;
                }
                gateMap.exit();
                return bl3;
            }
            Object var13_12 = null;
            if (fSuccess) return bl2;
            if (lock != null && lock.isDiscardable()) {
                mapLock.remove(oKey);
            }
            gateMap.exit();
            return bl2;
        }
        Object var13_13 = null;
        if (fSuccess) return bl;
        if (lock != null && lock.isDiscardable()) {
            mapLock.remove(oKey);
        }
        gateMap.exit();
        return bl;
    }

    public boolean lock(Object oKey) {
        return this.lock(oKey, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean unlock(Object oKey) {
        Lock lock;
        SafeHashMap mapLock = this.m_mapLock;
        ThreadGate gateMap = this.m_gateMap;
        if (oKey == LOCK_ALL) {
            try {
                gateMap.open();
                return true;
            }
            catch (IllegalStateException e) {
                return false;
            }
        }
        boolean fReleased = true;
        while ((lock = (Lock)mapLock.get(oKey)) != null) {
            Lock lock2 = lock;
            synchronized (lock2) {
                if (mapLock.get(oKey) == lock) {
                    fReleased = lock.release();
                    if (lock.isDiscardable()) {
                        mapLock.remove(oKey);
                    }
                    break;
                }
            }
        }
        try {
            gateMap.exit();
        }
        catch (IllegalStateException e) {
            // empty catch block
        }
        return fReleased;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        boolean fForceLock = this.isLockingEnforced();
        if (!fForceLock || this.lock(LOCK_ALL, this.getWaitMillis())) {
            try {
                super.clear();
            }
            finally {
                if (fForceLock) {
                    this.unlock(LOCK_ALL);
                }
            }
        } else {
            throw new ConcurrentModificationException("clear");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object put(Object oKey, Object oValue) {
        boolean fForceLock = this.isLockingEnforced();
        if (!fForceLock || this.lock(oKey, this.getWaitMillis())) {
            try {
                Object object = super.put(oKey, oValue);
                return object;
            }
            finally {
                if (fForceLock) {
                    this.unlock(oKey);
                }
            }
        }
        throw new ConcurrentModificationException("(thread=" + Thread.currentThread() + ") " + this.getLockDescription(oKey));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putAll(Map map) {
        block7: {
            block6: {
                Iterator iter3;
                boolean fForceLock = this.isLockingEnforced();
                if (!fForceLock) break block6;
                HashSet setLocked = new HashSet();
                try {
                    Iterator iter2 = map.keySet().iterator();
                    while (iter2.hasNext()) {
                        Object oKey = iter2.next();
                        if (this.lock(oKey, this.getWaitMillis())) {
                            setLocked.add(oKey);
                            continue;
                        }
                        throw new ConcurrentModificationException("(thread=" + Thread.currentThread() + ") " + this.getLockDescription(oKey));
                    }
                    super.putAll(map);
                    Object var7_6 = null;
                    iter3 = setLocked.iterator();
                }
                catch (Throwable throwable) {
                    Object var7_7 = null;
                    Iterator iter3 = setLocked.iterator();
                    while (iter3.hasNext()) {
                        this.unlock(iter3.next());
                    }
                    throw throwable;
                }
                while (iter3.hasNext()) {
                    this.unlock(iter3.next());
                }
                break block7;
            }
            super.putAll(map);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object remove(Object oKey) {
        boolean fForceLock = this.isLockingEnforced();
        if (!fForceLock || this.lock(oKey, this.getWaitMillis())) {
            try {
                Object object = super.remove(oKey);
                return object;
            }
            finally {
                if (fForceLock) {
                    this.unlock(oKey);
                }
            }
        }
        throw new ConcurrentModificationException("(thread=" + Thread.currentThread() + ") " + this.getLockDescription(oKey));
    }

    protected boolean isInternalKeySetIteratorMutable() {
        return super.isInternalKeySetIteratorMutable() && !this.isLockingEnforced();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean removeBlind(Object oKey) {
        boolean fForceLock = this.isLockingEnforced();
        if (!fForceLock || this.lock(oKey, this.getWaitMillis())) {
            try {
                boolean bl = super.removeBlind(oKey);
                return bl;
            }
            finally {
                if (fForceLock) {
                    this.unlock(oKey);
                }
            }
        }
        throw new ConcurrentModificationException("(thread=" + Thread.currentThread() + ") " + this.getLockDescription(oKey));
    }

    public String toString() {
        return "WrapperConcurrentMap {" + this.getDescription() + "}";
    }

    public boolean isLockingEnforced() {
        return this.m_fEnforceLocking;
    }

    public void setLockingEnforced(boolean fEnforce) {
        this.m_fEnforceLocking = fEnforce;
    }

    public long getWaitMillis() {
        return this.m_cWaitMillis;
    }

    public void setWaitMillis(long cWaitMillis) {
        this.m_cWaitMillis = cWaitMillis;
    }

    protected String getDescription() {
        return super.getDescription() + ", LockingEnforced=" + this.isLockingEnforced() + ", WaitMillis=" + this.getWaitMillis() + ", ThreadGate=" + this.m_gateMap + ", Locks={" + this.m_mapLock + "}";
    }

    public String getLockDescription(Object oKey) {
        return "key=\"" + oKey + "\", lock=" + this.m_mapLock.get(oKey);
    }

    protected Lock instantiateLock(Object oKey) {
        return new Lock(oKey);
    }

    protected static class Lock
    extends Base {
        private Thread m_thread;
        private short m_cLock;
        private short m_cBlock;

        protected Lock(Object oKey) {
        }

        protected boolean assign(long cWait) {
            while (this.isDirty()) {
                if (cWait == 0L) {
                    return false;
                }
                cWait = this.waitForNotify(cWait);
            }
            int cLock = this.m_cLock + 1;
            if (cLock == 1) {
                this.m_thread = Thread.currentThread();
            } else if (cLock == Short.MAX_VALUE) {
                throw new RuntimeException("Lock count overflow: " + this);
            }
            this.m_cLock = (short)cLock;
            return true;
        }

        protected long waitForNotify(long cWait) {
            long lTime = Lock.getSafeTimeMillis();
            try {
                this.m_cBlock = (short)(this.m_cBlock + 1);
                long cMaxWait = 1000L;
                long cMillis = cWait <= 0L || cWait > 1000L ? 1000L : cWait;
                this.wait(cMillis);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw Lock.ensureRuntimeException(e, "Lock request interrupted");
            }
            finally {
                this.m_cBlock = (short)(this.m_cBlock - 1);
            }
            if (cWait > 0L) {
                cWait -= Lock.getSafeTimeMillis() - lTime;
                cWait = Math.max(0L, cWait);
            }
            return cWait;
        }

        protected boolean release() {
            if (this.isDirty()) {
                return false;
            }
            int cLock = this.m_cLock - 1;
            if (cLock == 0) {
                this.m_thread = null;
            } else if (cLock < 0) {
                cLock = 0;
            }
            this.m_cLock = (short)cLock;
            if (cLock == 0) {
                if (this.m_cBlock > 0) {
                    this.notify();
                }
                return true;
            }
            return false;
        }

        protected boolean isDirty() {
            Thread threadHolder = this.m_thread;
            Thread threadCurrent = Thread.currentThread();
            if (threadHolder != null && threadHolder != threadCurrent) {
                if (threadHolder.isAlive()) {
                    return true;
                }
                this.m_thread = null;
                this.m_cLock = 0;
                if (this.m_cBlock > 0) {
                    this.notify();
                }
            }
            return false;
        }

        protected boolean isOwnedByCaller() {
            return this.m_thread == Thread.currentThread();
        }

        protected boolean isDiscardable() {
            return this.m_cLock == 0 && this.m_cBlock == 0;
        }

        protected Thread getLockThread() {
            return this.m_thread;
        }

        protected int getLockCount() {
            return this.m_cLock;
        }

        protected int getBlockCount() {
            return this.m_cBlock;
        }

        protected String getLockTypeDescription() {
            return "Lock";
        }

        public String toString() {
            return this.getLockTypeDescription() + "[" + this.m_thread + ", cnt=" + this.m_cLock + ", block=" + this.m_cBlock + ']';
        }
    }
}

