/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.util;

import com.tangosol.net.cache.CacheEvent;
import com.tangosol.net.cache.CacheStatistics;
import com.tangosol.net.cache.SimpleCacheStatistics;
import com.tangosol.util.AbstractKeySetBasedMap;
import com.tangosol.util.Filter;
import com.tangosol.util.MapEvent;
import com.tangosol.util.MapListener;
import com.tangosol.util.MapListenerSupport;
import com.tangosol.util.MultiplexingMapListener;
import com.tangosol.util.ObservableMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class WrapperObservableMap
extends AbstractKeySetBasedMap
implements ObservableMap {
    protected Map m_map;
    protected MapListenerSupport m_listenerSupport;
    protected MapListener m_listenerInternal;
    protected SimpleCacheStatistics m_stats;
    private boolean m_fCollectStats;
    private boolean m_fTranslateEvents;

    public WrapperObservableMap(Map map) {
        if (map == null) {
            throw new IllegalArgumentException("Map must be specified");
        }
        this.m_map = map;
    }

    public synchronized void clear() {
        if (this.isEventFabricator()) {
            Iterator iter = this.getInternalKeySet().iterator();
            while (iter.hasNext()) {
                this.dispatchPendingEvent(iter.next(), 3, null, false);
            }
        }
        this.getMap().clear();
    }

    public boolean containsValue(Object oValue) {
        return this.getMap().containsValue(oValue);
    }

    public Object get(Object oKey) {
        Map mapInner = this.getMap();
        if (this.isCollectStats()) {
            boolean fContains;
            long ldtStart = WrapperObservableMap.getSafeTimeMillis();
            Object oValue = mapInner.get(oKey);
            boolean bl = fContains = oValue != null || mapInner.containsKey(oKey);
            if (fContains) {
                this.m_stats.registerHit(ldtStart);
            } else {
                this.m_stats.registerMiss(ldtStart);
            }
            return oValue;
        }
        return mapInner.get(oKey);
    }

    public Object put(Object oKey, Object oValue) {
        Object oOrig;
        long ldtStart;
        Map mapInner = this.getMap();
        boolean fStats = this.isCollectStats();
        long l = ldtStart = fStats ? WrapperObservableMap.getSafeTimeMillis() : 0L;
        if (this.isEventFabricator()) {
            int nEvent = mapInner.containsKey(oKey) ? 2 : 1;
            oOrig = mapInner.put(oKey, oValue);
            this.dispatchEvent(new CacheEvent(this, nEvent, oKey, oOrig, oValue, false));
        } else {
            oOrig = mapInner.put(oKey, oValue);
        }
        if (fStats) {
            this.m_stats.registerPut(ldtStart);
        }
        return oOrig;
    }

    public void putAll(Map map) {
        long ldtStart;
        Map mapInner = this.getMap();
        boolean fStats = this.isCollectStats();
        long l = ldtStart = fStats ? WrapperObservableMap.getSafeTimeMillis() : 0L;
        if (this.isEventFabricator()) {
            Iterator iter = map.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                Object oKey = entry.getKey();
                int nEvent = mapInner.containsKey(oKey) ? 2 : 1;
                this.dispatchPendingEvent(oKey, nEvent, entry.getValue(), false);
            }
        }
        mapInner.putAll(map);
        if (fStats) {
            this.m_stats.registerPuts(map.size(), ldtStart);
        }
    }

    public Object remove(Object oKey) {
        Map mapInner = this.getMap();
        if (this.isEventFabricator()) {
            Object oOrig;
            boolean fContained = mapInner.containsKey(oKey);
            Object v0 = oOrig = fContained ? mapInner.remove(oKey) : null;
            if (fContained) {
                this.dispatchEvent(new CacheEvent(this, 3, oKey, oOrig, null, false));
            }
            return oOrig;
        }
        return mapInner.remove(oKey);
    }

    protected Set getInternalKeySet() {
        return this.getMap().keySet();
    }

    protected boolean isInternalKeySetIteratorMutable() {
        return !this.isEventFabricator();
    }

    protected boolean removeBlind(Object oKey) {
        if (this.isEventFabricator()) {
            boolean fRemoved = false;
            if (this.getMap().containsKey(oKey)) {
                this.dispatchPendingEvent(oKey, 3, null, false);
                this.getMap().keySet().remove(oKey);
                fRemoved = true;
            }
            return fRemoved;
        }
        return this.getMap().keySet().remove(oKey);
    }

    public synchronized void addMapListener(MapListener listener) {
        this.addMapListener(listener, null, false);
    }

    public synchronized void removeMapListener(MapListener listener) {
        this.removeMapListener(listener, null);
    }

    public synchronized void addMapListener(MapListener listener, Object oKey, boolean fLite) {
        boolean fWasEmpty;
        boolean fWasLite;
        WrapperObservableMap.azzert(listener != null);
        Map map = this.getMap();
        if (map instanceof ObservableMap && !this.isTranslateEvents()) {
            ((ObservableMap)map).addMapListener(listener, oKey, fLite);
            return;
        }
        MapListenerSupport support = this.m_listenerSupport;
        if (support == null) {
            support = this.m_listenerSupport = new MapListenerSupport();
        }
        boolean bl = fWasLite = (fWasEmpty = support.isEmpty(oKey)) || !support.containsStandardListeners(oKey);
        if ((fWasEmpty || fWasLite && !fLite) && map instanceof ObservableMap) {
            MapListener listenerInternal = this.instantiateInternalListener();
            ((ObservableMap)map).addMapListener(listenerInternal, oKey, fLite);
            this.m_listenerInternal = listenerInternal;
        }
        support.addListener(listener, oKey, fLite);
    }

    public synchronized void removeMapListener(MapListener listener, Object oKey) {
        WrapperObservableMap.azzert(listener != null);
        Map map = this.getMap();
        if (map instanceof ObservableMap && !this.isTranslateEvents()) {
            ((ObservableMap)map).removeMapListener(listener, oKey);
            return;
        }
        MapListenerSupport support = this.m_listenerSupport;
        if (support != null) {
            boolean fWasStandard = support.containsStandardListeners(oKey);
            support.removeListener(listener, oKey);
            MapListener listenerInternal = this.m_listenerInternal;
            if (listenerInternal != null) {
                ObservableMap mapObserve = (ObservableMap)this.getMap();
                if (support.isEmpty(oKey)) {
                    mapObserve.removeMapListener(listenerInternal, oKey);
                    if (support.isEmpty()) {
                        this.m_listenerSupport = null;
                        this.m_listenerInternal = null;
                    }
                } else if (fWasStandard && !support.containsStandardListeners(oKey)) {
                    mapObserve.removeMapListener(listenerInternal, oKey);
                    mapObserve.addMapListener(listenerInternal, oKey, true);
                }
            }
        }
    }

    public synchronized void addMapListener(MapListener listener, Filter filter, boolean fLite) {
        boolean fWasEmpty;
        boolean fWasLite;
        WrapperObservableMap.azzert(listener != null);
        Map map = this.getMap();
        if (map instanceof ObservableMap && !this.isTranslateEvents()) {
            ((ObservableMap)map).addMapListener(listener, filter, fLite);
            return;
        }
        MapListenerSupport support = this.m_listenerSupport;
        if (support == null) {
            support = this.m_listenerSupport = new MapListenerSupport();
        }
        boolean bl = fWasLite = (fWasEmpty = support.isEmpty(filter)) || !support.containsStandardListeners(filter);
        if ((fWasEmpty || fWasLite && !fLite) && map instanceof ObservableMap) {
            MapListener listenerInternal = this.instantiateInternalListener();
            ((ObservableMap)map).addMapListener(listenerInternal, filter, fLite);
            this.m_listenerInternal = listenerInternal;
        }
        support.addListener(listener, filter, fLite);
    }

    public synchronized void removeMapListener(MapListener listener, Filter filter) {
        WrapperObservableMap.azzert(listener != null);
        Map map = this.getMap();
        if (map instanceof ObservableMap && !this.isTranslateEvents()) {
            ((ObservableMap)map).removeMapListener(listener, filter);
            return;
        }
        MapListenerSupport support = this.m_listenerSupport;
        if (support != null) {
            boolean fWasStandard = support.containsStandardListeners(filter);
            support.removeListener(listener, filter);
            MapListener listenerInternal = this.m_listenerInternal;
            if (listenerInternal != null) {
                ObservableMap mapObserve = (ObservableMap)this.getMap();
                if (support.isEmpty(filter)) {
                    mapObserve.removeMapListener(listenerInternal, filter);
                    if (support.isEmpty()) {
                        this.m_listenerSupport = null;
                        this.m_listenerInternal = null;
                    }
                } else if (fWasStandard && !support.containsStandardListeners(filter)) {
                    mapObserve.removeMapListener(listenerInternal, filter);
                    mapObserve.addMapListener(listenerInternal, filter, true);
                }
            }
        }
    }

    public Map getMap() {
        return this.m_map;
    }

    public CacheStatistics getCacheStatistics() {
        return this.m_stats;
    }

    public boolean isCollectStats() {
        return this.m_fCollectStats;
    }

    public void setCollectStats(boolean fCollectStats) {
        if (fCollectStats != this.m_fCollectStats) {
            if (fCollectStats && this.m_stats == null) {
                this.m_stats = new SimpleCacheStatistics();
            }
            this.m_fCollectStats = fCollectStats;
        }
    }

    public boolean isTranslateEvents() {
        return this.m_fTranslateEvents;
    }

    public void setTranslateEvents(boolean fTranslate) {
        this.m_fTranslateEvents = fTranslate;
    }

    protected String getDescription() {
        Map map = this.getMap();
        return "Map {class=" + map.getClass().getName() + ", size=" + map.size() + ", observable=" + (map instanceof ObservableMap) + "}, CollectStats=" + this.isCollectStats() + ", CacheStatistics=" + this.getCacheStatistics() + ", hasListeners=" + this.hasListeners() + ", EventFabricator=" + this.isEventFabricator();
    }

    public String toString() {
        return "WrapperObservableMap {" + this.getDescription() + "}";
    }

    protected MapListenerSupport getMapListenerSupport() {
        return this.m_listenerSupport;
    }

    protected boolean hasListeners() {
        return this.m_listenerSupport != null;
    }

    protected boolean isEventFabricator() {
        return this.hasListeners() && this.m_listenerInternal == null;
    }

    protected static boolean isSynthetic(MapEvent evt) {
        return evt instanceof CacheEvent && ((CacheEvent)evt).isSynthetic();
    }

    protected void dispatchPendingEvent(Object oKey, int nId, Object oNewValue, boolean fSynthetic) {
        CacheEvent event = new CacheEvent(this, nId, oKey, null, oNewValue, fSynthetic){
            private Object m_oOldValue;

            public Object getOldValue() {
                Object oOldValue = this.m_oOldValue;
                if (oOldValue == null) {
                    this.m_oOldValue = oOldValue = WrapperObservableMap.this.get(this.getKey());
                }
                return oOldValue;
            }
        };
        this.dispatchEvent(event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void dispatchEvent(MapEvent evt) {
        MapListenerSupport listenerSupport = this.getMapListenerSupport();
        if (listenerSupport != null) {
            if (evt.getMap() != this) {
                final MapEvent evtOrig = evt;
                evt = new CacheEvent(this, evt.getId(), evt.getKey(), null, null, false){

                    public Object getOldValue() {
                        return evtOrig.getOldValue();
                    }

                    public Object getNewValue() {
                        return evtOrig.getNewValue();
                    }

                    public boolean isSynthetic() {
                        return WrapperObservableMap.isSynthetic(evtOrig);
                    }
                };
            }
            WrapperObservableMap wrapperObservableMap = this;
            synchronized (wrapperObservableMap) {
                listenerSupport.fireEvent(evt, false);
            }
        }
    }

    protected MapListener instantiateInternalListener() {
        return new InternalListener();
    }

    protected class InternalListener
    extends MultiplexingMapListener {
        protected InternalListener() {
        }

        protected void onMapEvent(MapEvent evt) {
            WrapperObservableMap.this.dispatchEvent(evt);
        }
    }
}

