/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.util.aggregator;

import com.tangosol.io.ExternalizableLite;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.io.pof.PortableObject;
import com.tangosol.util.ClassHelper;
import com.tangosol.util.ExternalizableHelper;
import com.tangosol.util.Filter;
import com.tangosol.util.InvocableMap;
import com.tangosol.util.NullImplementation;
import com.tangosol.util.ValueExtractor;
import com.tangosol.util.extractor.ChainedExtractor;
import com.tangosol.util.extractor.MultiExtractor;
import com.tangosol.util.extractor.ReflectionExtractor;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class GroupAggregator
extends ExternalizableHelper
implements InvocableMap.EntryAggregator,
ExternalizableLite,
PortableObject {
    protected ValueExtractor m_extractor;
    protected InvocableMap.EntryAggregator m_aggregator;
    protected Filter m_filter;

    public GroupAggregator() {
    }

    protected GroupAggregator(ValueExtractor extractor, InvocableMap.EntryAggregator aggregator, Filter filter) {
        GroupAggregator.azzert(extractor != null && aggregator != null);
        this.m_extractor = extractor;
        this.m_aggregator = aggregator;
        this.m_filter = filter;
    }

    public Object aggregate(Set setEntries) {
        Map.Entry entry;
        ValueExtractor extractor = this.m_extractor;
        InvocableMap.EntryAggregator aggregator = this.m_aggregator;
        Filter filter = this.m_filter;
        HashMap<Object, HashSet<Map.Entry>> mapResult = new HashMap<Object, HashSet<Map.Entry>>();
        Iterator<Object> iter = setEntries.iterator();
        while (iter.hasNext()) {
            entry = (InvocableMap.Entry)iter.next();
            if (!entry.isPresent()) continue;
            Object oDistinct = entry.extract(extractor);
            HashSet<Map.Entry> setGroup = (HashSet<Map.Entry>)mapResult.get(oDistinct);
            if (setGroup == null) {
                setGroup = new HashSet<Map.Entry>();
                mapResult.put(oDistinct, setGroup);
            }
            setGroup.add(entry);
        }
        iter = mapResult.entrySet().iterator();
        while (iter.hasNext()) {
            entry = (Map.Entry)iter.next();
            Set setGroup = (Set)entry.getValue();
            Object oResult = aggregator.aggregate(setGroup);
            if (filter == null || filter.evaluate(oResult)) {
                entry.setValue(oResult);
                continue;
            }
            iter.remove();
        }
        return mapResult;
    }

    public void readExternal(DataInput in) throws IOException {
        this.m_extractor = (ValueExtractor)GroupAggregator.readObject(in);
        this.m_aggregator = (InvocableMap.EntryAggregator)GroupAggregator.readObject(in);
        this.m_filter = (Filter)GroupAggregator.readObject(in);
    }

    public void writeExternal(DataOutput out) throws IOException {
        GroupAggregator.writeObject(out, this.m_extractor);
        GroupAggregator.writeObject(out, this.m_aggregator);
        GroupAggregator.writeObject(out, this.m_filter);
    }

    public void readExternal(PofReader in) throws IOException {
        this.m_extractor = (ValueExtractor)in.readObject(0);
        this.m_aggregator = (InvocableMap.EntryAggregator)in.readObject(1);
        this.m_filter = (Filter)in.readObject(2);
    }

    public void writeExternal(PofWriter out) throws IOException {
        out.writeObject(0, this.m_extractor);
        out.writeObject(1, this.m_aggregator);
        out.writeObject(2, this.m_filter);
    }

    public ValueExtractor getExtractor() {
        return this.m_extractor;
    }

    public InvocableMap.EntryAggregator getAggregator() {
        return this.m_aggregator;
    }

    public boolean equals(Object o) {
        if (o instanceof GroupAggregator) {
            GroupAggregator that = (GroupAggregator)o;
            return GroupAggregator.equals(this.m_extractor, that.m_extractor) && GroupAggregator.equals(this.m_aggregator, that.m_aggregator);
        }
        return false;
    }

    public int hashCode() {
        return ((Object)this.m_extractor).hashCode() + this.m_aggregator.hashCode();
    }

    public String toString() {
        return ClassHelper.getSimpleName(this.getClass()) + '(' + this.m_extractor + ", " + this.m_aggregator + (this.m_filter == null ? "" : ", " + this.m_filter) + ')';
    }

    public static GroupAggregator createInstance(String sMethod, InvocableMap.EntryAggregator aggregator) {
        return GroupAggregator.createInstance(sMethod, aggregator, null);
    }

    public static GroupAggregator createInstance(String sMethod, InvocableMap.EntryAggregator aggregator, Filter filter) {
        MultiExtractor extractor = sMethod.indexOf(44) >= 0 ? new MultiExtractor(sMethod) : (sMethod.indexOf(46) >= 0 ? new ChainedExtractor(sMethod) : new ReflectionExtractor(sMethod));
        return GroupAggregator.createInstance(extractor, aggregator, filter);
    }

    public static GroupAggregator createInstance(ValueExtractor extractor, InvocableMap.EntryAggregator aggregator) {
        return GroupAggregator.createInstance(extractor, aggregator, null);
    }

    public static GroupAggregator createInstance(ValueExtractor extractor, InvocableMap.EntryAggregator aggregator, Filter filter) {
        return aggregator instanceof InvocableMap.ParallelAwareAggregator ? new Parallel(extractor, (InvocableMap.ParallelAwareAggregator)aggregator, filter) : new GroupAggregator(extractor, aggregator, filter);
    }

    public static class Parallel
    extends GroupAggregator
    implements InvocableMap.ParallelAwareAggregator {
        public Parallel() {
        }

        protected Parallel(ValueExtractor extractor, InvocableMap.ParallelAwareAggregator aggregator, Filter filter) {
            super(extractor, aggregator, filter);
        }

        public InvocableMap.EntryAggregator getParallelAggregator() {
            InvocableMap.ParallelAwareAggregator aggregator = (InvocableMap.ParallelAwareAggregator)this.m_aggregator;
            return new GroupAggregator(this.m_extractor, aggregator.getParallelAggregator(), this.m_filter);
        }

        public Object aggregateResults(Collection collResults) {
            InvocableMap.ParallelAwareAggregator aggregator = (InvocableMap.ParallelAwareAggregator)this.m_aggregator;
            HashMap mapResult = new HashMap();
            Iterator iter = collResults.iterator();
            while (iter.hasNext()) {
                Map mapPart = (Map)iter.next();
                Iterator iterPart = mapPart.entrySet().iterator();
                while (iterPart.hasNext()) {
                    Map.Entry entry = iterPart.next();
                    Object oDistinct = entry.getKey();
                    Object oResult = entry.getValue();
                    HashSet setGroup = (HashSet)mapResult.get(oDistinct);
                    if (setGroup == null) {
                        setGroup = new HashSet();
                        mapResult.put(oDistinct, setGroup);
                    }
                    setGroup.add(oResult);
                }
            }
            if (mapResult.isEmpty()) {
                aggregator.aggregateResults(NullImplementation.getSet());
            } else {
                Filter filter = this.m_filter;
                Iterator iter2 = mapResult.entrySet().iterator();
                while (iter2.hasNext()) {
                    Map.Entry entry = iter2.next();
                    Set setGroup = (Set)entry.getValue();
                    Object oResult = aggregator.aggregateResults(setGroup);
                    if (filter == null || filter.evaluate(oResult)) {
                        entry.setValue(oResult);
                        continue;
                    }
                    iter2.remove();
                }
            }
            return mapResult;
        }
    }
}

