/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.util.comparator;

import com.tangosol.io.ExternalizableLite;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.io.pof.PortableObject;
import com.tangosol.util.Base;
import com.tangosol.util.ExternalizableHelper;
import com.tangosol.util.QueryMap;
import com.tangosol.util.comparator.EntryAwareComparator;
import com.tangosol.util.comparator.QueryMapComparator;
import com.tangosol.util.comparator.SafeComparator;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import java.util.Comparator;

public class ChainedComparator
extends Base
implements Comparator,
QueryMapComparator,
EntryAwareComparator,
Serializable,
ExternalizableLite,
PortableObject {
    private static final Comparator[] EMPTY_COMPARATOR_ARRAY = new Comparator[0];
    protected Comparator[] m_aComparator;

    public ChainedComparator() {
    }

    public ChainedComparator(Comparator[] aComparator) {
        ChainedComparator.azzert(aComparator != null);
        this.m_aComparator = aComparator;
    }

    public int compare(Object o1, Object o2) {
        Comparator[] aComparator = this.getComparators();
        int c = aComparator.length;
        for (int i = 0; i < c; ++i) {
            int nResult = aComparator[i].compare(o1, o2);
            if (nResult == 0) continue;
            return nResult;
        }
        return 0;
    }

    public int compareEntries(QueryMap.Entry entry1, QueryMap.Entry entry2) {
        Comparator[] aComparator = this.getComparators();
        int c = aComparator.length;
        for (int i = 0; i < c; ++i) {
            int nResult;
            Comparator comparator = aComparator[i];
            int n = nResult = comparator instanceof QueryMapComparator ? ((QueryMapComparator)comparator).compareEntries(entry1, entry2) : this.compare(entry1.getValue(), entry2.getValue());
            if (nResult == 0) continue;
            return nResult;
        }
        return 0;
    }

    public boolean isKeyComparator() {
        Comparator[] aComparator = this.getComparators();
        int c = aComparator.length;
        for (int i = 0; i < c; ++i) {
            if (SafeComparator.isKeyComparator(aComparator[i])) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("ChainedComparator(");
        Comparator[] aComparator = this.m_aComparator;
        int c = aComparator.length;
        for (int i = 0; i < c; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(aComparator[i]);
        }
        sb.append(')');
        return sb.toString();
    }

    public boolean equals(Object o) {
        return o instanceof ChainedComparator && ChainedComparator.equalsDeep(this.m_aComparator, ((ChainedComparator)o).m_aComparator);
    }

    public int hashCode() {
        Comparator[] aComparator = this.m_aComparator;
        int nHash = 0;
        int c = aComparator.length;
        for (int i = 0; i < c; ++i) {
            nHash += aComparator[i].hashCode();
        }
        return nHash;
    }

    public Comparator[] getComparators() {
        return this.m_aComparator;
    }

    public void readExternal(DataInput in) throws IOException {
        int cComparators = ExternalizableHelper.readInt(in);
        Comparator[] aComparator = new Comparator[cComparators];
        for (int i = 0; i < cComparators; ++i) {
            aComparator[i] = (Comparator)ExternalizableHelper.readObject(in);
        }
        this.m_aComparator = aComparator;
    }

    public void writeExternal(DataOutput out) throws IOException {
        Comparator[] aComparator = this.m_aComparator;
        int cComparators = aComparator.length;
        ExternalizableHelper.writeInt(out, cComparators);
        for (int i = 0; i < cComparators; ++i) {
            ExternalizableHelper.writeObject(out, aComparator[i]);
        }
    }

    public void readExternal(PofReader in) throws IOException {
        this.m_aComparator = (Comparator[])in.readObjectArray(0, EMPTY_COMPARATOR_ARRAY);
    }

    public void writeExternal(PofWriter out) throws IOException {
        out.writeObjectArray(0, this.m_aComparator);
    }
}

