/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.util.extractor;

import com.tangosol.io.ExternalizableLite;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.io.pof.PortableObject;
import com.tangosol.util.ClassHelper;
import com.tangosol.util.ExternalizableHelper;
import com.tangosol.util.MapEvent;
import com.tangosol.util.ValueExtractor;
import com.tangosol.util.extractor.AbstractExtractor;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.lang.reflect.Method;

public class ReflectionExtractor
extends AbstractExtractor
implements ValueExtractor,
ExternalizableLite,
PortableObject {
    protected String m_sMethod;
    protected Object[] m_aoParam;
    private transient Class m_clzPrev;
    private transient Method m_methodPrev;

    public ReflectionExtractor() {
    }

    public ReflectionExtractor(String sMethod) {
        this(sMethod, null);
    }

    public ReflectionExtractor(String sMethod, Object[] aoParam) {
        ReflectionExtractor.azzert(sMethod != null);
        this.m_sMethod = sMethod;
        this.m_aoParam = aoParam;
    }

    public Object extract(Object oTarget) {
        if (oTarget == null) {
            return null;
        }
        Class<?> clz = oTarget.getClass();
        String sMethod = this.getMethodName();
        try {
            Method method;
            if (clz == this.m_clzPrev) {
                method = this.m_methodPrev;
            } else {
                this.m_methodPrev = method = ClassHelper.findMethod(clz, sMethod, this.getClassArray(), false);
                this.m_clzPrev = clz;
            }
            return method.invoke(oTarget, this.m_aoParam);
        }
        catch (NullPointerException e) {
            throw new RuntimeException(this.suggestExtractFailureCause(clz));
        }
        catch (Exception e) {
            throw ReflectionExtractor.ensureRuntimeException(e, clz.getName() + this + '(' + oTarget + ')');
        }
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ReflectionExtractor) {
            ReflectionExtractor that = (ReflectionExtractor)o;
            return this.m_sMethod.equals(that.m_sMethod) && ReflectionExtractor.equalsDeep(this.m_aoParam, that.m_aoParam);
        }
        return false;
    }

    public int hashCode() {
        return this.m_sMethod.hashCode();
    }

    public String toString() {
        Object[] aoParam = this.m_aoParam;
        int cParams = aoParam == null ? 0 : aoParam.length;
        StringBuffer sb = new StringBuffer();
        sb.append('#').append(this.m_sMethod).append('[');
        for (int i = 0; i < cParams; ++i) {
            if (i != 0) {
                sb.append(", ");
            }
            sb.append(String.valueOf(aoParam[i]));
        }
        sb.append(']');
        return sb.toString();
    }

    public String getMethodName() {
        return this.m_sMethod;
    }

    public Object[] getParameters() {
        return this.m_aoParam;
    }

    private String suggestExtractFailureCause(Class clzTarget) {
        String sMsg = "Missing or inaccessible method: " + clzTarget.getName() + this;
        if (MapEvent.class.isAssignableFrom(clzTarget)) {
            sMsg = sMsg + " (the object is a com.tangosol.util.MapEvent, which may suggest that a raw com.tangosol.util.Filter is being used to filter map events rather than a com.tangosol.util.filter.MapEventFilter)";
        }
        return sMsg;
    }

    private Class[] getClassArray() {
        int cParams;
        Object[] aoParam = this.m_aoParam;
        if (aoParam != null && (cParams = aoParam.length) > 0) {
            Class[] aClass = new Class[cParams];
            for (int i = 0; i < cParams; ++i) {
                Object oParam = aoParam[i];
                if (oParam == null) continue;
                aClass[i] = oParam.getClass();
            }
            return aClass;
        }
        return ClassHelper.VOID_PARAMS;
    }

    public void readExternal(DataInput in) throws IOException {
        this.m_sMethod = ExternalizableHelper.readUTF(in);
        int cParams = ExternalizableHelper.readInt(in);
        Object[] aoParam = cParams == 0 ? null : new Object[cParams];
        for (int i = 0; i < cParams; ++i) {
            aoParam[i] = ExternalizableHelper.readObject(in);
        }
        this.m_aoParam = aoParam;
    }

    public void writeExternal(DataOutput out) throws IOException {
        Object[] aoParam = this.m_aoParam;
        int cParams = aoParam == null ? 0 : aoParam.length;
        ExternalizableHelper.writeUTF(out, this.m_sMethod);
        ExternalizableHelper.writeInt(out, cParams);
        for (int i = 0; i < cParams; ++i) {
            ExternalizableHelper.writeObject(out, aoParam[i]);
        }
    }

    public void readExternal(PofReader in) throws IOException {
        this.m_sMethod = in.readString(0);
        int cParams = in.readInt(1);
        Object[] aoParam = cParams == 0 ? null : new Object[cParams];
        for (int i = 0; i < cParams; ++i) {
            aoParam[i] = in.readObject(i + 2);
        }
        this.m_aoParam = aoParam;
    }

    public void writeExternal(PofWriter out) throws IOException {
        Object[] aoParam = this.m_aoParam;
        int cParams = aoParam == null ? 0 : aoParam.length;
        out.writeString(0, this.m_sMethod);
        out.writeInt(1, cParams);
        for (int i = 0; i < cParams; ++i) {
            out.writeObject(i + 2, aoParam[i]);
        }
    }
}

