/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.util.extractor;

import com.tangosol.io.ExternalizableLite;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.io.pof.PortableObject;
import com.tangosol.util.Base;
import com.tangosol.util.ClassHelper;
import com.tangosol.util.ValueUpdater;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.lang.reflect.Method;

public class ReflectionUpdater
extends Base
implements ValueUpdater,
ExternalizableLite,
PortableObject {
    protected String m_sMethod;
    private transient Class m_clzPrev;
    private transient Method m_methodPrev;

    public ReflectionUpdater() {
    }

    public ReflectionUpdater(String sMethod) {
        ReflectionUpdater.azzert(sMethod != null);
        this.m_sMethod = sMethod;
    }

    public void update(Object oTarget, Object oValue) {
        if (oTarget == null) {
            throw new IllegalArgumentException("Target object is missing for the Updater: " + this);
        }
        Class<?> clzTarget = oTarget.getClass();
        String sMethod = this.getMethodName();
        try {
            Method method;
            if (clzTarget == this.m_clzPrev) {
                method = this.m_methodPrev;
            } else {
                Class[] aclzParam = new Class[1];
                if (oValue != null) {
                    aclzParam[0] = oValue.getClass();
                }
                this.m_methodPrev = method = ClassHelper.findMethod(clzTarget, sMethod, aclzParam, false);
                this.m_clzPrev = clzTarget;
            }
            method.invoke(oTarget, oValue);
        }
        catch (NullPointerException e) {
            throw new RuntimeException("Missing or inaccessible method: " + clzTarget.getName() + '#' + sMethod);
        }
        catch (Exception e) {
            throw ReflectionUpdater.ensureRuntimeException(e, clzTarget.getName() + '#' + sMethod + '(' + oTarget + ')');
        }
    }

    public String getMethodName() {
        return this.m_sMethod;
    }

    public boolean equals(Object o) {
        if (o instanceof ReflectionUpdater) {
            ReflectionUpdater that = (ReflectionUpdater)o;
            return this.m_sMethod.equals(that.m_sMethod);
        }
        return false;
    }

    public int hashCode() {
        return this.m_sMethod.hashCode();
    }

    public String toString() {
        return '&' + this.m_sMethod;
    }

    public void readExternal(DataInput in) throws IOException {
        this.m_sMethod = in.readUTF();
    }

    public void writeExternal(DataOutput out) throws IOException {
        out.writeUTF(this.m_sMethod);
    }

    public void readExternal(PofReader in) throws IOException {
        this.m_sMethod = in.readString(0);
    }

    public void writeExternal(PofWriter out) throws IOException {
        out.writeString(0, this.m_sMethod);
    }
}

