/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.util.filter;

import com.tangosol.io.ExternalizableLite;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.io.pof.PortableObject;
import com.tangosol.util.ExternalizableHelper;
import com.tangosol.util.Filter;
import com.tangosol.util.filter.ExtractorFilter;
import com.tangosol.util.filter.IndexAwareFilter;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;

public abstract class ArrayFilter
extends ExternalizableHelper
implements IndexAwareFilter,
ExternalizableLite,
PortableObject {
    private static final Filter[] EMPTY_FILTER_ARRAY = new Filter[0];
    protected Filter[] m_aFilter;

    public ArrayFilter() {
    }

    public ArrayFilter(Filter[] aFilter) {
        ArrayFilter.azzert(aFilter != null);
        this.m_aFilter = aFilter;
    }

    public Filter[] getFilters() {
        return this.m_aFilter;
    }

    protected WeightedFilter[] calculateFilters(Map mapIndexes, Set setKeys) {
        Filter[] aFilter = this.m_aFilter;
        int cFilters = aFilter.length;
        Object[] awf = new WeightedFilter[cFilters];
        int nMax = setKeys.size() * ExtractorFilter.EVAL_COST;
        for (int i = 0; i < cFilters; ++i) {
            Filter filter = aFilter[i];
            int nEffect = filter instanceof IndexAwareFilter ? ((IndexAwareFilter)filter).calculateEffectiveness(mapIndexes, setKeys) : nMax;
            awf[i] = new WeightedFilter(filter, nEffect);
        }
        if (cFilters > 1) {
            Arrays.sort(awf);
        }
        return awf;
    }

    protected Filter applyFilter(IndexAwareFilter filter, Map mapIndexes, Set setKeys) {
        int nEffect = filter.calculateEffectiveness(mapIndexes, setKeys);
        if (nEffect < setKeys.size() * ExtractorFilter.EVAL_COST) {
            return filter.applyIndex(mapIndexes, setKeys);
        }
        return filter;
    }

    public boolean equals(Object o) {
        if (o instanceof ArrayFilter) {
            ArrayFilter that = (ArrayFilter)o;
            return this.getClass() == that.getClass() && ArrayFilter.equalsDeep(this.m_aFilter, that.m_aFilter);
        }
        return false;
    }

    public int hashCode() {
        int iHash = 0;
        Filter[] aFilter = this.m_aFilter;
        int c = aFilter.length;
        for (int i = 0; i < c; ++i) {
            iHash += aFilter[i].hashCode();
        }
        return iHash;
    }

    public String toString() {
        String sClass = this.getClass().getName();
        StringBuffer sb = new StringBuffer(sClass.substring(sClass.lastIndexOf(46) + 1));
        sb.append('(');
        Filter[] aFilter = this.m_aFilter;
        int c = aFilter.length;
        for (int i = 0; i < c; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(aFilter[i]);
        }
        sb.append(')');
        return sb.toString();
    }

    public void readExternal(DataInput in) throws IOException {
        int cFilters = ArrayFilter.readInt(in);
        Filter[] aFilter = new Filter[cFilters];
        for (int i = 0; i < cFilters; ++i) {
            aFilter[i] = (Filter)ArrayFilter.readObject(in);
        }
        this.m_aFilter = aFilter;
    }

    public void writeExternal(DataOutput out) throws IOException {
        Filter[] aFilter = this.m_aFilter;
        int cFilters = aFilter.length;
        ArrayFilter.writeInt(out, cFilters);
        for (int i = 0; i < cFilters; ++i) {
            ArrayFilter.writeObject(out, aFilter[i]);
        }
    }

    public void readExternal(PofReader in) throws IOException {
        this.m_aFilter = (Filter[])in.readObjectArray(0, EMPTY_FILTER_ARRAY);
    }

    public void writeExternal(PofWriter out) throws IOException {
        out.writeObjectArray(0, this.m_aFilter);
    }

    protected static class WeightedFilter
    implements Comparable {
        private Filter m_filter;
        private int m_nEffect;

        protected WeightedFilter(Filter filter, int nEffect) {
            this.m_filter = filter;
            this.m_nEffect = nEffect;
        }

        public int compareTo(Object o) {
            int nThis = this.m_nEffect;
            int nThat = ((WeightedFilter)o).m_nEffect;
            return nThis < nThat ? -1 : (nThis > nThat ? 1 : 0);
        }

        public Filter getFilter() {
            return this.m_filter;
        }

        public int getEffectiveness() {
            return this.m_nEffect;
        }
    }
}

