/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.util.filter;

import com.tangosol.util.Filter;
import com.tangosol.util.MapIndex;
import com.tangosol.util.ValueExtractor;
import com.tangosol.util.filter.ComparisonFilter;
import com.tangosol.util.filter.IndexAwareFilter;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class ContainsAllFilter
extends ComparisonFilter
implements IndexAwareFilter {
    public ContainsAllFilter() {
    }

    public ContainsAllFilter(ValueExtractor extractor, Set setValues) {
        super(extractor, new HashSet(setValues));
        ContainsAllFilter.azzert(setValues != null);
    }

    public ContainsAllFilter(String sMethod, Set setValues) {
        super(sMethod, new HashSet(setValues));
        ContainsAllFilter.azzert(setValues != null);
    }

    protected boolean evaluateExtracted(Object oExtracted) {
        Set setValues = (Set)this.getValue();
        if (oExtracted instanceof Collection) {
            return ((Collection)oExtracted).containsAll(setValues);
        }
        if (oExtracted instanceof Object[]) {
            Object[] aoExtracted = (Object[])oExtracted;
            int cExtracted = aoExtracted.length;
            Iterator iter = setValues.iterator();
            block0: while (iter.hasNext()) {
                Object oValue = iter.next();
                for (int i = 0; i < cExtracted; ++i) {
                    if (ContainsAllFilter.equals(aoExtracted[i], oValue)) continue block0;
                }
                return false;
            }
            return true;
        }
        return false;
    }

    public int calculateEffectiveness(Map mapIndexes, Set setKeys) {
        MapIndex index = (MapIndex)mapIndexes.get(this.getValueExtractor());
        return index == null ? setKeys.size() * EVAL_COST : ((Set)this.getValue()).size();
    }

    public Filter applyIndex(Map mapIndexes, Set setKeys) {
        MapIndex index = (MapIndex)mapIndexes.get(this.getValueExtractor());
        if (index == null) {
            return this;
        }
        Iterator iter = ((Set)this.getValue()).iterator();
        while (iter.hasNext()) {
            Object oValue = iter.next();
            Set setEQ = (Set)index.getIndexContents().get(oValue);
            if (setEQ == null) {
                setKeys.clear();
                break;
            }
            setKeys.retainAll(setEQ);
            if (!setKeys.isEmpty()) continue;
            break;
        }
        return null;
    }
}

