/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.util.filter;

import com.tangosol.util.Filter;
import com.tangosol.util.MapIndex;
import com.tangosol.util.ValueExtractor;
import com.tangosol.util.filter.ComparisonFilter;
import com.tangosol.util.filter.IndexAwareFilter;
import java.util.Collection;
import java.util.Map;
import java.util.Set;

public class ContainsFilter
extends ComparisonFilter
implements IndexAwareFilter {
    public ContainsFilter() {
    }

    public ContainsFilter(ValueExtractor extractor, Object oValue) {
        super(extractor, oValue);
    }

    public ContainsFilter(String sMethod, Object oValue) {
        super(sMethod, oValue);
    }

    protected boolean evaluateExtracted(Object oExtracted) {
        Object oValue = this.getValue();
        if (oExtracted instanceof Collection) {
            return ((Collection)oExtracted).contains(oValue);
        }
        if (oExtracted instanceof Object[]) {
            Object[] aoExtracted = (Object[])oExtracted;
            int c = aoExtracted.length;
            for (int i = 0; i < c; ++i) {
                if (!ContainsFilter.equals(aoExtracted[i], oValue)) continue;
                return true;
            }
        }
        return false;
    }

    public int calculateEffectiveness(Map mapIndexes, Set setKeys) {
        MapIndex index = (MapIndex)mapIndexes.get(this.getValueExtractor());
        return index == null ? setKeys.size() * EVAL_COST : 1;
    }

    public Filter applyIndex(Map mapIndexes, Set setKeys) {
        MapIndex index = (MapIndex)mapIndexes.get(this.getValueExtractor());
        if (index == null) {
            return this;
        }
        Set setEquals = (Set)index.getIndexContents().get(this.getValue());
        if (setEquals == null || setEquals.isEmpty()) {
            setKeys.clear();
        } else {
            setKeys.retainAll(setEquals);
        }
        return null;
    }
}

