/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.util.filter;

import com.tangosol.util.Filter;
import com.tangosol.util.MapIndex;
import com.tangosol.util.ValueExtractor;
import com.tangosol.util.filter.ComparisonFilter;
import com.tangosol.util.filter.IndexAwareFilter;
import java.util.Map;
import java.util.Set;

public class EqualsFilter
extends ComparisonFilter
implements IndexAwareFilter {
    public EqualsFilter() {
    }

    public EqualsFilter(ValueExtractor extractor, Object oValue) {
        super(extractor, oValue);
    }

    public EqualsFilter(String sMethod, Object oValue) {
        super(sMethod, oValue);
    }

    public EqualsFilter(String sMethod, int iValue) {
        this(sMethod, (Object)EqualsFilter.makeInteger(iValue));
    }

    public EqualsFilter(String sMethod, long lValue) {
        this(sMethod, (Object)EqualsFilter.makeLong(lValue));
    }

    public EqualsFilter(String sMethod, float fValue) {
        this(sMethod, (Object)new Float(fValue));
    }

    public EqualsFilter(String sMethod, double dValue) {
        this(sMethod, (Object)new Double(dValue));
    }

    protected boolean evaluateExtracted(Object oExtracted) {
        return EqualsFilter.equals(oExtracted, this.getValue());
    }

    public int calculateEffectiveness(Map mapIndexes, Set setKeys) {
        MapIndex index = (MapIndex)mapIndexes.get(this.getValueExtractor());
        return index == null ? setKeys.size() * EVAL_COST : 1;
    }

    public Filter applyIndex(Map mapIndexes, Set setKeys) {
        MapIndex index = (MapIndex)mapIndexes.get(this.getValueExtractor());
        if (index == null) {
            return this;
        }
        Set setEquals = (Set)index.getIndexContents().get(this.getValue());
        if (setEquals == null || setEquals.isEmpty()) {
            setKeys.clear();
        } else {
            setKeys.retainAll(setEquals);
        }
        return null;
    }
}

