/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.util.filter;

import com.tangosol.util.Filter;
import com.tangosol.util.MapIndex;
import com.tangosol.util.ValueExtractor;
import com.tangosol.util.filter.ComparisonFilter;
import com.tangosol.util.filter.IndexAwareFilter;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;

public class GreaterEqualsFilter
extends ComparisonFilter
implements IndexAwareFilter {
    public GreaterEqualsFilter() {
    }

    public GreaterEqualsFilter(ValueExtractor extractor, Comparable oValue) {
        super(extractor, (Object)oValue);
    }

    public GreaterEqualsFilter(String sMethod, Comparable oValue) {
        super(sMethod, (Object)oValue);
    }

    public GreaterEqualsFilter(String sMethod, int iValue) {
        this(sMethod, (Comparable)GreaterEqualsFilter.makeInteger(iValue));
    }

    public GreaterEqualsFilter(String sMethod, long lValue) {
        this(sMethod, (Comparable)GreaterEqualsFilter.makeLong(lValue));
    }

    public GreaterEqualsFilter(String sMethod, float fValue) {
        this(sMethod, (Comparable)new Float(fValue));
    }

    public GreaterEqualsFilter(String sMethod, double dValue) {
        this(sMethod, (Comparable)new Double(dValue));
    }

    protected boolean evaluateExtracted(Object oExtracted) {
        try {
            Comparable oLeft = (Comparable)oExtracted;
            Comparable oRight = (Comparable)this.getValue();
            return oLeft != null && oRight != null && oLeft.compareTo(oRight) >= 0;
        }
        catch (ClassCastException e) {
            return false;
        }
    }

    public int calculateEffectiveness(Map mapIndexes, Set setKeys) {
        MapIndex index = (MapIndex)mapIndexes.get(this.getValueExtractor());
        if (index == null) {
            return setKeys.size() * EVAL_COST;
        }
        if (index.isOrdered()) {
            return Math.max(index.getIndexContents().size() / 4, 1);
        }
        return index.getIndexContents().size();
    }

    public Filter applyIndex(Map mapIndexes, Set setKeys) {
        Object oValue = this.getValue();
        if (oValue == null) {
            setKeys.clear();
            return null;
        }
        MapIndex index = (MapIndex)mapIndexes.get(this.getValueExtractor());
        if (index == null) {
            return this;
        }
        if (index.isOrdered()) {
            SortedMap mapContents = (SortedMap)index.getIndexContents();
            SortedMap mapLT = mapContents.headMap(oValue);
            SortedMap mapGE = mapContents.tailMap(oValue);
            if (mapLT.size() < mapGE.size()) {
                Iterator iterLT = mapLT.values().iterator();
                while (iterLT.hasNext()) {
                    Set set = (Set)iterLT.next();
                    setKeys.removeAll(set);
                }
            } else {
                HashSet setGE = new HashSet();
                Iterator iterGE = mapGE.values().iterator();
                while (iterGE.hasNext()) {
                    Set set = (Set)iterGE.next();
                    setGE.addAll(set);
                }
                setKeys.retainAll(setGE);
            }
        } else {
            Map mapContents = index.getIndexContents();
            Iterator iter = mapContents.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                Comparable oTest = (Comparable)entry.getKey();
                if (oTest != null && oTest.compareTo(oValue) >= 0) continue;
                setKeys.removeAll((Set)entry.getValue());
            }
        }
        return null;
    }
}

