/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.util.filter;

import com.tangosol.io.ExternalizableLite;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.io.pof.PortableObject;
import com.tangosol.util.Converter;
import com.tangosol.util.ExternalizableHelper;
import com.tangosol.util.Filter;
import com.tangosol.util.InvocableMapHelper;
import com.tangosol.util.filter.ExtractorFilter;
import com.tangosol.util.filter.IndexAwareFilter;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class InKeySetFilter
extends ExternalizableHelper
implements IndexAwareFilter,
ExternalizableLite,
PortableObject {
    private Filter m_filter;
    private Set m_setKeys;
    private transient boolean m_fConverted;

    public InKeySetFilter() {
    }

    public InKeySetFilter(Filter filter, Set setKeys) {
        this.m_filter = filter;
        this.m_setKeys = setKeys;
    }

    public boolean evaluate(Object o) {
        throw new UnsupportedOperationException();
    }

    public boolean evaluateEntry(Map.Entry entry) {
        return this.m_setKeys.contains(entry.getKey()) && InvocableMapHelper.evaluateEntry(this.m_filter, entry);
    }

    public int calculateEffectiveness(Map mapIndexes, Set setKeys) {
        Filter filter = this.m_filter;
        if (this.m_setKeys.size() < setKeys.size()) {
            setKeys = this.m_setKeys;
        }
        return filter instanceof IndexAwareFilter ? ((IndexAwareFilter)filter).calculateEffectiveness(mapIndexes, setKeys) : setKeys.size() * ExtractorFilter.EVAL_COST;
    }

    public Filter applyIndex(Map mapIndexes, Set setKeys) {
        setKeys.retainAll(this.m_setKeys);
        Filter filter = this.m_filter;
        return filter instanceof IndexAwareFilter ? ((IndexAwareFilter)filter).applyIndex(mapIndexes, setKeys) : null;
    }

    public Filter getFilter() {
        return this.m_filter;
    }

    public synchronized void ensureConverted(Converter converter) {
        if (!this.m_fConverted) {
            HashSet<Object> setConv = new HashSet<Object>();
            Iterator iter = this.m_setKeys.iterator();
            while (iter.hasNext()) {
                setConv.add(converter.convert(iter.next()));
            }
            this.m_setKeys = setConv;
            this.m_fConverted = true;
        }
    }

    public String toString() {
        return "InKeySetFilter(" + this.m_filter + ", keys=" + this.m_setKeys + ')';
    }

    public void readExternal(DataInput in) throws IOException {
        this.m_filter = (Filter)InKeySetFilter.readObject(in);
        this.m_setKeys = new HashSet();
        ExternalizableHelper.readCollection(in, this.m_setKeys, null);
    }

    public void writeExternal(DataOutput out) throws IOException {
        InKeySetFilter.writeObject(out, this.m_filter);
        ExternalizableHelper.writeCollection(out, this.m_setKeys);
    }

    public void readExternal(PofReader in) throws IOException {
        this.m_filter = (Filter)in.readObject(0);
        this.m_setKeys = (Set)in.readCollection(1, new HashSet());
    }

    public void writeExternal(PofWriter out) throws IOException {
        out.writeObject(0, this.m_filter);
        out.writeCollection(1, this.m_setKeys);
    }
}

