/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.util.filter;

import com.tangosol.util.Filter;
import com.tangosol.util.MapIndex;
import com.tangosol.util.ValueExtractor;
import com.tangosol.util.filter.ComparisonFilter;
import com.tangosol.util.filter.IndexAwareFilter;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;

public class LessEqualsFilter
extends ComparisonFilter
implements IndexAwareFilter {
    public LessEqualsFilter() {
    }

    public LessEqualsFilter(ValueExtractor extractor, Comparable oValue) {
        super(extractor, (Object)oValue);
    }

    public LessEqualsFilter(String sMethod, Comparable oValue) {
        super(sMethod, (Object)oValue);
    }

    public LessEqualsFilter(String sMethod, int iValue) {
        this(sMethod, (Comparable)LessEqualsFilter.makeInteger(iValue));
    }

    public LessEqualsFilter(String sMethod, long lValue) {
        this(sMethod, (Comparable)LessEqualsFilter.makeLong(lValue));
    }

    public LessEqualsFilter(String sMethod, float fValue) {
        this(sMethod, (Comparable)new Float(fValue));
    }

    public LessEqualsFilter(String sMethod, double dValue) {
        this(sMethod, (Comparable)new Double(dValue));
    }

    protected boolean evaluateExtracted(Object oExtracted) {
        try {
            Comparable oLeft = (Comparable)oExtracted;
            Comparable oRight = (Comparable)this.getValue();
            return oLeft != null && oRight != null && oLeft.compareTo(oRight) <= 0;
        }
        catch (ClassCastException e) {
            return false;
        }
    }

    public int calculateEffectiveness(Map mapIndexes, Set setKeys) {
        MapIndex index = (MapIndex)mapIndexes.get(this.getValueExtractor());
        if (index == null) {
            return setKeys.size() * EVAL_COST;
        }
        if (index.isOrdered()) {
            return Math.max(index.getIndexContents().size() / 4, 1);
        }
        return index.getIndexContents().size();
    }

    public Filter applyIndex(Map mapIndexes, Set setKeys) {
        block8: {
            MapIndex index;
            Object oValue;
            block6: {
                Set setNULL;
                Set setEQ;
                SortedMap mapGE;
                block7: {
                    oValue = this.getValue();
                    if (oValue == null) {
                        setKeys.clear();
                        return null;
                    }
                    index = (MapIndex)mapIndexes.get(this.getValueExtractor());
                    if (index == null) {
                        return this;
                    }
                    if (!index.isOrdered()) break block6;
                    SortedMap mapContents = (SortedMap)index.getIndexContents();
                    SortedMap mapLT = mapContents.headMap(oValue);
                    mapGE = mapContents.tailMap(oValue);
                    setEQ = (Set)mapContents.get(oValue);
                    setNULL = (Set)mapContents.get(null);
                    if (mapLT.size() >= mapGE.size()) break block7;
                    HashSet setLE = new HashSet();
                    Iterator iterLT = mapLT.values().iterator();
                    while (iterLT.hasNext()) {
                        Set set = (Set)iterLT.next();
                        if (set == setNULL) continue;
                        setLE.addAll(set);
                    }
                    if (setEQ != null) {
                        setLE.addAll(setEQ);
                    }
                    setKeys.retainAll(setLE);
                    break block8;
                }
                Iterator iterGE = mapGE.values().iterator();
                while (iterGE.hasNext()) {
                    Set set = (Set)iterGE.next();
                    if (set == setEQ) continue;
                    setKeys.removeAll(set);
                }
                if (setNULL == null) break block8;
                setKeys.removeAll(setNULL);
                break block8;
            }
            Map mapContents = index.getIndexContents();
            Iterator iter = mapContents.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                Comparable oTest = (Comparable)entry.getKey();
                if (oTest != null && oTest.compareTo(oValue) <= 0) continue;
                setKeys.removeAll((Set)entry.getValue());
            }
        }
        return null;
    }
}

