/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.util.filter;

import com.tangosol.util.Filter;
import com.tangosol.util.MapIndex;
import com.tangosol.util.ValueExtractor;
import com.tangosol.util.filter.ComparisonFilter;
import com.tangosol.util.filter.IndexAwareFilter;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;

public class LessFilter
extends ComparisonFilter
implements IndexAwareFilter {
    public LessFilter() {
    }

    public LessFilter(ValueExtractor extractor, Comparable oValue) {
        super(extractor, (Object)oValue);
    }

    public LessFilter(String sMethod, Comparable oValue) {
        super(sMethod, (Object)oValue);
    }

    public LessFilter(String sMethod, int iValue) {
        this(sMethod, (Comparable)LessFilter.makeInteger(iValue));
    }

    public LessFilter(String sMethod, long lValue) {
        this(sMethod, (Comparable)LessFilter.makeLong(lValue));
    }

    public LessFilter(String sMethod, float fValue) {
        this(sMethod, (Comparable)new Float(fValue));
    }

    public LessFilter(String sMethod, double dValue) {
        this(sMethod, (Comparable)new Double(dValue));
    }

    protected boolean evaluateExtracted(Object oExtracted) {
        try {
            Comparable oLeft = (Comparable)oExtracted;
            Comparable oRight = (Comparable)this.getValue();
            return oLeft != null && oRight != null && oLeft.compareTo(oRight) < 0;
        }
        catch (ClassCastException e) {
            return false;
        }
    }

    public int calculateEffectiveness(Map mapIndexes, Set setKeys) {
        MapIndex index = (MapIndex)mapIndexes.get(this.getValueExtractor());
        if (index == null) {
            return setKeys.size() * EVAL_COST;
        }
        if (index.isOrdered()) {
            return Math.max(index.getIndexContents().size() / 4, 1);
        }
        return index.getIndexContents().size();
    }

    public Filter applyIndex(Map mapIndexes, Set setKeys) {
        block7: {
            MapIndex index;
            Object oValue;
            block5: {
                Set setNULL;
                SortedMap mapGE;
                block6: {
                    oValue = this.getValue();
                    if (oValue == null) {
                        setKeys.clear();
                        return null;
                    }
                    index = (MapIndex)mapIndexes.get(this.getValueExtractor());
                    if (index == null) {
                        return this;
                    }
                    if (!index.isOrdered()) break block5;
                    SortedMap mapContents = (SortedMap)index.getIndexContents();
                    SortedMap mapLT = mapContents.headMap(oValue);
                    mapGE = mapContents.tailMap(oValue);
                    setNULL = (Set)mapContents.get(null);
                    if (mapLT.size() >= mapGE.size()) break block6;
                    HashSet setLT = new HashSet();
                    Iterator iterLT = mapLT.values().iterator();
                    while (iterLT.hasNext()) {
                        Set set = (Set)iterLT.next();
                        if (set == setNULL) continue;
                        setLT.addAll(set);
                    }
                    setKeys.retainAll(setLT);
                    break block7;
                }
                Iterator iterGE = mapGE.values().iterator();
                while (iterGE.hasNext()) {
                    Set set = (Set)iterGE.next();
                    setKeys.removeAll(set);
                }
                if (setNULL == null) break block7;
                setKeys.removeAll(setNULL);
                break block7;
            }
            Map mapContents = index.getIndexContents();
            Iterator iter = mapContents.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                Comparable oTest = (Comparable)entry.getKey();
                if (oTest != null && oTest.compareTo(oValue) < 0) continue;
                setKeys.removeAll((Set)entry.getValue());
            }
        }
        return null;
    }
}

