/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.util.filter;

import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.util.Filter;
import com.tangosol.util.MapIndex;
import com.tangosol.util.SimpleEnumerator;
import com.tangosol.util.ValueExtractor;
import com.tangosol.util.filter.ComparisonFilter;
import com.tangosol.util.filter.IndexAwareFilter;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;

public class LikeFilter
extends ComparisonFilter
implements IndexAwareFilter {
    private static final int ITERATIVE_EVAL = 0;
    private static final int STARTS_WITH_CHAR = 1;
    private static final int STARTS_WITH_STRING = 2;
    private static final int STARTS_WITH_INSENS = 3;
    private static final int ENDS_WITH_CHAR = 4;
    private static final int ENDS_WITH_STRING = 5;
    private static final int ENDS_WITH_INSENS = 6;
    private static final int CONTAINS_CHAR = 7;
    private static final int CONTAINS_STRING = 8;
    private static final int ALWAYS_TRUE = 9;
    private static final int ALWAYS_FALSE = 10;
    private static final int EXACT_MATCH = 11;
    private static final int INSENS_MATCH = 12;
    private static final String[] PLAN_NAMES = new String[]{"iterative evaluation", "starts-with-character", "starts-with-string", "starts-with-string (case-insensitive)", "ends-with-character", "ends-with-string", "ends-with-string (case-insensitive)", "contains-character", "contains-string", "always-true", "always-false", "exact-match", "exact-match (case-insensitive)"};
    private static final Object ANY = new Object();
    private char m_chEscape;
    private boolean m_fIgnoreCase;
    private transient int m_nPlan;
    private transient char m_chPart;
    private transient String m_sPart;
    private transient MatchStep m_stepFront;
    private transient MatchStep m_stepBack;
    private transient boolean m_fTrailingTextAllowed;
    private transient MatchStep[] m_astepMiddle;

    public LikeFilter() {
    }

    public LikeFilter(String sMethod, String sPattern) {
        this(sMethod, sPattern, '\u0000', false);
    }

    public LikeFilter(String sMethod, String sPattern, boolean fIgnoreCase) {
        this(sMethod, sPattern, '\u0000', fIgnoreCase);
    }

    public LikeFilter(String sMethod, String sPattern, char chEscape, boolean fIgnoreCase) {
        super(sMethod, (Object)sPattern);
        this.init(chEscape, fIgnoreCase);
    }

    public LikeFilter(ValueExtractor extractor, String sPattern, char chEscape, boolean fIgnoreCase) {
        super(extractor, (Object)sPattern);
        this.init(chEscape, fIgnoreCase);
    }

    private void init(char chEscape, boolean fIgnoreCase) {
        this.m_chEscape = chEscape;
        this.m_fIgnoreCase = fIgnoreCase;
        this.buildPlan();
    }

    protected boolean evaluateExtracted(Object oExtracted) {
        try {
            String sValue = oExtracted == null ? null : String.valueOf(oExtracted);
            return this.isMatch(sValue);
        }
        catch (ClassCastException e) {
            return false;
        }
    }

    public int calculateEffectiveness(Map mapIndexes, Set setKeys) {
        int nPlan = this.m_nPlan;
        if (nPlan == 10 || nPlan == 9) {
            return 1;
        }
        MapIndex index = (MapIndex)mapIndexes.get(this.getValueExtractor());
        if (index == null) {
            return setKeys.size() * EVAL_COST;
        }
        if (nPlan == 11) {
            return 1;
        }
        String sPattern = this.getPattern();
        if (index.isOrdered() && sPattern.indexOf(37) != 0 && sPattern.indexOf(95) != 0) {
            return Math.max(index.getIndexContents().size() / 4, 1);
        }
        return index.getIndexContents().size();
    }

    public Filter applyIndex(Map mapIndexes, Set setKeys) {
        int nPlan = this.m_nPlan;
        switch (nPlan) {
            case 10: {
                setKeys.clear();
                return null;
            }
            case 9: {
                return null;
            }
        }
        MapIndex index = (MapIndex)mapIndexes.get(this.getValueExtractor());
        if (index == null) {
            return this;
        }
        if (nPlan == 11) {
            Set setEquals = (Set)index.getIndexContents().get(this.getValue());
            if (setEquals == null || setEquals.isEmpty()) {
                setKeys.clear();
            } else {
                setKeys.retainAll(setEquals);
            }
            return null;
        }
        Map mapValues = index.getIndexContents();
        if ((nPlan == 2 || nPlan == 1) && index.isOrdered()) {
            try {
                Map.Entry entry;
                String sValue;
                String sPrefix = nPlan == 2 ? this.m_sPart : String.valueOf(this.m_chPart);
                SortedMap mapTail = ((SortedMap)mapValues).tailMap(sPrefix);
                HashSet setMatch = new HashSet();
                Iterator iter = mapTail.entrySet().iterator();
                while (iter.hasNext() && (sValue = (entry = iter.next()).getKey()).startsWith(sPrefix)) {
                    setMatch.addAll((Set)entry.getValue());
                }
                setKeys.retainAll(setMatch);
                return null;
            }
            catch (ClassCastException e) {
                // empty catch block
            }
        }
        HashSet<Object> setDone = new HashSet<Object>();
        SimpleEnumerator iter = new SimpleEnumerator(setKeys.toArray());
        while (iter.hasNext()) {
            Set setKeysRemove;
            String sValue;
            Object oKey = iter.next();
            Object oValue = index.get(oKey);
            if (setDone.contains(oValue)) continue;
            String string = sValue = oValue == null ? null : String.valueOf(oValue);
            if (!this.isMatch(sValue) && (setKeysRemove = (Set)mapValues.get(oValue)) != null) {
                setKeys.removeAll(setKeysRemove);
                if (setKeys.isEmpty()) break;
            }
            setDone.add(oValue);
        }
        return null;
    }

    public String getPattern() {
        return (String)this.getValue();
    }

    public boolean isIgnoreCase() {
        return this.m_fIgnoreCase;
    }

    public char getEscapeChar() {
        return this.m_chEscape;
    }

    public void showPlan() {
        LikeFilter.out("Plan for case-" + (this.isIgnoreCase() ? "in" : "") + "sensitive LIKE \"" + this.getPattern() + "\" (escape=\"" + this.getEscapeChar() + "\") is \"" + PLAN_NAMES[this.m_nPlan] + "\"");
        LikeFilter.out("initial step: " + this.m_stepFront);
        MatchStep[] astep = this.m_astepMiddle;
        if (astep != null && astep.length > 0) {
            int c = astep.length;
            for (int i = 0; i < c; ++i) {
                LikeFilter.out("step " + (i + 1) + ": " + astep[i]);
            }
        }
        LikeFilter.out("final step: " + this.m_stepBack);
        LikeFilter.out();
    }

    public void readExternal(DataInput in) throws IOException {
        super.readExternal(in);
        this.m_fIgnoreCase = in.readBoolean();
        this.m_chEscape = in.readChar();
        this.buildPlan();
    }

    public void writeExternal(DataOutput out) throws IOException {
        super.writeExternal(out);
        out.writeBoolean(this.m_fIgnoreCase);
        out.writeChar(this.m_chEscape);
    }

    public void readExternal(PofReader in) throws IOException {
        super.readExternal(in);
        this.m_fIgnoreCase = in.readBoolean(2);
        this.m_chEscape = in.readChar(3);
        this.buildPlan();
    }

    public void writeExternal(PofWriter out) throws IOException {
        super.writeExternal(out);
        out.writeBoolean(2, this.m_fIgnoreCase);
        out.writeChar(3, this.m_chEscape);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.buildPlan();
    }

    protected void buildPlan() {
        String sPattern = this.getPattern();
        if (sPattern == null) {
            this.m_nPlan = 10;
            return;
        }
        char[] achPattern = sPattern.toCharArray();
        int cchPattern = achPattern.length;
        char chEscape = this.getEscapeChar();
        boolean fEscape = false;
        boolean fIgnoreCase = this.isIgnoreCase();
        StringBuffer sb = null;
        BitSet bitset = null;
        ArrayList<Object> list = new ArrayList<Object>();
        for (int of = 0; of < cchPattern; ++of) {
            char ch = achPattern[of];
            if (fEscape) {
                fEscape = false;
            } else {
                if (ch == chEscape) {
                    fEscape = true;
                    continue;
                }
                if (ch == '%') {
                    if (sb != null) {
                        list.add(new MatchStep(sb, bitset));
                        sb = null;
                        bitset = null;
                    }
                    if (!list.isEmpty() && list.get(list.size() - 1) == ANY) continue;
                    list.add(ANY);
                    continue;
                }
                if (ch == '_') {
                    if (bitset == null) {
                        bitset = new BitSet();
                    }
                    bitset.set(sb == null ? 0 : sb.length());
                }
            }
            if (sb == null) {
                sb = new StringBuffer();
            }
            sb.append(ch);
        }
        if (fEscape) {
            throw new IllegalArgumentException("pattern ends with an unclosed escape: \"" + sPattern + "\"");
        }
        if (sb != null) {
            list.add(new MatchStep(sb, bitset));
        }
        switch (list.size()) {
            case 0: {
                this.m_nPlan = 11;
                return;
            }
            case 1: {
                Object o = list.get(0);
                if (o == ANY) {
                    this.m_nPlan = 9;
                    return;
                }
                MatchStep matchstep = (MatchStep)o;
                if (!matchstep.isLiteral()) break;
                this.m_nPlan = fIgnoreCase ? 12 : 11;
                return;
            }
            case 2: {
                MatchStep matchstep;
                boolean fStartsWith;
                Object o = list.get(0);
                if (o == ANY) {
                    fStartsWith = false;
                    matchstep = (MatchStep)list.get(1);
                } else {
                    fStartsWith = true;
                    matchstep = (MatchStep)o;
                }
                if (!matchstep.isLiteral()) break;
                if (fIgnoreCase) {
                    this.m_nPlan = fStartsWith ? 3 : 6;
                    this.m_sPart = matchstep.getString();
                } else if (matchstep.getLength() == 1) {
                    this.m_nPlan = fStartsWith ? 1 : 4;
                    this.m_chPart = matchstep.getString().charAt(0);
                } else {
                    this.m_nPlan = fStartsWith ? 2 : 5;
                    this.m_sPart = matchstep.getString();
                }
                return;
            }
            case 3: {
                MatchStep matchstep;
                Object o;
                if (fIgnoreCase || (o = list.get(1)) == ANY || !(matchstep = (MatchStep)o).isLiteral()) break;
                if (matchstep.getLength() == 1) {
                    this.m_nPlan = 7;
                    this.m_chPart = matchstep.getString().charAt(0);
                } else {
                    this.m_nPlan = 8;
                    this.m_sPart = matchstep.getString();
                }
                return;
            }
        }
        this.m_nPlan = 0;
        switch (list.size()) {
            case 0: {
                throw LikeFilter.azzert();
            }
            case 1: {
                this.m_stepFront = (MatchStep)list.get(0);
                this.m_fTrailingTextAllowed = false;
                break;
            }
            case 2: {
                Object step1 = list.get(0);
                Object step2 = list.get(1);
                LikeFilter.azzert(step1 == ANY ^ step2 == ANY);
                if (step1 == ANY) {
                    this.m_stepBack = (MatchStep)step2;
                    this.m_fTrailingTextAllowed = false;
                    break;
                }
                this.m_stepFront = (MatchStep)step1;
                this.m_fTrailingTextAllowed = true;
                break;
            }
            default: {
                Object oLast;
                boolean fLastStepIsAny;
                int cMatchSteps = list.size();
                int ofStartMiddle = 1;
                int ofEndMiddle = cMatchSteps - 2;
                Object oFirst = list.get(0);
                if (oFirst != ANY) {
                    this.m_stepFront = (MatchStep)oFirst;
                    ++ofStartMiddle;
                }
                boolean bl = fLastStepIsAny = (oLast = list.get(cMatchSteps - 1)) == ANY;
                if (!fLastStepIsAny) {
                    this.m_stepBack = (MatchStep)oLast;
                    --ofEndMiddle;
                }
                this.m_fTrailingTextAllowed = fLastStepIsAny;
                int cMatches = (ofEndMiddle - ofStartMiddle) / 2 + 1;
                MatchStep[] aMatches = new MatchStep[cMatches];
                int nMatch = 0;
                for (int of = ofStartMiddle; of <= ofEndMiddle; of += 2) {
                    aMatches[nMatch++] = (MatchStep)list.get(of);
                }
                this.m_astepMiddle = aMatches;
            }
        }
    }

    protected boolean isMatch(String sValue) {
        MatchStep[] amatchstep;
        int cchStep;
        if (sValue == null) {
            return false;
        }
        int cchValue = sValue.length();
        switch (this.m_nPlan) {
            case 1: {
                return cchValue >= 1 && sValue.charAt(0) == this.m_chPart;
            }
            case 2: {
                return sValue.startsWith(this.m_sPart);
            }
            case 3: {
                String sPrefix = this.m_sPart;
                int cchPrefix = sPrefix.length();
                if (cchPrefix > cchValue) {
                    return false;
                }
                return sValue.regionMatches(true, 0, sPrefix, 0, cchPrefix);
            }
            case 4: {
                return cchValue >= 1 && sValue.charAt(cchValue - 1) == this.m_chPart;
            }
            case 5: {
                return sValue.endsWith(this.m_sPart);
            }
            case 6: {
                String sSuffix = this.m_sPart;
                int cchSuffix = sSuffix.length();
                if (cchSuffix > cchValue) {
                    return false;
                }
                return sValue.regionMatches(true, cchValue - cchSuffix, sSuffix, 0, cchSuffix);
            }
            case 7: {
                return sValue.indexOf(this.m_chPart) >= 0;
            }
            case 8: {
                return sValue.indexOf(this.m_sPart) >= 0;
            }
            case 9: {
                return true;
            }
            case 10: {
                return false;
            }
            case 11: {
                return this.getPattern().equals(sValue);
            }
            case 12: {
                return this.getPattern().equalsIgnoreCase(sValue);
            }
        }
        char[] ach = sValue.toCharArray();
        int cch = ach.length;
        int ofBegin = 0;
        int ofEnd = cch;
        MatchStep matchstep = this.m_stepFront;
        if (matchstep != null) {
            cchStep = matchstep.getLength();
            if (cchStep > cch || matchstep.indexOf(ach, ofBegin, cchStep) < 0) {
                return false;
            }
            ofBegin = cchStep;
        }
        if ((matchstep = this.m_stepBack) != null) {
            cchStep = matchstep.getLength();
            int ofStep = cch - cchStep;
            if (ofStep < ofBegin || matchstep.indexOf(ach, ofStep, ofEnd) < 0) {
                return false;
            }
            ofEnd = ofStep;
        }
        if ((amatchstep = this.m_astepMiddle) != null) {
            int c = amatchstep.length;
            for (int i = 0; i < c; ++i) {
                matchstep = amatchstep[i];
                int of = matchstep.indexOf(ach, ofBegin, ofEnd);
                if (of < 0) {
                    return false;
                }
                ofBegin = of + matchstep.getLength();
            }
        }
        return this.m_stepBack != null || this.m_fTrailingTextAllowed || ofBegin == cch;
    }

    private class MatchStep
    implements Serializable {
        private String m_sMatch;
        private char[] m_achMatch;
        private char[] m_achLower;
        private boolean[] m_afAny;
        private int m_cchSkipFront;
        private int m_cchSkipBack;
        private boolean m_fMiddleWilds;

        public MatchStep(StringBuffer sb, BitSet bitset) {
            int cch;
            String sMatch = sb.toString();
            char[] achMatch = sMatch.toCharArray();
            char[] achLower = null;
            boolean[] afAny = null;
            int cchSkipFront = 0;
            int cchSkipBack = 0;
            boolean fMiddleWilds = false;
            if (bitset != null) {
                cch = achMatch.length;
                afAny = new boolean[cch];
                boolean fFront = true;
                int cWilds = 0;
                int cCont = 0;
                for (int i = 0; i < cch; ++i) {
                    if (bitset.get(i)) {
                        afAny[i] = true;
                        if (fFront) {
                            ++cchSkipFront;
                        }
                        ++cWilds;
                        ++cCont;
                        continue;
                    }
                    fFront = false;
                    cCont = 0;
                }
                if (cCont > 0 && cCont < cWilds) {
                    cchSkipBack = cCont;
                }
                boolean bl = fMiddleWilds = cWilds > cchSkipFront + cchSkipBack;
            }
            if (LikeFilter.this.isIgnoreCase()) {
                cch = achMatch.length;
                achLower = new char[cch];
                for (int of = 0; of < cch; ++of) {
                    char ch = achMatch[of];
                    if (afAny == null || !afAny[of]) {
                        achMatch[of] = ch = Character.toUpperCase(ch);
                        ch = Character.toLowerCase(ch);
                    }
                    achLower[of] = ch;
                }
            }
            this.m_sMatch = sMatch;
            this.m_achMatch = achMatch;
            this.m_achLower = achLower;
            this.m_afAny = afAny;
            this.m_cchSkipFront = cchSkipFront;
            this.m_cchSkipBack = cchSkipBack;
            this.m_fMiddleWilds = fMiddleWilds;
        }

        public String getString() {
            return this.m_sMatch;
        }

        public int getLength() {
            return this.m_achMatch.length;
        }

        public boolean isLiteral() {
            return this.m_afAny == null;
        }

        public String toString() {
            return "MatchStep(" + this.m_sMatch + ", " + (this.m_afAny == null ? "exact" : "wild") + ')';
        }

        public int indexOf(char[] ach, int ofBegin, int ofEnd) {
            char[] achMatch = this.m_achMatch;
            int cchMatch = achMatch.length;
            int cch = ofEnd - ofBegin;
            if (cchMatch > cch) {
                return -1;
            }
            int cchSkipFront = this.m_cchSkipFront;
            if (cchSkipFront > 0) {
                if (cchSkipFront == cchMatch) {
                    return ofBegin;
                }
                ofBegin += cchSkipFront;
                ofEnd += cchSkipFront;
            }
            ofEnd -= cchMatch;
            cchMatch -= this.m_cchSkipBack;
            boolean fMiddleWilds = this.m_fMiddleWilds;
            boolean[] afAny = this.m_afAny;
            if (LikeFilter.this.isIgnoreCase()) {
                char[] achLower = this.m_achLower;
                char chFirstUpper = achMatch[cchSkipFront];
                char chFirstLower = achLower[cchSkipFront];
                while (ofBegin <= ofEnd) {
                    block21: {
                        char ch = ach[ofBegin];
                        if (ch == chFirstUpper || ch == chFirstLower) {
                            int ofCur;
                            int ofMatch;
                            if (fMiddleWilds) {
                                ofMatch = cchSkipFront + 1;
                                ofCur = ofBegin + 1;
                                while (ofMatch < cchMatch) {
                                    if (afAny[ofMatch] || (ch = ach[ofCur]) == achMatch[ofMatch] || ch == achLower[ofMatch]) {
                                        ++ofMatch;
                                        ++ofCur;
                                        continue;
                                    }
                                    break block21;
                                }
                            } else {
                                ofMatch = cchSkipFront + 1;
                                ofCur = ofBegin + 1;
                                while (ofMatch < cchMatch) {
                                    ch = ach[ofCur];
                                    if (ch == achMatch[ofMatch] || ch == achLower[ofMatch]) {
                                        ++ofMatch;
                                        ++ofCur;
                                        continue;
                                    }
                                    break block21;
                                }
                            }
                            return ofBegin - cchSkipFront;
                        }
                    }
                    ++ofBegin;
                }
            } else {
                char chFirst = achMatch[cchSkipFront];
                while (ofBegin <= ofEnd) {
                    block22: {
                        if (ach[ofBegin] == chFirst) {
                            int ofCur;
                            int ofMatch;
                            if (fMiddleWilds) {
                                ofMatch = cchSkipFront + 1;
                                ofCur = ofBegin + 1;
                                while (ofMatch < cchMatch) {
                                    if (afAny[ofMatch] || achMatch[ofMatch] == ach[ofCur]) {
                                        ++ofMatch;
                                        ++ofCur;
                                        continue;
                                    }
                                    break block22;
                                }
                            } else {
                                ofMatch = cchSkipFront + 1;
                                ofCur = ofBegin + 1;
                                while (ofMatch < cchMatch) {
                                    if (achMatch[ofMatch] == ach[ofCur]) {
                                        ++ofMatch;
                                        ++ofCur;
                                        continue;
                                    }
                                    break block22;
                                }
                            }
                            return ofBegin - cchSkipFront;
                        }
                    }
                    ++ofBegin;
                }
            }
            return -1;
        }
    }
}

