/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.util.filter;

import com.tangosol.io.ExternalizableLite;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.io.pof.PortableObject;
import com.tangosol.util.ExternalizableHelper;
import com.tangosol.util.Filter;
import com.tangosol.util.MapEvent;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class MapEventFilter
extends ExternalizableHelper
implements Filter,
ExternalizableLite,
PortableObject {
    public static final int E_INSERTED = 1;
    public static final int E_UPDATED = 2;
    public static final int E_DELETED = 4;
    public static final int E_UPDATED_ENTERED = 8;
    public static final int E_UPDATED_LEFT = 16;
    public static final int E_UPDATED_WITHIN = 32;
    public static final int E_ALL = 7;
    public static final int E_KEYSET = 29;
    private static final int[] MASK = new int[4];
    protected int m_nMask;
    protected Filter m_filter;

    public MapEventFilter() {
    }

    public MapEventFilter(int nMask) {
        this(nMask, null);
    }

    public MapEventFilter(Filter filter) {
        this(29, filter);
    }

    public MapEventFilter(int nMask, Filter filter) {
        if ((nMask & 0x3F) == 0) {
            throw new IllegalArgumentException("At least one E_* type must be specified");
        }
        this.m_nMask = nMask;
        this.m_filter = filter;
    }

    public boolean evaluate(Object o) {
        MapEvent event = (MapEvent)o;
        int nId = event.getId();
        int nMask = this.getEventMask();
        try {
            if ((MASK[nId] & nMask) == 0) {
                return false;
            }
        }
        catch (IndexOutOfBoundsException e) {
            return false;
        }
        Filter filter = this.getFilter();
        if (filter == null) {
            return true;
        }
        switch (nId) {
            case 1: {
                return filter.evaluate(event.getNewValue());
            }
            case 2: {
                boolean fNew = filter.evaluate(event.getNewValue());
                switch (nMask & 0x3A) {
                    case 8: {
                        return fNew && !filter.evaluate(event.getOldValue());
                    }
                    case 16: {
                        return !fNew && filter.evaluate(event.getOldValue());
                    }
                    case 24: {
                        return fNew != filter.evaluate(event.getOldValue());
                    }
                    case 32: {
                        return fNew && filter.evaluate(event.getOldValue());
                    }
                    case 40: {
                        return fNew;
                    }
                    case 48: {
                        return filter.evaluate(event.getOldValue());
                    }
                }
                return fNew || filter.evaluate(event.getOldValue());
            }
            case 3: {
                return filter.evaluate(event.getOldValue());
            }
        }
        return false;
    }

    public int getEventMask() {
        return this.m_nMask;
    }

    public Filter getFilter() {
        return this.m_filter;
    }

    public boolean equals(Object o) {
        if (o instanceof MapEventFilter) {
            MapEventFilter that = (MapEventFilter)o;
            return this.m_nMask == that.m_nMask && MapEventFilter.equals(this.m_filter, that.m_filter);
        }
        return false;
    }

    public int hashCode() {
        int nHash = this.m_nMask;
        Filter filter = this.m_filter;
        if (filter != null) {
            nHash += filter.hashCode();
        }
        return nHash;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("MapEventFilter(mask=");
        int nMask = this.getEventMask();
        if (nMask == 7) {
            sb.append("ALL");
        } else if (nMask == 29) {
            sb.append("KEYSET");
        } else {
            if ((nMask & 1) != 0) {
                sb.append("INSERTED|");
            }
            if ((nMask & 2) != 0) {
                sb.append("UPDATED|");
            }
            if ((nMask & 4) != 0) {
                sb.append("DELETED|");
            }
            if ((nMask & 8) != 0) {
                sb.append("UPDATED_ENTERED|");
            }
            if ((nMask & 0x10) != 0) {
                sb.append("UPDATED_LEFT|");
            }
            if ((nMask & 0x20) != 0) {
                sb.append("UPDATED_WITHIN|");
            }
            sb.setLength(sb.length() - 1);
        }
        Filter filter = this.getFilter();
        if (filter != null) {
            sb.append(", filter=").append(filter);
        }
        sb.append(')');
        return sb.toString();
    }

    public void readExternal(DataInput in) throws IOException {
        this.m_nMask = MapEventFilter.readInt(in);
        this.m_filter = (Filter)MapEventFilter.readObject(in);
    }

    public void writeExternal(DataOutput out) throws IOException {
        MapEventFilter.writeInt(out, this.m_nMask);
        MapEventFilter.writeObject(out, this.m_filter);
    }

    public void readExternal(PofReader in) throws IOException {
        this.m_nMask = in.readInt(0);
        this.m_filter = (Filter)in.readObject(1);
    }

    public void writeExternal(PofWriter out) throws IOException {
        out.writeInt(0, this.m_nMask);
        out.writeObject(1, this.m_filter);
    }

    static {
        MapEventFilter.MASK[1] = 1;
        MapEventFilter.MASK[2] = 58;
        MapEventFilter.MASK[3] = 4;
    }
}

