/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.util.filter;

import com.tangosol.io.ExternalizableLite;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.io.pof.PortableObject;
import com.tangosol.util.DeltaSet;
import com.tangosol.util.ExternalizableHelper;
import com.tangosol.util.Filter;
import com.tangosol.util.InvocableMapHelper;
import com.tangosol.util.filter.AndFilter;
import com.tangosol.util.filter.EntryFilter;
import com.tangosol.util.filter.ExtractorFilter;
import com.tangosol.util.filter.IndexAwareFilter;
import com.tangosol.util.filter.KeyFilter;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Map;
import java.util.Set;

public class NotFilter
extends ExternalizableHelper
implements Filter,
EntryFilter,
IndexAwareFilter,
ExternalizableLite,
PortableObject {
    private Filter m_filter;

    public NotFilter() {
    }

    public NotFilter(Filter filter) {
        this.m_filter = filter;
    }

    public boolean evaluate(Object o) {
        return !this.m_filter.evaluate(o);
    }

    public boolean evaluateEntry(Map.Entry entry) {
        return !InvocableMapHelper.evaluateEntry(this.m_filter, entry);
    }

    public int calculateEffectiveness(Map mapIndexes, Set setKeys) {
        Filter filter = this.m_filter;
        return filter instanceof IndexAwareFilter ? ((IndexAwareFilter)filter).calculateEffectiveness(mapIndexes, setKeys) : setKeys.size() * ExtractorFilter.EVAL_COST;
    }

    public Filter applyIndex(Map mapIndexes, Set setKeys) {
        Filter filter = this.m_filter;
        if (filter instanceof IndexAwareFilter) {
            DeltaSet setDelta = new DeltaSet(setKeys);
            Filter filterNew = ((IndexAwareFilter)filter).applyIndex(mapIndexes, setDelta);
            NotFilter.azzert(setDelta.getAdded().isEmpty());
            Set setRemoved = setDelta.getRemoved();
            if (filterNew == null || setDelta.isEmpty()) {
                if (setRemoved.isEmpty()) {
                    setKeys.clear();
                } else if (!setDelta.isEmpty()) {
                    setKeys.retainAll(setRemoved);
                }
                return null;
            }
            if (setRemoved.isEmpty()) {
                return filterNew == filter ? this : new NotFilter(filterNew);
            }
            KeyFilter filterKey = new KeyFilter(setRemoved);
            NotFilter filterNot = filterNew == filter ? this : new NotFilter(filterNew);
            return new AndFilter(filterKey, filterNot);
        }
        return this;
    }

    public Filter getFilter() {
        return this.m_filter;
    }

    public String toString() {
        return "NotFilter: !(" + this.m_filter + ')';
    }

    public void readExternal(DataInput in) throws IOException {
        this.m_filter = (Filter)NotFilter.readObject(in);
    }

    public void writeExternal(DataOutput out) throws IOException {
        NotFilter.writeObject(out, this.m_filter);
    }

    public void readExternal(PofReader in) throws IOException {
        this.m_filter = (Filter)in.readObject(0);
    }

    public void writeExternal(PofWriter out) throws IOException {
        out.writeObject(0, this.m_filter);
    }
}

