/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.util.internal;

import com.tangosol.util.AtomicCounter;
import java.util.concurrent.atomic.AtomicLong;

public class ConcurrentCounter
extends AtomicCounter {
    protected AtomicLong m_counter = new AtomicLong();

    public long getCount() {
        return this.m_counter.get();
    }

    public boolean setCount(long cAssume, long cNew) {
        return this.m_counter.compareAndSet(cAssume, cNew);
    }

    public long setCount(long cNew) {
        return this.m_counter.getAndSet(cNew);
    }

    protected long adjust(long c) {
        return this.m_counter.addAndGet(c);
    }

    protected long postAdjust(long c) {
        return this.m_counter.getAndAdd(c);
    }

    public static void testImpl(int nThreads, final long lBatch, int cIters) {
        final AtomicLong atl = new AtomicLong();
        for (int j = 0; j < cIters || cIters < 0; ++j) {
            int i;
            atl.set(0L);
            Thread[] aTest = new Thread[nThreads];
            for (i = 0; i < nThreads; ++i) {
                aTest[i] = new Thread(){

                    public void run() {
                        long lStep = lBatch / Math.abs(lBatch);
                        for (long i = 0L; i != lBatch; i += lStep) {
                            long lNext;
                            long lCur;
                            while (!atl.compareAndSet(lCur = atl.get(), lNext = lCur + lStep)) {
                            }
                        }
                    }
                };
            }
            for (i = 0; i < nThreads; ++i) {
                aTest[i].start();
            }
            for (i = 0; i < nThreads; ++i) {
                try {
                    aTest[i].join();
                    continue;
                }
                catch (InterruptedException e) {
                    ConcurrentCounter.ensureRuntimeException(e);
                }
            }
            long lValue = atl.get();
            if (lValue % lBatch == 0L) continue;
            throw new IllegalStateException("AtomicLong is broken, value is " + lValue);
        }
    }

    public static void main(String[] asArg) {
        try {
            int nThreads = asArg.length > 0 ? Integer.parseInt(asArg[0]) : 10;
            long lBatch = asArg.length > 1 ? Long.parseLong(asArg[1]) : 10000L;
            int cIters = asArg.length > 2 ? Integer.parseInt(asArg[2]) : 1000;
            System.out.println("Testing java.util.concurrent.atomic.AtomicLong on:");
            System.out.println("\t Java Version:   " + System.getProperty("java.version"));
            System.out.println("\t Vendor:         " + System.getProperty("java.vm.vendor"));
            System.out.println("\t VM Version:     " + System.getProperty("java.vm.version"));
            System.out.println("\t VM name:        " + System.getProperty("java.vm.name"));
            System.out.println("\t Processors:     " + Runtime.getRuntime().availableProcessors());
            System.out.println("\t Threads:        " + nThreads);
            System.out.println("\t Batch:          " + lBatch);
            System.out.println("\t Iterations:     " + cIters);
            ConcurrentCounter.testImpl(nThreads, lBatch, cIters);
            System.out.println("\nTest passed.");
        }
        catch (Exception e) {
            System.out.println("");
            e.printStackTrace();
        }
    }
}

