/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.util.internal;

import com.tangosol.util.AtomicCounter;
import sun.misc.AtomicLong;

public class SunMiscCounter
extends AtomicCounter {
    protected AtomicLong m_counter;
    protected static boolean s_fUseable = SunMiscCounter.testUseable();
    protected static String s_sReason;

    public SunMiscCounter() {
        if (!SunMiscCounter.isUseable()) {
            throw new RuntimeException(SunMiscCounter.getReason());
        }
        this.m_counter = AtomicLong.newAtomicLong((long)0L);
    }

    public long getCount() {
        return this.m_counter.get();
    }

    public boolean setCount(long cAssume, long cNew) {
        return this.m_counter.attemptUpdate(cAssume, cNew);
    }

    public long setCount(long cNew) {
        long lCurr;
        AtomicLong counter = this.m_counter;
        while (!counter.attemptUpdate(lCurr = counter.get(), cNew)) {
        }
        return lCurr;
    }

    protected long adjust(long c) {
        long lNew;
        long lCurr;
        AtomicLong counter = this.m_counter;
        while (!counter.attemptUpdate(lCurr = counter.get(), lNew = lCurr + c)) {
        }
        return lNew;
    }

    protected long postAdjust(long c) {
        long lNew;
        long lCurr;
        AtomicLong counter = this.m_counter;
        while (!counter.attemptUpdate(lCurr = counter.get(), lNew = lCurr + c)) {
        }
        return lCurr;
    }

    public static boolean isUseable() {
        return s_fUseable;
    }

    public static boolean testUseable() {
        String sAllow = System.getProperty("tangosol.coherence.atomiccounter.sunmisc");
        if (sAllow == null) {
            String sVendor = System.getProperty("java.vm.vendor", "");
            String sVersion = System.getProperty("java.version", "");
            String sVmName = System.getProperty("java.vm.name", "");
            if (Runtime.getRuntime().availableProcessors() > 1 && sVmName.indexOf("HotSpot") != -1 && sVmName.indexOf("Client VM") != -1 && sVersion.startsWith("1.4")) {
                s_sReason = "Run the JVM in server mode (include -server on command line) to fix this issue.";
                return false;
            }
            if (sVendor.indexOf("BEA") != -1) {
                s_sReason = "Though safe to ignore, you may upgrade to BEA's 1.5 JVM to fix this issue.";
                return false;
            }
            return true;
        }
        return Boolean.valueOf(sAllow);
    }

    public static String getReason() {
        return s_sReason;
    }

    public static void testImpl(int nThreads, final long lBatch, int cIters) {
        final AtomicLong atl = AtomicLong.newAtomicLong((long)0L);
        for (int j = 0; j < cIters || cIters < 0; ++j) {
            int i;
            while (!atl.attemptSet(0L)) {
            }
            Thread[] aTest = new Thread[nThreads];
            for (i = 0; i < nThreads; ++i) {
                aTest[i] = new Thread(){

                    public void run() {
                        long lStep = lBatch / Math.abs(lBatch);
                        for (long i = 0L; i != lBatch; i += lStep) {
                            long lNext;
                            long lCur;
                            while (!atl.attemptUpdate(lCur = atl.get(), lNext = lCur + lStep)) {
                            }
                        }
                    }
                };
            }
            for (i = 0; i < nThreads; ++i) {
                aTest[i].start();
            }
            for (i = 0; i < nThreads; ++i) {
                try {
                    aTest[i].join();
                    continue;
                }
                catch (InterruptedException e) {
                    SunMiscCounter.ensureRuntimeException(e);
                }
            }
            long lValue = atl.get();
            if (lValue % lBatch == 0L) continue;
            throw new IllegalStateException("AtomicLong is broken, value is " + lValue);
        }
    }

    public static void main(String[] asArg) {
        try {
            int nThreads = asArg.length > 0 ? Integer.parseInt(asArg[0]) : 10;
            long lBatch = asArg.length > 1 ? Long.parseLong(asArg[1]) : 10000L;
            int cIters = asArg.length > 2 ? Integer.parseInt(asArg[2]) : 1000;
            System.out.println("Testing sun.misc.AtomicLong on:");
            System.out.println("\t Java Version:   " + System.getProperty("java.version"));
            System.out.println("\t Vendor:         " + System.getProperty("java.vm.vendor"));
            System.out.println("\t VM Version:     " + System.getProperty("java.vm.version"));
            System.out.println("\t VM name:        " + System.getProperty("java.vm.name"));
            System.out.println("\t Processors:     " + Runtime.getRuntime().availableProcessors());
            System.out.println("\t Threads:        " + nThreads);
            System.out.println("\t Batch:          " + lBatch);
            System.out.println("\t Iterations:     " + cIters);
            System.out.println("\t Implementation: " + AtomicLong.newAtomicLong((long)0L).getClass());
            SunMiscCounter.testImpl(nThreads, lBatch, cIters);
            System.out.println("\nTest passed.");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

