/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.util.processor;

import com.tangosol.io.ExternalizableLite;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.io.pof.PortableObject;
import com.tangosol.util.ExternalizableHelper;
import com.tangosol.util.InvocableMap;
import com.tangosol.util.processor.AbstractProcessor;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class CompositeProcessor
extends AbstractProcessor
implements ExternalizableLite,
PortableObject {
    private static final InvocableMap.EntryProcessor[] EMPTY_PROCESSOR_ARRAY = new InvocableMap.EntryProcessor[0];
    protected InvocableMap.EntryProcessor[] m_aProcessor;

    public CompositeProcessor() {
    }

    public CompositeProcessor(InvocableMap.EntryProcessor[] aProcessor) {
        CompositeProcessor.azzert(aProcessor != null, "Processor array is null");
        this.m_aProcessor = aProcessor;
    }

    public Object process(InvocableMap.Entry entry) {
        InvocableMap.EntryProcessor[] aProcessor = this.m_aProcessor;
        int cProcessors = aProcessor.length;
        Object[] aoResult = new Object[cProcessors];
        for (int i = 0; i < cProcessors; ++i) {
            aoResult[i] = aProcessor[i].process(entry);
        }
        return aoResult;
    }

    public boolean equals(Object o) {
        if (o instanceof CompositeProcessor) {
            CompositeProcessor that = (CompositeProcessor)o;
            return CompositeProcessor.equalsDeep(this.m_aProcessor, that.m_aProcessor);
        }
        return false;
    }

    public int hashCode() {
        InvocableMap.EntryProcessor[] aProcessor = this.m_aProcessor;
        int cProcessors = aProcessor.length;
        int iHash = 0;
        for (int i = 0; i < cProcessors; ++i) {
            iHash += aProcessor[i].hashCode();
        }
        return iHash;
    }

    public String toString() {
        return "CompositeProcessor(" + CompositeProcessor.toDelimitedString(this.m_aProcessor, ", ") + ')';
    }

    public void readExternal(DataInput in) throws IOException {
        int cProcessors = ExternalizableHelper.readInt(in);
        InvocableMap.EntryProcessor[] aProcessor = new InvocableMap.EntryProcessor[cProcessors];
        for (int i = 0; i < cProcessors; ++i) {
            aProcessor[i] = (InvocableMap.EntryProcessor)ExternalizableHelper.readObject(in);
        }
        this.m_aProcessor = aProcessor;
    }

    public void writeExternal(DataOutput out) throws IOException {
        InvocableMap.EntryProcessor[] aProcessor = this.m_aProcessor;
        int cProcessors = aProcessor.length;
        ExternalizableHelper.writeInt(out, cProcessors);
        for (int i = 0; i < cProcessors; ++i) {
            ExternalizableHelper.writeObject(out, aProcessor[i]);
        }
    }

    public void readExternal(PofReader in) throws IOException {
        this.m_aProcessor = (InvocableMap.EntryProcessor[])in.readObjectArray(0, EMPTY_PROCESSOR_ARRAY);
    }

    public void writeExternal(PofWriter out) throws IOException {
        out.writeObjectArray(0, this.m_aProcessor);
    }
}

