/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.util.processor;

import com.tangosol.io.ExternalizableLite;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.io.pof.PortableObject;
import com.tangosol.util.ExternalizableHelper;
import com.tangosol.util.Filter;
import com.tangosol.util.InvocableMap;
import com.tangosol.util.InvocableMapHelper;
import com.tangosol.util.processor.AbstractProcessor;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class ConditionalProcessor
extends AbstractProcessor
implements ExternalizableLite,
PortableObject {
    protected Filter m_filter;
    protected InvocableMap.EntryProcessor m_processor;

    public ConditionalProcessor() {
    }

    public ConditionalProcessor(Filter filter, InvocableMap.EntryProcessor processor) {
        ConditionalProcessor.azzert(filter != null && processor != null, "Both filter and processor must be specified");
        this.m_filter = filter;
        this.m_processor = processor;
    }

    public Object process(InvocableMap.Entry entry) {
        if (InvocableMapHelper.evaluateEntry(this.m_filter, entry)) {
            return this.m_processor.process(entry);
        }
        return null;
    }

    public boolean equals(Object o) {
        if (o instanceof ConditionalProcessor) {
            ConditionalProcessor that = (ConditionalProcessor)o;
            return ConditionalProcessor.equals(this.m_filter, that.m_filter) && ConditionalProcessor.equals(this.m_processor, that.m_processor);
        }
        return false;
    }

    public int hashCode() {
        return this.m_filter.hashCode() + this.m_processor.hashCode();
    }

    public String toString() {
        return "ConditionalProcessor(" + this.m_filter + ", " + this.m_processor + ')';
    }

    public void readExternal(DataInput in) throws IOException {
        this.m_filter = (Filter)ExternalizableHelper.readObject(in);
        this.m_processor = (InvocableMap.EntryProcessor)ExternalizableHelper.readObject(in);
    }

    public void writeExternal(DataOutput out) throws IOException {
        ExternalizableHelper.writeObject(out, this.m_filter);
        ExternalizableHelper.writeObject(out, this.m_processor);
    }

    public void readExternal(PofReader in) throws IOException {
        this.m_filter = (Filter)in.readObject(0);
        this.m_processor = (InvocableMap.EntryProcessor)in.readObject(1);
    }

    public void writeExternal(PofWriter out) throws IOException {
        out.writeObject(0, this.m_filter);
        out.writeObject(1, this.m_processor);
    }
}

