/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.util.processor;

import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.util.ExternalizableHelper;
import com.tangosol.util.InvocableMap;
import com.tangosol.util.processor.NumberIncrementor;
import com.tangosol.util.processor.PropertyManipulator;
import com.tangosol.util.processor.PropertyProcessor;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;

public class NumberMultiplier
extends PropertyProcessor {
    private Number m_numFactor;
    private boolean m_fPostFactor;

    public NumberMultiplier() {
    }

    public NumberMultiplier(String sName, Number numFactor, boolean fPostFactor) {
        super(sName);
        NumberMultiplier.azzert(numFactor != null);
        this.m_numFactor = numFactor;
        this.m_fPostFactor = fPostFactor;
    }

    public NumberMultiplier(PropertyManipulator manipulator, Number numFactor, boolean fPostFactor) {
        super(manipulator);
        NumberMultiplier.azzert(numFactor != null);
        this.m_numFactor = numFactor;
        this.m_fPostFactor = fPostFactor;
    }

    /*
     * WARNING - void declaration
     */
    public Object process(InvocableMap.Entry entry) {
        void var4_8;
        Number numNew;
        if (!entry.isPresent()) {
            return null;
        }
        Number numFactor = this.m_numFactor;
        Number numOld = (Number)this.get(entry);
        if (numOld == null) {
            Number number = numFactor instanceof Integer ? (Number)NumberIncrementor.INTEGER_ZERO : (Number)(numFactor instanceof Long ? (Number)NumberIncrementor.LONG_ZERO : (Number)(numFactor instanceof Double ? (Number)NumberIncrementor.DOUBLE_ZERO : (Number)(numFactor instanceof Float ? (Number)NumberIncrementor.FLOAT_ZERO : (Number)(numFactor instanceof BigInteger ? (Number)NumberIncrementor.BIGINTEGER_ZERO : (Number)(numFactor instanceof BigDecimal ? (Number)NumberIncrementor.BIGDECIMAL_ZERO : (Number)(numFactor instanceof Short ? (Number)NumberIncrementor.SHORT_ZERO : (Number)(numOld = numFactor instanceof Byte ? NumberIncrementor.BYTE_ZERO : null)))))));
        }
        if (numOld instanceof Integer) {
            int iNew = numOld.intValue();
            iNew = numFactor instanceof Double || numFactor instanceof Float ? (int)((double)iNew * numFactor.doubleValue()) : (iNew *= numFactor.intValue());
            numNew = NumberMultiplier.makeInteger(iNew);
        } else if (numOld instanceof Long) {
            long lNew = numOld.longValue();
            lNew = numFactor instanceof Double || numFactor instanceof Float ? (long)((double)lNew * numFactor.doubleValue()) : (lNew *= numFactor.longValue());
            numNew = NumberMultiplier.makeLong(lNew);
        } else if (numOld instanceof Double) {
            numNew = new Double(numOld.doubleValue() * numFactor.doubleValue());
        } else if (numOld instanceof Float) {
            numNew = new Float(numOld.floatValue() * numFactor.floatValue());
        } else if (numOld instanceof BigInteger) {
            numNew = ((BigInteger)numOld).multiply((BigInteger)numFactor);
        } else if (numOld instanceof BigDecimal) {
            numNew = ((BigDecimal)numOld).multiply((BigDecimal)numFactor);
        } else if (numOld instanceof Short) {
            short iNew = numOld.shortValue();
            iNew = numFactor instanceof Double || numFactor instanceof Float ? (short)((double)iNew * numFactor.doubleValue()) : (short)(iNew * numFactor.shortValue());
            numNew = new Short(iNew);
        } else if (numOld instanceof Byte) {
            byte bNew = numOld.byteValue();
            bNew = numFactor instanceof Double || numFactor instanceof Float ? (byte)((double)bNew * numFactor.doubleValue()) : (byte)(bNew * numFactor.byteValue());
            numNew = new Byte(bNew);
        } else {
            throw new RuntimeException("Unsupported type:" + (numOld == null ? numFactor.getClass().getName() : numOld.getClass().getName()));
        }
        if (!var4_8.equals(numOld)) {
            this.set(entry, var4_8);
        }
        return this.m_fPostFactor ? numOld : var4_8;
    }

    protected String getDescription() {
        return (this.m_fPostFactor ? ", post" : ", pre") + "-factor=" + this.m_numFactor;
    }

    public void readExternal(DataInput in) throws IOException {
        super.readExternal(in);
        this.m_numFactor = (Number)ExternalizableHelper.readObject(in);
        this.m_fPostFactor = in.readBoolean();
    }

    public void writeExternal(DataOutput out) throws IOException {
        super.writeExternal(out);
        ExternalizableHelper.writeObject(out, this.m_numFactor);
        out.writeBoolean(this.m_fPostFactor);
    }

    public void readExternal(PofReader in) throws IOException {
        super.readExternal(in);
        this.m_numFactor = (Number)in.readObject(1);
        this.m_fPostFactor = in.readBoolean(2);
    }

    public void writeExternal(PofWriter out) throws IOException {
        super.writeExternal(out);
        out.writeObject(1, this.m_numFactor);
        out.writeBoolean(2, this.m_fPostFactor);
    }
}

