/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.util.processor;

import com.tangosol.io.ExternalizableLite;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.io.pof.PortableObject;
import com.tangosol.util.Base;
import com.tangosol.util.ValueExtractor;
import com.tangosol.util.ValueManipulator;
import com.tangosol.util.ValueUpdater;
import com.tangosol.util.extractor.AbstractExtractor;
import com.tangosol.util.extractor.ChainedExtractor;
import com.tangosol.util.extractor.CompositeUpdater;
import com.tangosol.util.extractor.ReflectionExtractor;
import com.tangosol.util.extractor.ReflectionUpdater;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class PropertyManipulator
extends Base
implements ValueManipulator,
ExternalizableLite,
PortableObject {
    protected String m_sName;
    protected boolean m_fUseIs;
    protected transient ValueExtractor m_extractorPart;
    protected transient ValueExtractor m_extractor;
    protected transient ValueUpdater m_updater;

    public PropertyManipulator() {
    }

    public PropertyManipulator(String sName) {
        this(sName, false);
    }

    public PropertyManipulator(String sName, boolean fUseIs) {
        PropertyManipulator.azzert(sName != null && sName.length() > 0);
        this.m_sName = sName;
        this.m_fUseIs = fUseIs;
    }

    public ValueExtractor getExtractor() {
        ValueExtractor extractor = this.m_extractor;
        if (extractor == null) {
            this.init();
            extractor = this.m_extractor;
        }
        return extractor;
    }

    public ValueUpdater getUpdater() {
        ValueUpdater updater = this.m_updater;
        if (updater == null) {
            this.init();
            updater = this.m_updater;
        }
        return updater;
    }

    protected void init() {
        String sName = this.m_sName;
        int ofLast = sName.lastIndexOf(46);
        String sProp = sName.substring(ofLast + 1);
        AbstractExtractor extractor = new ReflectionExtractor((this.m_fUseIs ? "is" : "get") + sProp);
        Base updater = new ReflectionUpdater("set" + sProp);
        if (ofLast > 0) {
            String[] asProp = PropertyManipulator.parseDelimitedString(sName.substring(0, ofLast), '.');
            int cParts = asProp.length;
            ValueExtractor[] veGet = new ValueExtractor[cParts + 1];
            ValueExtractor[] vePut = new ValueExtractor[cParts];
            for (int i = 0; i < cParts; ++i) {
                veGet[i] = vePut[i] = new ReflectionExtractor("get" + asProp[i]);
            }
            veGet[cParts] = extractor;
            extractor = new ChainedExtractor(veGet);
            updater = new CompositeUpdater(cParts == 1 ? vePut[0] : new ChainedExtractor(vePut), (ValueUpdater)((Object)updater));
        }
        this.m_extractor = extractor;
        this.m_updater = updater;
    }

    public boolean equals(Object o) {
        if (o instanceof PropertyManipulator) {
            PropertyManipulator that = (PropertyManipulator)o;
            return this.m_sName.equals(that.m_sName) && this.m_fUseIs == that.m_fUseIs;
        }
        return false;
    }

    public int hashCode() {
        return this.m_sName.hashCode();
    }

    public String toString() {
        return "PropertyManipulator(" + this.m_sName + ')';
    }

    public void readExternal(DataInput in) throws IOException {
        this.m_sName = in.readUTF();
        this.m_fUseIs = in.readBoolean();
    }

    public void writeExternal(DataOutput out) throws IOException {
        out.writeUTF(this.m_sName);
        out.writeBoolean(this.m_fUseIs);
    }

    public void readExternal(PofReader in) throws IOException {
        this.m_sName = in.readString(0);
        this.m_fUseIs = in.readBoolean(1);
    }

    public void writeExternal(PofWriter out) throws IOException {
        out.writeString(0, this.m_sName);
        out.writeBoolean(1, this.m_fUseIs);
    }
}

