/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.util.processor;

import com.tangosol.io.ExternalizableLite;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.io.pof.PortableObject;
import com.tangosol.util.ClassHelper;
import com.tangosol.util.ExternalizableHelper;
import com.tangosol.util.InvocableMap;
import com.tangosol.util.Versionable;
import com.tangosol.util.processor.AbstractProcessor;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class VersionedPut
extends AbstractProcessor
implements ExternalizableLite,
PortableObject {
    protected Versionable m_oValue;
    protected boolean m_fInsert;
    protected boolean m_fReturn;

    public VersionedPut() {
    }

    public VersionedPut(Versionable oValue) {
        this(oValue, false, false);
    }

    public VersionedPut(Versionable oValue, boolean fAllowInsert, boolean fReturn) {
        this.m_oValue = oValue;
        this.m_fInsert = fAllowInsert;
        this.m_fReturn = fReturn;
    }

    public Object process(InvocableMap.Entry entry) {
        boolean fMatch;
        Versionable oValueCur = (Versionable)entry.getValue();
        Versionable oValueNew = this.m_oValue;
        if (oValueCur == null) {
            fMatch = this.m_fInsert;
        } else {
            Comparable verNew;
            Comparable verCur = oValueCur.getVersionIndicator();
            boolean bl = fMatch = verCur.compareTo(verNew = oValueNew.getVersionIndicator()) == 0;
        }
        if (fMatch) {
            oValueNew.incrementVersion();
            entry.setValue(oValueNew, false);
            return null;
        }
        return this.m_fReturn ? oValueCur : null;
    }

    public boolean equals(Object o) {
        if (o instanceof VersionedPut) {
            VersionedPut that = (VersionedPut)o;
            return VersionedPut.equals(this.m_oValue, that.m_oValue) && this.m_fInsert == that.m_fInsert && this.m_fReturn == that.m_fReturn;
        }
        return false;
    }

    public int hashCode() {
        return this.m_oValue.hashCode() + (this.m_fInsert ? 1 : 2) + (this.m_fReturn ? 3 : 4);
    }

    public String toString() {
        return ClassHelper.getSimpleName(this.getClass()) + "{Value=" + this.m_oValue + ", InsertAllowed= " + this.m_fInsert + ", ReturnRequired= " + this.m_fReturn + '}';
    }

    public void readExternal(DataInput in) throws IOException {
        this.m_oValue = (Versionable)ExternalizableHelper.readObject(in);
        this.m_fInsert = in.readBoolean();
        this.m_fReturn = in.readBoolean();
    }

    public void writeExternal(DataOutput out) throws IOException {
        ExternalizableHelper.writeObject(out, this.m_oValue);
        out.writeBoolean(this.m_fInsert);
        out.writeBoolean(this.m_fReturn);
    }

    public void readExternal(PofReader in) throws IOException {
        this.m_oValue = (Versionable)in.readObject(0);
        this.m_fInsert = in.readBoolean(1);
        this.m_fReturn = in.readBoolean(2);
    }

    public void writeExternal(PofWriter out) throws IOException {
        out.writeObject(0, this.m_oValue);
        out.writeBoolean(1, this.m_fInsert);
        out.writeBoolean(2, this.m_fReturn);
    }
}

