/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.admin.actions;

import com.atlassian.config.ApplicationConfiguration;
import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.atlassian.confluence.event.events.admin.LicenceUpdatedEvent;
import com.atlassian.confluence.util.GeneralUtil;
import com.atlassian.confluence.util.UserChecker;
import com.atlassian.event.Event;
import com.atlassian.license.License;
import com.atlassian.license.LicenseException;
import com.atlassian.license.LicenseManager;
import com.atlassian.license.LicensePair;
import com.atlassian.license.LicenseUtils;
import com.atlassian.license.decoder.LicenseDecoder;
import com.opensymphony.util.TextUtils;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.log4j.Logger;

public abstract class AbstractUpdateLicenseAction
extends ConfluenceActionSupport {
    private static final Logger log = Logger.getLogger(AbstractUpdateLicenseAction.class);
    private String licenseString;
    private DateFormat dateFormatter = new SimpleDateFormat("dd MMM yyyy");
    private ApplicationConfiguration applicationConfig;
    private UserChecker userChecker;
    private boolean licenseSubmitted = false;

    public License getLicense() {
        return LicenseManager.getInstance().getLicense("CONF");
    }

    public void setApplicationConfig(ApplicationConfiguration applicationConfig) {
        this.applicationConfig = applicationConfig;
    }

    public String getLicenseString() {
        return this.licenseString;
    }

    public void setLicenseString(String licenseString) {
        this.licenseString = licenseString;
    }

    public UserChecker getUserChecker() {
        return this.userChecker;
    }

    public void setUserChecker(UserChecker userChecker) {
        this.userChecker = userChecker;
    }

    public Date getSupportPeriodEnd() {
        return new Date(LicenseUtils.getSupportPeriodEnd((License)this.getLicense()));
    }

    public boolean isHasSupportPeriodExpired() {
        return new Date().after(this.getSupportPeriodEnd());
    }

    public void validate() {
        super.validate();
        if (!TextUtils.stringSet((String)this.licenseString)) {
            this.addFieldError("licenseString", this.getText("license.invalid.notsupplied"));
        }
    }

    public String doUpdate() throws Exception {
        LicensePair pair;
        try {
            pair = new LicensePair(this.licenseString);
        }
        catch (LicenseException e) {
            log.warn((Object)"The license you specified was invalid.");
            this.addFieldError("licenseString", this.getText("license.invalid.error", new Object[]{e.getMessage()}));
            return "error";
        }
        License updatedLicense = LicenseDecoder.getLicense((LicensePair)pair, (String)"CONF");
        if (updatedLicense == null) {
            log.warn((Object)"The license you specified was invalid.");
            this.addFieldError("licenseString", this.getText("license.invalid.and.not.updated"));
            return "error";
        }
        Date supportPeriodEndDate = new Date(LicenseUtils.getSupportPeriodEnd((License)updatedLicense));
        String supportPeriodEndDateString = this.dateFormatter.format(supportPeriodEndDate);
        String partnerErrorMessage = GeneralUtil.checkPartnerDetails(updatedLicense, GeneralUtil.getBuildPartner());
        if (GeneralUtil.getBuildDate().after(supportPeriodEndDate)) {
            log.warn((Object)"The license you specified was invalid.");
            this.addFieldError("licenseString", this.getText("confluence.support.for.license.ended", new Object[]{supportPeriodEndDateString}));
            return "error";
        }
        if (TextUtils.stringSet((String)partnerErrorMessage)) {
            log.fatal((Object)"License does not match partner");
            this.addFieldError("licenseString", partnerErrorMessage);
            return "error";
        }
        LicenseManager.getInstance().setLicense(this.licenseString, "CONF");
        this.applicationConfig.save();
        this.eventManager.publishEvent((Event)new LicenceUpdatedEvent(this, updatedLicense));
        this.licenseString = "";
        this.userChecker.resetResult();
        return "success";
    }

    public boolean isLicenseSubmitted() {
        return this.licenseSubmitted;
    }

    public void setLicenseSubmitted(boolean licenseSubmitted) {
        this.licenseSubmitted = licenseSubmitted;
    }
}

