/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.admin.actions;

import com.atlassian.confluence.core.Administrative;
import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.atlassian.confluence.event.events.admin.GlobalSettingsChangedEvent;
import com.atlassian.confluence.setup.BootstrapManager;
import com.atlassian.confluence.setup.settings.Settings;
import com.atlassian.event.Event;
import com.atlassian.license.License;
import com.atlassian.license.LicenseManager;
import com.atlassian.license.LicenseUtils;
import com.atlassian.mail.MailFactory;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Category;

public class AdministrationConsoleAction
extends ConfluenceActionSupport
implements Administrative {
    private static final Category log = Category.getInstance(AdministrationConsoleAction.class);
    private String displayEmailAdminMessage;
    private String displayBaseUrlAdminMessage;
    private String displayAlmostSupportPeriodEndMessage;
    private String displaySupportPeriodEndMessage;
    private Date supportPeriodEndDate;
    private Date almostSupportPeriodEndDate;
    private String supportPeriodEndDateString;
    private DateFormat dateFormatter = new SimpleDateFormat("dd MMM yyyy");
    private BootstrapManager bootstrapManager;
    private LicenseManager licenseManager;

    public String execute() {
        this.setSupportPeriodDates();
        Settings originalSettings = this.settingsManager.getGlobalSettings();
        if ("off".equals(this.displayEmailAdminMessage)) {
            this.settingsManager.getGlobalSettings().setEmailAdminMessageOff(true);
        } else if (this.checkEmailConfiguration()) {
            this.setDisplayEmailAdminMessage("on");
        }
        if ("off".equals(this.displayBaseUrlAdminMessage)) {
            this.settingsManager.getGlobalSettings().setBaseUrlAdminMessageOff(true);
        } else if (this.checkDomainName()) {
            this.setDisplayBaseUrlAdminMessage("on");
        }
        if ("off".equals(this.displayAlmostSupportPeriodEndMessage)) {
            this.settingsManager.getGlobalSettings().setAlmostSupportPeriodEndMessageOff(true);
        } else if (this.checkAlmostSupportPeriodEnd()) {
            this.setDisplayAlmostSupportPeriodEndMessage("on");
        }
        this.settingsManager.updateGlobalSettings(this.settingsManager.getGlobalSettings());
        this.eventManager.publishEvent((Event)new GlobalSettingsChangedEvent(this, originalSettings, this.settingsManager.getGlobalSettings(), this.settingsManager.getGlobalSettings().getBaseUrl(), this.settingsManager.getGlobalSettings().getBaseUrl()));
        if (this.getActionErrors().size() != 0) {
            return "error";
        }
        return "success";
    }

    public String doDefault() {
        this.setSupportPeriodDates();
        if (this.checkEmailConfiguration()) {
            this.setDisplayEmailAdminMessage("on");
        }
        if (this.checkDomainName()) {
            this.setDisplayBaseUrlAdminMessage("on");
        }
        if (this.checkAlmostSupportPeriodEnd()) {
            this.setDisplayAlmostSupportPeriodEndMessage("on");
        }
        if (this.checkSupportPeriodEnd()) {
            this.setDisplaySupportPeriodEndMessage("on");
        }
        return "input";
    }

    private void setSupportPeriodDates() {
        License license = LicenseManager.getInstance().getLicense("CONF");
        this.almostSupportPeriodEndDate = new Date(LicenseUtils.getSupportPeriodAlmostExpiredDate((License)license));
        this.supportPeriodEndDate = new Date(LicenseUtils.getSupportPeriodEnd((License)license));
        this.supportPeriodEndDateString = this.dateFormatter.format(this.supportPeriodEndDate);
    }

    private boolean checkAlmostSupportPeriodEnd() {
        return new Date().after(this.almostSupportPeriodEndDate) && new Date().before(this.supportPeriodEndDate) && !this.settingsManager.getGlobalSettings().isAlmostSupportPeriodEndMessageOff();
    }

    private boolean checkSupportPeriodEnd() {
        return new Date().after(this.supportPeriodEndDate);
    }

    public boolean checkEmailConfiguration() {
        try {
            if (MailFactory.getServerManager().getSmtpMailServers().size() == 0 && !this.settingsManager.getGlobalSettings().isEmailAdminMessageOff()) {
                return true;
            }
        }
        catch (Exception e) {
            this.addActionError(this.getText("error.checking.mailserver.configuration") + e);
            log.error((Object)("Could not count mail servers: " + e), (Throwable)e);
        }
        return false;
    }

    public boolean checkDomainName() {
        String addy = this.bootstrapManager.getBaseUrl();
        addy = addy.replaceAll("\\.", "");
        addy = addy.replaceAll("\\/confluence", "");
        addy = addy.replaceAll("http:\\/\\/", "");
        addy = addy.replaceAll(":", "");
        long ip = -1L;
        try {
            ip = Long.parseLong(addy);
        }
        catch (NumberFormatException e) {
            log.debug((Object)("Error converting " + addy + " to numeric"), (Throwable)e);
        }
        if (ip != -1L || addy.indexOf("localhost") != -1) {
            return !this.settingsManager.getGlobalSettings().isBaseUrlAdminMessageOff();
        }
        return false;
    }

    public boolean isUsingDailyBackup() {
        String backupPath = this.getBootstrapManager().getFilePathProperty("daily.backup.dir");
        return StringUtils.isNotEmpty((String)backupPath);
    }

    public BootstrapManager getBootstrapManager() {
        return this.bootstrapManager;
    }

    public void setBootstrapManager(BootstrapManager bootstrapManager) {
        this.bootstrapManager = bootstrapManager;
    }

    public String getDisplayEmailAdminMessage() {
        return this.displayEmailAdminMessage;
    }

    public void setDisplayEmailAdminMessage(String displayEmailAdminMessage) {
        this.displayEmailAdminMessage = displayEmailAdminMessage;
    }

    public String getDisplayBaseUrlAdminMessage() {
        return this.displayBaseUrlAdminMessage;
    }

    public void setDisplayBaseUrlAdminMessage(String displayBaseUrlAdminMessage) {
        this.displayBaseUrlAdminMessage = displayBaseUrlAdminMessage;
    }

    public String getDisplayAlmostSupportPeriodEndMessage() {
        return this.displayAlmostSupportPeriodEndMessage;
    }

    public void setDisplayAlmostSupportPeriodEndMessage(String displayAlmostSupportPeriodEndMessage) {
        this.displayAlmostSupportPeriodEndMessage = displayAlmostSupportPeriodEndMessage;
    }

    public LicenseManager getLicenseManager() {
        return this.licenseManager;
    }

    public void setLicenseManager(LicenseManager licenseManager) {
        this.licenseManager = licenseManager;
    }

    public String getDisplaySupportPeriodEndMessage() {
        return this.displaySupportPeriodEndMessage;
    }

    public void setDisplaySupportPeriodEndMessage(String displaySupportPeriodEndMessage) {
        this.displaySupportPeriodEndMessage = displaySupportPeriodEndMessage;
    }

    public String getSupportPeriodEndDateString() {
        return this.supportPeriodEndDateString;
    }

    public void setSupportPeriodEndDateString(String supportPeriodEndDateString) {
        this.supportPeriodEndDateString = supportPeriodEndDateString;
    }
}

