/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.admin.actions;

import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.core.util.ClassLoaderUtils;
import com.atlassian.util.profiling.UtilTimerStack;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigureLog4jAction
extends ConfluenceActionSupport {
    private List<LoggingConfigEntry> entries;
    private static final Logger log = Logger.getLogger(ConfigureLog4jAction.class);
    private static final String HIBERNATE_CLASS_NAME = "net.sf.hibernate.SQL";
    private String[] classNames;
    private String[] levelNames;
    private String extraClassName;
    private String extraLevelName;
    private String toDeleteName;
    private String profileName;
    private static final String LOGLEVEL_DEFAULT = "loglevel.production";

    public void setToDeleteName(String toDeleteName) {
        this.toDeleteName = toDeleteName;
    }

    public String execute() {
        this.setupEntries();
        return "success";
    }

    private void setupEntries() {
        List<Logger> listLoggers = this.makeListOfExplicitLoggers();
        listLoggers.add(Logger.getRootLogger());
        this.entries = new ArrayList<LoggingConfigEntry>(listLoggers.size());
        this.classNames = new String[listLoggers.size()];
        this.levelNames = new String[listLoggers.size()];
        for (Logger log : listLoggers) {
            this.entries.add(new LoggingConfigEntry(log.getName(), log.getLevel()));
        }
    }

    private List<Logger> makeListOfExplicitLoggers() {
        Enumeration loggers = LogManager.getCurrentLoggers();
        ArrayList<Logger> listLoggers = new ArrayList<Logger>();
        while (loggers.hasMoreElements()) {
            Logger log = (Logger)loggers.nextElement();
            if (log.getLevel() == null) continue;
            listLoggers.add(log);
        }
        Collections.sort(listLoggers, new Comparator<Logger>(){

            @Override
            public int compare(Logger logger1, Logger logger2) {
                return logger1.getName().compareTo(logger2.getName());
            }
        });
        return listLoggers;
    }

    public List<String> getLevelTypes() {
        ArrayList<String> levels = new ArrayList<String>();
        levels.add("ALL");
        levels.add("DEBUG");
        levels.add("INFO");
        levels.add("WARN");
        levels.add("ERROR");
        levels.add("FATAL");
        return levels;
    }

    public String delete() {
        if (this.toDeleteName.equals("root")) {
            this.addActionError("You cannot delete the root logger");
            this.setupEntries();
            return "error";
        }
        LogManager.getLogger((String)this.toDeleteName).setLevel(null);
        return "success";
    }

    public String save() {
        for (int i = 0; i < this.classNames.length; ++i) {
            this.setLevelForLogger(this.classNames[i], this.levelNames[i]);
        }
        log.debug((Object)"New log configuration saved");
        return "success";
    }

    private void setLevelForLogger(String className, String levelName) {
        LoggingConfigEntry configEntry = new LoggingConfigEntry(className, levelName);
        if (configEntry.isRoot()) {
            LogManager.getRootLogger().setLevel(configEntry.level);
        } else {
            LogManager.getLogger((String)configEntry.getClazz()).setLevel(configEntry.level);
        }
    }

    public String add() {
        if (StringUtils.isBlank((String)this.extraClassName)) {
            this.addActionError("Please specify a valid name for the logger");
            this.setupEntries();
            return "error";
        }
        this.setLevelForLogger(this.extraClassName, this.extraLevelName);
        log.debug((Object)("New logger [ " + this.extraClassName + " ] saved"));
        return "success";
    }

    public List getEntries() {
        return this.entries;
    }

    public void setEntries(List<LoggingConfigEntry> entries) {
        this.entries = entries;
    }

    public void setClassNames(String[] classNames) {
        this.classNames = classNames;
    }

    public void setLevelNames(String[] levelNames) {
        this.levelNames = levelNames;
    }

    public void setExtraClassName(String extraClassName) {
        this.extraClassName = extraClassName;
    }

    public void setExtraLevelName(String extraLevelName) {
        this.extraLevelName = extraLevelName;
    }

    public String turnOnHibernateLogging() {
        this.setLevelForLogger(HIBERNATE_CLASS_NAME, "DEBUG");
        return "success";
    }

    public String turnOffHibernateLogging() {
        LogManager.getLogger((String)HIBERNATE_CLASS_NAME).setLevel(null);
        return "success";
    }

    public boolean isHibernateLoggingEnabled() {
        return LogManager.getLogger((String)HIBERNATE_CLASS_NAME).isDebugEnabled();
    }

    public void setProfileName(String profileName) {
        this.profileName = profileName;
    }

    public String changeProfile() {
        InputStream propStream = ClassLoaderUtils.getResourceAsStream((String)this.getPropertiesResource(this.profileName), ConfigureLog4jAction.class);
        if (propStream == null) {
            return this.handleError();
        }
        Properties props = new Properties();
        try {
            props.load(propStream);
        }
        catch (IOException e) {
            return this.handleError();
        }
        LogManager.resetConfiguration();
        PropertyConfigurator.configure((Properties)props);
        return "success";
    }

    private String getPropertiesResource(String profileName) {
        if (this.getText(LOGLEVEL_DEFAULT).equals(profileName) || StringUtils.isEmpty((String)profileName)) {
            return "log4j.properties";
        }
        return "log4j-" + profileName.toLowerCase() + ".properties";
    }

    private String handleError() {
        this.getActionErrors().add("Unable to load properties for profile : " + this.profileName);
        this.setupEntries();
        return "error";
    }

    public boolean isProfilingEnabled() {
        return UtilTimerStack.isActive();
    }

    @Override
    public boolean isPermitted() {
        return this.permissionManager.hasPermission(this.getRemoteUser(), Permission.ADMINISTER, PermissionManager.TARGET_SYSTEM);
    }

    public static class LoggingConfigEntry
    implements Comparable {
        private static final String ROOT = "root";
        private String clazz;
        private Level level;

        public LoggingConfigEntry() {
        }

        public boolean isRoot() {
            return this.clazz.equals(ROOT);
        }

        public LoggingConfigEntry(String clazz, Level level) {
            this.clazz = clazz;
            this.level = level;
        }

        public LoggingConfigEntry(String clazz, String level) {
            this.clazz = clazz;
            this.level = Level.toLevel((String)level);
        }

        public String getClazz() {
            return this.clazz;
        }

        public String getLevel() {
            return this.level.toString();
        }

        public void setClazz(String clazz) {
            this.clazz = clazz;
        }

        public void setLevel(String level) {
            this.level = Level.toLevel((String)level);
        }

        public int compareTo(Object o) {
            return this.clazz.compareTo(((LoggingConfigEntry)o).getClazz());
        }
    }
}

