/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.admin.actions;

import com.atlassian.confluence.core.Administrative;
import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.atlassian.confluence.core.UploadedResource;
import com.atlassian.confluence.util.FontManager;
import com.atlassian.xwork.FileUploadUtils;
import org.apache.fop.apps.FOPException;
import org.apache.log4j.Category;
import org.springframework.core.io.Resource;

public class ConfigurePDFLanguageSupportAction
extends ConfluenceActionSupport
implements Administrative {
    private static final Category log = Category.getInstance(ConfigurePDFLanguageSupportAction.class);
    private FontManager fontManager;
    private boolean installFontSuccess = false;

    public String execute() throws Exception {
        try {
            this.fontManager.installFont((Resource)new UploadedResource(FileUploadUtils.getSingleUploadedFile()));
        }
        catch (Exception e) {
            log.error((Object)"Unable to install language font", (Throwable)e);
            this.addActionError(e.getMessage());
            return "error";
        }
        return "success";
    }

    public String doRestoreDefault() {
        try {
            this.fontManager.restoreDefaultFont();
        }
        catch (FOPException e) {
            log.error((Object)"Unable to restore default font", (Throwable)e);
            this.addActionError(e.getMessage());
            return "error";
        }
        return "success";
    }

    public String getInstalledFontName() {
        return this.fontManager.getCurrentFont();
    }

    public void setFontManager(FontManager fontManager) {
        this.fontManager = fontManager;
    }

    public boolean isInstallFontSuccess() {
        return this.installFontSuccess;
    }

    public void setInstallFontSuccess(boolean installFontSuccess) {
        this.installFontSuccess = installFontSuccess;
    }
}

