/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.admin.actions;

import com.atlassian.config.ConfigurationException;
import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.atlassian.confluence.event.events.admin.ConfigurationEvent;
import com.atlassian.confluence.event.events.admin.GlobalSettingsChangedEvent;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.setup.settings.Settings;
import com.atlassian.event.Event;
import com.opensymphony.util.TextUtils;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;

public class DailyBackupAdminAction
extends ConfluenceActionSupport {
    private String backupPath;
    private boolean backupAttachments;
    private String backupOption;
    private String dailyBackupFilePrefix;
    private String dailyBackupDateFormatPattern;

    public void validate() {
        if (TextUtils.stringSet((String)this.getBackupOption()) && "custom".equals(this.getBackupOption())) {
            if (!TextUtils.stringSet((String)this.getBackupPath())) {
                this.addActionError("Backup path is a required field.");
            } else {
                File backupPathFile = new File(this.getBackupPath());
                if (!backupPathFile.exists()) {
                    this.addActionError("Backup path specified does not exist.");
                } else if (!backupPathFile.isDirectory()) {
                    this.addActionError("The backup path cannot be file.");
                } else if (!backupPathFile.canWrite()) {
                    this.addActionError("Confluence does not have permissions to write to the backup directory specified.");
                }
            }
        }
        if (!TextUtils.stringSet((String)this.getDailyBackupFilePrefix())) {
            this.addActionError("You must specify a value for the daily backup file prefix.");
        }
        try {
            new SimpleDateFormat(this.getDailyBackupDateFormatPattern());
        }
        catch (IllegalArgumentException e) {
            this.addActionError("Daily backup date pattern invalid.");
        }
    }

    public String doDefault() throws Exception {
        this.backupPath = this.getBootstrapManager().getFilePathProperty("daily.backup.dir");
        this.backupAttachments = this.settingsManager.getGlobalSettings().isBackupAttachmentsDaily();
        this.dailyBackupFilePrefix = this.settingsManager.getGlobalSettings().getDailyBackupFilePrefix();
        this.dailyBackupDateFormatPattern = this.settingsManager.getGlobalSettings().getDailyBackupDateFormatPattern();
        this.backupOption = !TextUtils.stringSet((String)this.backupPath) ? "disable" : (this.getDefaultBackupPath().equals(this.backupPath) ? "default" : "custom");
        return "success";
    }

    public boolean isPermitted() {
        return this.permissionManager.hasPermission(this.getRemoteUser(), Permission.ADMINISTER, PermissionManager.TARGET_SYSTEM);
    }

    public String execute() throws Exception {
        this.eventManager.publishEvent((Event)new ConfigurationEvent(this));
        return "success";
    }

    public String getDefaultBackupPath() {
        return this.getBootstrapManager().getConfluenceHome() + System.getProperty("file.separator") + "backups";
    }

    public String doEdit() throws ConfigurationException {
        Settings originalSettings = this.settingsManager.getGlobalSettings();
        if ("disable".equals(this.backupOption)) {
            this.getBootstrapManager().removeProperty("daily.backup.dir");
        } else if ("default".equals(this.backupOption)) {
            this.getBootstrapManager().setProperty("daily.backup.dir", this.getDefaultBackupPath());
        } else {
            this.getBootstrapManager().setProperty("daily.backup.dir", this.getBackupPath());
        }
        this.getBootstrapManager().save();
        this.settingsManager.getGlobalSettings().setBackupAttachmentsDaily(this.isBackupAttachments());
        this.settingsManager.getGlobalSettings().setDailyBackupFilePrefix(this.getDailyBackupFilePrefix());
        this.settingsManager.getGlobalSettings().setDailyBackupDateFormatPattern(this.getDailyBackupDateFormatPattern());
        this.settingsManager.updateGlobalSettings(this.settingsManager.getGlobalSettings());
        this.eventManager.publishEvent((Event)new GlobalSettingsChangedEvent(this, originalSettings, this.settingsManager.getGlobalSettings(), this.settingsManager.getGlobalSettings().getBaseUrl(), this.settingsManager.getGlobalSettings().getBaseUrl()));
        return "success";
    }

    public String getExampleOfDatePattern() {
        return new SimpleDateFormat(this.getDailyBackupDateFormatPattern()).format(new Date());
    }

    public String getBackupPath() {
        return this.backupPath;
    }

    public void setBackupPath(String backupPath) {
        this.backupPath = backupPath;
    }

    public boolean isBackupAttachments() {
        return this.backupAttachments;
    }

    public void setBackupAttachments(boolean backupAttachments) {
        this.backupAttachments = backupAttachments;
    }

    public String getBackupOption() {
        return this.backupOption;
    }

    public void setBackupOption(String backupOption) {
        this.backupOption = backupOption;
    }

    public String getDailyBackupFilePrefix() {
        return this.dailyBackupFilePrefix;
    }

    public void setDailyBackupFilePrefix(String dailyBackupFilePrefix) {
        this.dailyBackupFilePrefix = dailyBackupFilePrefix;
    }

    public String getDailyBackupDateFormatPattern() {
        return this.dailyBackupDateFormatPattern;
    }

    public void setDailyBackupDateFormatPattern(String dailyBackupDateFormatPattern) {
        this.dailyBackupDateFormatPattern = dailyBackupDateFormatPattern;
    }
}

