/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.admin.actions;

import com.atlassian.confluence.core.Administrative;
import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.atlassian.confluence.core.FormatSettingsManager;
import com.atlassian.confluence.event.events.admin.GlobalSettingsChangedEvent;
import com.atlassian.confluence.renderer.PageContext;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionCheckDispatcher;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.setup.settings.Settings;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.spaces.SpaceType;
import com.atlassian.confluence.util.GeneralUtil;
import com.atlassian.confluence.util.http.ConfluenceHttpParameters;
import com.atlassian.confluence.velocity.htmlsafe.HtmlSafe;
import com.atlassian.core.util.FileSize;
import com.atlassian.core.util.PairType;
import com.atlassian.event.Event;
import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.WikiStyleRenderer;
import com.atlassian.spring.container.ContainerManager;
import com.opensymphony.util.TextUtils;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class GeneralConfigurationAction
extends ConfluenceActionSupport
implements Administrative {
    private SpaceManager spaceManager;
    private WikiStyleRenderer wikiStyleRenderer;
    private FormatSettingsManager formatSettingsManager;
    private boolean allowCamelCase;
    private boolean allowTrackbacks;
    private boolean allowRemoteApi;
    private boolean allowRemoteApiAnonymous;
    private boolean antiXssMode;
    private boolean allowPublicSignup;
    private boolean viewSpaceGoesToSpaceSummary;
    private boolean externalUserManagement;
    private boolean allowThreadedComments;
    private boolean nofollowExternalLinks;
    private boolean enableWysiwyg;
    private boolean useWysiwygByDefault;
    private boolean gzipResponseEncoding;
    private boolean displayLinkIcons;
    private int numberOfBreadcrumbAncestors;
    private int maxAttachmentsInUI;
    private long attachmentMaxSize;
    private int draftSaveIntervalMinutes;
    private int draftSaveIntervalSeconds;
    private static final int DRAFT_SAVE_MIN = 10000;
    private String siteHomePage;
    private String siteTitle;
    private String siteWelcomeMessage;
    private String emailAddressVisibility;
    private String indexingLanguage;
    private String domainName;
    private String siteSupportAddress;
    private String defaultEncoding;
    private String defaultTimeFormatterPattern;
    private String defaultDayFormatterPattern;
    private String defaultDateTimeFormatterPattern;
    private String defaultDateFormatterPattern;
    private String defaultLongNumberFormatterPattern;
    private String defaultDecimalNumberFormatterPattern;
    private List emailAddressVisibilityTypes;
    private int socketTimeout;
    private int connectionTimeout;
    private boolean connectionsEnabled;
    private int maxThumbHeight;
    private int maxThumbWidth;

    public String doDefault() throws Exception {
        this.viewSpaceGoesToSpaceSummary = this.getGlobalSettings().isViewSpaceGoesToSpaceSummary();
        this.allowCamelCase = this.getGlobalSettings().isAllowCamelCase();
        this.allowTrackbacks = this.getGlobalSettings().isAllowTrackbacks();
        this.allowRemoteApi = this.getGlobalSettings().isAllowRemoteApi();
        this.allowRemoteApiAnonymous = this.getGlobalSettings().isAllowRemoteApiAnonymous();
        this.antiXssMode = this.getGlobalSettings().isAntiXssMode();
        this.allowPublicSignup = !this.getGlobalSettings().isDenyPublicSignup();
        this.allowThreadedComments = this.getGlobalSettings().isAllowThreadedComments();
        this.externalUserManagement = this.getGlobalSettings().isExternalUserManagement();
        this.emailAddressVisibility = this.getGlobalSettings().getEmailAddressVisibility();
        this.siteWelcomeMessage = this.getGlobalSettings().getSiteWelcomeMessage();
        this.siteHomePage = this.getGlobalSettings().getSiteHomePage();
        this.siteTitle = this.getGlobalSettings().getSiteTitle();
        this.siteSupportAddress = this.getGlobalSettings().getSupportRequestEmail();
        this.maxAttachmentsInUI = this.getGlobalSettings().getMaxAttachmentsInUI();
        this.attachmentMaxSize = this.getGlobalSettings().getAttachmentMaxSize();
        int draftSaveInterval = this.getGlobalSettings().getDraftSaveInterval();
        this.draftSaveIntervalMinutes = draftSaveInterval / 1000 / 60;
        this.draftSaveIntervalSeconds = draftSaveInterval / 1000 - this.draftSaveIntervalMinutes * 60;
        this.defaultEncoding = this.getGlobalSettings().getDefaultEncoding();
        this.maxThumbHeight = this.getGlobalSettings().getMaxThumbHeight();
        this.maxThumbWidth = this.getGlobalSettings().getMaxThumbWidth();
        this.indexingLanguage = this.getGlobalSettings().getIndexingLanguage();
        this.domainName = this.settingsManager.getGlobalSettings().getBaseUrl();
        this.nofollowExternalLinks = this.getGlobalSettings().isNofollowExternalLinks();
        this.enableWysiwyg = this.getGlobalSettings().isEnableWysiwyg();
        this.useWysiwygByDefault = this.getGlobalSettings().isUseWysiwygByDefault();
        this.numberOfBreadcrumbAncestors = this.getGlobalSettings().getNumberOfBreadcrumbAncestors();
        this.gzipResponseEncoding = this.getGlobalSettings().isGzippingResponse();
        this.displayLinkIcons = this.getGlobalSettings().isDisplayLinkIcons();
        this.defaultTimeFormatterPattern = this.formatSettingsManager.getTimeFormat();
        this.defaultDayFormatterPattern = this.formatSettingsManager.getDayFormat();
        this.defaultDateTimeFormatterPattern = this.formatSettingsManager.getDateTimeFormat();
        this.defaultDateFormatterPattern = this.formatSettingsManager.getDateFormat();
        this.defaultLongNumberFormatterPattern = this.formatSettingsManager.getLongNumberFormat();
        this.defaultDecimalNumberFormatterPattern = this.formatSettingsManager.getDecimalNumberFormat();
        ConfluenceHttpParameters httpParameters = this.getGlobalSettings().getConfluenceHttpParameters();
        this.socketTimeout = httpParameters.getSocketTimeout();
        this.connectionTimeout = httpParameters.getConnectionTimeout();
        this.connectionsEnabled = httpParameters.isEnabled();
        return super.doDefault();
    }

    private void validation() {
        try {
            new String(new byte[0], this.getDefaultEncoding());
            Charset cs = Charset.forName(this.getDefaultEncoding());
            this.setDefaultEncoding(cs.name());
        }
        catch (UnsupportedEncodingException e) {
            this.addFieldError("defaultEncoding", this.getText("error.encoding.not.supported"));
        }
        catch (UnsupportedCharsetException e) {
            this.addFieldError("defaultEncoding", this.getText("error.encoding.not.supported"));
        }
        if (!TextUtils.stringSet((String)this.domainName) && this.isSystemAdmin()) {
            this.addFieldError("domainName", this.getText("error.enter.domain.name"));
        }
        if (this.getDraftSaveInterval() < 10000) {
            Object[] args = new String[]{GeneralUtil.getNiceDuration(0, 10)};
            this.addFieldError("draftSaveInterval", this.getText("error.minimum.draft.interval", args));
        }
    }

    public String execute() throws Exception {
        this.validation();
        if (this.hasErrors()) {
            return "error";
        }
        Settings originalSettings = this.settingsManager.getGlobalSettings();
        String oldDomainName = this.settingsManager.getGlobalSettings().getBaseUrl();
        this.saveSetupOptions();
        this.saveFormattingSettings();
        GlobalSettingsChangedEvent event = new GlobalSettingsChangedEvent(this, originalSettings, this.settingsManager.getGlobalSettings(), oldDomainName, this.settingsManager.getGlobalSettings().getBaseUrl());
        this.eventManager.publishEvent((Event)event);
        return "success";
    }

    private void saveSetupOptions() {
        Settings settings = new Settings(this.getGlobalSettings());
        settings.setAllowThreadedComments(this.allowThreadedComments);
        settings.setAllowCamelCase(this.allowCamelCase);
        settings.setAllowTrackbacks(this.allowTrackbacks);
        settings.setAllowRemoteApiAnonymous(this.allowRemoteApiAnonymous);
        settings.setAnitXssMode(this.antiXssMode);
        settings.setViewSpaceGoesToSpaceSummary(this.viewSpaceGoesToSpaceSummary);
        settings.setNofollowExternalLinks(this.nofollowExternalLinks);
        settings.setEnableWysiwyg(this.enableWysiwyg);
        settings.setUseWysiwygByDefault(this.useWysiwygByDefault);
        settings.setNumberOfBreadcrumbAncestors(this.numberOfBreadcrumbAncestors);
        settings.setGzippingResponse(this.gzipResponseEncoding);
        if (this.allowPublicSignupHasChanged()) {
            ((PermissionCheckDispatcher)ContainerManager.getComponent((String)"permissionCheckDispatcher")).clearCache();
        }
        settings.setEmailAddressVisibility(this.emailAddressVisibility);
        settings.setMaxAttachmentsInUI(this.maxAttachmentsInUI);
        settings.setAttachmentMaxSize(this.attachmentMaxSize);
        settings.setDraftSaveInterval(this.getDraftSaveInterval());
        settings.setSiteHomePage("dashboard".equals(this.siteHomePage) ? null : this.siteHomePage);
        settings.setSiteWelcomeMessage(this.siteWelcomeMessage);
        settings.setSiteTitle(this.siteTitle);
        settings.setDefaultEncoding(TextUtils.stringSet((String)this.getDefaultEncoding()) ? this.getDefaultEncoding() : "UTF-8");
        settings.setMaxThumbHeight(this.getMaxThumbHeight());
        settings.setMaxThumbWidth(this.getMaxThumbWidth());
        settings.setIndexingLanguage(this.getIndexingLanguage());
        settings.setDisplayLinkIcons(this.displayLinkIcons);
        settings.setSupportRequestEmail(this.siteSupportAddress);
        if (this.isSystemAdmin()) {
            settings.setBaseUrl(this.getDomainName());
            settings.setAllowRemoteApi(this.allowRemoteApi);
            settings.setExternalUserManagement(this.externalUserManagement);
            settings.setDenyPublicSignup(!this.allowPublicSignup);
        }
        ConfluenceHttpParameters httpParameters = settings.getConfluenceHttpParameters();
        httpParameters.setConnectionTimeout(this.connectionTimeout);
        httpParameters.setSocketTimeout(this.socketTimeout);
        httpParameters.setEnabled(this.connectionsEnabled);
        this.settingsManager.updateGlobalSettings(settings);
    }

    public boolean isSystemAdmin() {
        return this.permissionManager.hasPermission(this.getRemoteUser(), Permission.ADMINISTER, PermissionManager.TARGET_SYSTEM);
    }

    private boolean allowPublicSignupHasChanged() {
        return this.getGlobalSettings().isDenyPublicSignup() == this.allowPublicSignup;
    }

    private void saveFormattingSettings() {
        try {
            new DecimalFormat(this.defaultLongNumberFormatterPattern);
        }
        catch (IllegalArgumentException e) {
            this.addFieldError("defaultLongNumberFormatterPattern", this.getText("invalid.pattern"));
        }
        try {
            new DecimalFormat(this.defaultDecimalNumberFormatterPattern);
        }
        catch (IllegalArgumentException e) {
            this.addFieldError("defaultDecimalNumberFormatterPattern", this.getText("invalid.pattern"));
        }
        this.formatSettingsManager.setTimeFormat(this.defaultTimeFormatterPattern);
        this.formatSettingsManager.setDayFormat(this.defaultDayFormatterPattern);
        this.formatSettingsManager.setDateTimeFormat(this.defaultDateTimeFormatterPattern);
        this.formatSettingsManager.setDateFormat(this.defaultDateFormatterPattern);
        this.formatSettingsManager.setLongNumberFormat(this.defaultLongNumberFormatterPattern);
        this.formatSettingsManager.setDecimalNumberFormat(this.defaultDecimalNumberFormatterPattern);
    }

    public SpaceManager getSpaceManager() {
        return this.spaceManager;
    }

    public void setSpaceManager(SpaceManager spaceManager) {
        this.spaceManager = spaceManager;
    }

    public void setWikiStyleRenderer(WikiStyleRenderer wikiStyleRenderer) {
        this.wikiStyleRenderer = wikiStyleRenderer;
    }

    public List getSiteHomePages() {
        ArrayList<PairType> siteHomePages = new ArrayList<PairType>();
        siteHomePages.add(new PairType((Serializable)((Object)this.getText("dashboard")), (Serializable)((Object)"dashboard")));
        boolean isGlobalAnonymousAccessEnabled = this.spacePermissionManager.hasPermission("USECONFLUENCE", null, null);
        List allSpaces = this.spaceManager.getSpacesByType(SpaceType.GLOBAL);
        for (int i = 0; i < allSpaces.size(); ++i) {
            Space space = (Space)allSpaces.get(i);
            if ((!isGlobalAnonymousAccessEnabled || !this.spacePermissionManager.hasPermission("VIEWSPACE", space, null)) && !this.spacePermissionManager.groupHasPermission("VIEWSPACE", space, "confluence-users")) continue;
            siteHomePages.add(new PairType((Serializable)((Object)space.getKey()), (Serializable)((Object)space.getKey())));
        }
        return siteHomePages;
    }

    public List getEmailAddressVisibilityTypes() {
        if (this.emailAddressVisibilityTypes == null) {
            this.emailAddressVisibilityTypes = new ArrayList();
            this.emailAddressVisibilityTypes.add(new PairType((Serializable)((Object)this.getText("email.address.public")), (Serializable)((Object)"email.address.public")));
            this.emailAddressVisibilityTypes.add(new PairType((Serializable)((Object)this.getText("email.address.masked")), (Serializable)((Object)"email.address.masked")));
            this.emailAddressVisibilityTypes.add(new PairType((Serializable)((Object)this.getText("email.address.private")), (Serializable)((Object)"email.address.private")));
        }
        return this.emailAddressVisibilityTypes;
    }

    public List getIndexingLanguages() {
        ArrayList<PairType> result = new ArrayList<PairType>();
        result.add(new PairType((Serializable)((Object)"english"), (Serializable)((Object)"English")));
        result.add(new PairType((Serializable)((Object)"german"), (Serializable)((Object)"German")));
        result.add(new PairType((Serializable)((Object)"russian"), (Serializable)((Object)"Russian")));
        result.add(new PairType((Serializable)((Object)"chinese"), (Serializable)((Object)"Chinese")));
        result.add(new PairType((Serializable)((Object)"CJK"), (Serializable)((Object)"CJK")));
        result.add(new PairType((Serializable)((Object)"CJK"), (Serializable)((Object)"Custom Japanese")));
        result.add(new PairType((Serializable)((Object)"french"), (Serializable)((Object)"French")));
        result.add(new PairType((Serializable)((Object)"brazilian"), (Serializable)((Object)"Brazilian")));
        result.add(new PairType((Serializable)((Object)"czech"), (Serializable)((Object)"Czech")));
        result.add(new PairType((Serializable)((Object)"greek"), (Serializable)((Object)"Greek")));
        result.add(new PairType((Serializable)((Object)"other"), (Serializable)((Object)"Other")));
        return result;
    }

    public String getSiteHomePage() {
        return this.siteHomePage;
    }

    public void setSiteHomePage(String siteHomePage) {
        this.siteHomePage = siteHomePage;
    }

    @HtmlSafe
    public String getRenderedSiteWelcomeMessage() {
        return this.wikiStyleRenderer.convertWikiToXHtml((RenderContext)new PageContext(), this.siteWelcomeMessage);
    }

    public int getMaxAttachmentsInUI() {
        return this.maxAttachmentsInUI;
    }

    public void setMaxAttachmentsInUI(int maxAttachmentsInUI) {
        this.maxAttachmentsInUI = maxAttachmentsInUI;
    }

    public long getAttachmentMaxSize() {
        return this.attachmentMaxSize;
    }

    public void setAttachmentMaxSize(long attachmentMaxSize) {
        this.attachmentMaxSize = attachmentMaxSize;
    }

    public int getDraftSaveIntervalMinutes() {
        return this.draftSaveIntervalMinutes;
    }

    public void setDraftSaveIntervalMinutes(int draftSaveIntervalMinutes) {
        this.draftSaveIntervalMinutes = draftSaveIntervalMinutes;
    }

    public int getDraftSaveIntervalSeconds() {
        return this.draftSaveIntervalSeconds;
    }

    public void setDraftSaveIntervalSeconds(int draftSaveIntervalSeconds) {
        this.draftSaveIntervalSeconds = draftSaveIntervalSeconds;
    }

    public String getSiteWelcomeMessage() {
        return this.siteWelcomeMessage;
    }

    public void setSiteWelcomeMessage(String siteWelcomeMessage) {
        this.siteWelcomeMessage = siteWelcomeMessage;
    }

    public String getCurrentTime(String dateFormatPattern) {
        return new SimpleDateFormat(dateFormatPattern).format(new Date());
    }

    public boolean getAllowCamelCase() {
        return this.allowCamelCase;
    }

    public boolean isAllowCamelCase() {
        return this.allowCamelCase;
    }

    public void setAllowCamelCase(boolean allowCamelCase) {
        this.allowCamelCase = allowCamelCase;
    }

    public boolean isAllowTrackbacks() {
        return this.allowTrackbacks;
    }

    public void setAllowTrackbacks(boolean allowTrackbacks) {
        this.allowTrackbacks = allowTrackbacks;
    }

    public boolean isAllowPublicSignup() {
        return this.allowPublicSignup;
    }

    public void setAllowPublicSignup(boolean allowPublicSignup) {
        this.allowPublicSignup = allowPublicSignup;
    }

    public boolean isViewSpaceGoesToSpaceSummary() {
        return this.viewSpaceGoesToSpaceSummary;
    }

    public void setViewSpaceGoesToSpaceSummary(boolean viewSpaceGoesToSpaceSummary) {
        this.viewSpaceGoesToSpaceSummary = viewSpaceGoesToSpaceSummary;
    }

    public boolean getExternalUserManagement() {
        return this.externalUserManagement;
    }

    public boolean isExternalUserManagement() {
        return this.externalUserManagement;
    }

    public void setExternalUserManagement(boolean externalUserManagement) {
        this.externalUserManagement = externalUserManagement;
    }

    public String getDefaultEncoding() {
        return this.defaultEncoding;
    }

    public void setDefaultEncoding(String defaultEncoding) {
        this.defaultEncoding = defaultEncoding;
    }

    public String getDefaultTimeFormatterPattern() {
        return this.defaultTimeFormatterPattern;
    }

    public void setDefaultTimeFormatterPattern(String defaultTimeFormatterPattern) {
        this.defaultTimeFormatterPattern = defaultTimeFormatterPattern;
    }

    public String getDefaultDateTimeFormatterPattern() {
        return this.defaultDateTimeFormatterPattern;
    }

    public void setDefaultDateTimeFormatterPattern(String defaultDateTimeFormatterPattern) {
        this.defaultDateTimeFormatterPattern = defaultDateTimeFormatterPattern;
    }

    public String getDefaultDateFormatterPattern() {
        return this.defaultDateFormatterPattern;
    }

    public void setDefaultDateFormatterPattern(String defaultDateFormatterPattern) {
        this.defaultDateFormatterPattern = defaultDateFormatterPattern;
    }

    public String getDefaultLongNumberFormatterPattern() {
        return this.defaultLongNumberFormatterPattern;
    }

    public void setDefaultLongNumberFormatterPattern(String defaultLongNumberFormatterPattern) {
        this.defaultLongNumberFormatterPattern = defaultLongNumberFormatterPattern;
    }

    public String getDefaultDecimalNumberFormatterPattern() {
        return this.defaultDecimalNumberFormatterPattern;
    }

    public void setDefaultDecimalNumberFormatterPattern(String defaultDecimalNumberFormatterPattern) {
        this.defaultDecimalNumberFormatterPattern = defaultDecimalNumberFormatterPattern;
    }

    public String getEmailAddressVisibility() {
        return this.emailAddressVisibility;
    }

    public void setEmailAddressVisibility(String emailAddressVisibility) {
        this.emailAddressVisibility = emailAddressVisibility;
    }

    public String getNiceAttachmentMaxSize() {
        return FileSize.format((long)this.attachmentMaxSize);
    }

    public String getNiceDraftSaveInterval() {
        return GeneralUtil.getNiceDuration(this.draftSaveIntervalMinutes, this.draftSaveIntervalSeconds);
    }

    public boolean isAllowThreadedComments() {
        return this.allowThreadedComments;
    }

    public void setAllowThreadedComments(boolean allowThreadedComments) {
        this.allowThreadedComments = allowThreadedComments;
    }

    public int getMaxThumbHeight() {
        return this.maxThumbHeight;
    }

    public void setMaxThumbHeight(int maxThumbHeight) {
        this.maxThumbHeight = maxThumbHeight;
    }

    public int getMaxThumbWidth() {
        return this.maxThumbWidth;
    }

    public void setMaxThumbWidth(int maxThumbWidth) {
        this.maxThumbWidth = maxThumbWidth;
    }

    public String getIndexingLanguage() {
        return this.indexingLanguage;
    }

    public void setIndexingLanguage(String indexingLanguage) {
        this.indexingLanguage = indexingLanguage;
    }

    public boolean isAllowRemoteApi() {
        return this.allowRemoteApi;
    }

    public void setAllowRemoteApi(boolean allowRemoteApi) {
        this.allowRemoteApi = allowRemoteApi;
    }

    public boolean isAllowRemoteApiAnonymous() {
        return this.allowRemoteApiAnonymous;
    }

    public void setAllowRemoteApiAnonymous(boolean allowRemoteApiAnonymous) {
        this.allowRemoteApiAnonymous = allowRemoteApiAnonymous;
    }

    public String getDomainName() {
        return this.domainName;
    }

    public void setDomainName(String domainName) {
        if (domainName != null) {
            domainName = domainName.trim();
        }
        this.domainName = domainName;
    }

    public boolean isNofollowExternalLinks() {
        return this.nofollowExternalLinks;
    }

    public void setNofollowExternalLinks(boolean nofollowExternalLinks) {
        this.nofollowExternalLinks = nofollowExternalLinks;
    }

    public String getSiteTitle() {
        return this.siteTitle;
    }

    public void setSiteTitle(String siteTitle) {
        this.siteTitle = siteTitle;
    }

    public boolean isEnableWysiwyg() {
        return this.enableWysiwyg;
    }

    public boolean isUseWysiwygByDefault() {
        return this.useWysiwygByDefault;
    }

    public void setEnableWysiwyg(boolean enableWysiwyg) {
        this.enableWysiwyg = enableWysiwyg;
    }

    public void setUseWysiwygByDefault(boolean useWysiwygByDefault) {
        this.useWysiwygByDefault = useWysiwygByDefault;
    }

    public int getNumberOfBreadcrumbAncestors() {
        return this.numberOfBreadcrumbAncestors;
    }

    public void setNumberOfBreadcrumbAncestors(int numberOfBreadcrumbAncestors) {
        this.numberOfBreadcrumbAncestors = numberOfBreadcrumbAncestors;
    }

    public int getDraftSaveInterval() {
        return (this.draftSaveIntervalMinutes * 60 + this.draftSaveIntervalSeconds) * 1000;
    }

    public boolean isGzipResponseEncoding() {
        return this.gzipResponseEncoding;
    }

    public void setGzipResponseEncoding(boolean gzipResponseEncoding) {
        this.gzipResponseEncoding = gzipResponseEncoding;
    }

    public void setFormatSettingsManager(FormatSettingsManager formatSettingsManager) {
        this.formatSettingsManager = formatSettingsManager;
    }

    public boolean isDisplayLinkIcons() {
        return this.displayLinkIcons;
    }

    public void setDisplayLinkIcons(boolean displayLinkIcons) {
        this.displayLinkIcons = displayLinkIcons;
    }

    public String getDefaultDayFormatterPattern() {
        return this.defaultDayFormatterPattern;
    }

    public void setDefaultDayFormatterPattern(String defaultDayFormatterPattern) {
        this.defaultDayFormatterPattern = defaultDayFormatterPattern;
    }

    public String getSiteSupportAddress() {
        return this.siteSupportAddress;
    }

    public void setSiteSupportAddress(String siteSupportAddress) {
        this.siteSupportAddress = siteSupportAddress;
    }

    public void setSocketTimeout(int socketTimeout) {
        this.socketTimeout = socketTimeout;
    }

    public void setConnectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public int getSocketTimeout() {
        return this.socketTimeout;
    }

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public boolean isConnectionsEnabled() {
        return this.connectionsEnabled;
    }

    public void setConnectionsEnabled(boolean connectionsEnabled) {
        this.connectionsEnabled = connectionsEnabled;
    }

    public boolean isAntiXssMode() {
        return this.antiXssMode;
    }

    public void setAntiXssMode(boolean antiXssMode) {
        this.antiXssMode = antiXssMode;
    }
}

